/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.token.ExpirableUserToken;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.crowd.accessor.SecSignIDStaticAccessor;
import java.text.DateFormat;
import java.util.Date;

public class SecSignIDForgotPasswordHelper {
    public static String getStringForMailWithPassword(User user) throws PropertyManagerException {
        String mailText = "";
        mailText = mailText + "Hello " + user.getDisplayName() + "\n\n";
        mailText = mailText + "You (or someone else) have requested to reset your password for " + SecSignIDStaticAccessor.getPropertyManager().getDeploymentTitle() + " on " + SecSignIDForgotPasswordHelper.getDate() + "\n\n";
        mailText = mailText + "If you follow the link below you will be able to personally reset your password.\n";
        mailText = mailText + SecSignIDForgotPasswordHelper.getLinkForPassword(user) + "\n\n";
        mailText = mailText + "This password reset request is valid for the next 24 hours.\n\nHere are the details of your account:\n\n";
        mailText = mailText + SecSignIDForgotPasswordHelper.getDataForUser(user);
        return mailText;
    }

    private static String getDataForUser(User user) {
        String result = "Username: ";
        result = result + user.getName() + "\n";
        result = result + "Full name: ";
        result = result + user.getDisplayName() + "\n\n";
        return result;
    }

    private static String getLinkForPassword(User user) throws PropertyManagerException {
        ExpirableUserToken token = SecSignIDStaticAccessor.getForgottenLoginManager().createAndStoreResetToken(user.getDirectoryId(), user.getName(), user.getEmailAddress(), 86400);
        return SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getBaseUrl() + "/plugins/servlet/forgot?reset-password&username=" + user.getName() + "&directoryId=" + user.getDirectoryId() + "&token=" + token.getToken();
    }

    private static String getDate() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        Date date = new Date();
        return dateFormat.format(date);
    }
}

