/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.servlet.filter;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.util.SecSignIDServletResponseWrapper;
import com.secsign.crowd.accessor.SecSignIDStaticAccessor;
import com.secsign.crowd.servlet.filter.SecSignIDForgotFilter;
import com.secsign.crowd.util.SecSignIDForgotPasswordHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDForgetPasswordRESTFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(SecSignIDForgotFilter.class);
    private final TemplateRenderer templateRenderer;
    private String forgotLoginTemplate = "/templates/secsignid-forgot.vm";

    public SecSignIDForgetPasswordRESTFilter(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block12: {
            SecSignIDServletResponseWrapper responseWrapper = new SecSignIDServletResponseWrapper((HttpServletResponse)response);
            HttpServletRequest httpServletReq = (HttpServletRequest)request;
            HttpServletResponse httpServletResp = (HttpServletResponse)response;
            String username = httpServletReq.getParameter("username");
            if (username == null || username.equals("")) {
                httpServletResp.sendError(400, "No username given");
                return;
            }
            String application = "";
            String cred = "";
            String authorization = httpServletReq.getHeader("Authorization");
            if (authorization == null || !authorization.toLowerCase().startsWith("basic")) {
                httpServletResp.sendError(400, "No basic authentication given");
                return;
            }
            String base64Credentials = authorization.substring("Basic".length()).trim();
            byte[] credDecoded = Base64.getDecoder().decode(base64Credentials);
            String credentials = new String(credDecoded, StandardCharsets.UTF_8);
            String[] values = credentials.split(":", 2);
            application = values[0];
            cred = values[1];
            boolean authed = false;
            Application applicationObject = null;
            try {
                applicationObject = SecSignIDStaticAccessor.getApplicationManager().findByName(application);
                authed = SecSignIDStaticAccessor.getApplicationManager().authenticate(applicationObject, new PasswordCredential(cred));
                if (authed) {
                    com.atlassian.crowd.model.user.User user = SecSignIDStaticAccessor.getApplicationService().findUserByName(applicationObject, username);
                    String mail = user.getEmailAddress();
                    if (mail == null || mail.equals("")) {
                        httpServletResp.sendError(400, "No mail address set for user");
                        return;
                    }
                    if (SecSignIDStaticAccessor.getMailManager().isConfigured()) {
                        try {
                            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(user.getEmailAddress()), "Reset password", SecSignIDForgotPasswordHelper.getStringForMailWithPassword((User)user));
                            break block12;
                        }
                        catch (AddressException e) {
                            httpServletResp.sendError(400, "Error sending mail");
                            this.logger.error("AddressException on reset password REST API");
                            this.logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                            return;
                        }
                        catch (MailSendException e) {
                            httpServletResp.sendError(400, "Error sending mail");
                            this.logger.error("MailSendException on reset password REST API");
                            this.logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                            return;
                        }
                        catch (PropertyManagerException e) {
                            httpServletResp.sendError(400, "Error sending mail");
                            this.logger.error("PropertyManagerException on reset password REST API");
                            this.logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                            return;
                        }
                    }
                    httpServletResp.sendError(400, "No mail server set");
                    return;
                }
                httpServletResp.sendError(400, "Basic authentication not valid");
                return;
            }
            catch (ApplicationNotFoundException e) {
                httpServletResp.sendError(400, "Basic authentication not valid");
                return;
            }
            catch (UserNotFoundException e1) {
                httpServletResp.sendError(400, "User not found");
                return;
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

