/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.listener;

import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.event.user.UserAttributeStoredEvent;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import com.secsign.crowd.accessor.SecSignIDLDAPAccessor;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SecSignIDUpdateEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDUpdateEventListener.class);
    private final EventPublisher eventPublisher;

    @Autowired
    public SecSignIDUpdateEventListener(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public void onUserAttributeStoredEvent(UserAttributeStoredEvent userUpdateEvent) {
        block8: {
            long dirid = userUpdateEvent.getDirectoryId();
            try {
                Set pwdset;
                Iterator iterator;
                if (!SecSignIDCommonStaticAccessor.getWriteLDAPEnable() || !userUpdateEvent.getDirectoryType().equals((Object)DirectoryType.CONNECTOR)) break block8;
                String secsignid = null;
                String pwdallowed = null;
                if (userUpdateEvent.getAttributeValues("secsignid") != null) {
                    Set secsignset = userUpdateEvent.getAttributeValues("secsignid");
                    secsignid = SecSignIDMappingUtils.getSecSignIdString(secsignset.toArray(new String[0]));
                }
                if (userUpdateEvent.getAttributeValues("pwdallowed") != null && (iterator = (pwdset = userUpdateEvent.getAttributeValues("pwdallowed")).iterator()).hasNext()) {
                    String string;
                    pwdallowed = string = (String)iterator.next();
                }
                Integer pwdAllowedInt = null;
                try {
                    pwdAllowedInt = Integer.valueOf(pwdallowed);
                }
                catch (NumberFormatException ex) {
                    logger.error("Cannot parse value for password login allowed: " + pwdallowed);
                }
                if (pwdAllowedInt == null) {
                    pwdAllowedInt = SecSignIDCommonConstants.PasswordLoginIsAllowed;
                }
                SecSignIDLDAPAccessor.writeSecSignIDMappingsToLDAP(userUpdateEvent.getUser().getName().toLowerCase(), SecSignIDMappingUtils.getArrayOfSecSignIds(secsignid), dirid);
            }
            catch (OperationFailedException e) {
                logger.debug("OperationFailedException on UserAttributeStoredEvent");
            }
            catch (NamingException e) {
                logger.debug("NamingException on UserAttributeStoredEvent");
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

