/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.util;

import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class SecSignIDTemplateHelper {
    public String getUnescapedGroupnameFromMappingKey(String mappingKey) {
        return SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
    }

    public boolean isSecSignIDActivated(SecSignID2FAActivatedSettings activatedSettings, SecSignID2FASettings setting) {
        return activatedSettings.isTwoStepActive() && (setting.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) || setting.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed));
    }

    public boolean is2FAActivated(SecSignID2FAActivatedSettings activatedSettings, SecSignID2FASettings setting) {
        if (activatedSettings.isFidoActive() && setting.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
            return true;
        }
        if (activatedSettings.isMailOtpActive() && setting.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
            return true;
        }
        if (activatedSettings.isTotpActive() && setting.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
            return true;
        }
        return activatedSettings.isTwoStepActive() && (setting.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) || setting.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed));
    }

    public List<String> getActivatedMethods(SecSignID2FAActivatedSettings activatedSettings, SecSignID2FASettings setting) {
        ArrayList<String> result = new ArrayList<String>();
        if (activatedSettings.isFidoActive() && setting.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
            result.add(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.fido.name.short.kind"));
        }
        if (activatedSettings.isMailOtpActive() && setting.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
            result.add(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.mailotp.name.short.kind"));
        }
        if (activatedSettings.isTotpActive() && setting.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
            result.add(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.totp.name.short.kind"));
        }
        if (activatedSettings.isTwoStepActive() && (setting.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) || setting.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed))) {
            result.add(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.twoStepAuth.name.short.kind"));
        }
        return result;
    }

    public List<String> getNotActivatedMethods(SecSignID2FAActivatedSettings activatedSettings, SecSignID2FASettings setting) {
        ArrayList<String> result = new ArrayList<String>();
        if (setting.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
            result.add(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.fido.name.short.kind"));
        }
        if (!activatedSettings.isMailOtpActive() && setting.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
            result.add(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.mailotp.name.short.kind"));
        }
        if (!activatedSettings.isTotpActive() && setting.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
            result.add(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.totp.name.short.kind"));
        }
        if (!activatedSettings.isTwoStepActive() && (setting.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) || setting.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed))) {
            result.add(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.twoStepAuth.name.short.kind"));
        }
        return result;
    }

    public boolean is2FAAllowed(SecSignID2FASettings setting) {
        return !setting.getPwdAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
    }

    public String getGroupLink(String groupMappingKey) {
        String groupName = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(groupMappingKey);
        long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(groupMappingKey);
        return SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getGroupLink(groupName, dirid);
    }

    public String getGroupLinkToAdd(String groupMappingKey) {
        String groupName = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(groupMappingKey);
        long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(groupMappingKey);
        return SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getGroupLinkToAdd(groupName, dirid);
    }

    public String getShortFormOf2FAMethods(SecSignID2FASettings setting) {
        int enabledMethods = 0;
        int allowedMethods = 0;
        if (SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled()) {
            ++enabledMethods;
            if (setting.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                ++allowedMethods;
            }
        }
        if (SecSignIDCommonStaticAccessor.getFidoAuthEnabled()) {
            ++enabledMethods;
            if (setting.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                ++allowedMethods;
            }
        }
        if (SecSignIDCommonStaticAccessor.getTotpAuthEnabled()) {
            ++enabledMethods;
            if (setting.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                ++allowedMethods;
            }
        }
        if (SecSignIDCommonStaticAccessor.getMailotpAuthEnabled()) {
            ++enabledMethods;
            if (setting.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                ++allowedMethods;
            }
        }
        if (SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled()) {
            ++enabledMethods;
            if (setting.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                ++allowedMethods;
            }
        }
        return "(" + allowedMethods + " " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.twofa.of") + " " + enabledMethods + " " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.twofa.methods") + ")";
    }

    public String getSecSignIDforUsername(String username, long dirid) {
        System.out.println("Test");
        try {
            return SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getSecSignIdStringForApplicationUserKey(SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(username), dirid);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String escapeGroupName(String groupName) {
        try {
            String escaped = URLEncoder.encode(groupName, StandardCharsets.UTF_8.toString());
            escaped = escaped.replace("+", "_add_");
            return escaped.replace("%", "_percent_");
        }
        catch (UnsupportedEncodingException e) {
            return groupName;
        }
    }

    public String unescapeGroupName(String groupName) {
        try {
            String escaped = groupName.replace("_percent_", "%");
            escaped = escaped.replace("_add_", "+");
            return URLDecoder.decode(escaped, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return groupName;
        }
    }
}

