/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenInfoResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTAuthenticationMethod;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import com.secsign.atlassian.common.rest.SecSignIDServerRESTConnector;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDHttpSessionUtil;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SecSignIDAuthenticationUtil {
    public static String getSecSignIdForUser(SecSignIDDataAccessor dataAccessor, User user, String userKey) throws ApplicationPermissionException, DirectoryNotFoundException, UserNotFoundException, com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException {
        String idString = dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
        String[] idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
        if (idArray.length != 0) {
            return idArray[0];
        }
        return null;
    }

    public static List<SecSignIDRESTAuthenticationMethod> getAvailableMethodsForActivation(HttpServletRequest request, User user, String userKey, String secSignId) throws ApplicationPermissionException, DirectoryNotFoundException, UserNotFoundException, com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, SecSignIDRESTException, DirectoryPermissionException {
        ArrayList<SecSignIDRESTAuthenticationMethod> methods = new ArrayList<SecSignIDRESTAuthenticationMethod>();
        if (secSignId == null || secSignId.equals("") || !SecSignIDServerRESTConnector.checkSecSignID(secSignId)) {
            return methods;
        }
        SecSignID2FASettings settingsForUser = SecSignIDAuthenticationUtil.get2FASettingsFromUserKey(request, userKey, user.getDirectoryId());
        Integer passwordlessAllowed = settingsForUser.getPasswordlessAllowed();
        Integer twoStepAllowed = settingsForUser.getTwoStepAllowed();
        Integer totpAllowed = settingsForUser.getTotpAllowed();
        Integer mailotpAllowed = settingsForUser.getMailOtpAllowed();
        Integer fidoAllowed = settingsForUser.getFidoAllowed();
        boolean twoStepEnabled = twoStepAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) || passwordlessAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean totpEnabled = totpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean fidoEnabled = fidoAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean mailOtpEnabled = mailotpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        SecSignID2FAActivatedSettings activatedSettings = SecSignIDAuthenticationUtil.get2FAActivatedSettingsFromUserKey(request, userKey, user.getDirectoryId());
        boolean twoStepActive = activatedSettings.isTwoStepActive();
        boolean totpActive = activatedSettings.isTotpActive();
        boolean mailOtpActive = activatedSettings.isMailOtpActive();
        boolean fidoActive = activatedSettings.isFidoActive();
        SecSignIDRESTAccessTokenInfoResponse accessTokenInfoResponse = SecSignIDServerRESTConnector.getAccessTokenInfo(secSignId);
        if (accessTokenInfoResponse.isAccessAllowedWithoutToken()) {
            if (twoStepEnabled && twoStepActive) {
                methods.add(SecSignIDRESTAuthenticationMethod.SEC_SIGN_ID);
            }
            if (totpEnabled && totpActive) {
                methods.add(SecSignIDRESTAuthenticationMethod.TOTP);
            }
            if (fidoEnabled && fidoActive) {
                methods.add(SecSignIDRESTAuthenticationMethod.FIDO);
            }
            if (mailOtpEnabled && mailOtpActive) {
                methods.add(SecSignIDRESTAuthenticationMethod.MAIL_OTP);
            }
        } else {
            methods.addAll(Arrays.asList(accessTokenInfoResponse.getAuthenticationMethods()));
        }
        return methods;
    }

    public static boolean isAccessTokenRequiredForActivation(String secSignId, SecSignIDRESTAuthenticationMethod methodToActivate) throws SecSignIDRESTException {
        if (methodToActivate == SecSignIDRESTAuthenticationMethod.MAIL_OTP || methodToActivate == SecSignIDRESTAuthenticationMethod.UNKNOWN) {
            return false;
        }
        SecSignIDRESTAccessTokenInfoResponse accessTokenInfoResponse = SecSignIDServerRESTConnector.getAccessTokenInfo(secSignId);
        return !accessTokenInfoResponse.isAccessAllowedWithoutToken();
    }

    public static String tryFindAutoFillSecSignId(User user, boolean indexed) throws SecSignIDRESTException {
        boolean autoFillMail = SecSignIDCommonStaticAccessor.getAutoFillMail();
        boolean autoFillUser = SecSignIDCommonStaticAccessor.getAutoFillUsername();
        boolean autoFillUserCompany = SecSignIDCommonStaticAccessor.getAutoFillUsernameCompany();
        boolean autoFillPattern = SecSignIDCommonStaticAccessor.getAutoFillPattern();
        String secSignId = null;
        if (autoFillMail) {
            secSignId = user.getEmailAddress().toLowerCase();
        } else if (autoFillUser) {
            secSignId = user.getName().toLowerCase().replace(" ", "_");
        } else if (autoFillUserCompany) {
            secSignId = user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName();
        } else if (autoFillPattern) {
            String autoFillPatterPattern;
            String result = autoFillPatterPattern = SecSignIDCommonStaticAccessor.getAutoFillPatternPattern();
            result = result.replace("%username%", user.getName().toLowerCase().replace(" ", "_"));
            result = result.replace("%displayname%", user.getDisplayName().replace(" ", "").toLowerCase());
            result = result.replace("%mail%", user.getEmailAddress().toLowerCase());
            result = result.replace("%index%", "");
            secSignId = result = result.toLowerCase();
        }
        if (secSignId == null) {
            return "";
        }
        if (indexed) {
            if (!SecSignIDServerRESTConnector.checkSecSignID(secSignId)) {
                return secSignId;
            }
            int index = 1;
            while (SecSignIDServerRESTConnector.checkSecSignID(secSignId + index)) {
                ++index;
            }
            return secSignId + index;
        }
        return secSignId;
    }

    public static void saveSecSignIdForUser(HttpServletRequest request, SecSignIDDataAccessor dataAccessor, User user, String secSignId) throws InvalidAuthenticationException, DirectoryPermissionException, com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, OperationNotPermittedException, NamingException, DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        String userKey = dataAccessor.getUserKeyForUsername(user.getName());
        long directoryId = user.getDirectoryId();
        dataAccessor.saveSecSignIDForUserKey(userKey, directoryId, secSignId);
        dataAccessor.logAutomaticUserChangeToAuditLog(userKey, directoryId, secSignId, request.getRemoteAddr());
        if (SecSignIDCommonStaticAccessor.getInformUser()) {
            dataAccessor.mailChangeSecSignIDToUser(userKey, directoryId, userKey, directoryId, secSignId);
        }
        List<String> groupMappingKeys = dataAccessor.getGroupMappingKeysForUserKey(userKey, directoryId);
        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(groupMappingKeys)) {
            dataAccessor.mailChangeSecSignIDToInformGroup(userKey, directoryId, userKey, directoryId, secSignId);
        }
    }

    public static String getMappingKeyFromRequest(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return SecSignIDHttpSessionUtil.getUserMappingKey(session);
    }

    public static String getUserKeyFromRequest(HttpServletRequest request) {
        String mappingKey = SecSignIDAuthenticationUtil.getMappingKeyFromRequest(request);
        if (mappingKey != null) {
            return SecSignIDMappingUtils.getUserKeyFromMappingKey(mappingKey);
        }
        return null;
    }

    public static User getUserFromRequest(HttpServletRequest request, SecSignIDDataAccessor dataAccessor) {
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(request);
        if (userKey == null) {
            return null;
        }
        try {
            return dataAccessor.getUserForKeyFirst(userKey);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException operationFailedException) {
            return null;
        }
    }

    private static SecSignID2FASettings get2FASettingsFromUserKey(HttpServletRequest request, String userKey, long dirid) throws com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        Object attributeTime = request.getSession().getAttribute(userKey + dirid + "settingstime");
        if (attributeTime != null) {
            Date timeNow = new Date();
            Date timeAttribute = (Date)attributeTime;
            if (timeNow.getTime() - timeAttribute.getTime() < 120000L) {
                Object fromSession = request.getSession().getAttribute(userKey + dirid + "2fasettings");
                if (fromSession != null) {
                    return new SecSignID2FASettings((String)fromSession);
                }
                SecSignID2FASettings settings = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().get2FASettingsFromUserKey(userKey, dirid);
                request.getSession().setAttribute(userKey + dirid + "2fasettings", (Object)settings.toString());
                request.getSession().setAttribute(userKey + dirid + "settingstime", (Object)new Date());
                return settings;
            }
            SecSignID2FASettings settings = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().get2FASettingsFromUserKey(userKey, dirid);
            request.getSession().setAttribute(userKey + dirid + "2fasettings", (Object)settings.toString());
            request.getSession().setAttribute(userKey + dirid + "settingstime", (Object)new Date());
            return settings;
        }
        SecSignID2FASettings settings = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().get2FASettingsFromUserKey(userKey, dirid);
        request.getSession().setAttribute(userKey + dirid + "2fasettings", (Object)settings.toString());
        request.getSession().setAttribute(userKey + dirid + "settingstime", (Object)new Date());
        return settings;
    }

    private static SecSignID2FAActivatedSettings get2FAActivatedSettingsFromUserKey(HttpServletRequest request, String userKey, long dirid) throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, SecSignIDRESTException, UserNotFoundException, DirectoryNotFoundException {
        Object attributeTime = request.getSession().getAttribute(userKey + dirid + "activatedsettingstime");
        if (attributeTime != null) {
            Date timeNow = new Date();
            Date timeAttribute = (Date)attributeTime;
            if (timeNow.getTime() - timeAttribute.getTime() < 120000L) {
                Object fromSession = request.getSession().getAttribute(userKey + dirid + "2faactivatedsettings");
                if (fromSession != null) {
                    return new SecSignID2FAActivatedSettings((String)fromSession);
                }
                SecSignID2FAActivatedSettings settings = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().get2FAActivatedSettingsFromUserKey(userKey, dirid);
                request.getSession().setAttribute(userKey + dirid + "2faactivatedsettings", (Object)settings.toString());
                request.getSession().setAttribute(userKey + dirid + "activatedsettingstime", (Object)new Date());
                return settings;
            }
            SecSignID2FAActivatedSettings settings = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().get2FAActivatedSettingsFromUserKey(userKey, dirid);
            request.getSession().setAttribute(userKey + dirid + "2faactivatedsettings", (Object)settings.toString());
            request.getSession().setAttribute(userKey + dirid + "activatedsettingstime", (Object)new Date());
            return settings;
        }
        SecSignID2FAActivatedSettings settings = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().get2FAActivatedSettingsFromUserKey(userKey, dirid);
        request.getSession().setAttribute(userKey + dirid + "2faactivatedsettings", (Object)settings.toString());
        request.getSession().setAttribute(userKey + dirid + "activatedsettingstime", (Object)new Date());
        return settings;
    }
}

