/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet.filter;

import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignIDWhiteListItem;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.util.SecSignIDIPHelper;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDBasicAuthFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDBasicAuthFilter.class);
    private SecSignIDDataAccessor dataAccessor;

    public SecSignIDBasicAuthFilter(SecSignIDDataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletReq = (HttpServletRequest)request;
        HttpServletResponse httpServletResp = (HttpServletResponse)response;
        String requestUri = httpServletReq.getRequestURI();
        HttpSession session = httpServletReq.getSession();
        logger.trace(String.valueOf("Session timeout is: " + session.getMaxInactiveInterval() + " seconds"));
        logger.debug("Filtering request url '" + requestUri + "'");
        logger.trace("     path info [filter]: " + httpServletReq.getPathInfo());
        logger.trace("     parameter [filter]: " + SecSignIDMappingUtils.toString(httpServletReq.getParameterMap()));
        logger.trace("     header [filter]: " + SecSignIDMappingUtils.headerToString(httpServletReq));
        logger.trace("     session [filter] SAMLRequest: " + session.getAttribute("SAMLRequest"));
        logger.trace("     session [filter] RelayState: " + session.getAttribute("RelayState"));
        boolean appliedFilterAndSentRedirect = this.filterUrlAndSendRedirect(requestUri, httpServletReq, httpServletResp);
        if (appliedFilterAndSentRedirect || httpServletResp.isCommitted()) {
            return;
        }
        logger.trace("Not filtered the request uri '" + requestUri + "' as login page.");
        filterChain.doFilter((ServletRequest)httpServletReq, (ServletResponse)httpServletResp);
    }

    private boolean filterUrlAndSendRedirect(String requestUri, HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        String authHeader;
        logger.trace("Filter " + requestUri + " to check http basic auth");
        String gitPrefix = httpServletReq.getContextPath() + "/scm/";
        if (!(!SecSignIDCommonStaticAccessor.isBasicAuthDisabled() || this.dataAccessor.getApplication().equals("Bitbucket") && requestUri.startsWith(gitPrefix))) {
            logger.trace("Http basic auth is disabled. Check if http basic auth header is set to reject request with a 401.");
            authHeader = httpServletReq.getHeader("authorization");
            if (authHeader != null && authHeader.contains("Basic")) {
                logger.trace("Call to " + requestUri + " from " + httpServletReq.getRemoteHost() + " with basic auth registered. Basic Auth disabled, check whitelist.");
                if (!this.checkRequestAllowed(httpServletReq, httpServletResp)) {
                    httpServletResp.setStatus(401);
                    httpServletResp.sendError(401);
                    return true;
                }
                HttpSession session = httpServletReq.getSession();
                session.setAttribute("secsign.basicAuth", (Object)Boolean.TRUE);
                return false;
            }
        }
        if (!(!SecSignIDCommonStaticAccessor.isAccessTokenDisabled() || this.dataAccessor.getApplication().equals("Bitbucket") && requestUri.startsWith(gitPrefix))) {
            logger.trace("Http basic auth is disabled. Check if http basic auth header is set to reject request with a 401.");
            authHeader = httpServletReq.getHeader("authorization");
            if (authHeader != null && authHeader.contains("Bearer")) {
                logger.trace("Call to " + requestUri + " from " + httpServletReq.getRemoteHost() + " with Access Token registered. Access Token disabled, check whitelist.");
                if (!this.checkRequestAllowed(httpServletReq, httpServletResp)) {
                    httpServletResp.setStatus(401);
                    httpServletResp.sendError(401);
                    return true;
                }
                HttpSession session = httpServletReq.getSession();
                session.setAttribute("secsign.basicAuth", (Object)Boolean.TRUE);
                return false;
            }
        }
        if ((authHeader = httpServletReq.getHeader("authorization")) != null) {
            if (authHeader.contains("Basic")) {
                logger.warn("Call to " + requestUri + " from " + httpServletReq.getRemoteHost() + " with basic auth registered. Basic Auth not disabled, let request pass.");
            }
            if (authHeader.contains("Bearer")) {
                logger.warn("Call to " + requestUri + " from " + httpServletReq.getRemoteHost() + " with Access Token registered. Access Token not disabled, let request pass.");
            }
            HttpSession session = httpServletReq.getSession();
            session.setAttribute("secsign.basicAuth", (Object)Boolean.TRUE);
        }
        return false;
    }

    private boolean checkRequestAllowed(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        String requestUrl = httpServletReq.getRequestURI();
        List<SecSignIDWhiteListItem> whiteList = SecSignIDCommonStaticAccessor.getWhiteList();
        String ip = httpServletReq.getRemoteAddr();
        logger.trace("checkBasicAuthForRequestAllowed for requestUrl: " + requestUrl + " and IP " + ip);
        InetAddress hostAddress = null;
        try {
            hostAddress = InetAddress.getByName(ip);
        }
        catch (UnknownHostException ex) {
            logger.error(ex.getMessage());
            return false;
        }
        String[] xForwardedFor = null;
        if (httpServletReq.getHeader("X-Forwarded-For") != null) {
            String[] clientIpAddresses;
            logger.trace("Request has set header field X-Forwarded-For to '" + httpServletReq.getHeader("X-Forwarded-For") + "'");
            LinkedList<String> clientIpAddrList = new LinkedList<String>();
            for (String clientIpAddress : clientIpAddresses = httpServletReq.getHeader("X-Forwarded-For").split(",")) {
                String clientIpAddrTrimmed = clientIpAddress.trim();
                if (clientIpAddrTrimmed.isEmpty()) continue;
                clientIpAddrList.add(clientIpAddrTrimmed);
            }
            xForwardedFor = clientIpAddrList.toArray(new String[clientIpAddrList.size()]);
        }
        logger.trace("Request comes from remote address '" + ip + "' (forwarded: " + SecSignIDMappingUtils.arrayToString(xForwardedFor) + ") and will be checked on whitelist '" + whiteList.toString() + "'");
        for (SecSignIDWhiteListItem whiteListItem : whiteList) {
            InetAddress addressOnWhitelist;
            if (whiteListItem.getIpAddress().equals("")) continue;
            String subnetIP = whiteListItem.getIpAddress();
            try {
                addressOnWhitelist = InetAddress.getByName(subnetIP);
            }
            catch (UnknownHostException ex) {
                logger.error(ex.getMessage());
                return false;
            }
            if (SecSignIDIPHelper.isEqual(hostAddress, addressOnWhitelist)) {
                String urlFromWhitelist = whiteListItem.getUrl();
                if (!urlFromWhitelist.startsWith(httpServletReq.getContextPath())) {
                    urlFromWhitelist = httpServletReq.getContextPath() + urlFromWhitelist;
                }
                if (requestUrl.equals(urlFromWhitelist)) {
                    return true;
                }
            }
            if (xForwardedFor == null) continue;
            for (String forwardedFor : xForwardedFor) {
                try {
                    InetAddress forwardedIpAddress = InetAddress.getByName(forwardedFor);
                    if (!SecSignIDIPHelper.isEqual(forwardedIpAddress, addressOnWhitelist) || !httpServletReq.getRequestURI().equals(whiteListItem.getUrl())) continue;
                    return true;
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            }
        }
        logger.warn("Blocked Basic-Auth request on " + requestUrl + " from ip: " + ip);
        return false;
    }

    public void init(FilterConfig fc) throws ServletException {
    }

    public void destroy() {
    }
}

