/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.secsign.atlassian.common.rest.SecSignIDRESTAuthenticationMethod;
import org.json.JSONException;
import org.json.JSONObject;

public class SecSignIDRESTAccessTokenAuthorizationRequest {
    private final String serviceUrl;
    private final String secSignId;
    private final SecSignIDRESTAuthenticationMethod authenticationMethod;
    private final Capability[] capabilities;

    public SecSignIDRESTAccessTokenAuthorizationRequest(String serviceUrl, String secSignId, SecSignIDRESTAuthenticationMethod authenticationMethod, Capability ... capabilities) {
        this.serviceUrl = serviceUrl;
        this.secSignId = secSignId;
        this.authenticationMethod = authenticationMethod;
        this.capabilities = capabilities;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject object = new JSONObject();
        object.put("secsignid", (Object)this.secSignId);
        object.put("authmethod", (Object)this.authenticationMethod.getName());
        object.put("serviceurl", (Object)this.serviceUrl);
        String capabilitiesString = "";
        for (int i = 0; i < this.capabilities.length; ++i) {
            capabilitiesString = capabilitiesString + this.capabilities[i].getName();
            if (i == this.capabilities.length - 1) continue;
            capabilitiesString = capabilitiesString + ";";
        }
        object.put("capabilities", (Object)capabilitiesString);
        return object;
    }

    public static enum Capability {
        SEC_SIGN_ID_DEVICE("SecSignIdDevice"),
        TOTP_SECRET("TOTPSecret"),
        FIDO_DEVICE("FIDODevice");

        private final String name;

        private Capability(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

