/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.data;

public class SecSignIDServerVersion {
    public static final SecSignIDServerVersion VERSION_UNKNOWN = new SecSignIDServerVersion(0, 0, 0);
    public static final SecSignIDServerVersion VERSION_10_7_5 = new SecSignIDServerVersion(10, 7, 5);
    private final int major;
    private final int minor;
    private final int patch;

    public SecSignIDServerVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isGreaterOrEquals(SecSignIDServerVersion otherVersion) {
        if (otherVersion.equals(this)) {
            return true;
        }
        return this.isGreater(otherVersion);
    }

    public boolean isGreater(SecSignIDServerVersion otherVersion) {
        if (this.major > otherVersion.getMajor()) {
            return true;
        }
        if (this.major == otherVersion.getMajor() && this.minor > otherVersion.getMinor()) {
            return true;
        }
        return this.major == otherVersion.getMajor() && this.minor == otherVersion.getMinor() && this.patch >= otherVersion.getPatch();
    }

    public boolean isLowerOrEquals(SecSignIDServerVersion otherVersion) {
        if (otherVersion.equals(this)) {
            return true;
        }
        return this.isLower(otherVersion);
    }

    public boolean isLower(SecSignIDServerVersion otherVersion) {
        if (this.major > otherVersion.getMajor()) {
            return false;
        }
        if (this.minor > otherVersion.getMinor() && this.major >= otherVersion.getMajor()) {
            return false;
        }
        return this.patch < otherVersion.getPatch() || this.minor < otherVersion.getMinor() || this.major < otherVersion.getMajor();
    }

    public String toString() {
        return this.getMajor() + "." + this.getMinor() + "." + this.getPatch();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecSignIDServerVersion that = (SecSignIDServerVersion)o;
        if (this.major != that.major) {
            return false;
        }
        if (this.minor != that.minor) {
            return false;
        }
        return this.patch == that.patch;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }
}

