/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.User;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.util.SecSignIDCharArrayWriter;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import com.secsign.atlassian.common.util.SecSignIDServletResponseWrapper;
import com.secsign.crowd.accessor.SecSignIDStaticAccessor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDAuthenticationFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDAuthenticationFilter.class);
    private final TemplateRenderer templateRenderer;
    private String bannerTemplate = "/templates/secsignid-banner.vm";
    private String accessBannerTemplate = "/templates/secsignid-access-banner.vm";
    private SecSignIDDataAccessor dataAccessor;
    private String notActiveTemplate = "/templates/secsignid-notactive.vm";

    public SecSignIDAuthenticationFilter(TemplateRenderer templateRenderer, SecSignIDDataAccessor dataAccessor) {
        this.templateRenderer = templateRenderer;
        this.dataAccessor = dataAccessor;
    }

    @UnrestrictedAccess
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean appliedFilterAndSentRedirect;
        HttpServletRequest httpServletReq = (HttpServletRequest)request;
        HttpServletResponse httpServletResp = (HttpServletResponse)response;
        String requestUri = httpServletReq.getRequestURI();
        HttpSession session = httpServletReq.getSession();
        logger.debug(String.valueOf("Session timeout is: " + session.getMaxInactiveInterval() + " seconds"));
        logger.debug("Filtering request url '" + requestUri + "'");
        logger.debug("     path info [filter]: " + httpServletReq.getPathInfo());
        logger.debug("     parameter [filter]: " + SecSignIDMappingUtils.toString(httpServletReq.getParameterMap()));
        logger.debug("     header [filter]: " + SecSignIDMappingUtils.headerToString(httpServletReq));
        logger.debug("     session [filter] SAMLRequest: " + session.getAttribute("SAMLRequest"));
        logger.debug("     session [filter] RelayState: " + session.getAttribute("RelayState"));
        boolean injectBanner = false;
        PluginSettings globalPluginSettings = SecSignIDCommonStaticAccessor.getPluginSettingsFactory().createGlobalSettings();
        Object value = globalPluginSettings.get("toAllSettingsAsOne");
        Object value2 = globalPluginSettings.get("toAllSettingsAsOneNew");
        if (value == null && value2 == null) {
            value = globalPluginSettings.get("toAllSettingsAsOneStarted");
            value2 = globalPluginSettings.get("toAllSettingsAsOneNewStarted");
            if (value == null && value == null) {
                logger.warn("Change To One Attribute needed");
                globalPluginSettings.put("toAllSettingsAsOneStarted", (Object)String.valueOf(true));
                globalPluginSettings.put("toAllSettingsAsOneNewStarted", (Object)String.valueOf(true));
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            SecSignIDAuthenticationFilter.this.dataAccessor.changeToOneAttribute();
                        }
                        catch (OperationFailedException e) {
                            logger.error("OperationFailedException on changeToOneAttribute");
                        }
                        catch (InvalidAuthenticationException e) {
                            logger.error("OperationFailedException on changeToOneAttribute");
                        }
                        catch (ApplicationPermissionException e) {
                            logger.error("OperationFailedException on changeToOneAttribute");
                        }
                        catch (DirectoryPermissionException e) {
                            logger.error("OperationFailedException on changeToOneAttribute");
                        }
                    }
                }.start();
                injectBanner = true;
                logger.warn("Change To One Attribute started");
            } else {
                logger.warn("Change To One Attribute in progress");
                injectBanner = true;
            }
        }
        if ((appliedFilterAndSentRedirect = this.filterUrlAndSendRedirect(requestUri, httpServletReq, httpServletResp)) || httpServletResp.isCommitted()) {
            return;
        }
        logger.debug("Not filtered the request uri '" + requestUri + "' as login page.");
        if (injectBanner) {
            SecSignIDServletResponseWrapper responseWrapper = new SecSignIDServletResponseWrapper((HttpServletResponse)response);
            filterChain.doFilter(request, (ServletResponse)responseWrapper);
            String contentType = responseWrapper.getContentType();
            if (contentType != null && contentType.contains("text/html") && !httpServletResp.containsHeader("bannerAdded")) {
                HashMap context = new HashMap();
                SecSignIDCharArrayWriter renderedTemplate = new SecSignIDCharArrayWriter();
                this.templateRenderer.render(this.bannerTemplate, context, (Writer)renderedTemplate);
                httpServletResp.addHeader("bannerAdded", String.valueOf(true));
                responseWrapper.inject(renderedTemplate);
            }
            try {
                PrintWriter responseOutput = response.getWriter();
                response.setContentLength(responseWrapper.length());
                responseOutput.write(responseWrapper.toString());
                responseOutput.close();
            }
            catch (Exception responseOutput) {}
        } else if (SecSignIDStaticAccessor.hasDeactivatedAccessOption() && !requestUri.contains("plugins/servlet/secsignid") && !requestUri.contains("dev-toolbar") && !requestUri.contains(".js")) {
            SecSignIDServletResponseWrapper responseWrapper = new SecSignIDServletResponseWrapper((HttpServletResponse)response);
            filterChain.doFilter(request, (ServletResponse)responseWrapper);
            String contentType = responseWrapper.getContentType();
            if (contentType != null && contentType.contains("text/html") && !httpServletResp.containsHeader("accessBannerAdded")) {
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("contextPath", httpServletReq.getContextPath());
                SecSignIDCharArrayWriter renderedTemplate = new SecSignIDCharArrayWriter();
                this.templateRenderer.render(this.accessBannerTemplate, context, (Writer)renderedTemplate);
                httpServletResp.addHeader("accessBannerAdded", String.valueOf(true));
                responseWrapper.inject(renderedTemplate);
            }
            try {
                PrintWriter responseOutput = response.getWriter();
                response.setContentLength(responseWrapper.length());
                responseOutput.write(responseWrapper.toString());
                responseOutput.close();
            }
            catch (Exception exception) {}
        } else {
            filterChain.doFilter((ServletRequest)httpServletReq, (ServletResponse)httpServletResp);
        }
    }

    private boolean filterUrlAndSendRedirect(String requestUri, HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        logger.debug("Filter " + requestUri + " to check SAML and SSO tokens.");
        if (requestUri.contains("sso.action")) {
            logger.debug("requestURL " + requestUri + " contains SAML parameters.");
            HttpSession session = httpServletReq.getSession();
            Object appUserObject = session.getAttribute("SPRING_SECURITY_CONTEXT");
            if (appUserObject != null) {
                return false;
            }
            if (httpServletReq.getParameter("SAMLRequest") != null) {
                logger.info("Found SAML request parameter and store it in a session.");
                String samlRequest = httpServletReq.getParameter("SAMLRequest");
                String relayState = httpServletReq.getParameter("RelayState");
                session.setAttribute("SAMLRequest", (Object)samlRequest);
                session.setAttribute("SAMLRequestEncoding", (Object)Boolean.FALSE);
                session.setAttribute("RelayState", (Object)relayState);
                return false;
            }
            logger.debug("Filtered sso.action but did not find a SAMLRequest parameter");
        } else {
            if (requestUri.contains("plugins/servlet/login")) {
                String tokenName;
                logger.debug("crowdLogin called, check for SAML and SSO");
                String returnUrl = "";
                String crowdBaseUrl = this.dataAccessor.getBaseUrl();
                if (httpServletReq.getParameter("next") != null) {
                    String next;
                    logger.debug("next found -> SAML");
                    returnUrl = next = String.valueOf(httpServletReq.getParameter("next"));
                    if (next.contains("sso.action") && next.contains("SAMLRequest")) {
                        HttpSession session = httpServletReq.getSession();
                        Object appUserObject = session.getAttribute("SPRING_SECURITY_CONTEXT");
                        if (appUserObject != null) {
                            logger.info("Found SAML request parameter in (cached) next parameter and store it in a session and user object in spring security context. Traverse the filter chain.");
                            return false;
                        }
                        URL urlToParseForSAMLRequestParam = new URL(crowdBaseUrl + next);
                        HashMap<String, Object> queryMap = SecSignIDMappingUtils.createQueryMap(urlToParseForSAMLRequestParam.getQuery(), false);
                        if (queryMap.get("SAMLRequest") != null) {
                            logger.info("Found SAML request parameter in (cached) next parameter and store it in a session.");
                            session.setAttribute("SAMLRequest", queryMap.get("SAMLRequest"));
                            session.setAttribute("RelayState", queryMap.get("RelayState"));
                            session.setAttribute("SAMLRequestEncoding", (Object)Boolean.TRUE);
                            httpServletResp.sendRedirect(crowdBaseUrl + "/plugins/servlet/secsignid");
                            return true;
                        }
                        logger.debug("Found next parameter with SAML SSO login url, but could not parse SAMLRequest value.");
                    }
                }
                if ((tokenName = SecSignIDStaticAccessor.getTokenKey()) != null) {
                    logger.debug("Check for a SSO token with name:'" + tokenName + "'");
                    Cookie[] cookies = httpServletReq.getCookies();
                    logger.debug("All found cookies: " + cookies.toString());
                    if (cookies != null) {
                        for (Cookie cookie : cookies) {
                            logger.debug("Check cookie '" + cookie.getName() + "' to match token name '" + tokenName + "'.");
                            if (!tokenName.equals(cookie.getName())) continue;
                            logger.debug("Found cookie for token '" + tokenName + "' and check if a user can be found for that token.");
                            try {
                                Application crowdApp = SecSignIDStaticAccessor.getApplicationManager().findByName("crowd");
                                if (SecSignIDStaticAccessor.getTokenAuthenticationManager() != null) {
                                    User user;
                                    block30: {
                                        TokenAuthenticationManager tam = SecSignIDStaticAccessor.getTokenAuthenticationManager();
                                        user = null;
                                        try {
                                            Method findUserByTokenMethod = tam.getClass().getMethod("findUserByToken", String.class, String.class);
                                            user = (User)findUserByTokenMethod.invoke((Object)tam, cookie.getValue(), crowdApp.getName());
                                        }
                                        catch (NoSuchMethodException ex1) {
                                            try {
                                                Method findUserByTokenMethod = tam.getClass().getMethod("findUserByToken", String.class, Application.class);
                                                user = (User)findUserByTokenMethod.invoke((Object)tam, cookie.getValue(), crowdApp);
                                            }
                                            catch (NoSuchMethodException ex2) {
                                                Token userToken = null;
                                                try {
                                                    Method findUserTokenByKeyMethod = tam.getClass().getMethod("findUserTokenByKey", String.class, String.class);
                                                    userToken = (Token)findUserTokenByKeyMethod.invoke((Object)tam, cookie.getValue(), crowdApp.getName());
                                                }
                                                catch (NoSuchMethodException ex3) {
                                                    try {
                                                        Method findUserTokenByKeyMethod = tam.getClass().getMethod("findUserTokenByKey", String.class, Application.class);
                                                        userToken = (Token)findUserTokenByKeyMethod.invoke((Object)tam, cookie.getValue(), crowdApp);
                                                    }
                                                    catch (NoSuchMethodException noSuchMethodException) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (userToken == null) break block30;
                                                logger.debug("Token found -> check by find User By Token " + userToken.getRandomHash());
                                                try {
                                                    Method findUserByTokenMethod = tam.getClass().getMethod("findUserByToken", Token.class, Application.class);
                                                    user = (User)findUserByTokenMethod.invoke((Object)tam, userToken, crowdApp);
                                                }
                                                catch (NoSuchMethodException noSuchMethodException) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                    }
                                    logger.info("Found user '" + user + "' for token '" + cookie.getValue() + "'.");
                                    return false;
                                }
                                logger.warn("Could not get a token authentication manager via static accessor.");
                            }
                            catch (InvocationTargetException ex) {
                                Throwable cause = ex.getCause();
                                if (cause == null) {
                                    cause = ex;
                                }
                                logger.info("Could not get user for token '" + tokenName + "': " + cause.getMessage());
                            }
                            catch (Exception e) {
                                logger.error("Could not check token and user for token '" + tokenName + "': " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                logger.info("Did not find a token or a user for token. Send redirect to /plugins/servlet/secsignid");
                httpServletResp.sendRedirect(crowdBaseUrl + "/plugins/servlet/secsignid" + "?" + "returnUrl" + "=" + returnUrl);
                return true;
            }
            if (requestUri.contains("/plugins/servlet/secsignid")) {
                logger.debug("Check spring security context.");
                HttpSession session = httpServletReq.getSession();
                Object appUserObject = session.getAttribute("SPRING_SECURITY_CONTEXT");
                if (appUserObject != null) {
                    logger.debug("SPRING_SECURITY_CONTEXT is not null -> user should be logged in. Check for SAML");
                    if (session.getAttribute("SAMLRequest") != null) {
                        logger.info("Found user object in spring security context and a SAML request in session. Traverse the filter chain.");
                        return false;
                    }
                    logger.info("Found user object in spring security context. Send redirect to /console/secure/console.action");
                    String crowdBaseUrl = this.dataAccessor.getBaseUrl();
                    httpServletResp.sendRedirect(crowdBaseUrl);
                    return true;
                }
            }
        }
        return false;
    }

    public void init(FilterConfig fc) throws ServletException {
    }

    public void destroy() {
    }
}

