/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.accessor;

import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.audit.AuditService;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.login.ForgottenLoginManager;
import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SecSignIDStaticAccessor {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDStaticAccessor.class);
    private static DirectoryInstanceLoader directoryInstanceLoader;
    private static PluginSettingsFactory pluginSettingsFactory;
    private static DirectoryManager directoryManager;
    private static ApplicationService applicationService;
    private static ApplicationManager applicationManager;
    private static PluginAccessor pluginAccessor;
    private static PropertyManager propertyManager;
    private static TokenAuthenticationManager tokenAuthenticationManager;
    private static MailManager mailManager;
    private static ForgottenLoginManager forgottenLoginManager;
    private static AuditService auditService;
    private static UserManager userManager;

    @Autowired
    public SecSignIDStaticAccessor(AuditService auditService, DirectoryInstanceLoader directoryInstanceLoader, PluginSettingsFactory pluginSettingsFactory, DirectoryManager directoryManager, ApplicationService applicationService, ApplicationManager applicationManager, PluginAccessor pluginAccessor, PropertyManager propertyManager, MailManager mailManager, TokenAuthenticationManager tokenAuthenticationManager, UserManager userManager, ForgottenLoginManager forgottenLoginManager) {
        SecSignIDStaticAccessor.directoryInstanceLoader = directoryInstanceLoader;
        SecSignIDStaticAccessor.pluginSettingsFactory = pluginSettingsFactory;
        SecSignIDStaticAccessor.directoryManager = directoryManager;
        SecSignIDStaticAccessor.applicationService = applicationService;
        SecSignIDStaticAccessor.applicationManager = applicationManager;
        SecSignIDStaticAccessor.pluginAccessor = pluginAccessor;
        SecSignIDStaticAccessor.propertyManager = propertyManager;
        SecSignIDStaticAccessor.tokenAuthenticationManager = tokenAuthenticationManager;
        SecSignIDStaticAccessor.mailManager = mailManager;
        SecSignIDStaticAccessor.forgottenLoginManager = forgottenLoginManager;
        SecSignIDStaticAccessor.auditService = auditService;
        SecSignIDStaticAccessor.userManager = userManager;
    }

    public static UserManager getUserManager() {
        return userManager;
    }

    public static AuditService getAuditService() {
        return auditService;
    }

    public static ForgottenLoginManager getForgottenLoginManager() {
        return forgottenLoginManager;
    }

    public static MailManager getMailManager() {
        return mailManager;
    }

    public static TokenAuthenticationManager getTokenAuthenticationManager() {
        return tokenAuthenticationManager;
    }

    public static PluginSettingsFactory getPluginSettingsFactory() {
        return pluginSettingsFactory;
    }

    public static PropertyManager getPropertyManager() {
        return propertyManager;
    }

    public static DirectoryInstanceLoader getDirectoryInstanceLoader() {
        return directoryInstanceLoader;
    }

    public static DirectoryManager getDirectoryManager() {
        return directoryManager;
    }

    public static ApplicationService getApplicationService() {
        return applicationService;
    }

    public static ApplicationManager getApplicationManager() {
        return applicationManager;
    }

    public static PluginAccessor getPluginAccessor() {
        return pluginAccessor;
    }

    public static String getTokenKey() {
        try {
            Class<?> propManager = SecSignIDStaticAccessor.getPropertyManager().getClass();
            Method method = propManager.getMethod("getCookieConfiguration", new Class[0]);
            CookieConfiguration config = (CookieConfiguration)method.invoke((Object)SecSignIDStaticAccessor.getPropertyManager(), new Object[0]);
            if (config != null && config.getName() != null) {
                logger.info("Found token key '" + config.getName() + "' for SSO");
                return config.getName();
            }
            return "crowd.token_key";
        }
        catch (Exception e) {
            logger.error("Cannot get token name from cookie configuration: " + e.getMessage(), (Throwable)e);
            PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
            Object value = pluginSettings.get("com.secsign.tokenkey");
            if (value != null) {
                return (String)value;
            }
            return "crowd.token_key";
        }
    }

    public static boolean hasDeactivatedAccessOption() {
        try {
            long build = Long.parseLong(SecSignIDCommonStaticAccessor.getApplicationProperties().getBuildNumber());
            Application app = SecSignIDStaticAccessor.getApplicationManager().findByName("crowd");
            String value = app.getValue("insecureAuthenticationEnabled");
            return (value == null || value.equals("false")) && build >= 1632L;
        }
        catch (Exception exception) {
            return true;
        }
    }
}

