/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.accessor;

import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEntityType;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.core.util.ConversionUtils;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.manager.audit.AuditService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.audit.AuditLogChangesetEntity;
import com.atlassian.crowd.model.audit.AuditLogEntityEntity;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.token.TokenLifetime;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.service.client.CrowdClient;
import com.atlassian.crowd.util.BoundedCount;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.user.UserProfile;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.accessor.SecSignIDMappingExtractor;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import com.secsign.crowd.SecSignIDCrowdException;
import com.secsign.crowd.accessor.SecSignIDStaticAccessor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SecSignIDDataAccessor
extends com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDDataAccessor.class);

    @Autowired
    public SecSignIDDataAccessor() {
    }

    @Override
    public final boolean isNewCrowd() {
        long build = Long.parseLong(SecSignIDCommonStaticAccessor.getApplicationProperties().getBuildNumber());
        return build > 1425L;
    }

    @Override
    public Set<String> getAllUserGroupsMappingKeys() {
        DirectoryManager localDirectoryManager = SecSignIDStaticAccessor.getDirectoryManager();
        List dirs = localDirectoryManager.findAllDirectories();
        LinkedHashSet<String> _groupNames = new LinkedHashSet<String>();
        if (dirs != null) {
            for (Directory directory : dirs) {
                if (!directory.isActive()) continue;
                EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
                try {
                    List groups = localDirectoryManager.searchGroups(directory.getId().longValue(), query);
                    for (String groupName : groups) {
                        _groupNames.add(groupName.toLowerCase().replace(" ", "___") + ";" + directory.getId());
                    }
                }
                catch (Exception e) {
                    logger.debug("Could not get user groups for directory with ID " + directory.getId() + ". Skip directory and use next one. (" + e.getMessage() + ")");
                }
            }
        } else {
            logger.warn("Did not get a list of directories.");
        }
        return _groupNames;
    }

    @Override
    public List<String> getGroupMappingKeysForUserKey(String userKey, long dirid) throws OperationFailedException {
        ArrayList<String> result = new ArrayList<String>();
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(this.getUsernameForUserKey(userKey)).returningAtMost(-1);
        ArrayList<String> groups = new ArrayList();
        try {
            groups = SecSignIDStaticAccessor.getDirectoryManager().searchNestedGroupRelationships(dirid, query);
        }
        catch (DirectoryNotFoundException e) {
            e.printStackTrace();
        }
        result.addAll(SecSignIDMappingUtils.fixGroupListForDirIDAndEscape(groups, dirid));
        return result;
    }

    @Override
    public List<Directory> getAllDirectories() {
        ArrayList<Directory> activatedDirs = new ArrayList<Directory>();
        List allDirs = SecSignIDStaticAccessor.getDirectoryManager().findAllDirectories();
        for (Directory directory : allDirs) {
            if (!directory.isActive()) continue;
            activatedDirs.add(directory);
        }
        return activatedDirs;
    }

    @Override
    public Collection<String> findGroupMembersUsernames(long dirID, String groupname) throws DirectoryNotFoundException, OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupname).startingAt(0).returningAtMost(-1);
        DirectoryManager localDirectoryManager = SecSignIDStaticAccessor.getDirectoryManager();
        return localDirectoryManager.searchNestedGroupRelationships(dirID, query);
    }

    @Override
    public Collection<String> findAllUsernames(long dirID) throws DirectoryNotFoundException, OperationFailedException {
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(0).returningAtMost(-1);
        DirectoryManager localDirectoryManager = SecSignIDStaticAccessor.getDirectoryManager();
        return localDirectoryManager.searchUsers(dirID, query);
    }

    @Override
    public String getEmailForUserKey(String username, long dirid) throws UserNotFoundException, ApplicationNotFoundException, OperationFailedException, DirectoryNotFoundException {
        return SecSignIDStaticAccessor.getDirectoryManager().findUserByName(dirid, username).getEmailAddress();
    }

    @Override
    public void deleteAllOptionsAndMappings() {
        PluginSettings globalPluginSettings = SecSignIDStaticAccessor.getPluginSettingsFactory().createGlobalSettings();
        globalPluginSettings.remove("com.secsign.allow.user.create");
        globalPluginSettings.remove("com.secsign.allow.user.existing");
        globalPluginSettings.remove("com.secsign.androidUrl");
        globalPluginSettings.remove("com.secsign.crowdurl");
        globalPluginSettings.remove("com.secsign.companyname");
        globalPluginSettings.remove("com.secsign.customlogin");
        globalPluginSettings.remove("com.secsign.customlogo");
        globalPluginSettings.remove("com.secsign.basicauth");
        globalPluginSettings.remove("com.secsign.idserverurl.fallback");
        globalPluginSettings.remove("com.secsign.autofillusername");
        globalPluginSettings.remove("com.secsign.autofillmail");
        globalPluginSettings.remove("com.secsign.autofillusernamecompany");
        globalPluginSettings.remove("com.secsign.autofillpattern");
        globalPluginSettings.remove("com.secsign.autofillpatternpattern");
        globalPluginSettings.remove("com.secsign.firststart");
        globalPluginSettings.remove("com.secsign.gitaccess.2fa.enabled");
        globalPluginSettings.remove("com.secsign.gitaccess.block.user.without.secsignid");
        globalPluginSettings.remove("com.secsign.gitaccess.enabled.for.group");
        globalPluginSettings.remove("com.secsign.gitaccess.ipsafezone.enabled");
        globalPluginSettings.remove("com.secsign.gitaccess.new2fa.required.after.hours");
        globalPluginSettings.remove("com.secsign.gitaccess.protect.read.commands");
        globalPluginSettings.remove("com.secsign.idserverurl");
        globalPluginSettings.remove("com.secsign.iOSUrl");
        globalPluginSettings.remove("com.secsign.ldapattr");
        globalPluginSettings.remove("com.secsign.ldapenable");
        globalPluginSettings.remove("com.secsign.logincolor");
        globalPluginSettings.remove("com.secsign.logintitle");
        globalPluginSettings.remove("com.secsign.loginsubtitle");
        globalPluginSettings.remove("com.secsign.hidepasswordlesslink");
        globalPluginSettings.remove("com.secsign.macOSUrl");
        globalPluginSettings.remove("com.secsign.mailotp");
        globalPluginSettings.remove("com.secsign.noaccesspass");
        globalPluginSettings.remove("com.secsign.otpauth");
        globalPluginSettings.remove("com.secsign.passwordless");
        globalPluginSettings.remove("com.secsign.pinuser");
        globalPluginSettings.remove("com.secsign.pinpassword");
        globalPluginSettings.remove("com.secsign.resetcrowd");
        globalPluginSettings.remove("com.secsign.safezone");
        globalPluginSettings.remove("com.secsign.safezonerange");
        globalPluginSettings.remove("com.secsign.secsignauth");
        globalPluginSettings.remove("com.secsign.secsignid");
        globalPluginSettings.remove("com.secsign.servicedesk");
        globalPluginSettings.remove("com.secsign.servicedesk.2fa");
        globalPluginSettings.remove("com.secsign.servicename");
        globalPluginSettings.remove("com.secsign.sessiontimeout");
        globalPluginSettings.remove("com.secsign.sessiontimeout.duration");
        globalPluginSettings.remove("com.secsign.synchid");
        globalPluginSettings.remove("com.secsign.synchwrite");
        globalPluginSettings.remove("com.secsign.totp");
        globalPluginSettings.remove("com.secsign.twostep");
        globalPluginSettings.remove("com.secsign.crowdnewlogin");
        globalPluginSettings.remove("com.secsign.trustdevice");
        globalPluginSettings.remove("com.secsign.trustdevice.duration");
        globalPluginSettings.remove("com.secsign.userchange");
        globalPluginSettings.remove("com.secsign.userestore");
        globalPluginSettings.remove("com.secsign.windowsUrl");
        globalPluginSettings.remove("com.secsign.writeldap");
        globalPluginSettings.remove("fixFor4_5_0_groups_started");
        globalPluginSettings.remove("fixFor4_5_0_groups_done");
        try {
            List dirs = SecSignIDStaticAccessor.getDirectoryManager().findAllDirectories();
            for (Directory directory : dirs) {
                try {
                    SecSignIDStaticAccessor.getDirectoryManager().removeGroup(directory.getId().longValue(), "PasswordlessAllowed");
                }
                catch (DirectoryPermissionException directoryPermissionException) {
                }
                catch (OperationFailedException operationFailedException) {
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                }
                catch (ReadOnlyGroupException readOnlyGroupException) {
                    // empty catch block
                }
                try {
                    SecSignIDStaticAccessor.getDirectoryManager().removeGroup(directory.getId().longValue(), "2SASecSignIDAllowed");
                }
                catch (DirectoryPermissionException directoryPermissionException) {
                }
                catch (OperationFailedException operationFailedException) {
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                }
                catch (ReadOnlyGroupException readOnlyGroupException) {
                    // empty catch block
                }
                try {
                    SecSignIDStaticAccessor.getDirectoryManager().removeGroup(directory.getId().longValue(), "2SAMailOTPAllowed");
                }
                catch (DirectoryPermissionException directoryPermissionException) {
                }
                catch (OperationFailedException operationFailedException) {
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                }
                catch (ReadOnlyGroupException readOnlyGroupException) {
                    // empty catch block
                }
                try {
                    SecSignIDStaticAccessor.getDirectoryManager().removeGroup(directory.getId().longValue(), "2SATOTPAllowed");
                }
                catch (DirectoryPermissionException directoryPermissionException) {
                }
                catch (OperationFailedException operationFailedException) {
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                }
                catch (ReadOnlyGroupException readOnlyGroupException) {}
            }
            SecSignIDMappingExtractor.deleteAllUser2FASettings();
            SecSignIDMappingExtractor.deleteLocalMappings();
            SecSignIDMappingExtractor.deleteAllGroup2FASettings();
        }
        catch (DirectoryPermissionException dirs) {
        }
        catch (OperationFailedException dirs) {
        }
        catch (UserNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvalidAuthenticationException e) {
            e.printStackTrace();
        }
        catch (ApplicationPermissionException e) {
            e.printStackTrace();
        }
        catch (DirectoryNotFoundException e) {
            e.printStackTrace();
        }
        catch (GroupNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getAllOptionsAsString() {
        StringBuilder answer = new StringBuilder();
        answer.append("com.secsign.idserverurl : " + SecSignIDCommonStaticAccessor.getSecSignIdServerUrl() + "%0A");
        answer.append("com.secsign.usefallback : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getUseFallback()) + "%0A");
        answer.append("com.secsign.idserverurl.fallback : " + SecSignIDCommonStaticAccessor.getFallbackSecSignIdServerUrl() + "%0A");
        answer.append("com.secsign.companyname : " + SecSignIDCommonStaticAccessor.getCompanyName() + "%0A");
        answer.append("com.secsign.servicename : " + SecSignIDCommonStaticAccessor.getServiceName() + "%0A");
        answer.append("com.secsign.cachedbaseurl : " + this.getBaseUrl() + "%0A");
        answer.append("com.secsign.userestore : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getUseRestore()) + "%0A");
        answer.append("com.secsign.noaccesspass : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getNoAccessPass()) + "%0A");
        answer.append("com.secsign.hidepasswordlesslink : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getHidePasswordlessLink()) + "%0A");
        answer.append("com.secsign.groups.created : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getGroupsCreated()) + "%0A");
        answer.append("com.secsign.inform.admin : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getInformAdmin()) + "%0A");
        answer.append("com.secsign.inform.group : " + SecSignIDCommonStaticAccessor.getInformGroup() + "%0A");
        answer.append("com.secsign.observe.group : " + SecSignIDCommonStaticAccessor.getObserveGroup() + "%0A");
        answer.append("com.secsign.inform.user : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getInformUser()) + "%0A");
        answer.append("com.secsign.autofillusername : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getAutoFillUsername()) + "%0A");
        answer.append("com.secsign.autofillusernamecompany : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getAutoFillUsernameCompany()) + "%0A");
        answer.append("com.secsign.autofillmail : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getAutoFillMail()) + "%0A");
        answer.append("com.secsign.autofillpattern : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getAutoFillPattern()) + "%0A");
        answer.append("com.secsign.autofillpatternpattern : " + SecSignIDCommonStaticAccessor.getAutoFillPatternPattern() + "%0A");
        answer.append("com.secsign.allow.user.create : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getAllowUserCreate()) + "%0A");
        answer.append("com.secsign.allow.user.existing : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getAllowUserExisting()) + "%0A");
        answer.append("com.secsign.basicauth : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.isBasicAuthDisabled()) + "%0A");
        answer.append("com.secsign.accesstoken : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.isAccessTokenDisabled()) + "%0A");
        answer.append("com.secsign.whitelist : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getWhiteList().toString()) + "%0A");
        answer.append("com.secsign.safezone : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getSafeZone()) + "%0A");
        answer.append("com.secsign.safezonerange : " + SecSignIDCommonStaticAccessor.getIPRanges() + "%0A");
        answer.append("com.secsign.userchange : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getUserChange()) + "%0A");
        answer.append("com.secsign.customlogin : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getCustomLogin()) + "%0A");
        answer.append("com.secsign.logincolor : " + SecSignIDCommonStaticAccessor.getLoginColor() + "%0A");
        answer.append("com.secsign.crowdnewlogin : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) + "%0A");
        answer.append("com.secsign.logintitle : " + SecSignIDCommonStaticAccessor.getLoginTitle() + "%0A");
        answer.append("com.secsign.loginsubtitle : " + SecSignIDCommonStaticAccessor.getLoginSubtitle() + "%0A");
        answer.append("com.secsign.customlogo : " + SecSignIDCommonStaticAccessor.getCustomLogo() + "%0A");
        answer.append("com.secsign.sessiontimeout : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getSessionTimeoutEnabled()) + "%0A");
        answer.append("com.secsign.sessiontimeout.duration : " + Integer.valueOf(SecSignIDCommonStaticAccessor.getSessionTimeoutDuration()) + "%0A");
        answer.append("com.secsign.trustdevice : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getTrustDeviceEnabled()) + "%0A");
        answer.append("com.secsign.trustdevice.duration : " + Integer.valueOf(SecSignIDCommonStaticAccessor.getTrustDeviceDuration()) + "%0A");
        answer.append("com.secsign.localenable : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getLocalEnable()) + "%0A");
        answer.append("com.secsign.ldapenable : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getLDAPEnable()) + "%0A");
        answer.append("com.secsign.ldapattr : " + SecSignIDCommonStaticAccessor.getLDAPSecSignIDAttr() + "%0A");
        answer.append("com.secsign.writeldap : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getWriteLDAPEnable()) + "%0A");
        answer.append("com.secsign.secsign.enabled : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled()) + "%0A");
        answer.append("com.secsign.fido.enabled : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getFidoAuthEnabled()) + "%0A");
        answer.append("com.secsign.totp.enabled : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getTotpAuthEnabled()) + "%0A");
        answer.append("com.secsign.mailotp.enabled : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getMailotpAuthEnabled()) + "%0A");
        answer.append("com.secsign.passwordless.enabled : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled()) + "%0A");
        if (this.getApplication().equals("Crowd")) {
            answer.append("com.secsign.localenable : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getLocalEnable()) + "%0A");
            answer.append("com.secsign.ldapenable : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getLDAPEnable()) + "%0A");
            answer.append("com.secsign.ldapattr : " + SecSignIDCommonStaticAccessor.getLDAPSecSignIDAttr() + "%0A");
            answer.append("com.secsign.writeldap : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getWriteLDAPEnable()) + "%0A");
        }
        if (this.getApplication().equals("Jira")) {
            answer.append("com.secsign.servicedesk.2fa : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getServiceDesk2FA()) + "%0A");
            answer.append("com.secsign.servicedeskgroup : " + SecSignIDCommonStaticAccessor.getServiceDeskGroups() + "%0A");
            answer.append("com.secsign.servicedesk : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getServiceDesk()) + "%0A");
        }
        if (this.getApplication().equals("Bitbucket")) {
            answer.append("com.secsign.gitaccess.2fa.enabled : " + SecSignIDCommonStaticAccessor.getGitAccessSecuredBy2FA() + "%0A");
            answer.append("com.secsign.gitaccess.enabled.for.group : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getGitAccessEnabledForGroups()) + "%0A");
            answer.append("com.secsign.gitaccess.ipsafezone.enabled : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getGitAccessIPSafeZoneEnabled()) + "%0A");
            answer.append("com.secsign.gitaccess.new2fa.required.after.hours : " + SecSignIDCommonStaticAccessor.getGitAccessNew2FARequiredAfterHours() + "%0A");
            answer.append("com.secsign.gitaccess.protect.read.commands : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getGitAccessProtectReadAccessBy2FA()) + "%0A");
        }
        answer.append("Used directories: {");
        List<Directory> dirs = this.getAllDirectories();
        for (Directory directory : dirs) {
            answer.append(directory.getType().name() + ",");
        }
        answer.append("}%0A");
        return answer.toString();
    }

    @Override
    public User getUserForKey(String userKey, long dirid) throws OperationFailedException {
        try {
            return SecSignIDStaticAccessor.getDirectoryManager().findUserByName(dirid, userKey);
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException userNotFoundException) {
        }
        catch (DirectoryNotFoundException directoryNotFoundException) {
        }
        catch (UserNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getUserKeyForUsername(String username) {
        return username;
    }

    @Override
    public String getUsernameForUserKey(String userKey) {
        return userKey;
    }

    @Override
    public User getUserCurrentlyLoggedIn() {
        UserProfile userProfile = SecSignIDStaticAccessor.getUserManager().getRemoteUser();
        if (userProfile != null) {
            try {
                return this.getUserForKeyFirst(userProfile.getUserKey().getStringValue());
            }
            catch (OperationFailedException e) {
                logger.debug("Could not get admin user: " + e.getLocalizedMessage());
            }
        }
        return null;
    }

    @Override
    public String getApplication() {
        return "Crowd";
    }

    @Override
    public List<String> getGroups(int page, long dirid) throws DirectoryNotFoundException, OperationFailedException {
        DirectoryManager localDirectoryManager = SecSignIDStaticAccessor.getDirectoryManager();
        int userPerPage = 10;
        LinkedHashSet<String> _groupNames = new LinkedHashSet<String>();
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).startingAt((page - 1) * userPerPage).returningAtMost(userPerPage);
        try {
            List groups = localDirectoryManager.searchGroups(dirid, query);
            for (String groupName : groups) {
                _groupNames.add(groupName.toLowerCase().replace(" ", "___") + ";" + dirid);
            }
        }
        catch (Exception e) {
            logger.debug("Could not get user groups for directory with ID " + dirid + ". Skip directory and use next one. (" + e.getMessage() + ")");
        }
        return new ArrayList<String>(_groupNames);
    }

    @Override
    public int getPagesGroup(long dirid) throws DirectoryNotFoundException, OperationFailedException {
        DirectoryManager localDirectoryManager = SecSignIDStaticAccessor.getDirectoryManager();
        int groupsPerPage = 10;
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).startingAt(0).returningAtMost(-1);
        try {
            List groups = localDirectoryManager.searchGroups(dirid, query);
            if (groups.size() % groupsPerPage == 0) {
                return groups.size() / groupsPerPage;
            }
            return groups.size() / groupsPerPage + 1;
        }
        catch (Exception e) {
            logger.debug("Could not get user groups for directory with ID " + dirid + ". Skip directory and use next one. (" + e.getMessage() + ")");
            return 0;
        }
    }

    @Override
    public String getVersion() {
        return SecSignIDStaticAccessor.getPluginAccessor().getPlugin("com.secsign.secsign-crowd").getPluginInformation().getVersion();
    }

    @Override
    public String getUserProfileLink(User appUser, String baseUrl) {
        String url = baseUrl + "/console/secure/user/view!execute.action?name=" + appUser.getName() + "&directoryID=" + appUser.getDirectoryId();
        return url;
    }

    @Override
    public List<User> getUsersByGroup(long dirid, String groupName, int page) throws DirectoryNotFoundException, OperationFailedException {
        int userPerPage = 10;
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(userPerPage * (page - 1)).returningAtMost(userPerPage);
        DirectoryManager localDirectoryManager = SecSignIDStaticAccessor.getDirectoryManager();
        ArrayList<User> result = new ArrayList<User>();
        List users = localDirectoryManager.searchDirectGroupRelationships(dirid, query);
        for (User user : users) {
            result.add(user);
        }
        return result;
    }

    @Override
    public List<User> getUsersBySearchKey(String _searchKey) throws DirectoryNotFoundException, OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException {
        LinkedHashSet _searchUsersSet = new LinkedHashSet();
        DirectoryManager localDirectoryManager = SecSignIDStaticAccessor.getDirectoryManager();
        List dirs = localDirectoryManager.findAllDirectories();
        EntityQuery queryWithUserName = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)_searchKey)).startingAt(0).returningAtMost(-1);
        EntityQuery queryWithSecSignId = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsignid")).containing((Object)_searchKey)).startingAt(0).returningAtMost(-1);
        if (dirs != null) {
            for (Directory dir : dirs) {
                if (!dir.isActive()) continue;
                long directoryID = dir.getId();
                _searchUsersSet.addAll(localDirectoryManager.searchUsers(directoryID, queryWithUserName));
                _searchUsersSet.addAll(localDirectoryManager.searchUsers(directoryID, queryWithSecSignId));
            }
        } else {
            logger.error("Did not get a list of directories.");
        }
        ArrayList<User> users = new ArrayList<User>(_searchUsersSet);
        if (users.size() != 0) {
            Collections.sort(users, new Comparator<User>(){

                @Override
                public int compare(User user1, User user2) {
                    if (user1 == null) {
                        return 1;
                    }
                    if (user2 == null) {
                        return -1;
                    }
                    return user1.getName().toLowerCase().compareTo(user2.getName().toLowerCase());
                }
            });
        }
        return users;
    }

    @Override
    public long getPagesForGroup(long _chosenDir, String _groupName) throws DirectoryNotFoundException, OperationFailedException {
        int userPerPage = 10;
        BoundedCount count = SecSignIDStaticAccessor.getDirectoryManager().countDirectMembersOfGroup(_chosenDir, _groupName, 1000);
        if (count.getCount() % (long)userPerPage == 0L) {
            return count.getCount() / (long)userPerPage;
        }
        return count.getCount() / (long)userPerPage + 1L;
    }

    @Override
    public boolean isChangeable(User user) {
        return true;
    }

    @Override
    public void updateAllMappings(boolean synchronizable, boolean synchwrite) throws DirectoryPermissionException, OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, DirectoryNotFoundException, com.atlassian.crowd.exception.runtime.OperationFailedException, OperationNotPermittedException {
    }

    @Override
    public String getBaseUrl() {
        try {
            return SecSignIDStaticAccessor.getPropertyManager().getBaseUrl().toString();
        }
        catch (PropertyManagerException e) {
            logger.error("PropertyManagerException on getBaseUrl");
            return "";
        }
    }

    @Override
    public Boolean canWrite() {
        return SecSignIDCommonStaticAccessor.getLocalEnable() || SecSignIDCommonStaticAccessor.getWriteLDAPEnable();
    }

    @Override
    public User getUserForKeyFirst(String userKey) throws OperationFailedException {
        try {
            Application app = SecSignIDStaticAccessor.getApplicationManager().findByName("crowd");
            com.atlassian.crowd.model.user.User user = SecSignIDStaticAccessor.getApplicationService().findUserByName(app, userKey);
            return user;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on getCrowdUserForUsernameFirst");
            e.printStackTrace();
        }
        catch (ApplicationNotFoundException e) {
            logger.error("ApplicationNotFoundException on getCrowdUserForUsernameFirst");
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on getCrowdUserForUsernameFirst");
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void changeToDirID() {
    }

    @Override
    public HashMap<String, Object> getAuthenticatorContextMap(HttpServletRequest httpServletReq) {
        HashMap<String, Object> authenticatorContext = new HashMap<String, Object>();
        authenticatorContext.put("req", httpServletReq);
        String returnUrl = httpServletReq.getParameter("returnUrl");
        if (returnUrl == null || returnUrl.length() < 1) {
            returnUrl = httpServletReq.getParameter("os_destination");
        }
        String crowdLoginUrl = this.getBaseUrl();
        authenticatorContext.put("returnUrl", returnUrl);
        authenticatorContext.put("loginUrl", crowdLoginUrl);
        authenticatorContext.put("os_destination", returnUrl);
        authenticatorContext.put("originalurl", returnUrl);
        return authenticatorContext;
    }

    @Override
    public String loginWithUsernameAndPassword(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        ValidationFactor[] factors;
        User user;
        logger.debug("loginWithUsernameAndPassword started");
        String username = this.getUserNameFromRequest(request);
        if (username == null) {
            return "failed";
        }
        logger.debug("username is " + username);
        String password = request.getParameter("secsign_os_password");
        try {
            user = this.getUserForKeyFirst(username);
        }
        catch (OperationFailedException e1) {
            return "failed";
        }
        if (user == null) {
            return "failed";
        }
        logger.debug("user for username " + username + ": " + user.toString());
        UserAuthenticationContext userAuthContext = new UserAuthenticationContext();
        userAuthContext.setApplication("crowd");
        userAuthContext.setName(user.getName());
        userAuthContext.setCredential(new PasswordCredential(password, false));
        if (request.getHeader("X-FORWARDED-FOR") != null) {
            factors = new ValidationFactor[2];
            factors[0] = new ValidationFactor("remote_address", request.getRemoteAddr());
            if (request.getHeader("X-FORWARDED-FOR") != null) {
                factors[1] = new ValidationFactor("X-Forwarded-For", request.getHeader("X-FORWARDED-FOR"));
                logger.debug("Found ForwardedFor " + request.getHeader("X-FORWARDED-FOR") + " as ValidationFactor for username " + username);
            }
        } else {
            factors = new ValidationFactor[]{new ValidationFactor("remote_address", request.getRemoteAddr())};
        }
        userAuthContext.setValidationFactors(factors);
        Token token = null;
        logger.debug("ValidationFactor.REMOTE_ADDRESS is " + request.getRemoteAddr() + " for username " + username);
        Class<?> tAMClass = SecSignIDStaticAccessor.getTokenAuthenticationManager().getClass();
        try {
            Method authold = tAMClass.getMethod("authenticateUser", Application.class, UserAuthenticationContext.class, TokenLifetime.class);
            token = (Token)authold.invoke((Object)SecSignIDStaticAccessor.getTokenAuthenticationManager(), SecSignIDStaticAccessor.getApplicationManager().findByName("crowd"), userAuthContext, TokenLifetime.USE_DEFAULT);
            logger.debug("oldMethod worked for username " + username + " and generated token: " + token);
        }
        catch (NoSuchMethodException e) {
            try {
                Method authnew = tAMClass.getMethod("authenticateUser", UserAuthenticationContext.class, TokenLifetime.class);
                token = (Token)authnew.invoke((Object)SecSignIDStaticAccessor.getTokenAuthenticationManager(), userAuthContext, TokenLifetime.USE_DEFAULT);
                logger.debug("newMethod worked for username " + username + " and generated token: " + token);
            }
            catch (Exception e1) {
                logger.error("Exception on generating token new method for username " + username + ":\n " + e.getClass() + ":" + e.getMessage());
                return "failed";
            }
        }
        catch (ApplicationNotFoundException e) {
            logger.error("ApplicationNotFoundException on generating token for username " + username + ":\n " + ((Object)((Object)e)).getClass() + ":" + e.getMessage());
        }
        catch (Exception e) {
            InvocationTargetException error;
            if (e.getClass().equals(InvocationTargetException.class) && (error = (InvocationTargetException)e).getTargetException().getClass().equals(ExpiredCredentialException.class)) {
                return "auth_error_type";
            }
            return "failed";
        }
        String tokenString = token.getRandomHash();
        String tokenName = SecSignIDStaticAccessor.getTokenKey();
        logger.debug("token is: " + tokenString + "\n and token name is: " + tokenName);
        Cookie cookie = null;
        if (tokenName != null) {
            cookie = new Cookie(tokenName, tokenString);
        }
        if (cookie == null) {
            cookie = new Cookie("crowd.token_key", tokenString);
        }
        cookie.setPath("/");
        try {
            if (SecSignIDStaticAccessor.getPropertyManager() == null) {
                logger.warn("Could not get property manager via static accessor");
            } else {
                String domainName = SecSignIDStaticAccessor.getPropertyManager().getDomain();
                if (domainName != null) {
                    logger.debug("domainName is: " + domainName);
                    if (domainName.startsWith(".")) {
                        cookie.setDomain(domainName.substring(1));
                    } else {
                        cookie.setDomain(domainName);
                    }
                    logger.debug("domain set for cookie: " + domainName);
                }
            }
        }
        catch (Exception e) {
            logger.error("Could not get domain property for crowd SSO cookie: " + e.getMessage(), (Throwable)e);
        }
        response.addCookie(cookie);
        logger.debug("cookie added: " + cookie.toString());
        logger.debug("loginWithUsernameAndPassword done successfull");
        return "success";
    }

    private String getUserNameFromRequest(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String username = request.getParameter("secsign_os_username");
        if (username == null) {
            if (request.getParameter("username") != null) {
                username = request.getParameter("username").trim();
                logger.warn("Got username from parameter 'username' but expected to be parameter 'secsign_os_username'. Request contains parameter: " + SecSignIDMappingUtils.toString(request.getParameterMap()));
            } else {
                logger.error("Could not get username from parameter 'secsign_os_username'. Request contains parameter: " + SecSignIDMappingUtils.toString(request.getParameterMap()));
            }
        } else {
            username = username.trim();
        }
        return username;
    }

    @Override
    public String checkLoginWithUsernameAndPassword(HttpServletRequest request, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        block11: {
            User user;
            String username = this.getUserNameFromRequest(request);
            String password = request.getParameter("secsign_os_password");
            if (username == null) {
                logger.error("Username is null. Could not get crowd user.");
                return "failed";
            }
            try {
                user = this.getUserForKeyFirst(username);
            }
            catch (Exception e1) {
                return "failed";
            }
            if (user == null) {
                logger.error("Could not get crowd user for username '" + username + "'.");
                return "failed";
            }
            UserAuthenticationContext userAuthContext = new UserAuthenticationContext();
            userAuthContext.setApplication("crowd");
            userAuthContext.setName(user.getName());
            userAuthContext.setCredential(new PasswordCredential(password, false));
            ValidationFactor[] factors = new ValidationFactor[]{new ValidationFactor("remote_address", request.getRemoteAddr())};
            userAuthContext.setValidationFactors(factors);
            Class<?> tAMClass = SecSignIDStaticAccessor.getTokenAuthenticationManager().getClass();
            try {
                Method authold = tAMClass.getMethod("authenticateUser", Application.class, UserAuthenticationContext.class, TokenLifetime.class);
                authold.invoke((Object)SecSignIDStaticAccessor.getTokenAuthenticationManager(), SecSignIDStaticAccessor.getApplicationManager().findByName("crowd"), userAuthContext, TokenLifetime.USE_DEFAULT);
            }
            catch (NoSuchMethodException e) {
                try {
                    Method authnew = tAMClass.getMethod("authenticateUser", UserAuthenticationContext.class, TokenLifetime.class);
                    authnew.invoke((Object)SecSignIDStaticAccessor.getTokenAuthenticationManager(), userAuthContext, TokenLifetime.USE_DEFAULT);
                }
                catch (Exception e1) {
                    return "failed";
                }
            }
            catch (ApplicationNotFoundException e) {
            }
            catch (Exception e) {
                if (!e.getClass().equals(InvocationTargetException.class)) break block11;
                InvocationTargetException error = (InvocationTargetException)e;
                if (error.getTargetException().getClass().equals(ExpiredCredentialException.class)) {
                    return "auth_error_type";
                }
                return "failed";
            }
        }
        return "success";
    }

    @Override
    public boolean checkForElevatedSecurityCheck(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        return false;
    }

    @Override
    public String getLoginReason(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, ServletContext servletContext) {
        return "failed";
    }

    @Override
    public void loginUserWithoutPassword(HttpServletRequest request, HttpServletResponse response, User user) throws Exception {
        ValidationFactor[] factors;
        UserAuthenticationContext userAuthContext = new UserAuthenticationContext();
        userAuthContext.setApplication("crowd");
        userAuthContext.setName(user.getName());
        if (request.getHeader("X-FORWARDED-FOR") != null) {
            factors = new ValidationFactor[2];
            factors[0] = new ValidationFactor("remote_address", request.getRemoteAddr());
            if (request.getHeader("X-FORWARDED-FOR") != null) {
                factors[1] = new ValidationFactor("X-Forwarded-For", request.getHeader("X-FORWARDED-FOR"));
                logger.debug("Found ForwardedFor " + request.getHeader("X-FORWARDED-FOR") + " as ValidationFactor for username " + user.getName());
            }
        } else {
            factors = new ValidationFactor[]{new ValidationFactor("remote_address", request.getRemoteAddr())};
        }
        userAuthContext.setValidationFactors(factors);
        Token token = null;
        Class<?> tAMClass = SecSignIDStaticAccessor.getTokenAuthenticationManager().getClass();
        try {
            Method authold = tAMClass.getMethod("authenticateUserWithoutValidatingPassword", Application.class, UserAuthenticationContext.class);
            token = (Token)authold.invoke((Object)SecSignIDStaticAccessor.getTokenAuthenticationManager(), SecSignIDStaticAccessor.getApplicationManager().findByName("crowd"), userAuthContext);
        }
        catch (NoSuchMethodException e) {
            try {
                Method authnew = tAMClass.getMethod("authenticateUserWithoutValidatingPassword", UserAuthenticationContext.class);
                token = (Token)authnew.invoke((Object)SecSignIDStaticAccessor.getTokenAuthenticationManager(), userAuthContext);
            }
            catch (Exception e1) {
                logger.error("Could not call authenticateUserWithoutValidatingPassword on token authenticatoin manager: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (ApplicationNotFoundException e) {
        }
        catch (Exception e) {
            if (e.getClass().equals(InvocationTargetException.class)) {
                logger.error("Please check option 'Allow to generate users token' on application 'crowd'! More infos at: https://www.secsign.com/important-setting-for-crowd-4-3-0-and-newer/", (Throwable)e);
                throw new SecSignIDCrowdException("'Allow to generate users token' has to be activated for application 'crowd'", "", 0);
            }
            logger.error("Could not call authenticateUserWithoutValidatingPassword on token authenticatoin manager: " + e.getMessage(), (Throwable)e);
        }
        String tokenString = token.getRandomHash();
        String tokenName = SecSignIDStaticAccessor.getTokenKey();
        Cookie cookie = null;
        cookie = tokenName != null ? new Cookie(tokenName, tokenString) : new Cookie("crowd.token_key", tokenString);
        cookie.setPath("/");
        try {
            if (SecSignIDStaticAccessor.getPropertyManager() == null) {
                logger.warn("Could not get property manager via static accessor");
            } else {
                String domainName = SecSignIDStaticAccessor.getPropertyManager().getDomain();
                if (domainName != null) {
                    if (domainName.startsWith(".")) {
                        cookie.setDomain(domainName.substring(1));
                    } else {
                        cookie.setDomain(domainName);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Could not get domain property for crowd SSO cookie: " + e.getMessage(), (Throwable)e);
        }
        response.addCookie(cookie);
    }

    @Override
    public void sendRedirect(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        String returnUrl = httpServletReq.getParameter("returnUrl");
        String osDestination = httpServletReq.getParameter("os_destination");
        String crowdBaseUrl = this.getBaseUrl();
        logger.debug("Redirect after secsign id login to: returnUrl='" + returnUrl + "', osDestination='" + osDestination + "', crowdBaseUrl='" + crowdBaseUrl + "'");
        if (returnUrl != null && !returnUrl.equals("plugins/servlet/login")) {
            if (returnUrl.length() > 0 && returnUrl.contains("://")) {
                logger.debug("send Redirect to " + returnUrl);
                httpServletResp.sendRedirect(returnUrl);
            } else if (returnUrl.length() == 0) {
                logger.debug("send Redirect to " + crowdBaseUrl);
                httpServletResp.sendRedirect(crowdBaseUrl);
            } else {
                logger.debug("send Redirect to " + crowdBaseUrl + returnUrl);
                httpServletResp.sendRedirect(crowdBaseUrl + returnUrl);
            }
        } else if (osDestination != null && !osDestination.equals("plugins/servlet/login")) {
            if (osDestination.startsWith(crowdBaseUrl)) {
                logger.debug("send Redirect to " + osDestination);
                httpServletResp.sendRedirect(osDestination);
            } else {
                logger.debug("send Redirect to " + crowdBaseUrl + osDestination);
                httpServletResp.sendRedirect(crowdBaseUrl + osDestination);
            }
        } else {
            logger.debug("send Redirect to " + crowdBaseUrl);
            httpServletResp.sendRedirect(crowdBaseUrl);
        }
    }

    @Override
    public boolean isUserAdmin(User userToTest) {
        return SecSignIDStaticAccessor.getUserManager().isAdmin(userToTest.getName());
    }

    @Override
    public void deleteAllSettingsForNewAuthentication() {
        PluginSettings globalPluginSettings = SecSignIDCommonStaticAccessor.getPluginSettingsFactory().createGlobalSettings();
        globalPluginSettings.remove("com.secsign.allow.user.create");
        globalPluginSettings.remove("com.secsign.allow.user.existing");
        globalPluginSettings.remove("com.secsign.androidUrl");
        globalPluginSettings.remove("com.secsign.cachedbaseurl");
        globalPluginSettings.remove("com.secsign.crowdurl");
        globalPluginSettings.remove("com.secsign.companyname");
        globalPluginSettings.remove("com.secsign.customlogin");
        globalPluginSettings.remove("com.secsign.customlogo");
        globalPluginSettings.remove("com.secsign.accesstoken");
        globalPluginSettings.remove("com.secsign.basicauth");
        globalPluginSettings.remove("com.secsign.idserverurl.fallback");
        globalPluginSettings.remove("com.secsign.fido.enabled");
        globalPluginSettings.remove("com.secsign.autofillusername");
        globalPluginSettings.remove("com.secsign.autofillmail");
        globalPluginSettings.remove("com.secsign.autofillusernamecompany");
        globalPluginSettings.remove("com.secsign.autofillpattern");
        globalPluginSettings.remove("com.secsign.autofillpatternpattern");
        globalPluginSettings.remove("com.secsign.firststart");
        globalPluginSettings.remove("com.secsign.fromotp");
        globalPluginSettings.remove("com.secsign.gitaccess.2fa.enabled");
        globalPluginSettings.remove("com.secsign.gitaccess.block.user.without.secsignid");
        globalPluginSettings.remove("com.secsign.gitaccess.enabled.for.group");
        globalPluginSettings.remove("com.secsign.gitaccess.ipsafezone.enabled");
        globalPluginSettings.remove("com.secsign.gitaccess.new2fa.required.after.hours");
        globalPluginSettings.remove("com.secsign.gitaccess.protect.read.commands");
        globalPluginSettings.remove("com.secsign.groups.created");
        globalPluginSettings.remove("com.secsign.hidepasswordlesslink");
        globalPluginSettings.remove("com.secsign.idserverurl");
        globalPluginSettings.remove("com.secsign.inform.admin");
        globalPluginSettings.remove("com.secsign.inform.group");
        globalPluginSettings.remove("com.secsign.inform.user");
        globalPluginSettings.remove("com.secsign.iOSUrl");
        globalPluginSettings.remove("com.secsign.ldapattr");
        globalPluginSettings.remove("com.secsign.ldapenable");
        globalPluginSettings.remove("com.secsign.localenable");
        globalPluginSettings.remove("com.secsign.logincolor");
        globalPluginSettings.remove("com.secsign.logintitle");
        globalPluginSettings.remove("com.secsign.loginsubtitle");
        globalPluginSettings.remove("com.secsign.macOSUrl");
        globalPluginSettings.remove("com.secsign.mailotp.enabled");
        globalPluginSettings.remove("com.secsign.noaccesspass");
        globalPluginSettings.remove("com.secsign.usefallback");
        globalPluginSettings.remove("com.secsign.observe.group");
        globalPluginSettings.remove("com.secsign.otpauth");
        globalPluginSettings.remove("com.secsign.passwordless");
        globalPluginSettings.remove("com.secsign.passwordless.enabled");
        globalPluginSettings.remove("com.secsign.pinuser");
        globalPluginSettings.remove("com.secsign.pinpassword");
        globalPluginSettings.remove("com.secsign.resetcrowd");
        globalPluginSettings.remove("com.secsign.safezone");
        globalPluginSettings.remove("com.secsign.safezonerange");
        globalPluginSettings.remove("com.secsign.secsignauth");
        globalPluginSettings.remove("com.secsign.secsign.enabled");
        globalPluginSettings.remove("com.secsign.secsignid");
        globalPluginSettings.remove("com.secsign.servicedesk");
        globalPluginSettings.remove("com.secsign.servicedesk.2fa");
        globalPluginSettings.remove("com.secsign.servicedeskgroup");
        globalPluginSettings.remove("com.secsign.servicename");
        globalPluginSettings.remove("com.secsign.sessiontimeout");
        globalPluginSettings.remove("com.secsign.sessiontimeout.duration");
        globalPluginSettings.remove("com.secsign.synchid");
        globalPluginSettings.remove("com.secsign.synchwrite");
        globalPluginSettings.remove("com.secsign.telemetry");
        globalPluginSettings.remove("com.secsign.totp");
        globalPluginSettings.remove("com.secsign.totp.enabled");
        globalPluginSettings.remove("com.secsign.trustdevice");
        globalPluginSettings.remove("com.secsign.trustdevice.duration");
        globalPluginSettings.remove("com.secsign.twostep");
        globalPluginSettings.remove("com.secsign.usefallback");
        globalPluginSettings.remove("com.secsign.crowdnewlogin");
        globalPluginSettings.remove("com.secsign.userchange");
        globalPluginSettings.remove("com.secsign.userestore");
        globalPluginSettings.remove("com.secsign.whitelist");
        globalPluginSettings.remove("com.secsign.windowsUrl");
        globalPluginSettings.remove("com.secsign.writeldap");
        globalPluginSettings.remove("fixFor4_5_0_groups_started");
        globalPluginSettings.remove("fixFor4_5_0_groups_done");
        try {
            List dirs = SecSignIDStaticAccessor.getDirectoryManager().findAllDirectories();
            for (Directory directory : dirs) {
                try {
                    SecSignIDStaticAccessor.getDirectoryManager().removeGroup(directory.getId().longValue(), "PasswordlessAllowed");
                }
                catch (DirectoryPermissionException directoryPermissionException) {
                }
                catch (OperationFailedException operationFailedException) {
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                }
                catch (ReadOnlyGroupException readOnlyGroupException) {
                    // empty catch block
                }
                try {
                    SecSignIDStaticAccessor.getDirectoryManager().removeGroup(directory.getId().longValue(), "2SASecSignIDAllowed");
                }
                catch (DirectoryPermissionException directoryPermissionException) {
                }
                catch (OperationFailedException operationFailedException) {
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                }
                catch (ReadOnlyGroupException readOnlyGroupException) {
                    // empty catch block
                }
                try {
                    SecSignIDStaticAccessor.getDirectoryManager().removeGroup(directory.getId().longValue(), "2SAMailOTPAllowed");
                }
                catch (DirectoryPermissionException directoryPermissionException) {
                }
                catch (OperationFailedException operationFailedException) {
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                }
                catch (ReadOnlyGroupException readOnlyGroupException) {
                    // empty catch block
                }
                try {
                    SecSignIDStaticAccessor.getDirectoryManager().removeGroup(directory.getId().longValue(), "2SATOTPAllowed");
                }
                catch (DirectoryPermissionException directoryPermissionException) {
                }
                catch (OperationFailedException operationFailedException) {
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                }
                catch (ReadOnlyGroupException readOnlyGroupException) {}
            }
            SecSignIDMappingExtractor.deleteLocalMappings();
            SecSignIDMappingExtractor.deleteAllOldGroup2FASettings();
        }
        catch (DirectoryPermissionException e) {
            logger.error("DirectoryPermissionException on deleteAllOptionsAndMappings");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on deleteAllOptionsAndMappings");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on deleteAllOptionsAndMappings");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on deleteAllOptionsAndMappings");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on deleteAllOptionsAndMappings");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
    }

    @Override
    public void createGroupsWithSettings() throws InvalidGroupException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, GroupNotFoundException, ApplicationPermissionException, InvalidAuthenticationException {
        List dirs = SecSignIDStaticAccessor.getDirectoryManager().findAllDirectories();
        for (Directory directory : dirs) {
            GroupTemplate passwordlessTemplate = new GroupTemplate("PasswordlessAllowed");
            passwordlessTemplate.setDescription(SecSignIDCommonStaticAccessor.getI18nResolver().getText("com.secsign.group.passwordless.description"));
            passwordlessTemplate.setDirectoryId(directory.getId().longValue());
            GroupTemplate twostepTemplate = new GroupTemplate("2SASecSignIDAllowed");
            twostepTemplate.setDescription(SecSignIDCommonStaticAccessor.getI18nResolver().getText("com.secsign.group.twostep.description"));
            twostepTemplate.setDirectoryId(directory.getId().longValue());
            GroupTemplate mailotpTemplate = new GroupTemplate("2SAMailOTPAllowed");
            mailotpTemplate.setDescription(SecSignIDCommonStaticAccessor.getI18nResolver().getText("com.secsign.group.mailotp.description"));
            mailotpTemplate.setDirectoryId(directory.getId().longValue());
            GroupTemplate totpTemplate = new GroupTemplate("2SATOTPAllowed");
            totpTemplate.setDescription(SecSignIDCommonStaticAccessor.getI18nResolver().getText("com.secsign.group.totp.description"));
            totpTemplate.setDirectoryId(directory.getId().longValue());
            GroupTemplate fidoTemplate = new GroupTemplate("2SAFIDOAllowed");
            fidoTemplate.setDescription(SecSignIDCommonStaticAccessor.getI18nResolver().getText("com.secsign.group.fido.description"));
            fidoTemplate.setDirectoryId(directory.getId().longValue());
            try {
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), passwordlessTemplate.getName());
            }
            catch (GroupNotFoundException e) {
                SecSignIDStaticAccessor.getDirectoryManager().addGroup(directory.getId().longValue(), passwordlessTemplate);
            }
            try {
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), twostepTemplate.getName());
            }
            catch (GroupNotFoundException e) {
                SecSignIDStaticAccessor.getDirectoryManager().addGroup(directory.getId().longValue(), twostepTemplate);
            }
            try {
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), mailotpTemplate.getName());
            }
            catch (GroupNotFoundException e) {
                SecSignIDStaticAccessor.getDirectoryManager().addGroup(directory.getId().longValue(), mailotpTemplate);
            }
            try {
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), totpTemplate.getName());
            }
            catch (GroupNotFoundException e) {
                SecSignIDStaticAccessor.getDirectoryManager().addGroup(directory.getId().longValue(), totpTemplate);
            }
            try {
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), fidoTemplate.getName());
            }
            catch (GroupNotFoundException e) {
                SecSignIDStaticAccessor.getDirectoryManager().addGroup(directory.getId().longValue(), fidoTemplate);
            }
            HashMap<String, SecSignID2FASettings> mapping = new HashMap<String, SecSignID2FASettings>();
            SecSignID2FASettings forPasswordless = new SecSignID2FASettings("010000");
            SecSignID2FASettings forTwoStep = new SecSignID2FASettings("001000");
            SecSignID2FASettings forMailOTP = new SecSignID2FASettings("000100");
            SecSignID2FASettings forTOTP = new SecSignID2FASettings("000010");
            SecSignID2FASettings forFIDO = new SecSignID2FASettings("000001");
            mapping.put("PasswordlessAllowed".toLowerCase() + ";" + directory.getId(), forPasswordless);
            mapping.put("2SASecSignIDAllowed".toLowerCase() + ";" + directory.getId(), forTwoStep);
            mapping.put("2SAMailOTPAllowed".toLowerCase() + ";" + directory.getId(), forMailOTP);
            mapping.put("2SATOTPAllowed".toLowerCase() + ";" + directory.getId(), forTOTP);
            mapping.put("2SAFIDOAllowed".toLowerCase() + ";" + directory.getId(), forFIDO);
            this.save2FAGroupMappings(mapping);
            this.logGroup2FAChangeToAuditLog("PasswordlessAllowed", directory.getId(), false, true, false, false, false, false, this.getBaseUrl());
            this.logGroup2FAChangeToAuditLog("2SASecSignIDAllowed", directory.getId(), false, false, true, false, false, false, this.getBaseUrl());
            this.logGroup2FAChangeToAuditLog("2SAMailOTPAllowed", directory.getId(), false, false, false, true, false, false, this.getBaseUrl());
            this.logGroup2FAChangeToAuditLog("2SATOTPAllowed", directory.getId(), false, false, false, false, true, false, this.getBaseUrl());
            this.logGroup2FAChangeToAuditLog("2SAFIDOAllowed", directory.getId(), false, false, false, false, false, true, this.getBaseUrl());
            if (!SecSignIDCommonStaticAccessor.getInformAdmin()) continue;
            this.mail2FAChangeOfGroupToInformGroup("PasswordlessAllowed", directory.getId(), false, true, false, false, false, false, this.getUserCurrentlyLoggedIn().getName(), this.getUserCurrentlyLoggedIn().getDirectoryId());
            this.mail2FAChangeOfGroupToInformGroup("2SASecSignIDAllowed", directory.getId(), false, false, true, false, false, false, this.getUserCurrentlyLoggedIn().getName(), this.getUserCurrentlyLoggedIn().getDirectoryId());
            this.mail2FAChangeOfGroupToInformGroup("2SAMailOTPAllowed", directory.getId(), false, false, false, true, false, false, this.getUserCurrentlyLoggedIn().getName(), this.getUserCurrentlyLoggedIn().getDirectoryId());
            this.mail2FAChangeOfGroupToInformGroup("2SATOTPAllowed", directory.getId(), false, false, false, false, true, false, this.getUserCurrentlyLoggedIn().getName(), this.getUserCurrentlyLoggedIn().getDirectoryId());
            this.mail2FAChangeOfGroupToInformGroup("2SAFIDOAllowed", directory.getId(), false, false, false, false, false, true, this.getUserCurrentlyLoggedIn().getName(), this.getUserCurrentlyLoggedIn().getDirectoryId());
        }
    }

    @Override
    public List<String> findGroupsForTerm(String searchTerm) throws DirectoryNotFoundException, OperationFailedException {
        ArrayList<String> result = new ArrayList<String>();
        DirectoryManager localDirectoryManager = SecSignIDStaticAccessor.getDirectoryManager();
        List dirs = localDirectoryManager.findAllDirectories();
        for (Directory directory : dirs) {
            EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)searchTerm)).startingAt(0).returningAtMost(11);
            List groups = localDirectoryManager.searchGroups(directory.getId().longValue(), query);
            result.addAll(SecSignIDMappingUtils.fixGroupListForDirIDAndEscape(groups, directory.getId()));
        }
        return result;
    }

    @Override
    public int findPageForGroup(String groupName, long _chosenDir) throws DirectoryNotFoundException, OperationFailedException {
        List groups;
        DirectoryManager localDirectoryManager = SecSignIDStaticAccessor.getDirectoryManager();
        List dirs = localDirectoryManager.findAllDirectories();
        int page = 1;
        do {
            EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).startingAt((page - 1) * 10).returningAtMost(10);
            groups = localDirectoryManager.searchGroups(_chosenDir, query);
            for (String foundGroups : groups) {
                if (!foundGroups.toLowerCase().equals(groupName)) continue;
                return page;
            }
            ++page;
        } while (groups.size() == 10);
        return 0;
    }

    @Override
    public String getGroupLink(String groupName, long dirid) {
        return this.getBaseUrl() + "/console/secure/group/viewmembers.action?groupName=" + groupName + "&directoryID=" + dirid;
    }

    @Override
    public void logAutomaticUserChangeToAuditLog(String userKey, long dirid, String secSignID, String ip) {
        AuditService auditService = SecSignIDStaticAccessor.getAuditService();
        AuditLogChangesetEntity auditEntry = new AuditLogChangesetEntity();
        auditEntry.setTimestamp(Long.valueOf(Instant.now().toEpochMilli()));
        auditEntry.setEventMessage(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.audit.admin.changed.secsignid.auto,secSignID"));
        HashSet<AuditLogEntityEntity> set = new HashSet<AuditLogEntityEntity>();
        AuditLogEntityEntity entity = new AuditLogEntityEntity();
        EntityQuery query = QueryBuilder.queryFor(InternalUser.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)userKey)).returningAtMost(-1);
        try {
            List list = SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dirid, query);
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                InternalUser internalUser = (InternalUser)iterator.next();
                Long id = internalUser.getId();
                entity.setEntityName(userKey);
                entity.setEntityId(id);
                entity.setEntityType(AuditLogEntityType.USER);
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on logAutomaticUserChangeToAuditLog");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on logAutomaticUserChangeToAuditLog");
        }
        AuditLogEntityEntity entity2 = new AuditLogEntityEntity();
        entity2.setEntityId(Long.valueOf(dirid));
        entity2.setEntityType(AuditLogEntityType.DIRECTORY);
        set.add(entity);
        set.add(entity2);
        auditEntry.setEntities(set);
        auditEntry.setEventType(AuditLogEventType.USER_UPDATED);
        auditEntry.setIpAddress(ip);
        auditService.saveAudit((AuditLogChangeset)auditEntry);
    }

    @Override
    public void logChangeSecSignIDToAuditLog(String userKey, long dirid, String secSignID, String ip) {
        AuditService auditService = SecSignIDStaticAccessor.getAuditService();
        AuditLogChangesetEntity auditEntry = new AuditLogChangesetEntity();
        auditEntry.setTimestamp(Long.valueOf(Instant.now().toEpochMilli()));
        auditEntry.setEventMessage(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.audit.admin.changed.secsignid", new Serializable[]{secSignID}));
        HashSet<AuditLogEntityEntity> set = new HashSet<AuditLogEntityEntity>();
        AuditLogEntityEntity entity = new AuditLogEntityEntity();
        EntityQuery query = QueryBuilder.queryFor(InternalUser.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)userKey)).returningAtMost(-1);
        try {
            List list = SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dirid, query);
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                InternalUser internalUser = (InternalUser)iterator.next();
                Long id = internalUser.getId();
                entity.setEntityName(userKey);
                entity.setEntityId(id);
                entity.setEntityType(AuditLogEntityType.USER);
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on logUserChangeToAuditLog");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on logUserChangeToAuditLog");
        }
        AuditLogEntityEntity entity2 = new AuditLogEntityEntity();
        entity2.setEntityId(Long.valueOf(dirid));
        entity2.setEntityType(AuditLogEntityType.DIRECTORY);
        set.add(entity);
        set.add(entity2);
        auditEntry.setEntities(set);
        auditEntry.setEventType(AuditLogEventType.USER_UPDATED);
        auditEntry.setIpAddress(ip);
        auditService.saveAudit((AuditLogChangeset)auditEntry);
    }

    @Override
    public void logActivateTOTP(String userKey, long dirid, String ip) {
        AuditService auditService = SecSignIDStaticAccessor.getAuditService();
        AuditLogChangesetEntity auditEntry = new AuditLogChangesetEntity();
        auditEntry.setTimestamp(Long.valueOf(Instant.now().toEpochMilli()));
        auditEntry.setEventMessage(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.totp.activated"));
        HashSet<AuditLogEntityEntity> set = new HashSet<AuditLogEntityEntity>();
        AuditLogEntityEntity entity = new AuditLogEntityEntity();
        EntityQuery query = QueryBuilder.queryFor(InternalUser.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)userKey)).returningAtMost(-1);
        try {
            List list = SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dirid, query);
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                InternalUser internalUser = (InternalUser)iterator.next();
                Long id = internalUser.getId();
                entity.setEntityName(userKey);
                entity.setEntityId(id);
                entity.setEntityType(AuditLogEntityType.USER);
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on logUserChangeToAuditLog");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on logUserChangeToAuditLog");
        }
        AuditLogEntityEntity entity2 = new AuditLogEntityEntity();
        entity2.setEntityId(Long.valueOf(dirid));
        entity2.setEntityType(AuditLogEntityType.DIRECTORY);
        set.add(entity);
        set.add(entity2);
        auditEntry.setEntities(set);
        auditEntry.setEventType(AuditLogEventType.USER_UPDATED);
        auditEntry.setIpAddress(ip);
        auditService.saveAudit((AuditLogChangeset)auditEntry);
    }

    @Override
    public void logActivateFIDO(String userKey, long dirid, String ip) {
        AuditService auditService = SecSignIDStaticAccessor.getAuditService();
        AuditLogChangesetEntity auditEntry = new AuditLogChangesetEntity();
        auditEntry.setTimestamp(Long.valueOf(Instant.now().toEpochMilli()));
        auditEntry.setEventMessage(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.fido.activated"));
        HashSet<AuditLogEntityEntity> set = new HashSet<AuditLogEntityEntity>();
        AuditLogEntityEntity entity = new AuditLogEntityEntity();
        EntityQuery query = QueryBuilder.queryFor(InternalUser.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)userKey)).returningAtMost(-1);
        try {
            List list = SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dirid, query);
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                InternalUser internalUser = (InternalUser)iterator.next();
                Long id = internalUser.getId();
                entity.setEntityName(userKey);
                entity.setEntityId(id);
                entity.setEntityType(AuditLogEntityType.USER);
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on logUserChangeToAuditLog");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on logUserChangeToAuditLog");
        }
        AuditLogEntityEntity entity2 = new AuditLogEntityEntity();
        entity2.setEntityId(Long.valueOf(dirid));
        entity2.setEntityType(AuditLogEntityType.DIRECTORY);
        set.add(entity);
        set.add(entity2);
        auditEntry.setEntities(set);
        auditEntry.setEventType(AuditLogEventType.USER_UPDATED);
        auditEntry.setIpAddress(ip);
        auditService.saveAudit((AuditLogChangeset)auditEntry);
    }

    @Override
    public void logActivateSecSignID(String userKey, long dirid, String ip) {
        AuditService auditService = SecSignIDStaticAccessor.getAuditService();
        AuditLogChangesetEntity auditEntry = new AuditLogChangesetEntity();
        auditEntry.setTimestamp(Long.valueOf(Instant.now().toEpochMilli()));
        auditEntry.setEventMessage(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.secsignid.activated"));
        HashSet<AuditLogEntityEntity> set = new HashSet<AuditLogEntityEntity>();
        AuditLogEntityEntity entity = new AuditLogEntityEntity();
        EntityQuery query = QueryBuilder.queryFor(InternalUser.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)userKey)).returningAtMost(-1);
        try {
            List list = SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dirid, query);
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                InternalUser internalUser = (InternalUser)iterator.next();
                Long id = internalUser.getId();
                entity.setEntityName(userKey);
                entity.setEntityId(id);
                entity.setEntityType(AuditLogEntityType.USER);
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on logUserChangeToAuditLog");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on logUserChangeToAuditLog");
        }
        AuditLogEntityEntity entity2 = new AuditLogEntityEntity();
        entity2.setEntityId(Long.valueOf(dirid));
        entity2.setEntityType(AuditLogEntityType.DIRECTORY);
        set.add(entity);
        set.add(entity2);
        auditEntry.setEntities(set);
        auditEntry.setEventType(AuditLogEventType.USER_UPDATED);
        auditEntry.setIpAddress(ip);
        auditService.saveAudit((AuditLogChangeset)auditEntry);
    }

    @Override
    public void logActivateMailOTP(String userKey, long dirid, String ip) {
        AuditService auditService = SecSignIDStaticAccessor.getAuditService();
        AuditLogChangesetEntity auditEntry = new AuditLogChangesetEntity();
        auditEntry.setTimestamp(Long.valueOf(Instant.now().toEpochMilli()));
        auditEntry.setEventMessage(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.mailotp.activated"));
        HashSet<AuditLogEntityEntity> set = new HashSet<AuditLogEntityEntity>();
        AuditLogEntityEntity entity = new AuditLogEntityEntity();
        EntityQuery query = QueryBuilder.queryFor(InternalUser.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)userKey)).returningAtMost(-1);
        try {
            List list = SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dirid, query);
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                InternalUser internalUser = (InternalUser)iterator.next();
                Long id = internalUser.getId();
                entity.setEntityName(userKey);
                entity.setEntityId(id);
                entity.setEntityType(AuditLogEntityType.USER);
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on logUserChangeToAuditLog");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on logUserChangeToAuditLog");
        }
        AuditLogEntityEntity entity2 = new AuditLogEntityEntity();
        entity2.setEntityId(Long.valueOf(dirid));
        entity2.setEntityType(AuditLogEntityType.DIRECTORY);
        set.add(entity);
        set.add(entity2);
        auditEntry.setEntities(set);
        auditEntry.setEventType(AuditLogEventType.USER_UPDATED);
        auditEntry.setIpAddress(ip);
        auditService.saveAudit((AuditLogChangeset)auditEntry);
    }

    @Override
    public void logGroup2FAChangeToAuditLog(String groupname, long dirid, boolean newValuePwdAllowed, boolean newValuePasswordless, boolean newValueTwoStep, boolean newValueMailOTP, boolean newValueTOTP, boolean newValueFIDO, String ip) {
        AuditService auditService = SecSignIDStaticAccessor.getAuditService();
        AuditLogChangesetEntity auditEntry = new AuditLogChangesetEntity();
        auditEntry.setTimestamp(Long.valueOf(Instant.now().toEpochMilli()));
        auditEntry.setEventMessage(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.audit.admin.changed.2fa", new Serializable[]{this.getAllowedStringForBoolean(newValuePwdAllowed), this.getAllowedStringForBoolean(newValuePasswordless), this.getAllowedStringForBoolean(newValueTwoStep), this.getAllowedStringForBoolean(newValueMailOTP), this.getAllowedStringForBoolean(newValueTOTP), this.getAllowedStringForBoolean(newValueFIDO)}));
        HashSet<AuditLogEntityEntity> set = new HashSet<AuditLogEntityEntity>();
        AuditLogEntityEntity entity = new AuditLogEntityEntity();
        EntityQuery query = QueryBuilder.queryFor(InternalGroup.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)groupname)).returningAtMost(-1);
        try {
            List list = SecSignIDStaticAccessor.getDirectoryManager().searchGroups(dirid, query);
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                InternalGroup internalGroup = (InternalGroup)iterator.next();
                Long id = internalGroup.getId();
                entity.setEntityName(groupname);
                entity.setEntityId(id);
                entity.setEntityType(AuditLogEntityType.GROUP);
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on logGroup2FAChangeToAuditLog");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on logGroup2FAChangeToAuditLog");
        }
        AuditLogEntityEntity entity2 = new AuditLogEntityEntity();
        entity2.setEntityId(Long.valueOf(dirid));
        entity2.setEntityType(AuditLogEntityType.DIRECTORY);
        set.add(entity);
        set.add(entity2);
        auditEntry.setEntities(set);
        auditEntry.setEventType(AuditLogEventType.GROUP_UPDATED);
        auditEntry.setIpAddress(ip);
        auditService.saveAudit((AuditLogChangeset)auditEntry);
    }

    @Override
    public void logChangeSettingToAuditLog(String settingName, String newValue, String oldValue, String ip) {
        if (oldValue.length() > 30) {
            oldValue = oldValue.substring(0, 30);
        }
        if (newValue.length() > 30) {
            newValue = newValue.substring(0, 30);
        }
        AuditService auditService = SecSignIDStaticAccessor.getAuditService();
        AuditLogChangesetEntity auditEntry = new AuditLogChangesetEntity();
        auditEntry.setTimestamp(Long.valueOf(Instant.now().toEpochMilli()));
        auditEntry.setEventMessage(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.audit.admin.changed.setting", new Serializable[]{settingName, oldValue, newValue}));
        auditEntry.setEventType(AuditLogEventType.CONFIGURATION_MODIFIED);
        auditEntry.setIpAddress(ip);
        auditService.saveAudit((AuditLogChangeset)auditEntry);
    }

    @Override
    public DirectoryManager getDirectoryManager() {
        return SecSignIDStaticAccessor.getDirectoryManager();
    }

    @Override
    public void removeUserAttributes(long dirid, String userKey, String attributeKey) throws UserNotFoundException, com.atlassian.crowd.exception.runtime.UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException {
        DirectoryManager manager = SecSignIDStaticAccessor.getDirectoryManager();
        manager.removeUserAttributes(dirid, userKey, attributeKey);
    }

    @Override
    public List<User> searchUsers(long dirid, EntityQuery<User> query) throws OperationFailedException, DirectoryNotFoundException {
        DirectoryManager manager = SecSignIDStaticAccessor.getDirectoryManager();
        return manager.searchUsers(dirid, query);
    }

    @Override
    public List<String> searchUserStrings(long dirid, EntityQuery<String> query) throws OperationFailedException, DirectoryNotFoundException {
        DirectoryManager manager = SecSignIDStaticAccessor.getDirectoryManager();
        return manager.searchUsers(dirid, query);
    }

    @Override
    public Directory getDirectory(long dirid) throws OperationFailedException, DirectoryNotFoundException {
        DirectoryManager manager = SecSignIDStaticAccessor.getDirectoryManager();
        return manager.findDirectoryById(dirid);
    }

    @Override
    public void storeUserAttributes(long dirid, String userKey, HashMap<String, Set<String>> attrMap) throws DirectoryPermissionException, OperationFailedException, UserNotFoundException, DirectoryNotFoundException {
        DirectoryManager manager = SecSignIDStaticAccessor.getDirectoryManager();
        manager.storeUserAttributes(dirid, userKey, attrMap);
    }

    @Override
    public List<String> searchGroups(long dirid, EntityQuery<String> query) throws OperationFailedException, DirectoryNotFoundException {
        DirectoryManager manager = SecSignIDStaticAccessor.getDirectoryManager();
        return manager.searchGroups(dirid, query);
    }

    @Override
    public GroupWithAttributes findGroupWithAttributesByName(long dirid, String groupName) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        DirectoryManager manager = SecSignIDStaticAccessor.getDirectoryManager();
        return ConversionUtils.toEmbeddedGroupWithAttributes((com.atlassian.crowd.model.group.GroupWithAttributes)manager.findGroupWithAttributesByName(dirid, groupName));
    }

    @Override
    public void storeGroupAttributes(long dirid, String groupName, HashMap<String, Set<String>> attrMap) throws DirectoryPermissionException, OperationFailedException, GroupNotFoundException, DirectoryNotFoundException {
        DirectoryManager manager = SecSignIDStaticAccessor.getDirectoryManager();
        manager.storeGroupAttributes(dirid, groupName, attrMap);
    }

    @Override
    public void removeGroupAttributes(long dirid, String groupName, String attributeKey) throws DirectoryPermissionException, OperationFailedException, GroupNotFoundException, DirectoryNotFoundException {
        DirectoryManager manager = SecSignIDStaticAccessor.getDirectoryManager();
        manager.removeGroupAttributes(dirid, groupName, attributeKey);
    }

    @Override
    public void mailChangeSecSignIDToInformGroup(String userKey, long diridChanged, String changedByUserKey, long changedByDirid, String secSignID) throws OperationFailedException {
        User user = this.getUserForKey(userKey, diridChanged);
        User changedBy = this.getUserForKey(changedByUserKey, changedByDirid);
        String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
        if (informGroupString != null && !informGroupString.equals("")) {
            String[] mappingKeysToInform;
            for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                try {
                    Collection<String> usernames = this.findGroupMembersUsernames(dirid, groupname);
                    for (String string : usernames) {
                        User userToInform = this.getUserForKey(string, dirid);
                        String email = userToInform.getEmailAddress();
                        try {
                            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"), this.getChangeMailForUserToInform(user, changedBy, userToInform, secSignID));
                        }
                        catch (AddressException e) {
                            logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                        catch (MailSendException e) {
                            logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                    }
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mail2FAChangeToGroupMembers(String groupnameChanged, long diridChanged) {
        try {
            Set<String> usernamesOfGroup = this.getUsernamesForGroupname(groupnameChanged + ";" + diridChanged);
            for (String username : usernamesOfGroup) {
                try {
                    User user = this.getUserForKey(username, diridChanged);
                    SecSignID2FASettings settings = this.get2FASettingsFromUserKey(this.getUserKeyForUsername(username), user.getDirectoryId());
                    boolean pwdAllowed = settings.getPwdAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                    boolean passwordlessAllowed = settings.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                    boolean twostepAllowed = settings.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                    boolean mailotpAllowed = settings.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                    boolean totpAllowed = settings.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                    boolean fidoAllowed = settings.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                    String email = user.getEmailAddress();
                    try {
                        SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.2fa.changed.topic"), this.getChange2FAMailForUser(user, pwdAllowed, passwordlessAllowed, twostepAllowed, mailotpAllowed, totpAllowed, fidoAllowed));
                    }
                    catch (AddressException e) {
                        logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                    }
                    catch (MailSendException e) {
                        logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                    }
                }
                catch (ApplicationPermissionException e) {
                    logger.error("ApplicationPermissionException on mail2FAChangeToGroupMembers");
                }
                catch (InvalidAuthenticationException e) {
                    logger.error("InvalidAuthenticationException on mail2FAChangeToGroupMembers");
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mail2FAChangeToGroupMembers");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mail2FAChangeToGroupMembers");
        }
    }

    @Override
    public void mail2FAChangeOfGroupToInformGroup(String groupnameChanged, long diridChanged, boolean newValuePwdAllowed, boolean newValuePasswordless, boolean newValueTwoStep, boolean newValueMailOTP, boolean newValueTOTP, boolean newValueFIDO, String changedByUserKey, long changedByDirid) {
        try {
            User changedBy = this.getUserForKey(changedByUserKey, changedByDirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    Collection<String> usernames = this.findGroupMembersUsernames(dirid, groupname);
                    for (String userNameToInform : usernames) {
                        User user = this.getUserForKey(userNameToInform, dirid);
                        String email = user.getEmailAddress();
                        try {
                            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.2fa.changed.topic"), this.getChange2FAMailForGroupToInform(user, changedBy, groupnameChanged, newValuePwdAllowed, newValuePasswordless, newValueTwoStep, newValueMailOTP, newValueTOTP, newValueFIDO));
                        }
                        catch (AddressException e) {
                            logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                        catch (MailSendException e) {
                            logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mail2FAChangeOfGroupToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mail2FAChangeOfGroupToInformGroup");
        }
    }

    @Override
    public void mailChangeSecSignIDToUser(String userKey, long dirid, String changedByUserKey, long changedByDirid, String secSignID) throws OperationFailedException {
        User user = this.getUserForKey(userKey, dirid);
        User changedBy = this.getUserForKey(changedByUserKey, changedByDirid);
        String email = user.getEmailAddress();
        try {
            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"), this.getChangeMailForSecSignIDToUser(user, changedBy, secSignID));
        }
        catch (AddressException e) {
            logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
        }
        catch (MailSendException e) {
            logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateTOTPToUser(String userKey, long dirid) throws OperationFailedException {
        User user = this.getUserForKey(userKey, dirid);
        String email = user.getEmailAddress();
        try {
            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"), this.getChangeMailForTOTPToUser(user));
        }
        catch (AddressException e) {
            logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
        }
        catch (MailSendException e) {
            logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateFIDOToUser(String userKey, long dirid) throws OperationFailedException {
        User user = this.getUserForKey(userKey, dirid);
        String email = user.getEmailAddress();
        try {
            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"), this.getChangeMailForFIDOToUser(user));
        }
        catch (AddressException e) {
            logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
        }
        catch (MailSendException e) {
            logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateSecSignIDToUser(String userKey, long dirid) throws OperationFailedException {
        User user = this.getUserForKey(userKey, dirid);
        String email = user.getEmailAddress();
        try {
            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"), this.getChangeMailForSecSignIDToUser(user));
        }
        catch (AddressException e) {
            logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
        }
        catch (MailSendException e) {
            logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateMailOTPToUser(String userKey, long dirid) throws OperationFailedException {
        User user = this.getUserForKey(userKey, dirid);
        String email = user.getEmailAddress();
        try {
            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"), this.getChangeMailForMailOTPToUser(user));
        }
        catch (AddressException e) {
            logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
        }
        catch (MailSendException e) {
            logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateTOTPToInformGroup(String userKey, long dirid) throws OperationFailedException {
        try {
            User changedUser = this.getUserForKey(userKey, dirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long diridToInform = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    Collection<String> usernames = this.findGroupMembersUsernames(diridToInform, groupname);
                    for (String userNameToInform : usernames) {
                        User user = this.getUserForKey(userNameToInform, diridToInform);
                        String email = user.getEmailAddress();
                        try {
                            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"), this.getChangeMailForTOTPToGroup(changedUser, user));
                        }
                        catch (AddressException e) {
                            logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                        catch (MailSendException e) {
                            logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailActivateTOTPToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailActivateTOTPToInformGroup");
        }
    }

    @Override
    public void mailActivateFIDOToInformGroup(String userKey, long dirid) throws OperationFailedException {
        try {
            User changedUser = this.getUserForKey(userKey, dirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long diridToInform = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    Collection<String> usernames = this.findGroupMembersUsernames(diridToInform, groupname);
                    for (String userNameToInform : usernames) {
                        User user = this.getUserForKey(userNameToInform, diridToInform);
                        String email = user.getEmailAddress();
                        try {
                            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"), this.getChangeMailForFIDOToGroup(changedUser, user));
                        }
                        catch (AddressException e) {
                            logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                        catch (MailSendException e) {
                            logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailActivateTOTPToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailActivateTOTPToInformGroup");
        }
    }

    @Override
    public void mailActivateSecSignIDToInformGroup(String userKey, long dirid) throws OperationFailedException {
        try {
            User changedUser = this.getUserForKey(userKey, dirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long diridToInform = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    Collection<String> usernames = this.findGroupMembersUsernames(diridToInform, groupname);
                    for (String userNameToInform : usernames) {
                        User user = this.getUserForKey(userNameToInform, diridToInform);
                        String email = user.getEmailAddress();
                        try {
                            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"), this.getChangeMailForSecSignIDToGroup(changedUser, user));
                        }
                        catch (AddressException e) {
                            logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                        catch (MailSendException e) {
                            logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailActivateTOTPToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailActivateTOTPToInformGroup");
        }
    }

    @Override
    public void mailActivateMailOTPToInformGroup(String userKey, long dirid) throws OperationFailedException {
        try {
            User changedUser = this.getUserForKey(userKey, dirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long diridToInform = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    Collection<String> usernames = this.findGroupMembersUsernames(diridToInform, groupname);
                    for (String userNameToInform : usernames) {
                        User user = this.getUserForKey(userNameToInform, diridToInform);
                        String email = user.getEmailAddress();
                        try {
                            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"), this.getChangeMailForMailOTPToGroup(changedUser, user));
                        }
                        catch (AddressException e) {
                            logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                        catch (MailSendException e) {
                            logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailActivateMailOTPToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailActivateMailOTPToInformGroup");
        }
    }

    @Override
    public void mailChangeSettingToInformGroup(String settingName, String newValue, String oldValue, String changedByUserKey, long changedByDirid) {
        try {
            User changedBy = this.getUserForKey(changedByUserKey, changedByDirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long diridToInform = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    Collection<String> usernames = this.findGroupMembersUsernames(diridToInform, groupname);
                    for (String userNameToInform : usernames) {
                        User user = this.getUserForKey(userNameToInform, diridToInform);
                        String email = user.getEmailAddress();
                        try {
                            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(email), SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.settings.changed.topic"), this.getChangeMailForChangeSettingsToGroup(changedBy, user, settingName, newValue, oldValue));
                        }
                        catch (AddressException e) {
                            logger.error("AddressException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                        catch (MailSendException e) {
                            logger.error("MailSendException on sending Mail to User For Changes: " + e.getLocalizedMessage());
                        }
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailChangeSettingToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailChangeSettingToInformGroup");
        }
    }

    @Override
    public void resetAllFIDO() throws DirectoryNotFoundException, OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException {
        SecSignIDMappingExtractor.resetAllFIDO();
    }

    @Override
    public CrowdClient getCrowdClientForDir(Directory dir) {
        String applicationName = dir.getValue("application.name");
        String applicationPassword = dir.getValue("application.password");
        String crowdURL = dir.getValue("crowd.server.url");
        logger.debug("Application Name for Crowd is: " + applicationName);
        logger.debug("Crowd Url for Crowd is: " + crowdURL);
        if (applicationName != null && applicationPassword != null && crowdURL != null) {
            logger.debug("Try to create CrowdClient");
            CrowdClient client = new RestCrowdClientFactory().newInstance(crowdURL, applicationName, applicationPassword);
            logger.debug("CrowdClient created");
            return client;
        }
        logger.error("One mandatory field for CrowdClient is null -> not create Client");
        return null;
    }

    @Override
    public void changeToOneAttribute() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryPermissionException {
        List<Directory> dirs = this.getAllDirectories();
        for (Directory directory : dirs) {
            try {
                HashSet allGroupsWithAttributes = new HashSet();
                EntityQuery query1 = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"pwdallowed")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                EntityQuery query2 = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"passwordlessallowed")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                EntityQuery query3 = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"twostepallowed")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                EntityQuery query4 = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"mailotpallowed")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                EntityQuery query5 = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"totpallowed")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                allGroupsWithAttributes.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchGroups(directory.getId().longValue(), query1));
                allGroupsWithAttributes.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchGroups(directory.getId().longValue(), query2));
                allGroupsWithAttributes.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchGroups(directory.getId().longValue(), query3));
                allGroupsWithAttributes.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchGroups(directory.getId().longValue(), query4));
                allGroupsWithAttributes.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchGroups(directory.getId().longValue(), query5));
                ArrayList<String> allGroupsAsList = new ArrayList<String>(allGroupsWithAttributes);
                List<String> fixedGroups = SecSignIDMappingUtils.fixGroupListForDirIDAndEscape(allGroupsAsList, directory.getId());
                for (String groupMappingKey : fixedGroups) {
                    ArrayList<String> currentGroupAsList = new ArrayList<String>();
                    currentGroupAsList.add(groupMappingKey);
                    HashMap<String, String> pwdlessMappings = this.getPasswordlessGroupMappings(currentGroupAsList);
                    HashMap<String, String> twostepMappings = this.getTwoStepGroupMappings(currentGroupAsList);
                    HashMap<String, String> mailotpMappings = this.getMailOTPGroupMappings(currentGroupAsList);
                    HashMap<String, String> totpMappings = this.getTOTPGroupMappings(currentGroupAsList);
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(groupMappingKey);
                    long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(groupMappingKey);
                    try {
                        com.atlassian.crowd.model.group.GroupWithAttributes groupAttr = SecSignIDStaticAccessor.getDirectoryManager().findGroupWithAttributesByName(dirid, groupname);
                        String result = groupAttr.getValue("secsign.twofa");
                        if (result == null || result.equals("")) {
                            logger.debug("Settings for group " + groupname + " in dir " + dirid + " will be converted");
                            boolean pwdless = pwdlessMappings.get(groupMappingKey).equals("activate");
                            boolean twoStep = twostepMappings.get(groupMappingKey).equals("activate");
                            boolean mailOTP = mailotpMappings.get(groupMappingKey).equals("activate");
                            boolean totp = totpMappings.get(groupMappingKey).equals("activate");
                            SecSignID2FASettings settings = new SecSignID2FASettings();
                            if (pwdless) {
                                settings.setPasswordlessAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            }
                            if (twoStep) {
                                settings.setTwoStepAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            }
                            if (mailOTP) {
                                settings.setMailOtpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            }
                            if (totp) {
                                settings.setTotpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            }
                            HashMap<String, SecSignID2FASettings> mappingToSave = new HashMap<String, SecSignID2FASettings>();
                            mappingToSave.put(groupMappingKey, settings);
                            this.save2FAGroupMappings(mappingToSave);
                            logger.debug("Settings for group " + groupname + " in dir " + dirid + " converted");
                            continue;
                        }
                        logger.debug("Settings for group " + groupname + " in dir " + dirid + " already converted");
                    }
                    catch (GroupNotFoundException e) {
                        logger.error("GroupNotFoundException on save2FAGroupMappings in changeToOneAttribute for group: " + groupMappingKey);
                    }
                }
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on save2FAGroupMappings in changeToOneAttribute for dir: " + directory.getId());
            }
            try {
                HashSet allUserWithActivated = new HashSet();
                EntityQuery queryForUser1 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"mailotpactive")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                EntityQuery queryForUser2 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"usedtotpbefore")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                allUserWithActivated.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchUsers(directory.getId().longValue(), queryForUser1));
                allUserWithActivated.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchUsers(directory.getId().longValue(), queryForUser2));
                for (User user : allUserWithActivated) {
                    UserWithAttributes userWithAttributes = SecSignIDStaticAccessor.getDirectoryManager().findUserWithAttributesByName(user.getDirectoryId(), user.getName());
                    String result = userWithAttributes.getValue("secsign.activated");
                    if (result == null || result.equals("")) {
                        logger.debug("Activated Methods for user " + user.getName() + " in dir " + user.getDirectoryId() + " will be converted");
                        boolean mailOTPActive = SecSignIDMappingExtractor.getMailOTPActiveForUserKey(this.getUserKeyForUsername(user.getName()), directory.getId());
                        boolean totpActive = SecSignIDMappingExtractor.getTOTPActiveForUserKey(this.getUserKeyForUsername(user.getName()), directory.getId());
                        String secsignid = SecSignIDMappingExtractor.getSecSignIdStringForApplicationUserKey(user.getName(), user.getDirectoryId());
                        SecSignID2FAActivatedSettings activatedsettings = new SecSignID2FAActivatedSettings();
                        if (secsignid != null && !secsignid.equals("")) {
                            activatedsettings.setTwoStepActive(true);
                        }
                        if (mailOTPActive) {
                            activatedsettings.setMailOtpActive(true);
                        }
                        if (totpActive) {
                            activatedsettings.setTotpActive(true);
                        }
                        this.save2FAActivatedSettingsForUserKey(this.getUserKeyForUsername(user.getName()), directory.getId(), activatedsettings);
                        logger.debug("Activated Methods for user " + user.getName() + " in dir " + user.getDirectoryId() + " converted");
                        continue;
                    }
                    logger.debug("Activated Methods for user " + user.getName() + " in dir " + user.getDirectoryId() + " already converted");
                }
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on updating ActivatedSettings");
            }
            catch (UserNotFoundException e) {
                logger.error("UserNotFoundException on updating ActivatedSettings");
            }
        }
        SecSignIDCommonStaticAccessor.getPluginSettingsFactory().createGlobalSettings().put("toAllSettingsAsOne", (Object)String.valueOf(true));
        SecSignIDCommonStaticAccessor.getPluginSettingsFactory().createGlobalSettings().put("toAllSettingsAsOneNew", (Object)String.valueOf(true));
        logger.warn("Change To One Attribute done");
    }

    @Deprecated
    private HashMap<String, String> getTOTPGroupMappings(List<String> groupNames) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : groupNames) {
            String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
            result.putAll(SecSignIDMappingExtractor.getTOTPMappingsForGroup(groupname, dirid));
        }
        return result;
    }

    @Deprecated
    private HashMap<String, String> getMailOTPGroupMappings(List<String> groupNames) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : groupNames) {
            String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
            result.putAll(SecSignIDMappingExtractor.getMailOTPMappingsForGroup(groupname, dirid));
        }
        return result;
    }

    @Deprecated
    private HashMap<String, String> getTwoStepGroupMappings(List<String> groupNames) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : groupNames) {
            String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
            result.putAll(SecSignIDMappingExtractor.getTwoStepMappingsForGroup(groupname, dirid));
        }
        return result;
    }

    @Deprecated
    private HashMap<String, String> getPasswordlessGroupMappings(List<String> groupNames) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : groupNames) {
            String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
            result.putAll(SecSignIDMappingExtractor.getPasswordlessMappingsForGroup(groupname, dirid));
        }
        return result;
    }

    private HashMap<String, SecSignID2FASettings> get2FAGroupMappings(List<String> groupNames) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, SecSignID2FASettings> result = new HashMap<String, SecSignID2FASettings>();
        for (String string : groupNames) {
            String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
            result.putAll(SecSignIDMappingExtractor.get2FAGroupMappingsForGroup(groupname, dirid));
        }
        return result;
    }

    @Override
    public void sendRedirectForNotAuthed(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        String returnURL = httpServletReq.getRequestURI();
        returnURL = returnURL.replace(httpServletReq.getContextPath(), "");
        httpServletResp.sendRedirect(this.getBaseUrl() + "/plugins/servlet/secsignid" + "?" + "returnUrl" + "=" + returnURL);
    }

    @Override
    public void addUserToPasswordless(String userKey, long dirid) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException {
        User user = this.getUserForKey(userKey, dirid);
        try {
            SecSignIDStaticAccessor.getDirectoryManager().addUserToGroup(user.getDirectoryId(), user.getName(), "PasswordlessAllowed");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public void addUserToTwoStep(String userKey, long dirid) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException {
        User user = this.getUserForKey(userKey, dirid);
        try {
            SecSignIDStaticAccessor.getDirectoryManager().addUserToGroup(user.getDirectoryId(), user.getName(), "2SASecSignIDAllowed");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public void addUserToMailOTP(String userKey, long dirid) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException {
        User user = this.getUserForKey(userKey, dirid);
        try {
            SecSignIDStaticAccessor.getDirectoryManager().addUserToGroup(user.getDirectoryId(), user.getName(), "2SAMailOTPAllowed");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public void addUserToTOTP(String userKey, long dirid) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException {
        User user = this.getUserForKey(userKey, dirid);
        try {
            SecSignIDStaticAccessor.getDirectoryManager().addUserToGroup(user.getDirectoryId(), user.getName(), "2SATOTPAllowed");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public void addUserToFIDO(String userKey, long dirid) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException {
        User user = this.getUserForKey(userKey, dirid);
        try {
            SecSignIDStaticAccessor.getDirectoryManager().addUserToGroup(user.getDirectoryId(), user.getName(), "2SAFIDOAllowed");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public String getGroupLinkToAdd(String groupName, long dirid) {
        String baseURL = this.getBaseUrl();
        return baseURL + "/console/secure/group/viewmembers.action?groupName=" + groupName + "&directoryID=" + dirid;
    }

    @Override
    public List<User> searchUsers(EntityQuery<User> query) throws OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException {
        ArrayList<User> result = new ArrayList<User>();
        List<Directory> dirs = this.getAllDirectories();
        DirectoryManager manager = SecSignIDStaticAccessor.getDirectoryManager();
        for (Directory directory : dirs) {
            result.addAll(manager.searchUsers(directory.getId().longValue(), query));
        }
        return result;
    }

    @Override
    public String getUPMLink() {
        return this.getBaseUrl() + "/plugins/servlet/upm?source=side_nav_manage_addons";
    }

    @Override
    public boolean checkGroupExists(String groupName, long dirid) throws OperationFailedException {
        try {
            SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(dirid, groupName);
        }
        catch (GroupNotFoundException e) {
            return false;
        }
        catch (DirectoryNotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    public void addUserToGroup(String username, String groupName) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException {
        User user = this.getUserForKeyFirst(this.getUserKeyForUsername(username));
        try {
            SecSignIDStaticAccessor.getDirectoryManager().addUserToGroup(user.getDirectoryId(), username, groupName);
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    protected Set<String> getUsernamesForGroupname(String groupToAdd) throws DirectoryNotFoundException, OperationFailedException {
        LinkedHashSet<String> _searchUsersSet = new LinkedHashSet<String>();
        if (groupToAdd.contains(";")) {
            String group = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(groupToAdd);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(groupToAdd);
            _searchUsersSet.addAll(this.findGroupMembersUsernames(dirid, group));
            return _searchUsersSet;
        }
        List<Directory> directories = this.getAllDirectories();
        for (Directory dir : directories) {
            _searchUsersSet.addAll(this.findGroupMembersUsernames(dir.getId(), groupToAdd));
        }
        return _searchUsersSet;
    }

    @Override
    public String getUserNameForProfile(Map<String, Object> context) {
        return (String)context.get("name");
    }

    @Override
    public void checkGroupsCreated() {
        List<Directory> dirs = this.getAllDirectories();
        for (Directory directory : dirs) {
            try {
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), "PasswordlessAllowed");
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), "2SAFIDOAllowed");
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), "2SAMailOTPAllowed");
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), "2SATOTPAllowed");
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), "2SASecSignIDAllowed");
            }
            catch (GroupNotFoundException e) {
                SecSignIDCommonStaticAccessor.saveGroupsCreated(false);
                return;
            }
            catch (DirectoryNotFoundException e) {
            }
            catch (OperationFailedException e) {
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                logger.error("OperationFailedException on checkGroupsCreated for dir " + directory.getName() + " (" + directory.getId() + ")");
                SecSignIDCommonStaticAccessor.saveGroupsCreated(false);
                return;
            }
        }
        SecSignIDCommonStaticAccessor.saveGroupsCreated(true);
    }

    @Override
    public void activateCrowdAccess() throws ApplicationNotFoundException, ApplicationManagerException {
        Application crowdApp = SecSignIDStaticAccessor.getApplicationManager().findByName("crowd");
        ApplicationImpl crowdAppNew = ApplicationImpl.newInstance((Application)crowdApp);
        crowdAppNew.setAttribute("insecureAuthenticationEnabled", "true");
        SecSignIDStaticAccessor.getApplicationManager().update((Application)crowdAppNew);
    }

    @Override
    public boolean logoutUser(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        String tokenName = SecSignIDStaticAccessor.getTokenKey();
        Cookie cookie = null;
        if (tokenName != null) {
            cookie = new Cookie(tokenName, "");
        }
        if (cookie == null) {
            cookie = new Cookie("crowd.token_key", "");
        }
        httpServletResp.addCookie(cookie);
        return true;
    }
}

