/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDPublicSuffixInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDPublicSuffixInterpreter.class);
    private static final Map<String, String> registeredDomainCache = new HashMap<String, String>();
    private final List<Rule> rules = new ArrayList<Rule>();

    /*
     * WARNING - void declaration
     */
    public String getRegisteredDomain(URI uri) {
        String publicSuffix;
        void var6_10;
        String host = uri.getHost();
        if (host == null) {
            host = uri.getPath();
        }
        if (host == null || host.length() == 0 || host.startsWith(".")) {
            return null;
        }
        if (!host.contains(".")) {
            return host;
        }
        String registeredDomainCacheValue = registeredDomainCache.getOrDefault(host = host.toLowerCase(), null);
        if (registeredDomainCacheValue != null) {
            return registeredDomainCacheValue;
        }
        this.loadRulesIfNecessary();
        ArrayList<Rule> matchingRules = new ArrayList<Rule>();
        for (Rule rule : this.rules) {
            if (!rule.isMatching(host)) continue;
            matchingRules.add(rule);
        }
        if (matchingRules.size() == 0) {
            String[] splittedHost = host.split("\\.");
            if (splittedHost.length >= 2) {
                return splittedHost[splittedHost.length - 2] + "." + splittedHost[splittedHost.length - 1];
            }
            return host;
        }
        Rule selectedRule = (Rule)matchingRules.get(0);
        for (Rule rule : matchingRules) {
            if (rule.getPriority() <= selectedRule.getPriority()) continue;
            selectedRule = rule;
        }
        String string = selectedRule.getPublicSuffix();
        if (selectedRule.isException()) {
            String leftMostLabel = selectedRule.getLabels()[0];
            String string2 = string.replace(leftMostLabel + ".", "");
        }
        if (selectedRule.isWildcard()) {
            String[] hostLabelsSplitted = host.split("\\.");
            String[] ruleLabelsSplitted = var6_10.split("\\.");
            publicSuffix = ruleLabelsSplitted[ruleLabelsSplitted.length - 1];
            for (int i = ruleLabelsSplitted.length - 2; i >= 0; --i) {
                String ruleLabel = ruleLabelsSplitted[i];
                if (ruleLabel.equals("*")) {
                    int relativeIndex = ruleLabelsSplitted.length - i;
                    ruleLabel = hostLabelsSplitted[hostLabelsSplitted.length - relativeIndex];
                }
                publicSuffix = ruleLabel + "." + publicSuffix;
            }
        } else {
            publicSuffix = var6_10;
        }
        if (host.equals(publicSuffix)) {
            return host;
        }
        String[] hostLabels = host.replace("." + publicSuffix, "").split("\\.");
        String registeredDomain = hostLabels[hostLabels.length - 1] + "." + publicSuffix;
        registeredDomainCache.put(host, registeredDomain);
        return registeredDomain;
    }

    private void loadRulesIfNecessary() {
        if (this.rules.size() == 0) {
            logger.debug("Trying to load public suffix list.");
            InputStream in = this.getClass().getResourceAsStream("/public_suffix_list.dat");
            if (in == null) {
                logger.warn("Couldn't load public suffix list.");
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            List<String> lines = reader.lines().collect(Collectors.toList());
            this.rules.addAll(this.interpretLinesToRules(lines));
            logger.debug("Successfully loaded public suffix list.");
        }
    }

    private List<Rule> interpretLinesToRules(List<String> lines) {
        ArrayList<Rule> rulesObject = new ArrayList<Rule>();
        for (String line : lines) {
            String[] splittedLine;
            if (line.startsWith("//") || (splittedLine = line.split(" ")).length == 0 || splittedLine[0].length() == 0) continue;
            String interpretedLine = splittedLine[0];
            boolean onlyContainsWhitespace = true;
            for (char c : interpretedLine.toCharArray()) {
                if (c == ' ') continue;
                onlyContainsWhitespace = false;
                break;
            }
            if (onlyContainsWhitespace) continue;
            rulesObject.add(new Rule(interpretedLine));
        }
        return rulesObject;
    }

    private static class Rule {
        private final String ruleString;

        public Rule(String ruleString) {
            this.ruleString = ruleString;
        }

        public boolean isMatching(String host) {
            String regex = this.getPublicSuffixRegex();
            return host.matches(regex);
        }

        public String getPublicSuffix() {
            if (this.isException()) {
                return this.ruleString.replaceFirst("!", "");
            }
            return this.ruleString;
        }

        public String[] getLabels() {
            return this.getPublicSuffix().split("\\.");
        }

        public int getLabelCount() {
            int labelCount = 0;
            for (char c : this.ruleString.toCharArray()) {
                if (c != '.') continue;
                ++labelCount;
            }
            return labelCount;
        }

        public boolean isException() {
            return this.ruleString.startsWith("!");
        }

        public boolean isWildcard() {
            return this.ruleString.contains("*");
        }

        public int getPriority() {
            int priority = this.getLabelCount();
            if (this.isException()) {
                priority += 100000;
            }
            return priority;
        }

        private String getPublicSuffixRegex() {
            String regex = this.getPublicSuffix().replace(".", "\\.");
            if (this.isWildcard()) {
                regex = regex.replace("*", ".*?");
                regex = "(" + regex + ")";
            }
            return ".*?" + regex + "$";
        }
    }
}

