/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.templaterenderer.RenderingException;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenAuthorizationRequest;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenAuthorizationResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenFIDORequest;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenInfoResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenRequest;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenTOTPRequest;
import com.secsign.atlassian.common.rest.SecSignIDRESTAuthenticationMethod;
import com.secsign.atlassian.common.rest.SecSignIDRESTCheckAuthSessionStateResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTCreateAuthSessionResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTCreateQRCodeResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTCreateSecSignIDResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTDevicesResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import com.secsign.atlassian.common.rest.SecSignIDRESTFIDOAuthenticateStartResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTFIDORegisterStartResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTRestorationResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTTOTPResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTVerifyMailCodeResponse;
import com.secsign.atlassian.common.rest.SecSignIDServerRESTConnector;
import com.secsign.atlassian.common.util.SecSignIDAuthenticationUtil;
import com.secsign.atlassian.common.util.SecSignIDHttpSessionUtil;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDActivateMethodsServlet
extends HttpServlet {
    private static final long serialVersionUID = 6842235411471448500L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDActivateMethodsServlet.class);
    private SecSignIDDataAccessor dataAccessor;
    private static final String AUTH_SESSION_ID_KEY = "activatemethods.authsession.id";
    private static final String AUTH_SESSION_ICON_KEY = "authenticator.authsession.icon";
    private static final String AUTH_SESSION_SECSIGN_ID_KEY = "authenticator.authsession.secsignid";
    private static final String ACCESS_TOKEN_AUTHORIZATION_ID_KEY = "activatemethods.accesstokenauthorizationid";
    private static final String ACCESS_TOKEN_KEY = "activatemethods.accesstoken";
    private static final String METHOD_TO_ACTIVATE_KEY = "activatemethods.methodtoactivate";
    private static final String TWO_STEP_KEY = "id";
    private static final String TOTP_KEY = "totp";
    private static final String MAIL_OTP_KEY = "mail-otp";
    private static final String FIDO_KEY = "fido";

    public SecSignIDActivateMethodsServlet(SecSignIDDataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        boolean basicAuthUsed;
        HashMap<String, Object> context = new HashMap<String, Object>();
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        HttpSession session = httpServletRequest.getSession();
        boolean bl = basicAuthUsed = session.getAttribute("secsign.basicAuth") != null;
        if (user == null || basicAuthUsed) {
            this.sendJSONAnswer(false, "User not authorized", httpServletResp);
            return;
        }
        if (httpServletRequest.getParameter("cancel-secsignid") != null) {
            String authSessionId = httpServletRequest.getParameter("authsessionid");
            if (authSessionId == null) {
                this.sendJSONAnswer(false, "No AuthSession", httpServletResp);
                return;
            }
            try {
                SecSignIDServerRESTConnector.cancelAuthSession(authSessionId);
            }
            catch (SecSignIDRESTException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-with-secsignid") != null) {
            try {
                this.handleActivateWithSecSignID(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-with-mailotp") != null) {
            try {
                this.handleActivateWithMailOTP(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-with-totp") != null) {
            try {
                this.handleActivateWithTOTP(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-secsignid") != null) {
            try {
                this.handleActivateSecSignID(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-totp") != null) {
            try {
                this.handleActivateTOTP(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-fido") != null) {
            try {
                this.handleActivateFIDO(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-fido-finish-register") != null) {
            try {
                this.handleActivateFIDOFinishRegister(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-fido-finish-register-exists") != null) {
            try {
                this.handleActivateFIDOFinishRegisterExists(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-fido-finish-authenticate") != null) {
            try {
                this.handleActivateFIDOFinishAuthenticate(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-mailotp") != null) {
            try {
                this.handleActivateMailOTP(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-totp-check-new") != null) {
            try {
                this.handleCheckAndActivateTOTP(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-mailotp-check-new") != null) {
            try {
                this.handleCheckAndActivateMailOTP(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-totp-check-old") != null) {
            try {
                this.handleCheckTOTP(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-mailotp-check-old") != null) {
            try {
                this.handleCheckMailOTP(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("secsignid-checkauthsession") != null) {
            try {
                this.handleCheckAuth(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("secsignid-checkauthsession-new") != null) {
            try {
                this.handleCheckAuthAndActivateSecSignID(httpServletRequest, httpServletResp, context);
            }
            catch (JSONException e) {
                logger.error("JSONException on doPost: " + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.json"), httpServletResp);
            }
            return;
        }
        if (httpServletRequest.getParameter("activate-method") != null) {
            String authenticationMethod = httpServletRequest.getParameter("authentication-method");
            String methodToActivate = httpServletRequest.getParameter("method-to-activate");
            this.activateMethod(httpServletRequest, httpServletResp, authenticationMethod, methodToActivate);
            return;
        }
    }

    private void activateMethod(HttpServletRequest request, HttpServletResponse response, String authenticationMethodKey, String methodToActivateKey) throws IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
        try {
            String secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            SecSignIDRESTAuthenticationMethod authenticationMethod = this.convertKeyToAuthenticationMethod(authenticationMethodKey);
            SecSignIDRESTAuthenticationMethod methodToActivate = this.convertKeyToAuthenticationMethod(methodToActivateKey);
            if (methodToActivate == SecSignIDRESTAuthenticationMethod.UNKNOWN) {
                this.sendJSONAnswer(false, "Unknown method to activate.", response);
                return;
            }
            SecSignIDHttpSessionUtil.setAttribute(request.getSession(), METHOD_TO_ACTIVATE_KEY, (Object)methodToActivate);
            boolean accessTokenRequired = this.isAccessTokenRequiredForActivation(secSignId, methodToActivate);
            switch (authenticationMethod) {
                case SEC_SIGN_ID: {
                    this.activateMethodWithSecSignId(request, response, user, secSignId, accessTokenRequired, methodToActivate);
                    break;
                }
                case TOTP: {
                    this.activateMethodWithTOTP(request, response, user, secSignId, accessTokenRequired, methodToActivate);
                    break;
                }
                case FIDO: {
                    this.activateMethodWithFIDO(request, response, user, secSignId, accessTokenRequired, methodToActivate);
                    break;
                }
                case MAIL_OTP: {
                    this.activateMethodWithMailOTP(request, response, user, secSignId, accessTokenRequired, methodToActivate);
                    break;
                }
                case UNKNOWN: {
                    this.sendJSONAnswer(false, "Unknown authentication method.", response);
                }
            }
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | UserNotFoundException | SecSignIDRESTException e) {
            logger.error(e.getMessage(), e);
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), response);
        }
    }

    private void activateMethodWithSecSignId(HttpServletRequest request, HttpServletResponse response, User user, String secSignId, boolean accessTokenRequired, SecSignIDRESTAuthenticationMethod methodToActivate) throws IOException {
        HttpSession session = request.getSession();
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("secsignid", secSignId);
            if (accessTokenRequired) {
                SecSignIDRESTAccessTokenAuthorizationResponse accessTokenAuthorizationResponse = this.requestAccessTokenAuthorization(request, secSignId, SecSignIDRESTAuthenticationMethod.SEC_SIGN_ID, methodToActivate);
                parameters.put("authsessionid", String.valueOf(accessTokenAuthorizationResponse.getAuthSessionId()));
                SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_ID_KEY, String.valueOf(accessTokenAuthorizationResponse.getAuthSessionId()));
                SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_SECSIGN_ID_KEY, secSignId);
            } else {
                String serviceName = SecSignIDCommonStaticAccessor.getServiceName();
                String serviceAddress = this.dataAccessor.getBaseUrl();
                boolean noAccesspass = SecSignIDCommonStaticAccessor.getNoAccessPass();
                SecSignIDRESTCreateAuthSessionResponse createAuthSessionResponse = SecSignIDServerRESTConnector.getAuthSession(secSignId, serviceName, serviceAddress, !noAccesspass);
                parameters.put("authsessionid", String.valueOf(createAuthSessionResponse.getAuthSessionId()));
                parameters.put("authsessionicondata", createAuthSessionResponse.getAuthSessionIconData());
                SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_ID_KEY, String.valueOf(createAuthSessionResponse.getAuthSessionId()));
                SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_ICON_KEY, createAuthSessionResponse.getAuthSessionIconData());
                SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_SECSIGN_ID_KEY, secSignId);
            }
            this.sendSuccessJSONAnswer(response, parameters);
        }
        catch (SecSignIDRESTException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), response);
        }
    }

    private void activateMethodWithTOTP(HttpServletRequest request, HttpServletResponse response, User user, String secSignId, boolean accessTokenRequired, SecSignIDRESTAuthenticationMethod methodToActivate) throws IOException {
        this.sendJSONAnswer(true, null, response);
    }

    private void activateMethodWithFIDO(HttpServletRequest request, HttpServletResponse response, User user, String secSignId, boolean accessTokenRequired, SecSignIDRESTAuthenticationMethod methodToActivate) throws IOException {
        try {
            String requestOptions;
            if (accessTokenRequired) {
                SecSignIDRESTAccessTokenAuthorizationResponse accessTokenAuthorizationResponse = this.requestAccessTokenAuthorization(request, secSignId, SecSignIDRESTAuthenticationMethod.FIDO, methodToActivate);
                requestOptions = accessTokenAuthorizationResponse.getFido();
            } else {
                SecSignIDRESTFIDOAuthenticateStartResponse authenticateStartResponse = SecSignIDServerRESTConnector.startFIDOAuthenticate(secSignId);
                requestOptions = authenticateStartResponse.getRequestOptions();
            }
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("requestOptions", requestOptions);
            this.sendSuccessJSONAnswer(response, parameters);
        }
        catch (SecSignIDRESTException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), response);
        }
    }

    private void activateMethodWithMailOTP(HttpServletRequest request, HttpServletResponse response, User user, String secSignId, boolean accessTokenRequired, SecSignIDRESTAuthenticationMethod methodToActivate) throws IOException {
        if (accessTokenRequired) {
            logger.info("Mail-OTP is not supported with access tokens.");
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), response);
            return;
        }
        try {
            SecSignIDServerRESTConnector.startMailAuth(secSignId, user.getEmailAddress());
            this.sendJSONAnswer(true, null, response);
        }
        catch (SecSignIDRESTException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), response);
        }
    }

    private void handleActivateWithSecSignID(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws JSONException, IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String username = user.getName();
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        try {
            String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
            String[] idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
            String secSignId = idArray[0];
            this.startAuth(httpServletRequest, httpServletResp, secSignId, username, userKey, user.getDirectoryId(), context);
            return;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("OperationFailedException on handleActivateWithSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("ApplicationPermissionException on handleActivateWithSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("InvalidAuthenticationException on handleActivateWithSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.OperationFailedException on handleActivateWithSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("UserNotFoundException on handleActivateWithSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryNotFoundException on handleActivateWithSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.UserNotFoundException on handleActivateWithSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
    }

    private void handleActivateWithMailOTP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws JSONException, IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String username = user.getName();
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        try {
            String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
            String[] idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
            String secSignId = idArray[0];
            SecSignIDServerRESTConnector.startMailAuth(secSignId, user.getEmailAddress());
            JSONObject answerObject = new JSONObject();
            answerObject.append("success", (Object)Boolean.TRUE);
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
            return;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("OperationFailedException on handleActivateWithMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("ApplicationPermissionException on handleActivateWithMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("InvalidAuthenticationException on handleActivateWithMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.OperationFailedException on handleActivateWithMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("UserNotFoundException on handleActivateWithMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryNotFoundException on handleActivateWithMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.UserNotFoundException on handleActivateWithMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
    }

    private void handleActivateWithTOTP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws JSONException, IOException {
        JSONObject answerObject = new JSONObject();
        answerObject.append("success", (Object)Boolean.TRUE);
        httpServletResp.setContentType("application/json");
        httpServletResp.getWriter().write(answerObject.toString());
    }

    private void handleActivateWithFIDO(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> context) throws JSONException, IOException {
        JSONObject answerObject = new JSONObject();
        response.setContentType("application/json");
        response.getWriter().write(answerObject.toString());
    }

    private void handleActivateTOTP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws JSONException, IOException {
        JSONObject answerObject = new JSONObject();
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String username = user.getName();
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        String[] idArray = null;
        Object qrPair = null;
        try {
            String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
            idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("OperationFailedException on handleActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("ApplicationPermissionException on handleActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("InvalidAuthenticationException on handleActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.OperationFailedException on handleActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("UserNotFoundException on handleActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryNotFoundException on handleActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.UserNotFoundException on handleActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        if (idArray == null || idArray.length == 0) {
            String otpID = "";
            try {
                boolean autofillMail = SecSignIDCommonStaticAccessor.getAutoFillMail();
                boolean autofillUser = SecSignIDCommonStaticAccessor.getAutoFillUsername();
                boolean autofillUsercompany = SecSignIDCommonStaticAccessor.getAutoFillUsernameCompany();
                boolean autoFillPattern = SecSignIDCommonStaticAccessor.getAutoFillPattern();
                if (autofillMail) {
                    if (!SecSignIDServerRESTConnector.checkSecSignID(user.getEmailAddress().toLowerCase())) {
                        SecSignIDServerRESTConnector.createSecSignID(user.getEmailAddress().toLowerCase(), user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getEmailAddress().toLowerCase());
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getEmailAddress().toLowerCase();
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(user.getEmailAddress().toLowerCase() + indexToAdd)) {
                            ++indexToAdd;
                        }
                        SecSignIDServerRESTConnector.createSecSignID(user.getEmailAddress().toLowerCase() + indexToAdd, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getEmailAddress().toLowerCase() + indexToAdd);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getEmailAddress().toLowerCase() + indexToAdd;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    }
                } else if (autofillUser) {
                    if (!SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_"))) {
                        SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_"), user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_"));
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getName().toLowerCase().replace(" ", "_");
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + indexToAdd)) {
                            ++indexToAdd;
                        }
                        SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_") + indexToAdd, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_") + indexToAdd);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getName().toLowerCase().replace(" ", "_") + indexToAdd;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    }
                } else if (autofillUsercompany) {
                    if (!SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName())) {
                        SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName(), user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName());
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName();
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd)) {
                            ++indexToAdd;
                        }
                        SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    }
                } else if (autoFillPattern) {
                    String autoFillPatterPattern;
                    String result = autoFillPatterPattern = SecSignIDCommonStaticAccessor.getAutoFillPatternPattern();
                    result = result.replace("%username%", user.getName().toLowerCase().replace(" ", "_"));
                    result = result.replace("%displayname%", user.getDisplayName().replace(" ", "").toLowerCase());
                    result = result.replace("%mail%", user.getEmailAddress().toLowerCase());
                    result = result.replace("%index%", "");
                    if (!SecSignIDServerRESTConnector.checkSecSignID(result = result.toLowerCase())) {
                        SecSignIDServerRESTConnector.createSecSignID(result, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), result);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = result;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(result + indexToAdd)) {
                            ++indexToAdd;
                        }
                        SecSignIDServerRESTConnector.createSecSignID(result + indexToAdd, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), result + indexToAdd);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = result + indexToAdd;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    }
                }
            }
            catch (SecSignIDRESTException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
                return;
            }
            catch (com.atlassian.crowd.exception.OperationFailedException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("OperationFailedException on handleActivateTOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (ApplicationPermissionException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("ApplicationPermissionException on handleActivateTOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (InvalidAuthenticationException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("InvalidAuthenticationException on handleActivateTOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (DirectoryPermissionException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("DirectoryPermissionException on handleActivateTOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (OperationFailedException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("runtime.OperationFailedException on handleActivateTOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (OperationNotPermittedException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("OperationNotPermittedException on handleActivateTOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (NamingException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("NamingException on handleActivateTOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError(e));
                return;
            }
            catch (DirectoryNotFoundException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("DirectoryNotFoundException on handleActivateTOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("runtime.UserNotFoundException on handleActivateTOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (UserNotFoundException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("UserNotFoundException on handleActivateTOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            answerObject.append("secsignid", (Object)otpID);
            try {
                SecSignIDRESTTOTPResponse totpArray = SecSignIDServerRESTConnector.getTOTPQRCode(otpID, this.getAccessToken(httpServletRequest));
                if (totpArray.getTotpQRCodeBase64().equals("") || totpArray.getTotpKeyUri().equals("")) {
                    totpArray = SecSignIDServerRESTConnector.getTOTPQRCode(otpID, this.getAccessToken(httpServletRequest));
                }
                if (totpArray.getTotpQRCodeBase64() == null || totpArray.getTotpKeyUri() == null) {
                    logger.error("SecSignIDRESTException on getTOTPQRCode: No Code found, Server not ready?");
                    return;
                }
                answerObject.append("totpQRUrl", (Object)totpArray.getTotpKeyUri());
                answerObject.append("totpQRCode", (Object)totpArray.getTotpQRCodeBase64());
                String toExtract = totpArray.getTotpKeyUri();
                int startIndex = toExtract.indexOf("secret=") + 7;
                int endIndex = toExtract.indexOf("&", startIndex);
                String secret = toExtract.substring(startIndex, endIndex);
                answerObject.append("totpQRSecret", (Object)secret);
                answerObject.append("success", (Object)Boolean.TRUE);
            }
            catch (SecSignIDRESTException e1) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e1.getLocalizedMessage(), httpServletResp);
                return;
            }
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        String secSignId = idArray[0];
        answerObject.append("secsignid", (Object)secSignId);
        try {
            SecSignIDRESTTOTPResponse totpArray = SecSignIDServerRESTConnector.getTOTPQRCode(secSignId, this.getAccessToken(httpServletRequest));
            if (totpArray.getTotpQRCodeBase64().equals("") || totpArray.getTotpKeyUri().equals("")) {
                totpArray = SecSignIDServerRESTConnector.getTOTPQRCode(secSignId, this.getAccessToken(httpServletRequest));
            }
            if (totpArray.getTotpQRCodeBase64() == null || totpArray.getTotpKeyUri() == null) {
                logger.error("SecSignIDRESTException on getTOTPQRCode: No Code found, Server not ready?");
                return;
            }
            answerObject.append("totpQRUrl", (Object)totpArray.getTotpKeyUri());
            answerObject.append("totpQRCode", (Object)totpArray.getTotpQRCodeBase64());
            String toExtract = totpArray.getTotpKeyUri();
            int startIndex = toExtract.indexOf("secret=") + 7;
            int endIndex = toExtract.indexOf("&", startIndex);
            String secret = toExtract.substring(startIndex, endIndex);
            answerObject.append("totpQRSecret", (Object)secret);
            answerObject.append("success", (Object)Boolean.TRUE);
        }
        catch (SecSignIDRESTException e1) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e1.getLocalizedMessage(), httpServletResp);
            return;
        }
        httpServletResp.setContentType("application/json");
        httpServletResp.getWriter().write(answerObject.toString());
    }

    private void handleActivateFIDO(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> context) throws JSONException, IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
        String secSignId = null;
        try {
            secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            if (secSignId == null) {
                secSignId = SecSignIDAuthenticationUtil.tryFindAutoFillSecSignId(user, true);
            }
            if (!SecSignIDServerRESTConnector.checkSecSignID(secSignId)) {
                SecSignIDServerRESTConnector.createSecSignID(secSignId, user.getEmailAddress());
                SecSignIDAuthenticationUtil.saveSecSignIdForUser(request, this.dataAccessor, user, secSignId);
                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
            }
            String credentialNickname = request.getParameter("credentialNickname");
            SecSignIDRESTFIDORegisterStartResponse registerStartResponse = SecSignIDServerRESTConnector.startFIDORegister(secSignId, credentialNickname, this.getAccessToken(request));
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("creationOptions", registerStartResponse.getCreationOptions());
            this.sendSuccessJSONAnswer(response, parameters);
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | OperationNotPermittedException | UserNotFoundException | DirectoryPermissionException | SecSignIDRESTException | NamingException e) {
            logger.error(e.getMessage(), e);
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), response);
        }
    }

    private void handleActivateFIDOFinishRegister(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> context) throws JSONException, IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
        try {
            String secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            if (secSignId == null || !SecSignIDServerRESTConnector.checkSecSignID(secSignId)) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), response);
                return;
            }
            String credentialId = request.getParameter("credentialId");
            String clientDataJson = request.getParameter("clientDataJson");
            String attestationObject = request.getParameter("attestationObject");
            SecSignIDServerRESTConnector.finishFIDORegister(secSignId, credentialId, clientDataJson, attestationObject, this.getAccessToken(request));
            SecSignID2FAActivatedSettings activatedSettings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, user.getDirectoryId());
            activatedSettings.setFidoActive(true);
            this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
            if (SecSignIDCommonStaticAccessor.getInformUser()) {
                this.dataAccessor.mailActivateFIDOToUser(userKey, user.getDirectoryId());
            }
            this.dataAccessor.logActivateFIDO(userKey, user.getDirectoryId(), request.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                this.dataAccessor.mailActivateFIDOToInformGroup(userKey, user.getDirectoryId());
            }
            this.sendJSONAnswer(true, null, response);
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | UserNotFoundException | DirectoryPermissionException | SecSignIDRESTException e) {
            logger.error(e.getMessage(), e);
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), response);
        }
    }

    private void handleActivateFIDOFinishRegisterExists(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> context) throws JSONException, IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
        try {
            String secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            if (secSignId == null || !SecSignIDServerRESTConnector.checkSecSignID(secSignId)) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), response);
                return;
            }
            SecSignID2FAActivatedSettings activatedSettings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, user.getDirectoryId());
            activatedSettings.setFidoActive(true);
            this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
            if (SecSignIDCommonStaticAccessor.getInformUser()) {
                this.dataAccessor.mailActivateFIDOToUser(userKey, user.getDirectoryId());
            }
            this.dataAccessor.logActivateFIDO(userKey, user.getDirectoryId(), request.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                this.dataAccessor.mailActivateFIDOToInformGroup(userKey, user.getDirectoryId());
            }
            this.sendJSONAnswer(true, null, response);
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | UserNotFoundException | DirectoryPermissionException | SecSignIDRESTException e) {
            logger.error(e.getMessage(), e);
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), response);
        }
    }

    private void handleActivateFIDOFinishAuthenticate(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> context) throws JSONException, IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
        String secSignId = null;
        try {
            secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            if (secSignId == null || !SecSignIDServerRESTConnector.checkSecSignID(secSignId)) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), response);
                return;
            }
            String credentialId = request.getParameter("credentialId");
            String clientDataJson = request.getParameter("clientDataJson");
            String authenticatorData = request.getParameter("authenticatorData");
            String signature = request.getParameter("signature");
            String userHandle = request.getParameter("userHandle");
            boolean accessTokenRequired = this.isAccessTokenRequiredForActivation(secSignId, this.getMethodToActivate(request));
            if (accessTokenRequired) {
                this.requestAccessTokenForFIDOAuthentication(request, credentialId, clientDataJson, authenticatorData, signature, userHandle);
            } else {
                SecSignIDServerRESTConnector.finishFIDOAuthenticate(secSignId, credentialId, clientDataJson, authenticatorData, signature, userHandle);
            }
            this.sendJSONAnswer(true, null, response);
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | UserNotFoundException | SecSignIDRESTException e) {
            logger.error(e.getMessage(), e);
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), response);
        }
    }

    private void handleActivateSecSignID(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws JSONException, IOException {
        JSONObject answerObject = new JSONObject();
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String username = user.getName();
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        String[] idArray = null;
        try {
            String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
            idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("OperationFailedException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("ApplicationPermissionException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("InvalidAuthenticationException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.OperationFailedException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("UserNotFoundException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryNotFoundException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.UserNotFoundException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        if (idArray == null || idArray.length == 0) {
            String otpID = "";
            boolean useRestore = SecSignIDCommonStaticAccessor.getUseRestore();
            try {
                boolean autofillMail = SecSignIDCommonStaticAccessor.getAutoFillMail();
                boolean autofillUser = SecSignIDCommonStaticAccessor.getAutoFillUsername();
                boolean autofillUsercompany = SecSignIDCommonStaticAccessor.getAutoFillUsernameCompany();
                boolean autoFillPattern = SecSignIDCommonStaticAccessor.getAutoFillPattern();
                if (autofillMail) {
                    if (!SecSignIDServerRESTConnector.checkSecSignID(user.getEmailAddress().toLowerCase())) {
                        otpID = user.getEmailAddress().toLowerCase();
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(user.getEmailAddress().toLowerCase() + indexToAdd)) {
                            ++indexToAdd;
                        }
                        otpID = user.getEmailAddress().toLowerCase() + indexToAdd;
                    }
                } else if (autofillUser) {
                    if (!SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_"))) {
                        otpID = user.getName().toLowerCase().replace(" ", "_");
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + indexToAdd)) {
                            ++indexToAdd;
                        }
                        otpID = user.getName().toLowerCase().replace(" ", "_") + indexToAdd;
                    }
                } else if (autofillUsercompany) {
                    if (!SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName())) {
                        otpID = user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName();
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd)) {
                            ++indexToAdd;
                        }
                        otpID = user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd;
                    }
                } else if (autoFillPattern) {
                    String autoFillPatterPattern;
                    String result = autoFillPatterPattern = SecSignIDCommonStaticAccessor.getAutoFillPatternPattern();
                    result = result.replace("%username%", user.getName().toLowerCase().replace(" ", "_"));
                    result = result.replace("%displayname%", user.getDisplayName().replace(" ", "").toLowerCase());
                    result = result.replace("%mail%", user.getEmailAddress().toLowerCase());
                    result = result.replace("%index%", "");
                    if (!SecSignIDServerRESTConnector.checkSecSignID(result = result.toLowerCase())) {
                        otpID = result;
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(result + indexToAdd)) {
                            ++indexToAdd;
                        }
                        otpID = result + indexToAdd;
                    }
                }
            }
            catch (SecSignIDRESTException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
                return;
            }
            if (useRestore) {
                try {
                    SecSignIDRESTCreateSecSignIDResponse newQrPair = SecSignIDServerRESTConnector.createSecSignID(otpID, user.getEmailAddress());
                    this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), otpID);
                    this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                    this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                    if (SecSignIDCommonStaticAccessor.getInformUser()) {
                        this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                    }
                    if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                        this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                    }
                    answerObject.append("qrMail", (Object)user.getEmailAddress());
                    answerObject.append("qrID", (Object)otpID);
                    answerObject.append("savedQRCode", (Object)newQrPair.getQrCodeBase64());
                    answerObject.append("savedUrl", (Object)newQrPair.getRestoreUrl());
                    answerObject.append("qrExists", (Object)Boolean.TRUE);
                    answerObject.append("success", (Object)Boolean.TRUE);
                    httpServletResp.setContentType("application/json");
                    httpServletResp.getWriter().write(answerObject.toString());
                    return;
                }
                catch (SecSignIDRESTException e) {
                    this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
                    return;
                }
                catch (com.atlassian.crowd.exception.OperationFailedException e) {
                    this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                    logger.error("OperationFailedException on handleActivateSecSignID:" + e.getMessage());
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                    return;
                }
                catch (ApplicationPermissionException e) {
                    this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                    logger.error("ApplicationPermissionException on handleActivateSecSignID:" + e.getMessage());
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                    return;
                }
                catch (InvalidAuthenticationException e) {
                    this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                    logger.error("InvalidAuthenticationException on handleActivateSecSignID:" + e.getMessage());
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                    return;
                }
                catch (DirectoryPermissionException e) {
                    this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                    logger.error("DirectoryPermissionException on handleActivateSecSignID:" + e.getMessage());
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                    return;
                }
                catch (OperationFailedException e) {
                    this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                    logger.error("runtime.OperationFailedException on handleActivateSecSignID:" + e.getMessage());
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                    return;
                }
                catch (OperationNotPermittedException e) {
                    this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                    logger.error("OperationNotPermittedException on handleActivateSecSignID:" + e.getMessage());
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                    return;
                }
                catch (NamingException e) {
                    this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                    logger.error("NamingException on handleActivateSecSignID:" + e.getMessage());
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError(e));
                    return;
                }
                catch (DirectoryNotFoundException e) {
                    this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                    logger.error("DirectoryNotFoundException on handleActivateSecSignID:" + e.getMessage());
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                    return;
                }
                catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
                    this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                    logger.error("runtime.UserNotFoundException on handleActivateSecSignID:" + e.getMessage());
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                    return;
                }
                catch (UserNotFoundException e) {
                    this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                    logger.error("UserNotFoundException on handleActivateSecSignID:" + e.getMessage());
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                    return;
                }
            }
            try {
                SecSignIDRESTCreateQRCodeResponse newQrPair = SecSignIDServerRESTConnector.getCreateSecSignIDQrCode(otpID);
                this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), otpID);
                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                    this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                }
                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                    this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                }
                answerObject.append("create", (Object)Boolean.TRUE);
                answerObject.append("qrID", (Object)otpID);
                answerObject.append("savedQRCode", (Object)newQrPair.getQrCodeBase64());
                answerObject.append("savedUrl", (Object)newQrPair.getCreateUrl());
                answerObject.append("qrExists", (Object)Boolean.TRUE);
                answerObject.append("success", (Object)Boolean.TRUE);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
                return;
            }
            catch (SecSignIDRESTException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
                return;
            }
            catch (com.atlassian.crowd.exception.OperationFailedException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("OperationFailedException on handleActivateSecSignID:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (ApplicationPermissionException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("ApplicationPermissionException on handleActivateSecSignID:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (InvalidAuthenticationException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("InvalidAuthenticationException on handleActivateSecSignID:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (DirectoryPermissionException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("DirectoryPermissionException on handleActivateSecSignID:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (OperationFailedException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("runtime.OperationFailedException on handleActivateSecSignID:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (OperationNotPermittedException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("OperationNotPermittedException on handleActivateSecSignID:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (NamingException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("NamingException on handleActivateSecSignID:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError(e));
                return;
            }
            catch (DirectoryNotFoundException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("DirectoryNotFoundException on handleActivateSecSignID:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("runtime.UserNotFoundException on handleActivateSecSignID:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (UserNotFoundException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("UserNotFoundException on handleActivateSecSignID:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
        }
        String secSignId = idArray[0];
        try {
            String url;
            String qrCode;
            if (SecSignIDServerRESTConnector.checkSecSignID(secSignId)) {
                boolean restored;
                SecSignIDRESTDevicesResponse devices = SecSignIDServerRESTConnector.getDevicesOfSecSignID(secSignId);
                boolean bl = restored = devices.getDeviceCount() != 0;
                if (restored) {
                    this.startAuth(httpServletRequest, httpServletResp, secSignId, username, userKey, user.getDirectoryId(), context);
                    return;
                }
                SecSignIDRESTRestorationResponse restorationResponse = SecSignIDServerRESTConnector.getRestoreQRCode(secSignId, this.getAccessToken(httpServletRequest));
                answerObject.append("qrMail", (Object)this.dataAccessor.getUserForKeyFirst(userKey).getEmailAddress());
                answerObject.append("qrID", (Object)secSignId);
                answerObject.append("savedQRCode", (Object)restorationResponse.getQrCodeBase64());
                answerObject.append("savedUrl", (Object)restorationResponse.getRestoreUrl());
                answerObject.append("qrExists", (Object)Boolean.TRUE);
                answerObject.append("success", (Object)Boolean.TRUE);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
                return;
            }
            boolean useRestore = SecSignIDCommonStaticAccessor.getUseRestore();
            if (useRestore) {
                SecSignIDRESTCreateSecSignIDResponse createSecSignIDResponse = SecSignIDServerRESTConnector.createSecSignID(secSignId, user.getEmailAddress());
                qrCode = createSecSignIDResponse.getQrCodeBase64();
                url = createSecSignIDResponse.getRestoreUrl();
                context.put("qrMail", user.getEmailAddress());
            } else {
                SecSignIDRESTCreateQRCodeResponse createQRCodeResponse = SecSignIDServerRESTConnector.getCreateSecSignIDQrCode(secSignId);
                qrCode = createQRCodeResponse.getQrCodeBase64();
                url = createQRCodeResponse.getCreateUrl();
                context.put("create", Boolean.TRUE);
            }
            SecSignIDAuthenticationUtil.saveSecSignIdForUser(httpServletRequest, this.dataAccessor, user, secSignId);
            answerObject.put("qrID", (Object)secSignId);
            answerObject.put("savedQRCode", (Object)qrCode);
            answerObject.put("savedUrl", (Object)URLEncoder.encode(url, "UTF-8"));
            answerObject.put("qrExists", (Object)Boolean.TRUE);
            answerObject.append("success", (Object)Boolean.TRUE);
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
            return;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("OperationFailedException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.OperationFailedException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.UserNotFoundException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("InvalidAuthenticationException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (DirectoryPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryPermissionException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("ApplicationPermissionException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (OperationNotPermittedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("OperationNotPermittedException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryNotFoundException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (NamingException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("NamingException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError(e));
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("UserNotFoundException on handleActivateSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
    }

    private void handleActivateMailOTP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws JSONException, IOException {
        JSONObject answerObject = new JSONObject();
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String username = user.getName();
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        String[] idArray = null;
        try {
            String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
            idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("OperationFailedException on handleActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("ApplicationPermissionException on handleActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("InvalidAuthenticationException on handleActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.OperationFailedException on handleActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("UserNotFoundException on handleActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryNotFoundException on handleActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.UserNotFoundException on handleActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        if (idArray == null || idArray.length == 0) {
            String otpID = "";
            try {
                boolean autofillMail = SecSignIDCommonStaticAccessor.getAutoFillMail();
                boolean autofillUser = SecSignIDCommonStaticAccessor.getAutoFillUsername();
                boolean autofillUsercompany = SecSignIDCommonStaticAccessor.getAutoFillUsernameCompany();
                boolean autoFillPattern = SecSignIDCommonStaticAccessor.getAutoFillPattern();
                if (autofillMail) {
                    if (!SecSignIDServerRESTConnector.checkSecSignID(user.getEmailAddress().toLowerCase())) {
                        SecSignIDServerRESTConnector.createSecSignID(user.getEmailAddress().toLowerCase(), user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getEmailAddress().toLowerCase());
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getEmailAddress().toLowerCase();
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(user.getEmailAddress() + indexToAdd)) {
                            ++indexToAdd;
                        }
                        SecSignIDServerRESTConnector.createSecSignID(user.getEmailAddress().toLowerCase() + indexToAdd, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getEmailAddress().toLowerCase() + indexToAdd);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getEmailAddress().toLowerCase() + indexToAdd;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    }
                } else if (autofillUser) {
                    if (!SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_"))) {
                        SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_"), user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_"));
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getName().toLowerCase().replace(" ", "_");
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + indexToAdd)) {
                            ++indexToAdd;
                        }
                        SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_") + indexToAdd, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_") + indexToAdd);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getName().toLowerCase().replace(" ", "_") + indexToAdd;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    }
                } else if (autofillUsercompany) {
                    if (!SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName())) {
                        SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName(), user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName());
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName();
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd)) {
                            ++indexToAdd;
                        }
                        SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    }
                } else if (autoFillPattern) {
                    String autoFillPatterPattern;
                    String result = autoFillPatterPattern = SecSignIDCommonStaticAccessor.getAutoFillPatternPattern();
                    result = result.replace("%username%", user.getName().toLowerCase().replace(" ", "_"));
                    result = result.replace("%displayname%", user.getDisplayName().replace(" ", "").toLowerCase());
                    result = result.replace("%mail%", user.getEmailAddress().toLowerCase());
                    result = result.replace("%index%", "");
                    if (!SecSignIDServerRESTConnector.checkSecSignID(result = result.toLowerCase())) {
                        SecSignIDServerRESTConnector.createSecSignID(result, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), result);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = result;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(result + indexToAdd)) {
                            ++indexToAdd;
                        }
                        SecSignIDServerRESTConnector.createSecSignID(result + indexToAdd, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), result + indexToAdd);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = result + indexToAdd;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletRequest.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    }
                }
            }
            catch (SecSignIDRESTException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
                return;
            }
            catch (com.atlassian.crowd.exception.OperationFailedException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("OperationFailedException on handleActivateMailOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (ApplicationPermissionException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("ApplicationPermissionException on handleActivateMailOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (InvalidAuthenticationException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("InvalidAuthenticationException on handleActivateMailOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (DirectoryPermissionException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("DirectoryPermissionException on handleActivateMailOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (OperationFailedException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("runtime.OperationFailedException on handleActivateMailOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (OperationNotPermittedException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("OperationNotPermittedException on handleActivateMailOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (NamingException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("NamingException on handleActivateMailOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError(e));
                return;
            }
            catch (DirectoryNotFoundException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("DirectoryNotFoundException on handleActivateMailOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("runtime.UserNotFoundException on handleActivateMailOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            catch (UserNotFoundException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                logger.error("UserNotFoundException on handleActivateMailOTP:" + e.getMessage());
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                return;
            }
            try {
                SecSignIDServerRESTConnector.startMailAuth(otpID, user.getEmailAddress());
                answerObject.append("secsignid", (Object)otpID);
                answerObject.append("success", (Object)Boolean.TRUE);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
                return;
            }
            catch (SecSignIDRESTException e) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
                return;
            }
        }
        String secSignId = idArray[0];
        try {
            SecSignIDServerRESTConnector.startMailAuth(secSignId, user.getEmailAddress());
            answerObject.append("secsignid", (Object)secSignId);
            answerObject.append("success", (Object)Boolean.TRUE);
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
            return;
        }
    }

    private void handleCheckAndActivateTOTP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws JSONException, IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String username = user.getName();
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        String otpCode = httpServletRequest.getParameter("otpCode");
        if (otpCode == null || otpCode.length() == 0) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.otp.wrong"), httpServletResp);
            return;
        }
        try {
            String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
            String[] idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
            String secSignId = idArray[0];
            boolean result = SecSignIDServerRESTConnector.verifyOTPCode(secSignId, otpCode);
            if (result) {
                SecSignID2FAActivatedSettings activatedSettings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, user.getDirectoryId());
                activatedSettings.setTotpActive(true);
                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                    this.dataAccessor.mailActivateTOTPToUser(userKey, user.getDirectoryId());
                }
                this.dataAccessor.logActivateTOTP(userKey, user.getDirectoryId(), httpServletRequest.getRemoteAddr());
                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                    this.dataAccessor.mailActivateTOTPToInformGroup(userKey, user.getDirectoryId());
                }
                this.sendJSONAnswer(true, null, httpServletResp);
                return;
            }
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.otp.wrong"), httpServletResp);
            return;
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
            return;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("OperationFailedException on handleCheckAndActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("ApplicationPermissionException on handleCheckAndActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("InvalidAuthenticationException on handleCheckAndActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryPermissionException on handleCheckAndActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.OperationFailedException on handleCheckAndActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("UserNotFoundException on handleCheckAndActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryNotFoundException on handleCheckAndActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.UserNotFoundException on handleCheckAndActivateTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
    }

    private void handleCheckAndActivateMailOTP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws JSONException, IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String username = user.getName();
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        String otpCode = httpServletRequest.getParameter("mailCode");
        if (otpCode == null || otpCode.length() == 0) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.otp.wrong"), httpServletResp);
            return;
        }
        try {
            String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
            String[] idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
            String secSignId = idArray[0];
            SecSignIDRESTVerifyMailCodeResponse result = SecSignIDServerRESTConnector.verifyMailCode(secSignId, otpCode);
            if (result.getValid()) {
                SecSignID2FAActivatedSettings activatedSettings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, user.getDirectoryId());
                activatedSettings.setMailOtpActive(true);
                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                    this.dataAccessor.mailActivateMailOTPToUser(userKey, user.getDirectoryId());
                }
                this.dataAccessor.logActivateMailOTP(userKey, user.getDirectoryId(), httpServletRequest.getRemoteAddr());
                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                    this.dataAccessor.mailActivateMailOTPToInformGroup(userKey, user.getDirectoryId());
                }
                this.sendJSONAnswer(true, null, httpServletResp);
                return;
            }
            if (result.getExists()) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.mail.wrong"), httpServletResp);
                return;
            }
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.mail.notexist"), httpServletResp);
            return;
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
            return;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("OperationFailedException on handleCheckAndActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("ApplicationPermissionException on handleCheckAndActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("InvalidAuthenticationException on handleCheckAndActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryPermissionException on handleCheckAndActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.OperationFailedException on handleCheckAndActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("UserNotFoundException on handleCheckAndActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryNotFoundException on handleCheckAndActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.UserNotFoundException on handleCheckAndActivateMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
    }

    private void handleCheckTOTP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws JSONException, IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String username = user.getName();
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        String otpCode = httpServletRequest.getParameter("otpCode");
        if (otpCode == null || otpCode.length() == 0) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.otp.wrong"), httpServletResp);
            return;
        }
        try {
            boolean result;
            String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
            String[] idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
            String secSignId = idArray[0];
            boolean accessTokenRequired = this.isAccessTokenRequiredForActivation(secSignId, this.getMethodToActivate(httpServletRequest));
            if (accessTokenRequired) {
                this.requestAccessTokenAuthorization(httpServletRequest, secSignId, SecSignIDRESTAuthenticationMethod.TOTP, this.getMethodToActivate(httpServletRequest));
                result = this.requestAccessTokenForTOTPAuthentication(httpServletRequest, otpCode);
            } else {
                result = SecSignIDServerRESTConnector.verifyOTPCode(secSignId, otpCode);
            }
            if (result) {
                this.sendJSONAnswer(true, null, httpServletResp);
                return;
            }
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.otp.wrong"), httpServletResp);
            return;
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
            return;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("OperationFailedException on handleCheckTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("ApplicationPermissionException on handleCheckTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("InvalidAuthenticationException on handleCheckTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.OperationFailedException on handleCheckTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("UserNotFoundException on handleCheckTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryNotFoundException on handleCheckTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.UserNotFoundException on handleCheckTOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
    }

    private void handleCheckMailOTP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws JSONException, IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String username = user.getName();
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        String otpCode = httpServletRequest.getParameter("mailCode");
        if (otpCode == null || otpCode.length() == 0) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.otp.wrong"), httpServletResp);
            return;
        }
        try {
            String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
            String[] idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
            String secSignId = idArray[0];
            SecSignIDRESTVerifyMailCodeResponse result = SecSignIDServerRESTConnector.verifyMailCode(secSignId, otpCode);
            if (result.getValid()) {
                this.sendJSONAnswer(true, null, httpServletResp);
                return;
            }
            if (result.getExists()) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.mail.wrong"), httpServletResp);
                return;
            }
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.mail.notexist"), httpServletResp);
            return;
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
            return;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("OperationFailedException on handleCheckMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("ApplicationPermissionException on handleCheckMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("InvalidAuthenticationException on handleCheckMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.OperationFailedException on handleCheckMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("UserNotFoundException on handleCheckMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryNotFoundException on handleCheckMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.UserNotFoundException on handleCheckMailOTP:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
    }

    private void handleCheckAuth(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException, JSONException {
        String authSessionId = (String)SecSignIDHttpSessionUtil.getAttribute(httpServletReq.getSession(), AUTH_SESSION_ID_KEY);
        if (authSessionId == null) {
            this.sendJSONAnswer(false, "No AuthSession", httpServletResp);
            return;
        }
        try {
            SecSignIDRESTCheckAuthSessionStateResponse sessionState = SecSignIDServerRESTConnector.checkAuth(authSessionId);
            int sessionStateInt = sessionState.getAuthSessionStateValue();
            JSONObject answerObject = new JSONObject();
            answerObject.put("success", true);
            answerObject.put("authSessionState", sessionStateInt);
            switch (sessionStateInt) {
                case 5: {
                    answerObject.put("errormsg", (Object)SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.session.suspended"));
                    break;
                }
                case 4: {
                    answerObject.put("errormsg", (Object)SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.session.denied"));
                    break;
                }
                case 6: {
                    answerObject.put("errormsg", (Object)SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.warning.canceled"));
                    break;
                }
                case 2: {
                    answerObject.put("errormsg", (Object)SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.session.expired"));
                    break;
                }
                case 0: 
                case 8: {
                    answerObject.put("errormsg", (Object)SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.session.invalid"));
                    break;
                }
                case 3: {
                    this.requestAccessTokenForTwoStepAuthentication(httpServletReq);
                    break;
                }
            }
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
            return;
        }
    }

    private void handleCheckAuthAndActivateSecSignID(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException, JSONException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String username = user.getName();
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        String authSessionId = (String)SecSignIDHttpSessionUtil.getAttribute(httpServletReq.getSession(), AUTH_SESSION_ID_KEY);
        if (authSessionId == null) {
            this.sendJSONAnswer(false, "No AuthSession", httpServletResp);
            return;
        }
        try {
            SecSignIDRESTCheckAuthSessionStateResponse sessionState = SecSignIDServerRESTConnector.checkAuth(authSessionId);
            int sessionStateInt = sessionState.getAuthSessionStateValue();
            JSONObject answerObject = new JSONObject();
            answerObject.put("success", true);
            answerObject.put("authSessionState", sessionStateInt);
            switch (sessionStateInt) {
                case 3: {
                    try {
                        SecSignID2FAActivatedSettings activatedSettings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, user.getDirectoryId());
                        activatedSettings.setTwoStepActive(true);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailActivateSecSignIDToUser(userKey, user.getDirectoryId());
                        }
                        this.dataAccessor.logActivateSecSignID(userKey, user.getDirectoryId(), httpServletReq.getRemoteAddr());
                        if (!SecSignIDCommonStaticAccessor.getInformAdmin() || !SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) break;
                        this.dataAccessor.mailActivateSecSignIDToInformGroup(userKey, user.getDirectoryId());
                        break;
                    }
                    catch (com.atlassian.crowd.exception.OperationFailedException e) {
                        this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                        logger.error("OperationFailedException on handleActivateSuccessfullSecSignID:" + e.getMessage());
                        logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                        return;
                    }
                    catch (ApplicationPermissionException e) {
                        this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                        logger.error("ApplicationPermissionException on handleActivateSuccessfullSecSignID:" + e.getMessage());
                        logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                        return;
                    }
                    catch (InvalidAuthenticationException e) {
                        this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                        logger.error("InvalidAuthenticationException on handleActivateSuccessfullSecSignID:" + e.getMessage());
                        logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                        return;
                    }
                    catch (DirectoryPermissionException e) {
                        this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                        logger.error("DirectoryPermissionException on handleActivateSuccessfullSecSignID:" + e.getMessage());
                        logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                        return;
                    }
                    catch (OperationFailedException e) {
                        this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                        logger.error("runtime.OperationFailedException on handleActivateSuccessfullSecSignID:" + e.getMessage());
                        logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                        return;
                    }
                    catch (DirectoryNotFoundException e) {
                        this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                        logger.error("DirectoryNotFoundException on handleActivateSuccessfullSecSignID:" + e.getMessage());
                        logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                        return;
                    }
                    catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
                        this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                        logger.error("runtime.UserNotFoundException on handleActivateSuccessfullSecSignID:" + e.getMessage());
                        logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                        return;
                    }
                    catch (UserNotFoundException e) {
                        this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
                        logger.error("com.atlassian.crowd.exception.UserNotFoundException on handleActivateSuccessfullSecSignID:" + e.getMessage());
                        logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                        return;
                    }
                }
                case 5: {
                    answerObject.put("errormsg", (Object)SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.session.suspended"));
                    break;
                }
                case 4: {
                    answerObject.put("errormsg", (Object)SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.session.denied"));
                    break;
                }
                case 6: {
                    answerObject.put("errormsg", (Object)SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.warning.canceled"));
                    break;
                }
                case 2: {
                    answerObject.put("errormsg", (Object)SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.session.expired"));
                    break;
                }
                case 0: 
                case 8: {
                    answerObject.put("errormsg", (Object)SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.session.invalid"));
                    break;
                }
            }
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
            return;
        }
    }

    private void startAuth(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, String secSignId, String username, String userKey, long directoryId, HashMap<String, Object> context) throws RenderingException, IOException, JSONException {
        String serviceName = SecSignIDCommonStaticAccessor.getServiceName();
        String serviceAddress = this.dataAccessor.getBaseUrl();
        boolean noAccesspass = SecSignIDCommonStaticAccessor.getNoAccessPass();
        logger.info("create a new authentication session for '" + secSignId + "' and service '" + serviceName + ".");
        JSONObject answerObject = new JSONObject();
        try {
            SecSignIDRESTCreateAuthSessionResponse result = SecSignIDServerRESTConnector.getAuthSession(secSignId, serviceName, serviceAddress, !noAccesspass);
            if (result == null) {
                this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.secsignid.frozen"), httpServletResp);
                return;
            }
            SecSignIDHttpSessionUtil.setAttribute(httpServletReq.getSession(), AUTH_SESSION_ID_KEY, String.valueOf(result.getAuthSessionId()));
            answerObject.append("success", (Object)Boolean.TRUE);
            answerObject.append("authsessionid", (Object)String.valueOf(result.getAuthSessionId()));
            answerObject.append("authsessionicondata", (Object)result.getAuthSessionIconData());
            answerObject.append("servicename", (Object)serviceName);
            answerObject.append("serviceaddress", (Object)serviceAddress);
            answerObject.append("secsignid", (Object)secSignId);
            answerObject.append("username", (Object)username);
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + e.getLocalizedMessage(), httpServletResp);
            return;
        }
    }

    private void sendJSONAnswer(boolean success, String errormsg, HttpServletResponse httpServletResp) throws IOException {
        JSONObject answerObject = new JSONObject();
        if (success) {
            try {
                answerObject.put("success", true);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
            }
            catch (JSONException e) {
                logger.error("Exception on success msg '" + errormsg + "' with reason: " + e.getMessage(), (Throwable)e);
                httpServletResp.sendError(400, e.getMessage());
            }
        } else {
            try {
                answerObject.put("success", false);
                answerObject.put("errormsg", (Object)errormsg);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
            }
            catch (JSONException e) {
                logger.error("Exception on error msg '" + errormsg + "' with reason: " + e.getMessage(), (Throwable)e);
                httpServletResp.sendError(400, e.getMessage());
            }
        }
    }

    private void sendSuccessJSONAnswer(HttpServletResponse response, Map<String, Object> parameters) throws IOException {
        try {
            JSONObject answerObject = this.createJSONObjectFromMap(parameters);
            answerObject.put("success", true);
            response.setContentType("application/json");
            response.getWriter().write(answerObject.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void handleActivateSuccessfullSecSignID(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws JSONException, IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String username = user.getName();
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        try {
            SecSignID2FAActivatedSettings activatedSettings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, user.getDirectoryId());
            activatedSettings.setTwoStepActive(true);
            this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
            if (SecSignIDCommonStaticAccessor.getInformUser()) {
                this.dataAccessor.mailActivateSecSignIDToUser(userKey, user.getDirectoryId());
            }
            this.dataAccessor.logActivateSecSignID(userKey, user.getDirectoryId(), httpServletRequest.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                this.dataAccessor.mailActivateSecSignIDToInformGroup(userKey, user.getDirectoryId());
            }
            this.sendJSONAnswer(true, null, httpServletResp);
            return;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("OperationFailedException on handleActivateSuccessfullSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("ApplicationPermissionException on handleActivateSuccessfullSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("InvalidAuthenticationException on handleActivateSuccessfullSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryPermissionException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryPermissionException on handleActivateSuccessfullSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.OperationFailedException on handleActivateSuccessfullSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("DirectoryNotFoundException on handleActivateSuccessfullSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error("runtime.UserNotFoundException on handleActivateSuccessfullSecSignID:" + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.crowd.all"), httpServletResp);
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
    }

    private boolean isAccessTokenRequiredForActivation(String secSignId, SecSignIDRESTAuthenticationMethod methodToActivate) throws SecSignIDRESTException {
        if (methodToActivate == SecSignIDRESTAuthenticationMethod.MAIL_OTP || methodToActivate == SecSignIDRESTAuthenticationMethod.UNKNOWN) {
            return false;
        }
        SecSignIDRESTAccessTokenInfoResponse accessTokenInfoResponse = SecSignIDServerRESTConnector.getAccessTokenInfo(secSignId);
        return !accessTokenInfoResponse.isAccessAllowedWithoutToken();
    }

    private SecSignIDRESTAuthenticationMethod getAuthenticationMethodFromMethodToActivate(String userKey, long directoryId) throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, DirectoryNotFoundException, UserNotFoundException {
        String selectedInactiveMethod = this.dataAccessor.getMethodToActivate(userKey, directoryId);
        return this.convertKeyToAuthenticationMethod(selectedInactiveMethod);
    }

    private SecSignIDRESTAuthenticationMethod convertKeyToAuthenticationMethod(String key) {
        if (key == null) {
            return SecSignIDRESTAuthenticationMethod.UNKNOWN;
        }
        switch (key) {
            case "id": {
                return SecSignIDRESTAuthenticationMethod.SEC_SIGN_ID;
            }
            case "totp": {
                return SecSignIDRESTAuthenticationMethod.TOTP;
            }
            case "fido": {
                return SecSignIDRESTAuthenticationMethod.FIDO;
            }
            case "mail-otp": {
                return SecSignIDRESTAuthenticationMethod.MAIL_OTP;
            }
        }
        return SecSignIDRESTAuthenticationMethod.UNKNOWN;
    }

    private SecSignIDRESTAccessTokenAuthorizationResponse requestAccessTokenAuthorization(HttpServletRequest request, String secSignId, SecSignIDRESTAuthenticationMethod authenticationMethod, SecSignIDRESTAuthenticationMethod methodToActivate) throws SecSignIDRESTException {
        SecSignIDRESTAccessTokenAuthorizationRequest.Capability capability;
        if (methodToActivate == SecSignIDRESTAuthenticationMethod.TOTP) {
            capability = SecSignIDRESTAccessTokenAuthorizationRequest.Capability.TOTP_SECRET;
        } else if (methodToActivate == SecSignIDRESTAuthenticationMethod.SEC_SIGN_ID) {
            capability = SecSignIDRESTAccessTokenAuthorizationRequest.Capability.SEC_SIGN_ID_DEVICE;
        } else if (methodToActivate == SecSignIDRESTAuthenticationMethod.FIDO) {
            capability = SecSignIDRESTAccessTokenAuthorizationRequest.Capability.FIDO_DEVICE;
        } else {
            logger.debug("No Capability was found for " + (Object)((Object)methodToActivate) + ". Using " + (Object)((Object)SecSignIDRESTAccessTokenAuthorizationRequest.Capability.SEC_SIGN_ID_DEVICE));
            capability = SecSignIDRESTAccessTokenAuthorizationRequest.Capability.SEC_SIGN_ID_DEVICE;
        }
        SecSignIDRESTAccessTokenAuthorizationResponse accessTokenAuthorizationResponse = SecSignIDServerRESTConnector.requestAccessTokenAuthorization(secSignId, authenticationMethod, capability);
        SecSignIDHttpSessionUtil.setAttribute(request.getSession(), ACCESS_TOKEN_AUTHORIZATION_ID_KEY, accessTokenAuthorizationResponse.getTokenId());
        return accessTokenAuthorizationResponse;
    }

    private String getAccessTokenAuthorizationId(HttpServletRequest request) {
        return (String)SecSignIDHttpSessionUtil.getAttribute(request.getSession(), ACCESS_TOKEN_AUTHORIZATION_ID_KEY);
    }

    private void requestAccessTokenForTwoStepAuthentication(HttpServletRequest request) {
        String tokenId = this.getAccessTokenAuthorizationId(request);
        if (tokenId == null) {
            return;
        }
        SecSignIDRESTAccessTokenRequest accessTokenRequest = new SecSignIDRESTAccessTokenRequest(tokenId);
        try {
            SecSignIDRESTAccessTokenResponse accessTokenResponse = SecSignIDServerRESTConnector.requestAccessToken(accessTokenRequest);
            SecSignIDHttpSessionUtil.setAttribute(request.getSession(), ACCESS_TOKEN_KEY, accessTokenResponse.getToken());
        }
        catch (SecSignIDRESTException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean requestAccessTokenForTOTPAuthentication(HttpServletRequest request, String totp) {
        String tokenId = this.getAccessTokenAuthorizationId(request);
        if (tokenId == null) {
            return false;
        }
        SecSignIDRESTAccessTokenTOTPRequest accessTokenRequest = new SecSignIDRESTAccessTokenTOTPRequest(tokenId, totp);
        try {
            SecSignIDRESTAccessTokenResponse accessTokenResponse = SecSignIDServerRESTConnector.requestAccessToken(accessTokenRequest);
            SecSignIDHttpSessionUtil.setAttribute(request.getSession(), ACCESS_TOKEN_KEY, accessTokenResponse.getToken());
            return true;
        }
        catch (SecSignIDRESTException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean requestAccessTokenForFIDOAuthentication(HttpServletRequest request, String credentialId, String clientDataJson, String authenticatorData, String signature, String userHandle) {
        String tokenId = this.getAccessTokenAuthorizationId(request);
        if (tokenId == null) {
            return false;
        }
        SecSignIDRESTAccessTokenFIDORequest accessTokenRequest = new SecSignIDRESTAccessTokenFIDORequest(tokenId, credentialId, clientDataJson, authenticatorData, signature, userHandle);
        try {
            SecSignIDRESTAccessTokenResponse accessTokenResponse = SecSignIDServerRESTConnector.requestAccessToken(accessTokenRequest);
            SecSignIDHttpSessionUtil.setAttribute(request.getSession(), ACCESS_TOKEN_KEY, accessTokenResponse.getToken());
            return true;
        }
        catch (SecSignIDRESTException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private String getAccessToken(HttpServletRequest request) {
        return (String)SecSignIDHttpSessionUtil.getAttribute(request.getSession(), ACCESS_TOKEN_KEY);
    }

    private SecSignIDRESTAuthenticationMethod getMethodToActivate(HttpServletRequest request) {
        SecSignIDRESTAuthenticationMethod methodToActivate = (SecSignIDRESTAuthenticationMethod)((Object)SecSignIDHttpSessionUtil.getAttribute(request.getSession(), METHOD_TO_ACTIVATE_KEY));
        if (methodToActivate == null) {
            return SecSignIDRESTAuthenticationMethod.UNKNOWN;
        }
        return methodToActivate;
    }

    private JSONObject createJSONObjectFromMap(Map<String, Object> map) throws JSONException {
        JSONObject createdObject = new JSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            createdObject.put(entry.getKey(), entry.getValue());
        }
        return createdObject;
    }
}

