/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.secsign.atlassian.common.rest.SecSignIDRESTAuthenticationMethod;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDRESTAccessTokenInfoResponse {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDRESTAccessTokenInfoResponse.class);
    public static final SecSignIDRESTAccessTokenInfoResponse NO_ACCESS_TOKEN_RESPONSE = new SecSignIDRESTAccessTokenInfoResponse(new SecSignIDRESTAuthenticationMethod[0], true);
    private final SecSignIDRESTAuthenticationMethod[] authenticationMethods;
    private final boolean accessAllowedWithoutToken;

    public static SecSignIDRESTAccessTokenInfoResponse fromJson(String json) throws JSONException, SecSignIDRESTException {
        JSONObject rootObject = new JSONObject(json);
        JSONArray authenticationMethods = rootObject.optJSONArray("authmethods");
        if (authenticationMethods == null) {
            logger.debug("Key 'authmethods' not found");
            throw new SecSignIDRESTException("Key 'authmethods' not found");
        }
        ArrayList<SecSignIDRESTAuthenticationMethod> authenticationMethodList = new ArrayList<SecSignIDRESTAuthenticationMethod>();
        for (int i = 0; i < authenticationMethods.length(); ++i) {
            String authenticationMethod = authenticationMethods.getString(i);
            SecSignIDRESTAuthenticationMethod method = SecSignIDRESTAuthenticationMethod.fromName(authenticationMethod);
            if (method == SecSignIDRESTAuthenticationMethod.UNKNOWN) {
                String message = "Authentication method with name '" + authenticationMethod + "' is unknown!";
                logger.debug(message);
                throw new SecSignIDRESTException(message);
            }
            authenticationMethodList.add(method);
        }
        if (!rootObject.has("accessAllowedWithoutToken")) {
            logger.debug("Key 'accessAllowedWithoutToken' not found");
            throw new SecSignIDRESTException("Key 'accessAllowedWithoutToken' not found");
        }
        boolean accessAllowedWithoutToken = rootObject.getBoolean("accessAllowedWithoutToken");
        return new SecSignIDRESTAccessTokenInfoResponse(authenticationMethodList.toArray(new SecSignIDRESTAuthenticationMethod[0]), accessAllowedWithoutToken);
    }

    private SecSignIDRESTAccessTokenInfoResponse(SecSignIDRESTAuthenticationMethod[] authenticationMethods, boolean accessAllowedWithoutToken) {
        this.authenticationMethods = authenticationMethods;
        this.accessAllowedWithoutToken = accessAllowedWithoutToken;
    }

    public SecSignIDRESTAuthenticationMethod[] getAuthenticationMethods() {
        return this.authenticationMethods;
    }

    public boolean isAccessAllowedWithoutToken() {
        return this.accessAllowedWithoutToken;
    }
}

