/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.interfaces;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.service.client.CrowdClient;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.accessor.SecSignIDMappingExtractor;
import com.secsign.atlassian.common.ao.SecSignIDUsersActiveObject;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.data.SecSignIDTrustDeviceToken;
import com.secsign.atlassian.common.rest.SecSignIDRESTDevicesResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import com.secsign.atlassian.common.rest.SecSignIDServerRESTConnector;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecSignIDDataAccessor {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDDataAccessor.class);
    private List<String> usersCreated = new ArrayList<String>();

    public final Object[] checkDuplicatesWithUserKey(String idToAdd, long dirid, String userKey) throws com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        Object[] duplicateTest = null;
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            duplicateTest = SecSignIDMappingExtractor.checkDuplicates(idToAdd, dirid, userKey);
            return duplicateTest;
        }
        duplicateTest = SecSignIDUsersActiveObject.checkDuplicates(idToAdd, userKey, dirid);
        return duplicateTest;
    }

    public final Object[] checkDuplicates(String idToAdd) throws com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        Object[] duplicateTest = null;
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            duplicateTest = SecSignIDMappingExtractor.checkDuplicates(idToAdd);
            return duplicateTest;
        }
        duplicateTest = SecSignIDUsersActiveObject.checkDuplicates(idToAdd);
        return duplicateTest;
    }

    public final void save2FAGroupMappings(HashMap<String, SecSignID2FASettings> groupMappings) throws com.atlassian.crowd.exception.OperationFailedException, GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, ApplicationPermissionException, InvalidAuthenticationException {
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            SecSignIDMappingExtractor.save2FAGroupMappings(groupMappings);
        } else {
            SecSignIDUsersActiveObject.save2FAGroupMappings(groupMappings);
        }
    }

    public abstract Set<String> getAllUserGroupsMappingKeys() throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException;

    public abstract List<Directory> getAllDirectories();

    public abstract Collection<String> findGroupMembersUsernames(long var1, String var3) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException;

    public abstract Collection<String> findAllUsernames(long var1) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException;

    public abstract String getEmailForUserKey(String var1, long var2) throws UserNotFoundException, ApplicationNotFoundException, com.atlassian.crowd.exception.OperationFailedException, DirectoryNotFoundException;

    public final String getSecSignIdStringForApplicationUserKey(String key, long dirid) throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, UserNotFoundException, DirectoryNotFoundException {
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            return SecSignIDMappingExtractor.getSecSignIdStringForApplicationUserKey(key, dirid);
        }
        return SecSignIDUsersActiveObject.getSecSignIdStringForApplicationUserKey(key, dirid);
    }

    public final void checkDataIntegrity() {
        if (!this.getApplication().equals("Crowd")) {
            SecSignIDUsersActiveObject.checkDataIntegrityInvoked();
        }
    }

    public abstract void deleteAllOptionsAndMappings() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract String getAllOptionsAsString();

    public final String getMappingKeyForSecSignID(String secSignId) throws com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        String mappingKey = "";
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            mappingKey = SecSignIDMappingExtractor.getMappingKeyForSecSignId(secSignId);
            return mappingKey;
        }
        mappingKey = SecSignIDUsersActiveObject.getMappingKeyForSecSignId(secSignId);
        return mappingKey;
    }

    public final void saveSecSignIDForUserKey(String userKey, long dirID, String secSignId) throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, DirectoryPermissionException, OperationFailedException, OperationNotPermittedException, NamingException, UserNotFoundException, DirectoryNotFoundException {
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            SecSignIDMappingExtractor.saveSecSignIDForUserKey(userKey, dirID, secSignId);
            SecSignIDMappingExtractor.save2FAActivatedSettingsForUserKey(userKey, dirID, new SecSignID2FAActivatedSettings());
        } else {
            SecSignIDUsersActiveObject.saveSecSignIDForUserKey(userKey, dirID, secSignId);
            SecSignIDUsersActiveObject.save2FAActivatedSettingsForUserKey(userKey, dirID, new SecSignID2FAActivatedSettings());
        }
    }

    public abstract User getUserForKeyFirst(String var1) throws com.atlassian.crowd.exception.OperationFailedException;

    public abstract User getUserForKey(String var1, long var2) throws com.atlassian.crowd.exception.OperationFailedException, UserNotFoundException, DirectoryNotFoundException;

    public abstract String getUserKeyForUsername(String var1);

    public abstract String getUsernameForUserKey(String var1);

    public abstract User getUserCurrentlyLoggedIn();

    public abstract String getApplication();

    public abstract List<String> getGroups(int var1, long var2) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException;

    public abstract int getPagesGroup(long var1) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException;

    public abstract String getVersion();

    public final TreeMap<String, String> getIPMappings() {
        if (!this.getApplication().equals("Crowd")) {
            return SecSignIDUsersActiveObject.getIPMappings();
        }
        return null;
    }

    public abstract String getUserProfileLink(User var1, String var2);

    public abstract List<User> getUsersByGroup(long var1, String var3, int var4) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException;

    public final Map<String, String[]> getSecSignIDMappingForUsers(List<User> _users) throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException {
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            return SecSignIDMappingExtractor.getSecSignIDMappingsForUsers(_users);
        }
        return SecSignIDUsersActiveObject.getSecSignIdUserMappings(_users);
    }

    public abstract List<User> getUsersBySearchKey(String var1) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException;

    public abstract long getPagesForGroup(long var1, String var3) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException;

    public abstract boolean isChangeable(User var1);

    public abstract void updateAllMappings(boolean var1, boolean var2) throws DirectoryPermissionException, com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, OperationNotPermittedException, GroupNotFoundException, DirectoryNotFoundException, UserNotFoundException;

    public abstract String getBaseUrl();

    public abstract Boolean canWrite();

    public abstract List<String> getGroupMappingKeysForUserKey(String var1, long var2) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException;

    public abstract HashMap<String, Object> getAuthenticatorContextMap(HttpServletRequest var1);

    public boolean isJira7OrJira8() {
        return false;
    }

    public final boolean getAllDeactivated() {
        return false;
    }

    public final List<String> getUsersCreated() {
        return this.usersCreated;
    }

    public final void addUserCreated(String userKey) {
        this.usersCreated.add(userKey);
    }

    public final void deleteUserCreated(String userKey) {
        this.usersCreated.remove(userKey);
    }

    public boolean isJiraPublicMode() {
        return false;
    }

    public abstract String loginWithUsernameAndPassword(HttpServletRequest var1, HttpServletResponse var2, ServletContext var3);

    public abstract String checkLoginWithUsernameAndPassword(HttpServletRequest var1, HttpServletResponse var2, ServletContext var3);

    public abstract boolean checkForElevatedSecurityCheck(HttpServletRequest var1, HttpServletResponse var2);

    public abstract String getLoginReason(HttpServletRequest var1, HttpServletResponse var2, ServletContext var3);

    public final void saveIPForUserKey(String userKey, long dirID, String ipAddress) throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, DirectoryPermissionException, OperationFailedException, OperationNotPermittedException, NamingException {
        if (!this.getApplication().equals("Crowd")) {
            SecSignIDUsersActiveObject.addIPToMapping(userKey, dirID, ipAddress);
        }
    }

    public abstract void loginUserWithoutPassword(HttpServletRequest var1, HttpServletResponse var2, User var3) throws Exception;

    public abstract void sendRedirect(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract void sendRedirectForNotAuthed(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract boolean isUserAdmin(User var1);

    public abstract void deleteAllSettingsForNewAuthentication();

    public final String getMethodToActivate(String userKey, long dirId) throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, UserNotFoundException, DirectoryNotFoundException {
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            return SecSignIDMappingExtractor.getMethodToActivate(userKey, dirId);
        }
        return SecSignIDUsersActiveObject.getMethodToActivate(userKey, dirId);
    }

    public final void saveMethodToActivate(String userKey, long dirId, String method) throws com.atlassian.crowd.exception.OperationFailedException, DirectoryPermissionException, ApplicationPermissionException, InvalidAuthenticationException, UserNotFoundException, DirectoryNotFoundException {
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            SecSignIDMappingExtractor.saveMethodToActivate(userKey, dirId, method);
        } else {
            SecSignIDUsersActiveObject.saveMethodToActivate(userKey, dirId, method);
        }
    }

    public final String getLastMethodUsed(String userKey, long dirId) throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, UserNotFoundException, DirectoryNotFoundException {
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            return SecSignIDMappingExtractor.getLastMethodUsed(userKey, dirId);
        }
        return SecSignIDUsersActiveObject.getLastMethodUsed(userKey, dirId);
    }

    public final void saveLastMethodUsed(String userKey, long dirId, String method) throws com.atlassian.crowd.exception.OperationFailedException, DirectoryPermissionException, ApplicationPermissionException, InvalidAuthenticationException, UserNotFoundException, DirectoryNotFoundException {
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            SecSignIDMappingExtractor.saveLastMethodUsed(userKey, dirId, method);
        } else {
            SecSignIDUsersActiveObject.saveLastMethodUsed(userKey, dirId, method);
        }
    }

    public final SecSignIDTrustDeviceToken createTrustDeviceToken(String userKey, long dirId, String userAgent) throws UserNotFoundException, com.atlassian.crowd.exception.OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryPermissionException {
        if (this.getApplication().equals("Crowd")) {
            return SecSignIDMappingExtractor.createTrustDeviceToken(userKey, dirId, userAgent);
        }
        return SecSignIDUsersActiveObject.createTrustDeviceToken(userKey, dirId, userAgent);
    }

    public final void removeTrustDeviceToken(String userKey, long dirId, SecSignIDTrustDeviceToken token) throws UserNotFoundException, com.atlassian.crowd.exception.OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryPermissionException {
        if (this.getApplication().equals("Crowd")) {
            SecSignIDMappingExtractor.removeTrustDeviceToken(userKey, dirId, token);
            return;
        }
        SecSignIDUsersActiveObject.removeTrustDeviceToken(userKey, dirId, token);
    }

    public final void removeAllTrustDeviceTokens(String userKey, long dirId) throws UserNotFoundException, com.atlassian.crowd.exception.OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, DirectoryPermissionException, ApplicationPermissionException {
        if (this.getApplication().equals("Crowd")) {
            SecSignIDMappingExtractor.removeAllTrustDeviceTokens(userKey, dirId);
            return;
        }
        SecSignIDUsersActiveObject.removeAllTrustDeviceTokens(userKey, dirId);
    }

    public final SecSignIDTrustDeviceToken getTrustDeviceToken(String userKey, long dirId, String token, String userAgent) throws UserNotFoundException, com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException, DirectoryPermissionException {
        if (this.getApplication().equals("Crowd")) {
            return SecSignIDMappingExtractor.getTrustDeviceToken(userKey, dirId, token, userAgent);
        }
        return SecSignIDUsersActiveObject.getTrustDeviceToken(userKey, dirId, token, userAgent);
    }

    public final List<SecSignIDTrustDeviceToken> getAllTrustDeviceTokens(String userKey, long dirId) throws UserNotFoundException, com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException, PermissionException {
        if (this.getApplication().equals("Crowd")) {
            return SecSignIDMappingExtractor.getAllTrustDeviceTokens(userKey, dirId);
        }
        return SecSignIDUsersActiveObject.getAllTrustDeviceTokens(userKey, dirId);
    }

    public abstract void createGroupsWithSettings() throws InvalidGroupException, DirectoryPermissionException, DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException, GroupNotFoundException, ApplicationPermissionException, InvalidAuthenticationException;

    public abstract void addUserToPasswordless(String var1, long var2) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException, ReadOnlyGroupException;

    public abstract void addUserToTwoStep(String var1, long var2) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException, ReadOnlyGroupException;

    public abstract void addUserToMailOTP(String var1, long var2) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException, ReadOnlyGroupException;

    public abstract void addUserToTOTP(String var1, long var2) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException, ReadOnlyGroupException;

    public abstract void addUserToFIDO(String var1, long var2) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException, ReadOnlyGroupException;

    public final boolean checkLoggedinAdminIsIn2FAGroup() throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, DirectoryNotFoundException {
        User user = this.getUserCurrentlyLoggedIn();
        return this.get2FASettingsFromUserKey(this.getUserKeyForUsername(user.getName()), user.getDirectoryId()).getPwdAllowed().equals(SecSignIDCommonConstants.AuthIsNotAllowed);
    }

    public final boolean checkLoggedinAdminIsInSecSignGroup() throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, DirectoryNotFoundException {
        User user = this.getUserCurrentlyLoggedIn();
        SecSignID2FASettings settings = this.get2FASettingsFromUserKey(this.getUserKeyForUsername(user.getName()), user.getDirectoryId());
        boolean passwordlessAllowed = settings.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean twoStepAllowed = settings.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
        return passwordlessAllowed || twoStepAllowed;
    }

    public abstract List<String> findGroupsForTerm(String var1) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException;

    public abstract int findPageForGroup(String var1, long var2) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException;

    public abstract String getGroupLink(String var1, long var2);

    public abstract String getGroupLinkToAdd(String var1, long var2);

    public void prepareContextForCaptcha(HttpServletRequest request, HashMap<String, Object> context) {
    }

    public abstract void logChangeSecSignIDToAuditLog(String var1, long var2, String var4, String var5);

    public abstract void logAutomaticUserChangeToAuditLog(String var1, long var2, String var4, String var5);

    public abstract void logGroup2FAChangeToAuditLog(String var1, long var2, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, String var10);

    public abstract void logChangeSettingToAuditLog(String var1, String var2, String var3, String var4);

    public abstract void logActivateTOTP(String var1, long var2, String var4);

    public abstract void logActivateFIDO(String var1, long var2, String var4);

    public abstract void logActivateMailOTP(String var1, long var2, String var4);

    public abstract void logActivateSecSignID(String var1, long var2, String var4);

    public abstract void mailChangeSecSignIDToUser(String var1, long var2, String var4, long var5, String var7) throws com.atlassian.crowd.exception.OperationFailedException;

    public abstract void mailActivateTOTPToUser(String var1, long var2) throws com.atlassian.crowd.exception.OperationFailedException;

    public abstract void mailActivateFIDOToUser(String var1, long var2) throws com.atlassian.crowd.exception.OperationFailedException;

    public abstract void mailActivateMailOTPToUser(String var1, long var2) throws com.atlassian.crowd.exception.OperationFailedException;

    public abstract void mailActivateSecSignIDToUser(String var1, long var2) throws com.atlassian.crowd.exception.OperationFailedException;

    public abstract void mailActivateTOTPToInformGroup(String var1, long var2) throws com.atlassian.crowd.exception.OperationFailedException;

    public abstract void mailActivateFIDOToInformGroup(String var1, long var2) throws com.atlassian.crowd.exception.OperationFailedException;

    public abstract void mailActivateMailOTPToInformGroup(String var1, long var2) throws com.atlassian.crowd.exception.OperationFailedException;

    public abstract void mailActivateSecSignIDToInformGroup(String var1, long var2) throws com.atlassian.crowd.exception.OperationFailedException;

    public abstract void mailChangeSecSignIDToInformGroup(String var1, long var2, String var4, long var5, String var7) throws com.atlassian.crowd.exception.OperationFailedException;

    public abstract void mailChangeSettingToInformGroup(String var1, String var2, String var3, String var4, long var5);

    public abstract void mail2FAChangeOfGroupToInformGroup(String var1, long var2, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, String var10, long var11);

    public abstract void mail2FAChangeToGroupMembers(String var1, long var2);

    public abstract void removeUserAttributes(long var1, String var3, String var4) throws UserNotFoundException, com.atlassian.crowd.exception.runtime.UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract List<User> searchUsers(long var1, EntityQuery<User> var3) throws com.atlassian.crowd.exception.OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract List<User> searchUsers(EntityQuery<User> var1) throws com.atlassian.crowd.exception.OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract List<String> searchUserStrings(long var1, EntityQuery<String> var3) throws com.atlassian.crowd.exception.OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract Directory getDirectory(long var1) throws com.atlassian.crowd.exception.OperationFailedException, DirectoryNotFoundException;

    public abstract void storeUserAttributes(long var1, String var3, HashMap<String, Set<String>> var4) throws DirectoryPermissionException, com.atlassian.crowd.exception.OperationFailedException, UserNotFoundException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract List<String> searchGroups(long var1, EntityQuery<String> var3) throws com.atlassian.crowd.exception.OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract GroupWithAttributes findGroupWithAttributesByName(long var1, String var3) throws GroupNotFoundException, DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract void storeGroupAttributes(long var1, String var3, HashMap<String, Set<String>> var4) throws DirectoryPermissionException, com.atlassian.crowd.exception.OperationFailedException, GroupNotFoundException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract void removeGroupAttributes(long var1, String var3, String var4) throws DirectoryPermissionException, com.atlassian.crowd.exception.OperationFailedException, GroupNotFoundException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException;

    public final String getChangeMailForSecSignIDToUser(User userChanged, User changedBy, String secSignID) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.by", new Serializable[]{SecSignIDCommonStaticAccessor.getServiceName(), changedBy.getDisplayName(), changedBy.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.secsignid", new Serializable[]{secSignID}));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getChangeMailForSecSignIDToUser(User userChanged) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed", new Serializable[]{SecSignIDCommonStaticAccessor.getServiceName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.secsignid.activated"));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getChangeMailForTOTPToGroup(User userChanged, User toInform) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{toInform.getDisplayName(), toInform.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.group", new Serializable[]{SecSignIDCommonStaticAccessor.getServiceName(), userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.totp.activated"));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getChangeMailForFIDOToGroup(User userChanged, User toInform) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{toInform.getDisplayName(), toInform.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.group", new Serializable[]{SecSignIDCommonStaticAccessor.getServiceName(), userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.fido.activated"));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getChangeMailForMailOTPToUser(User userChanged) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed", new Serializable[]{SecSignIDCommonStaticAccessor.getServiceName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.mailotp.activated"));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getChangeMailForTOTPToUser(User userChanged) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed", new Serializable[]{SecSignIDCommonStaticAccessor.getServiceName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.totp.activated"));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getChangeMailForSecSignIDToGroup(User userChanged, User toInform) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.group", new Serializable[]{SecSignIDCommonStaticAccessor.getServiceName(), userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.secsignid.activated"));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getChangeMailForFIDOToUser(User userChanged) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed", new Serializable[]{SecSignIDCommonStaticAccessor.getServiceName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.fido.activated"));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getChangeMailForMailOTPToGroup(User userChanged, User toInform) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.group", new Serializable[]{SecSignIDCommonStaticAccessor.getServiceName(), userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.mailotp.activated"));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getChange2FAMailForUser(User userChanged, boolean newValuePwdAllowed, boolean newValuePasswordless, boolean newValueTwoStep, boolean newValueMailOTP, boolean newValueTOTP, boolean newValueFIDO) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed", new Serializable[]{SecSignIDCommonStaticAccessor.getServiceName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.2fa.changed"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.2fa.changed.to", new Serializable[]{this.getAllowedStringForBoolean(newValuePwdAllowed), this.getAllowedStringForBoolean(newValuePasswordless), this.getAllowedStringForBoolean(newValueTwoStep), this.getAllowedStringForBoolean(newValueMailOTP), this.getAllowedStringForBoolean(newValueTOTP), this.getAllowedStringForBoolean(newValueFIDO)}));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getChange2FAMailForGroupToInform(User userChanged, User changedBy, String groupname, boolean newValuePwdAllowed, boolean newValuePasswordless, boolean newValueTwoStep, boolean newValueMailOTP, boolean newValueTOTP, boolean newValueFIDO) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{userChanged.getDisplayName(), userChanged.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.user.changed.2fa", new Serializable[]{changedBy.getDisplayName(), changedBy.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.group.changed", new Serializable[]{groupname}));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.group.changed.to", new Serializable[]{this.getAllowedStringForBoolean(newValuePwdAllowed), this.getAllowedStringForBoolean(newValuePasswordless), this.getAllowedStringForBoolean(newValueTwoStep), this.getAllowedStringForBoolean(newValueMailOTP), this.getAllowedStringForBoolean(newValueTOTP), this.getAllowedStringForBoolean(newValueFIDO)}));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getChangeMailForUserToInform(User userChanged, User changedBy, User toInform, String secSignID) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{toInform.getDisplayName(), toInform.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.admin.changed", new Serializable[]{SecSignIDCommonStaticAccessor.getServiceName(), userChanged.getDisplayName(), userChanged.getName(), changedBy.getDisplayName(), changedBy.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.secsignid", new Serializable[]{secSignID}));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getChangeMailForChangeSettingsToGroup(User changedBy, User toInform, String settingName, String newValue, String oldValue) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.hello", new Serializable[]{toInform.getDisplayName(), toInform.getName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.settings.changed", new Serializable[]{changedBy.getDisplayName(), changedBy.getName(), SecSignIDCommonStaticAccessor.getServiceName()}));
        stringBuilder.append("\n");
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changes.made"));
        stringBuilder.append(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.settings.changed.to", new Serializable[]{settingName, oldValue, newValue}));
        if (this.getApplication().equals("Confluence")) {
            return stringBuilder.toString().replaceAll("\n", "<br>");
        }
        return stringBuilder.toString();
    }

    public final String getAllowedStringForBoolean(boolean value) {
        if (value) {
            return "allowed";
        }
        return "not allowed";
    }

    public boolean isNewCrowd() {
        return false;
    }

    public final SecSignID2FASettings get2FASettingsFromUserKey(String userKey, long directoryID) throws com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        SecSignID2FASettings resultSettings = new SecSignID2FASettings("100000");
        List<String> groupNames = this.getGroupMappingKeysForUserKey(userKey, directoryID);
        for (String string : groupNames) {
            String groupName = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
            SecSignID2FASettings settings = this.get2FASettingsForGroup(groupName, dirid);
            resultSettings = resultSettings.changeForGroupMapping(settings);
        }
        return resultSettings;
    }

    public final SecSignID2FAActivatedSettings get2FAActivatedSettingsFromUserKey(String userKey, long directoryID) throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, SecSignIDRESTException, UserNotFoundException, DirectoryNotFoundException {
        SecSignID2FAActivatedSettings result = SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd") ? SecSignIDMappingExtractor.get2FAActivatedSettingsFromUserKey(userKey, directoryID) : SecSignIDUsersActiveObject.get2FAActivatedSettingsFromUserKey(userKey, directoryID);
        String secSignIdsString = this.getSecSignIdStringForApplicationUserKey(userKey, directoryID);
        String[] secSignIds = SecSignIDMappingUtils.getArrayOfSecSignIds(secSignIdsString);
        if (secSignIds == null || secSignIds.length == 0) {
            return result;
        }
        try {
            SecSignIDRESTDevicesResponse devicesResponse;
            if (SecSignIDServerRESTConnector.checkSecSignID(secSignIds[0]) && (devicesResponse = SecSignIDServerRESTConnector.getDevicesOfSecSignID(secSignIds[0])).getDeviceCount() != 0) {
                result.setTwoStepActive(true);
            }
        }
        catch (SecSignIDRESTException secSignIDRESTException) {
            // empty catch block
        }
        return result;
    }

    public final HashMap<String, SecSignID2FASettings> get2FASettingsForGroups(List<String> groupMappingsKeys) throws com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, SecSignID2FASettings> result = new HashMap<String, SecSignID2FASettings>();
        for (String string : groupMappingsKeys) {
            String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
            if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
                result.putAll(SecSignIDMappingExtractor.get2FAGroupMappingsForGroup(groupname, dirid));
                continue;
            }
            result.putAll(SecSignIDUsersActiveObject.get2FAGroupMappingsForGroup(groupname, dirid));
        }
        return result;
    }

    public final SecSignID2FASettings get2FASettingsForGroup(String groupName, long dirid) throws com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        ArrayList<String> groupAsList = new ArrayList<String>();
        groupAsList.add(groupName + ";" + dirid);
        HashMap<String, SecSignID2FASettings> result = this.get2FASettingsForGroups(groupAsList);
        return result.get(groupName.toLowerCase().replace(" ", "___") + ";" + dirid);
    }

    public final HashMap<String, SecSignID2FASettings> get2FASettingsForUsers(List<User> users) throws com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        HashMap<String, SecSignID2FASettings> result = new HashMap<String, SecSignID2FASettings>();
        for (User user : users) {
            result.put(this.getUserKeyForUsername(user.getName()) + ":" + user.getDirectoryId(), this.get2FASettingsFromUserKey(this.getUserKeyForUsername(user.getName()), user.getDirectoryId()));
        }
        return result;
    }

    public final void save2FAActivatedSettingsForUserKey(String userKey, long directoryID, SecSignID2FAActivatedSettings settings) throws DirectoryPermissionException, com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, UserNotFoundException, DirectoryNotFoundException {
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            SecSignIDMappingExtractor.save2FAActivatedSettingsForUserKey(userKey, directoryID, settings);
        } else {
            SecSignIDUsersActiveObject.save2FAActivatedSettingsForUserKey(userKey, directoryID, settings);
        }
    }

    public abstract void changeToOneAttribute() throws com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryPermissionException;

    public abstract DirectoryManager getDirectoryManager();

    public abstract void resetAllFIDO() throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract CrowdClient getCrowdClientForDir(Directory var1);

    public abstract String getUPMLink();

    public abstract boolean checkGroupExists(String var1, long var2) throws com.atlassian.crowd.exception.OperationFailedException;

    public final void addGroupMembersToGroup(String groupName, String groupToAdd) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException, UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, ReadOnlyGroupException {
        Set<String> usernamesToAdd = this.getUsernamesForGroupname(groupToAdd);
        for (String username : usernamesToAdd) {
            this.addUserToGroup(username, groupName);
        }
    }

    public abstract void addUserToGroup(String var1, String var2) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException, ReadOnlyGroupException;

    protected abstract Set<String> getUsernamesForGroupname(String var1) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException;

    public final HashMap<String, SecSignID2FASettings> getGroupMappingsWithOptions() throws com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        if (SecSignIDCommonStaticAccessor.isSynchronizable() || this.getApplication().equals("Crowd")) {
            return SecSignIDMappingExtractor.getGroupMappingsWithOptions();
        }
        return SecSignIDUsersActiveObject.getGroupMappingsWithOptions();
    }

    public void deleteLocalMappings() throws DirectoryPermissionException, com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        if (!SecSignIDCommonStaticAccessor.isSynchronizableWrite()) {
            SecSignIDMappingExtractor.deleteLocalMappings();
        }
    }

    public abstract String getUserNameForProfile(Map<String, Object> var1);

    public abstract void changeToDirID();

    public abstract void checkGroupsCreated();

    public HttpServletRequest getRequestFromContext(Map<String, Object> context) {
        return (HttpServletRequest)context.get("req");
    }

    public void activateCrowdAccess() throws ApplicationNotFoundException, ApplicationManagerException {
    }

    public abstract boolean logoutUser(HttpServletRequest var1, HttpServletResponse var2);

    public void showExpiredForCrowd(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, String usernameFromRequest) {
    }
}

