/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.data;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDTrustDeviceToken {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDTrustDeviceToken.class);
    private final String token;
    private final String userAgent;
    private final long creation;

    public static SecSignIDTrustDeviceToken createFromSerializableString(String serializableString) {
        long creation;
        String[] stringComponents = serializableString.split("\\|");
        if (stringComponents.length != 3) {
            return null;
        }
        try {
            creation = Long.parseLong(stringComponents[2]);
        }
        catch (NumberFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        String token = stringComponents[0];
        String userAgent = stringComponents[1];
        return new SecSignIDTrustDeviceToken(token, userAgent, creation);
    }

    public SecSignIDTrustDeviceToken(String token, String userAgent, long creation) {
        this.token = token;
        this.creation = creation;
        this.userAgent = userAgent.replace('|', '_');
    }

    public String getToken() {
        return this.token;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public long getCreation() {
        return this.creation;
    }

    public String getSerializableString() {
        return this.getToken() + "|" + this.getUserAgent() + "|" + this.getCreation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecSignIDTrustDeviceToken that = (SecSignIDTrustDeviceToken)o;
        if (this.creation != that.creation) {
            return false;
        }
        if (this.token != null ? !this.token.equals(that.token) : that.token != null) {
            return false;
        }
        return this.userAgent != null ? this.userAgent.equals(that.userAgent) : that.userAgent == null;
    }

    public int hashCode() {
        int result = this.token != null ? this.token.hashCode() : 0;
        result = 31 * result + (this.userAgent != null ? this.userAgent.hashCode() : 0);
        result = 31 * result + (int)(this.creation ^ this.creation >>> 32);
        return result;
    }
}

