/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.contextprovider;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.data.SecSignIDTrustDeviceToken;
import com.secsign.atlassian.common.rest.SecSignIDRESTAuthenticationMethod;
import com.secsign.atlassian.common.util.SecSignIDAuthenticationUtil;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import com.secsign.atlassian.common.util.SecSignIDTemplateHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDUserInfoProvider
implements ContextProvider {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDUserInfoProvider.class);

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        HttpServletRequest request = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getRequestFromContext(context);
        User shownApplicationUser = null;
        User loggedInUser = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserCurrentlyLoggedIn();
        boolean isAdmin = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().isUserAdmin(loggedInUser);
        logger.debug("context map of user provider: " + SecSignIDMappingUtils.toString(context));
        String profileUserName = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserNameForProfile(context);
        String userKey = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(profileUserName);
        if (context.get("dirid") != null) {
            long dirid = Long.parseLong((String)context.get("dirid"));
            try {
                shownApplicationUser = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirid);
            }
            catch (OperationFailedException e) {
                logger.error("OperationFailedException on getContextMap in InfoProvider");
            }
            catch (UserNotFoundException e) {
                logger.error("UserNotFoundException on getContextMap in InfoProvider");
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on getContextMap in InfoProvider");
            }
        } else {
            try {
                shownApplicationUser = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKeyFirst(userKey);
            }
            catch (OperationFailedException e) {
                logger.error("OperationFailedException on getContextMap in InfoProvider");
            }
        }
        logger.debug("profile user name is " + profileUserName);
        if (shownApplicationUser != null) {
            boolean mailOtpAuthentication;
            boolean fidoAuthentication;
            boolean totpAuthentication;
            boolean twoStepAuthentication;
            boolean firstMethod;
            boolean canActivateNewMethod;
            boolean canActivateFIDO;
            boolean canActivateTOTP;
            boolean canActivateMailOTP;
            boolean canActivateTwoStep;
            boolean fidoActivated;
            boolean totpActivated;
            boolean mailotpActivated;
            boolean twostepActivated;
            boolean fidoAllowed;
            boolean totpAllowed;
            boolean mailotpAllowed;
            boolean twoStepAllowed;
            boolean passwordlessAllowed;
            boolean pwdAllowed;
            logger.debug("got application user '" + String.valueOf(shownApplicationUser) + "' and profile user name '" + profileUserName + "'");
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            boolean fidoSupported = SecSignIDCommonStaticAccessor.isFIDOSupported();
            boolean noAccesspass = SecSignIDCommonStaticAccessor.getNoAccessPass();
            SecSignID2FASettings settings = null;
            SecSignID2FAActivatedSettings activatedSettings = null;
            String secSignId = "";
            try {
                settings = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().get2FASettingsFromUserKey(userKey, shownApplicationUser.getDirectoryId());
                activatedSettings = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().get2FAActivatedSettingsFromUserKey(userKey, shownApplicationUser.getDirectoryId());
                pwdAllowed = settings.getPwdAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                passwordlessAllowed = settings.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                twoStepAllowed = settings.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                mailotpAllowed = settings.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                totpAllowed = settings.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                boolean bl = fidoAllowed = settings.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) && fidoSupported;
                if (!twoStepAllowed) {
                    activatedSettings.setTwoStepActive(false);
                }
                twostepActivated = activatedSettings.isTwoStepActive();
                mailotpActivated = activatedSettings.isMailOtpActive();
                totpActivated = activatedSettings.isTotpActive();
                fidoActivated = activatedSettings.isFidoActive() && fidoSupported;
                canActivateTwoStep = (passwordlessAllowed || twoStepAllowed) && !twostepActivated;
                canActivateMailOTP = mailotpAllowed && !mailotpActivated;
                canActivateTOTP = totpAllowed && !totpActivated;
                canActivateFIDO = fidoAllowed && fidoSupported;
                canActivateNewMethod = false;
                boolean bl2 = firstMethod = !twostepActivated && !mailotpActivated && !totpActivated && !fidoActivated;
                if (canActivateTwoStep || canActivateMailOTP || canActivateTOTP || canActivateFIDO) {
                    canActivateNewMethod = true;
                }
                secSignId = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getSecSignIdStringForApplicationUserKey(userKey, shownApplicationUser.getDirectoryId());
                List<SecSignIDRESTAuthenticationMethod> authenticationMethods = SecSignIDAuthenticationUtil.getAvailableMethodsForActivation(request, shownApplicationUser, userKey, secSignId);
                twoStepAuthentication = authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.SEC_SIGN_ID);
                totpAuthentication = authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.TOTP);
                fidoAuthentication = authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.FIDO) && fidoSupported;
                mailOtpAuthentication = authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.MAIL_OTP);
            }
            catch (Exception e) {
                pwdAllowed = true;
                passwordlessAllowed = false;
                twoStepAllowed = false;
                mailotpAllowed = false;
                totpAllowed = false;
                fidoAllowed = false;
                twostepActivated = false;
                mailotpActivated = false;
                totpActivated = false;
                fidoActivated = false;
                canActivateNewMethod = false;
                canActivateTwoStep = false;
                canActivateMailOTP = false;
                canActivateTOTP = false;
                canActivateFIDO = false;
                firstMethod = true;
                twoStepAuthentication = false;
                totpAuthentication = false;
                fidoAuthentication = false;
                mailOtpAuthentication = false;
            }
            contextMap.put("userName", shownApplicationUser.getName());
            contextMap.put("userKey", userKey);
            boolean ownProfile = shownApplicationUser.equals((Object)loggedInUser);
            if (ownProfile && request != null) {
                List<Object> tokens = new ArrayList();
                try {
                    tokens = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getAllTrustDeviceTokens(userKey, shownApplicationUser.getDirectoryId());
                }
                catch (UserNotFoundException e) {
                    logger.error("UserNotFoundException on getAllTrustDeviceTokens for UserInfoProvider");
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                }
                catch (OperationFailedException e) {
                    logger.error("OperationFailedException on getAllTrustDeviceTokens for UserInfoProvider");
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                }
                catch (InvalidAuthenticationException e) {
                    logger.error("InvalidAuthenticationException on getAllTrustDeviceTokens for UserInfoProvider");
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                }
                catch (ApplicationPermissionException e) {
                    logger.error("ApplicationPermissionException on getAllTrustDeviceTokens for UserInfoProvider");
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                }
                catch (DirectoryNotFoundException e) {
                    logger.error("DirectoryNotFoundException on getAllTrustDeviceTokens for UserInfoProvider");
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                }
                catch (PermissionException e) {
                    logger.error("PermissionException on getAllTrustDeviceTokens for UserInfoProvider");
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                }
                boolean currentDeviceTrusted = tokens.contains(this.getTrustDeviceTokenFromRequest(userKey, shownApplicationUser.getDirectoryId(), request));
                contextMap.put("deviceTrusted", currentDeviceTrusted);
                contextMap.put("multipleDevicesTrusted", currentDeviceTrusted && tokens.size() > 1 || !currentDeviceTrusted && tokens.size() > 0);
            }
            HashMap<String, SecSignID2FASettings> mappings = null;
            try {
                List<String> groupNames = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getGroupMappingKeysForUserKey(userKey, shownApplicationUser.getDirectoryId());
                mappings = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().get2FASettingsForGroups(groupNames);
            }
            catch (OperationFailedException e) {
                logger.error("OperationFailedException on ViewUserfilter");
            }
            catch (InvalidAuthenticationException e) {
                logger.error("InvalidAuthenticationException on ViewUserfilter");
            }
            catch (ApplicationPermissionException e) {
                logger.error("ApplicationPermissionException on ViewUserfilter");
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on ViewUserfilter");
            }
            contextMap.put("groupMappingsOfUser", mappings);
            contextMap.put("contextPath", request.getContextPath());
            contextMap.put("templateHelper", new SecSignIDTemplateHelper());
            contextMap.put("user2FASettings", settings);
            contextMap.put("activatedSettings", activatedSettings);
            contextMap.put("directoryID", shownApplicationUser.getDirectoryId());
            contextMap.put("ownProfile", ownProfile);
            contextMap.put("pwdAllowed", pwdAllowed);
            contextMap.put("secsignidstr", secSignId);
            contextMap.put("passwordlessAllowed", passwordlessAllowed);
            contextMap.put("mailotpAllowed", mailotpAllowed);
            contextMap.put("twoStepAllowed", twoStepAllowed);
            contextMap.put("logged-in-isadmin", String.valueOf(isAdmin));
            contextMap.put("totpAllowed", totpAllowed);
            contextMap.put("fidoAllowed", fidoAllowed);
            contextMap.put("authIsAllowedValue", SecSignIDCommonConstants.AuthIsAllowed);
            contextMap.put("passwordlessAuthEnabled", SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled());
            contextMap.put("twoStepAuthEnabled", SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled());
            contextMap.put("mailotpAuthEnabled", SecSignIDCommonStaticAccessor.getMailotpAuthEnabled());
            contextMap.put("totpAuthEnabled", SecSignIDCommonStaticAccessor.getTotpAuthEnabled());
            contextMap.put("fidoAuthEnabled", SecSignIDCommonStaticAccessor.getFidoAuthEnabled());
            contextMap.put("PASSWORDLESSGROUPNAME", "PasswordlessAllowed".toLowerCase());
            contextMap.put("TWOSTEPGROUPNAME", "2SASecSignIDAllowed".toLowerCase());
            contextMap.put("MAILOTPGROUPNAME", "2SAMailOTPAllowed".toLowerCase());
            contextMap.put("TOTPGROUPNAME", "2SATOTPAllowed".toLowerCase());
            contextMap.put("FIDOGROUPNAME", "2SAFIDOAllowed".toLowerCase());
            contextMap.put("twoStepActive", twostepActivated);
            contextMap.put("mailOtpActive", mailotpActivated);
            contextMap.put("totpActive", totpActivated);
            contextMap.put("fidoActive", fidoActivated);
            contextMap.put("canActivateNewMethod", canActivateNewMethod);
            contextMap.put("canActivateTwoStep", canActivateTwoStep);
            contextMap.put("canActivateMailOTP", canActivateMailOTP);
            contextMap.put("canActivateTOTP", canActivateTOTP);
            contextMap.put("canActivateFIDO", canActivateFIDO);
            contextMap.put("firstMethod", firstMethod);
            contextMap.put("twoStepAuthentication", twoStepAuthentication);
            contextMap.put("totpAuthentication", totpAuthentication);
            contextMap.put("fidoAuthentication", fidoAuthentication);
            contextMap.put("mailOtpAuthentication", mailOtpAuthentication);
            contextMap.put("is-pwdallowed-value", SecSignIDCommonConstants.PasswordLoginIsAllowed);
            contextMap.put("groupsCreated", SecSignIDCommonStaticAccessor.getGroupsCreated());
            contextMap.put("trustDevicesEnabled", SecSignIDCommonStaticAccessor.getTrustDeviceEnabled());
            contextMap.putAll(context);
            logger.debug("complete context map of user provider: " + SecSignIDMappingUtils.toString(contextMap));
            return contextMap;
        }
        return context;
    }

    private SecSignIDTrustDeviceToken getTrustDeviceTokenFromRequest(String userKey, long dirId, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        String tokenValue = null;
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals("secsignid_trustdevicetoken_" + SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getApplication().toLowerCase())) continue;
            tokenValue = cookie.getValue();
            break;
        }
        if (tokenValue == null) {
            return null;
        }
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null || userAgent.equals("")) {
            userAgent = "empty";
        }
        try {
            return SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getTrustDeviceToken(userKey, dirId, tokenValue, userAgent);
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on getAllTrustDeviceTokens for getTrustDeviceTokenFromRequest in UserInfoProvider");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on getAllTrustDeviceTokens for getTrustDeviceTokenFromRequest in UserInfoProvider");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on getAllTrustDeviceTokens for getTrustDeviceTokenFromRequest in UserInfoProvider");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on getAllTrustDeviceTokens for getTrustDeviceTokenFromRequest in UserInfoProvider");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getAllTrustDeviceTokens for getTrustDeviceTokenFromRequest in UserInfoProvider");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (PermissionException e) {
            logger.error("PermissionException on getAllTrustDeviceTokens for getTrustDeviceTokenFromRequest in UserInfoProvider");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        return null;
    }
}

