/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.accessor.directories;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.service.client.CrowdClient;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.accessor.SecSignIDMappingExtractor;
import com.secsign.atlassian.common.accessor.directories.DirectoryWrapper;
import com.secsign.atlassian.common.data.EmbeddedCrowdGroup;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdClientDirectoryWrapper
extends DirectoryWrapper {
    private static final Logger logger = LoggerFactory.getLogger(CrowdClientDirectoryWrapper.class);
    private final CrowdClient client;

    public CrowdClientDirectoryWrapper(Directory directory) {
        super(directory);
        this.client = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getCrowdClientForDir(directory);
    }

    @Override
    public UserWithAttributes findUserWithAttributesByName(String username) throws UserNotFoundException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        try {
            return this.client.getUserWithAttributes(username);
        }
        catch (OperationFailedException e) {
            if (e.getMessage().contains("timed out")) {
                return this.client.getUserWithAttributes(username);
            }
            throw e;
        }
    }

    @Override
    protected void storeUserAttributesUnsafe(String userKey, HashMap<String, Set<String>> attributeMap) throws UserNotFoundException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        String username = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUsernameForUserKey(userKey);
        try {
            this.client.storeUserAttributes(username, attributeMap);
        }
        catch (OperationFailedException e) {
            if (e.getMessage().contains("timed out")) {
                this.client.storeUserAttributes(username, attributeMap);
            }
            throw e;
        }
    }

    @Override
    public GroupWithAttributes findGroupWithAttributesByName(String groupName) throws InvalidAuthenticationException, ApplicationPermissionException, GroupNotFoundException, OperationFailedException {
        try {
            return EmbeddedCrowdGroup.convertGroupToEmbedded(this.client.getGroupWithAttributes(groupName));
        }
        catch (OperationFailedException e) {
            if (e.getMessage().contains("timed out")) {
                return EmbeddedCrowdGroup.convertGroupToEmbedded(this.client.getGroupWithAttributes(groupName));
            }
            throw e;
        }
    }

    @Override
    public void storeGroupAttributesUnsafe(String groupName, HashMap<String, Set<String>> attributeMap) throws OperationFailedException, GroupNotFoundException, InvalidAuthenticationException, ApplicationPermissionException {
        try {
            this.client.storeGroupAttributes(groupName, attributeMap);
        }
        catch (OperationFailedException e) {
            if (e.getMessage().contains("timed out")) {
                this.client.storeGroupAttributes(groupName, attributeMap);
            }
            throw e;
        }
    }

    @Override
    public HashMap<String, SecSignID2FASettings> getGroupMappingsWithOptions() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, SecSignID2FASettings> result = new HashMap<String, SecSignID2FASettings>();
        try {
            List groupNames = this.client.searchGroupNames((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.twofa")).containing((Object)"01"), 0, -1);
            for (String string : groupNames) {
                result.putAll(SecSignIDMappingExtractor.get2FAGroupMappingsForGroup(string, this.getDirectoryId()));
            }
        }
        catch (OperationFailedException e) {
            if (e.getMessage().contains("timed out")) {
                List groupNames = this.client.searchGroupNames((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.twofa")).containing((Object)"01"), 0, -1);
                for (String string : groupNames) {
                    result.putAll(SecSignIDMappingExtractor.get2FAGroupMappingsForGroup(string, this.getDirectoryId()));
                }
            }
            throw e;
        }
        return result;
    }

    @Override
    public void deleteAllUserAttributesWithKey(String string) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException, DirectoryPermissionException, UserNotFoundException {
        List userlist;
        PropertyRestriction restrictionUser = Restriction.on((Property)PropertyUtils.ofTypeString((String)string)).startingWith((Object)"");
        try {
            userlist = this.client.searchUsers((SearchRestriction)restrictionUser, 0, -1);
        }
        catch (OperationFailedException e) {
            if (e.getMessage().contains("timed out")) {
                userlist = this.client.searchUsers((SearchRestriction)restrictionUser, 0, -1);
            }
            throw e;
        }
        for (User user : userlist) {
            String userKey = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(user.getName());
            this.removeUserAttribute(userKey, string);
        }
    }

    @Override
    public void deleteAllGroupAttributesWithKey(String string) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException {
        List groupList;
        PropertyRestriction restrictionGroup = Restriction.on((Property)PropertyUtils.ofTypeString((String)string)).startingWith((Object)"");
        try {
            groupList = this.client.searchGroupNames((SearchRestriction)restrictionGroup, 0, -1);
        }
        catch (OperationFailedException e) {
            if (e.getMessage().contains("timed out")) {
                groupList = this.client.searchGroupNames((SearchRestriction)restrictionGroup, 0, -1);
            }
            throw e;
        }
        for (String groupName : groupList) {
            this.removeGroupAttribute(groupName, string);
        }
    }

    @Override
    public List<String> findUsersWithAttributeMatchesValue(String keyOfValue, String valueToMatch) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        List userlist;
        ArrayList<String> listOfMappings = new ArrayList<String>();
        PropertyRestriction restrictionUser = Restriction.on((Property)PropertyUtils.ofTypeString((String)keyOfValue)).exactlyMatching((Object)valueToMatch);
        try {
            userlist = this.client.searchUsers((SearchRestriction)restrictionUser, 0, -1);
        }
        catch (OperationFailedException e) {
            if (e.getMessage().contains("timed out")) {
                userlist = this.client.searchUsers((SearchRestriction)restrictionUser, 0, -1);
            }
            throw e;
        }
        for (User user : userlist) {
            String userKey = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(user.getName());
            listOfMappings.add(userKey + ":" + this.getDirectoryId());
        }
        return listOfMappings;
    }

    @Override
    public List<String> getActivatedFIDOMappings() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        ArrayList<String> listOfMappings = new ArrayList<String>();
        PropertyRestriction restrictionUser1 = Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"0001");
        PropertyRestriction restrictionUser2 = Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"0101");
        PropertyRestriction restrictionUser3 = Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"0011");
        PropertyRestriction restrictionUser4 = Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"0111");
        PropertyRestriction restrictionUser5 = Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"1001");
        PropertyRestriction restrictionUser6 = Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"1101");
        PropertyRestriction restrictionUser7 = Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"1011");
        PropertyRestriction restrictionUser8 = Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"1111");
        ArrayList userlist = new ArrayList();
        try {
            userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser1, 0, -1));
            userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser2, 0, -1));
            userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser3, 0, -1));
            userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser4, 0, -1));
            userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser5, 0, -1));
            userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser6, 0, -1));
            userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser7, 0, -1));
            userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser8, 0, -1));
        }
        catch (OperationFailedException e) {
            if (e.getMessage().contains("timed out")) {
                userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser1, 0, -1));
                userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser2, 0, -1));
                userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser3, 0, -1));
                userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser4, 0, -1));
                userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser5, 0, -1));
                userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser6, 0, -1));
                userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser7, 0, -1));
                userlist.addAll(this.client.searchUsers((SearchRestriction)restrictionUser8, 0, -1));
            }
            throw e;
        }
        for (User user : userlist) {
            String userKey = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(user.getName());
            listOfMappings.add(userKey + ":" + this.getDirectoryId());
        }
        return listOfMappings;
    }
}

