/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.servlet.filter;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.util.SecSignIDCharArrayWriter;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import com.secsign.atlassian.common.util.SecSignIDServletResponseWrapper;
import com.secsign.atlassian.common.util.SecSignIDTemplateHelper;
import com.secsign.crowd.accessor.SecSignIDStaticAccessor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.TreeMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDViewGroupFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(SecSignIDViewGroupFilter.class);
    private final TemplateRenderer templateRenderer;
    private final DirectoryManager directoryManager;
    private String viewUserTemplate = "/templates/secsignid-viewgroup.vm";
    private SecSignIDDataAccessor dataAccessor;

    public SecSignIDViewGroupFilter(TemplateRenderer templateRenderer, DirectoryManager directoryManager, SecSignIDDataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
        this.templateRenderer = templateRenderer;
        this.directoryManager = directoryManager;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecSignIDServletResponseWrapper responseWrapper = new SecSignIDServletResponseWrapper((HttpServletResponse)response);
        HttpServletRequest httpServletReq = (HttpServletRequest)request;
        chain.doFilter(request, (ServletResponse)responseWrapper);
        try {
            String groupName = "";
            groupName = request.getParameter("name") != null ? request.getParameter("name") : request.getParameter("groupName");
            String diridString = request.getParameter("directoryID");
            long dirid = Long.parseLong(diridString);
            groupName = URLDecoder.decode(groupName);
            groupName = groupName.replace("+", " ");
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("contextPath", ((HttpServletRequest)request).getContextPath());
            context.put("groupName", groupName);
            TreeMap<String, Boolean> pwdAllowedMappings = new TreeMap<String, Boolean>();
            TreeMap<String, Boolean> passwordlessMappings = new TreeMap<String, Boolean>();
            TreeMap<String, Boolean> twoStepMappings = new TreeMap<String, Boolean>();
            TreeMap<String, Boolean> totpMappings = new TreeMap<String, Boolean>();
            TreeMap<String, Boolean> mailotpMappings = new TreeMap<String, Boolean>();
            TreeMap<String, Boolean> fidoMappings = new TreeMap<String, Boolean>();
            TreeMap<String, String> dirMapping = new TreeMap<String, String>();
            Directory directory = this.dataAccessor.getDirectory(dirid);
            try {
                Group group = SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), groupName);
                dirMapping.put(directory.getId().toString(), directory.getName());
                SecSignID2FASettings settings = this.dataAccessor.get2FASettingsForGroup(groupName, directory.getId());
                boolean pwdAllowed = settings.getPwdAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                boolean passwordlessAllowed = settings.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                boolean twoStepAllowed = settings.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                boolean mailotpAllowed = settings.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                boolean totpAllowed = settings.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                boolean fidoAllowed = settings.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                pwdAllowedMappings.put(String.valueOf(groupName) + ";" + directory.getId(), pwdAllowed);
                passwordlessMappings.put(String.valueOf(groupName) + ";" + directory.getId(), passwordlessAllowed);
                twoStepMappings.put(String.valueOf(groupName) + ";" + directory.getId(), twoStepAllowed);
                totpMappings.put(String.valueOf(groupName) + ";" + directory.getId(), totpAllowed);
                fidoMappings.put(String.valueOf(groupName) + ";" + directory.getId(), fidoAllowed);
                mailotpMappings.put(String.valueOf(groupName) + ";" + directory.getId(), mailotpAllowed);
            }
            catch (GroupNotFoundException group) {
            }
            catch (DirectoryNotFoundException e) {
                this.logger.error("DirectoryNotFoundException on get Groups for Groupname on viewGroup");
            }
            catch (OperationFailedException e) {
                this.logger.error("OperationFailedException on get Groups for Groupname on viewGroup");
            }
            catch (InvalidAuthenticationException e) {
                this.logger.error("InvalidAuthenticationException on get Groups for Groupname on viewGroup");
            }
            catch (ApplicationPermissionException e) {
                this.logger.error("ApplicationPermissionException on get Groups for Groupname on viewGroup");
            }
            context.put("dirMapping", dirMapping);
            context.put("pwdAllowedMappings", pwdAllowedMappings);
            context.put("passwordlessMappings", passwordlessMappings);
            context.put("twoStepMappings", twoStepMappings);
            context.put("mailotpMappings", mailotpMappings);
            context.put("totpMappings", totpMappings);
            context.put("fidoMappings", fidoMappings);
            context.put("twoStepEnabled", SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled());
            context.put("fidoEnabled", SecSignIDCommonStaticAccessor.getFidoAuthEnabled());
            context.put("totpEnabled", SecSignIDCommonStaticAccessor.getTotpAuthEnabled());
            context.put("mailotpEnabled", SecSignIDCommonStaticAccessor.getMailotpAuthEnabled());
            context.put("passwordlessEnabled", SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled());
            context.put("PASSWORDLESSGROUPNAME", "PasswordlessAllowed".toLowerCase());
            context.put("TWOSTEPGROUPNAME", "2SASecSignIDAllowed".toLowerCase());
            context.put("MAILOTPGROUPNAME", "2SAMailOTPAllowed".toLowerCase());
            context.put("TOTPGROUPNAME", "2SATOTPAllowed".toLowerCase());
            context.put("FIDOGROUPNAME", "2SAFIDOAllowed".toLowerCase());
            context.put("req", request);
            context.put("isCreatedGroup", this.isCreatedGroup(groupName));
            context.put("isDeactivatedCreatedGroup", this.isDeactivatedCreatedGroup(groupName));
            context.put("groupLinkToAdd", new SecSignIDTemplateHelper().getGroupLinkToAdd(String.valueOf(groupName) + ";" + dirid));
            this.logger.debug("context map of view user filter: " + SecSignIDMappingUtils.toString(context));
            SecSignIDCharArrayWriter renderedTemplate = new SecSignIDCharArrayWriter();
            this.templateRenderer.render(this.viewUserTemplate, context, (Writer)renderedTemplate);
            responseWrapper.inject(renderedTemplate);
            PrintWriter responseOutput = response.getWriter();
            response.setContentLength(responseWrapper.length());
            responseOutput.write(responseWrapper.toString());
            responseOutput.close();
        }
        catch (Exception e) {
            PrintWriter responseOutput = response.getWriter();
            response.setContentLength(responseWrapper.length());
            responseOutput.write(responseWrapper.toString());
            responseOutput.close();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private Boolean isCreatedGroup(String groupName) {
        if (groupName.toLowerCase().equals("PasswordlessAllowed".toLowerCase())) {
            return Boolean.TRUE;
        }
        if (groupName.toLowerCase().equals("2SASecSignIDAllowed".toLowerCase())) {
            return Boolean.TRUE;
        }
        if (groupName.toLowerCase().equals("2SAFIDOAllowed".toLowerCase())) {
            return Boolean.TRUE;
        }
        if (groupName.toLowerCase().equals("2SATOTPAllowed".toLowerCase())) {
            return Boolean.TRUE;
        }
        if (groupName.toLowerCase().equals("2SAMailOTPAllowed".toLowerCase())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean isDeactivatedCreatedGroup(String groupName) {
        if (groupName.toLowerCase().equals("PasswordlessAllowed".toLowerCase()) && !SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled()) {
            return Boolean.TRUE;
        }
        if (groupName.toLowerCase().equals("2SASecSignIDAllowed".toLowerCase()) && !SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled()) {
            return Boolean.TRUE;
        }
        if (groupName.toLowerCase().equals("2SAFIDOAllowed".toLowerCase()) && !SecSignIDCommonStaticAccessor.getFidoAuthEnabled()) {
            return Boolean.TRUE;
        }
        if (groupName.toLowerCase().equals("2SATOTPAllowed".toLowerCase()) && !SecSignIDCommonStaticAccessor.getTotpAuthEnabled()) {
            return Boolean.TRUE;
        }
        if (groupName.toLowerCase().equals("2SAMailOTPAllowed".toLowerCase()) && !SecSignIDCommonStaticAccessor.getMailotpAuthEnabled()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

