/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.accessor;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SpringLDAPConnector;
import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.User;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import com.secsign.crowd.accessor.SecSignIDStaticAccessor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDLDAPAccessor {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDLDAPAccessor.class);
    private static String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private static String securityAuthType = "simple";

    public static User getUserForSecSignID(String secSignID) {
        return SecSignIDLDAPAccessor.getUserForSecSignIDNotSame(secSignID, null);
    }

    public static User getUserForSecSignIDNotSame(String secSignID, String sameUser) {
        DirectoryInstanceLoader dirLoader = SecSignIDStaticAccessor.getDirectoryInstanceLoader();
        DirectoryManager dirManager = SecSignIDStaticAccessor.getDirectoryManager();
        String attributeSecSignID = SecSignIDCommonStaticAccessor.getLDAPSecSignIDAttr();
        List directories = dirManager.findAllDirectories();
        if (directories == null) {
            logger.warn("Did not get a list of directories.");
            return null;
        }
        for (Directory dir : directories) {
            if (!dir.isActive()) continue;
            long dirId = dir.getId();
            if (!dir.getType().equals((Object)DirectoryType.CONNECTOR)) continue;
            try {
                RemoteDirectory remoteDir = dirLoader.getDirectory(dir);
                LDAPPropertiesMapper ldapPropertiesMapper = ((SpringLDAPConnector)remoteDir.getAuthoritativeDirectory()).getLdapPropertiesMapper();
                String password = ldapPropertiesMapper.getPassword();
                String url = ldapPropertiesMapper.getConnectionURL();
                String username = ldapPropertiesMapper.getUsername();
                String filter = ldapPropertiesMapper.getUserFilter();
                String baseDN = ldapPropertiesMapper.getAttribute("ldap.basedn");
                String attributeForName = ((SpringLDAPConnector)remoteDir.getAuthoritativeDirectory()).getLdapPropertiesMapper().getUserNameAttribute();
                filter = String.valueOf(filter.substring(0, filter.length() - 1)) + "(" + attributeSecSignID + "=" + secSignID + ")" + filter.substring(filter.length() - 1, filter.length());
                String[] attribs = new String[]{attributeForName, attributeSecSignID};
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", contextFactory);
                env.put("java.naming.provider.url", url);
                env.put("java.naming.security.authentication", securityAuthType);
                env.put("java.naming.security.principal", username);
                env.put("java.naming.security.credentials", password);
                env.put("java.naming.referral", "follow");
                InitialDirContext context = new InitialDirContext(env);
                SearchControls ctrl = new SearchControls();
                ctrl.setSearchScope(2);
                ctrl.setReturningAttributes(attribs);
                NamingEnumeration<SearchResult> enumeration = context.search(baseDN, filter, ctrl);
                while (enumeration.hasMore()) {
                    SearchResult result = enumeration.next();
                    User resultUser = dirManager.findUserByName(dirId, result.getAttributes().get(attributeForName).get().toString());
                    if (sameUser != null) {
                        if (resultUser.getName().equals(sameUser)) continue;
                        return resultUser;
                    }
                    return resultUser;
                }
            }
            catch (PartialResultException e) {
                logger.debug("Received partial result exception. Return null.");
                return null;
            }
            catch (ClassCastException e) {
                logger.debug("No Success in ClassCast, since directory is no LDAPDirectory for secsign id " + secSignID + " from directory with id " + dirId);
            }
            catch (Exception e) {
                logger.error("Cannot get user for secsign id '" + secSignID + "' from directory with id " + dirId + " from LDAP: " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static HashMap<String, String[]> getMappingForDir(long dirid) {
        HashMap<String, String[]> resultMap = new HashMap<String, String[]>();
        DirectoryInstanceLoader dirLoader = SecSignIDStaticAccessor.getDirectoryInstanceLoader();
        DirectoryManager dirManager = SecSignIDStaticAccessor.getDirectoryManager();
        String attributeSecSignID = SecSignIDCommonStaticAccessor.getLDAPSecSignIDAttr();
        try {
            Directory dir = dirManager.findDirectoryById(dirid);
            if (dir.getType().equals((Object)DirectoryType.CONNECTOR)) {
                RemoteDirectory remoteDir = dirLoader.getDirectory(dir);
                LDAPPropertiesMapper ldapPropertiesMapper = ((SpringLDAPConnector)remoteDir.getAuthoritativeDirectory()).getLdapPropertiesMapper();
                String password = ldapPropertiesMapper.getPassword();
                String url = ldapPropertiesMapper.getConnectionURL();
                String username = ldapPropertiesMapper.getUsername();
                String filter = ldapPropertiesMapper.getUserFilter();
                String baseDN = ldapPropertiesMapper.getAttribute("ldap.basedn");
                String attributeForName = ldapPropertiesMapper.getUserNameAttribute();
                String[] attribs = new String[]{attributeForName, attributeSecSignID};
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", contextFactory);
                env.put("java.naming.provider.url", url);
                env.put("java.naming.security.authentication", securityAuthType);
                env.put("java.naming.security.principal", username);
                env.put("java.naming.security.credentials", password);
                env.put("java.naming.referral", "follow");
                InitialDirContext context = new InitialDirContext(env);
                SearchControls ctrl = new SearchControls();
                ctrl.setSearchScope(2);
                ctrl.setReturningAttributes(attribs);
                NamingEnumeration<SearchResult> enumeration = context.search(baseDN, filter, ctrl);
                while (enumeration.hasMore()) {
                    SearchResult result = enumeration.next();
                    Attributes attributesObject = result.getAttributes();
                    if (attributesObject.get(attributeForName) == null || attributesObject.get(attributeSecSignID) == null) continue;
                    resultMap.put(attributesObject.get(attributeForName).get().toString(), SecSignIDMappingUtils.getArrayOfSecSignIds(attributesObject.get(attributeSecSignID).get().toString()));
                }
            }
        }
        catch (PartialResultException e) {
            logger.debug("Received partial result exception. Return the result map as filled until now.");
        }
        catch (ClassCastException e) {
            logger.debug("No Success in ClassCast, since directory is no LDAPDirectory from directory with id " + dirid);
        }
        catch (Exception e) {
            logger.error("Cannot get user mappings from directory with id " + dirid + " from LDAP: " + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    public static Object[] checkDuplicates(String secsignid, String username, Directory dir) {
        HashMap<String, String[]> mapping = SecSignIDLDAPAccessor.getMappingForDir(dir);
        for (Map.Entry<String, String[]> element : mapping.entrySet()) {
            String[] stringArray = element.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String idForUser = stringArray[n2];
                if (secsignid.equalsIgnoreCase(idForUser) && !username.equals(element.getKey())) {
                    Object[] duplicate = new Object[]{Boolean.TRUE, dir.getName(), element.getKey()};
                    return duplicate;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String[] getSecSignIDsForUser(User user) {
        long dirid = user.getDirectoryId();
        try {
            Directory dir = SecSignIDStaticAccessor.getDirectoryManager().findDirectoryById(dirid);
            return SecSignIDLDAPAccessor.getMappingForUser(user.getName(), dir);
        }
        catch (Exception e) {
            logger.error("Cannot get SecSign IDs for user '" + user + "' in directory with ID " + dirid + ": " + e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    public static String getSecSignIDStringForUser(User user) {
        long dirid = user.getDirectoryId();
        try {
            Directory dir = SecSignIDStaticAccessor.getDirectoryManager().findDirectoryById(dirid);
            String[] result = SecSignIDLDAPAccessor.getMappingForUser(user.getName(), dir);
            return SecSignIDMappingUtils.getSecSignIdString(result);
        }
        catch (Exception e) {
            logger.error("Cannot get mappings for user '" + user + "' in directory with ID " + dirid + ": " + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String[] getMappingForUser(String user, Directory dir) {
        String[] secSignIDs = new String[]{};
        DirectoryInstanceLoader dirLoader = SecSignIDStaticAccessor.getDirectoryInstanceLoader();
        String attributeSecSignID = SecSignIDCommonStaticAccessor.getLDAPSecSignIDAttr();
        try {
            if (dir.getType().equals((Object)DirectoryType.CONNECTOR)) {
                RemoteDirectory remoteDir = dirLoader.getDirectory(dir);
                LDAPPropertiesMapper ldapPropertiesMapper = ((SpringLDAPConnector)remoteDir.getAuthoritativeDirectory()).getLdapPropertiesMapper();
                String password = ldapPropertiesMapper.getPassword();
                String url = ldapPropertiesMapper.getConnectionURL();
                String username = ldapPropertiesMapper.getUsername();
                String filter = ldapPropertiesMapper.getUserFilter();
                String baseDN = ldapPropertiesMapper.getAttribute("ldap.basedn");
                String attributeForName = ldapPropertiesMapper.getUserNameAttribute();
                filter = String.valueOf(filter.substring(0, filter.length() - 1)) + "(" + attributeForName + "=" + user + ")" + filter.substring(filter.length() - 1, filter.length());
                String[] attribs = new String[]{attributeForName, attributeSecSignID};
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", contextFactory);
                env.put("java.naming.provider.url", url);
                env.put("java.naming.security.authentication", securityAuthType);
                env.put("java.naming.security.principal", username);
                env.put("java.naming.security.credentials", password);
                env.put("java.naming.referral", "follow");
                InitialDirContext context = new InitialDirContext(env);
                SearchControls ctrl = new SearchControls();
                ctrl.setSearchScope(2);
                ctrl.setReturningAttributes(attribs);
                NamingEnumeration<SearchResult> enumeration = context.search(baseDN, filter, ctrl);
                while (enumeration.hasMore()) {
                    SearchResult result = enumeration.next();
                    Attributes attributesObject = result.getAttributes();
                    if (attributesObject.get(attributeForName) == null || attributesObject.get(attributeSecSignID) == null) continue;
                    secSignIDs = SecSignIDMappingUtils.getArrayOfSecSignIds(attributesObject.get(attributeSecSignID).get().toString());
                }
            }
        }
        catch (PartialResultException e) {
            logger.debug("Received partial result exception. Return empty mapping.");
        }
        catch (ClassCastException e) {
            logger.debug("No Success in ClassCast, since directory is no LDAPDirectory for user '" + user + "' in directory '" + dir);
        }
        catch (Exception e) {
            logger.error("Could not get mappings for user '" + user + "' in directory '" + dir + "': " + e.getMessage(), (Throwable)e);
        }
        return secSignIDs;
    }

    public static HashMap<String, String[]> getMappingForDir(Directory dir) {
        HashMap<String, String[]> resultMap = new HashMap<String, String[]>();
        DirectoryInstanceLoader dirLoader = SecSignIDStaticAccessor.getDirectoryInstanceLoader();
        String attributeSecSignID = SecSignIDCommonStaticAccessor.getLDAPSecSignIDAttr();
        try {
            if (dir.getType().equals((Object)DirectoryType.CONNECTOR)) {
                RemoteDirectory remoteDir = dirLoader.getDirectory(dir);
                LDAPPropertiesMapper ldapPropertiesMapper = ((SpringLDAPConnector)remoteDir.getAuthoritativeDirectory()).getLdapPropertiesMapper();
                String password = ldapPropertiesMapper.getPassword();
                String url = ldapPropertiesMapper.getConnectionURL();
                String username = ldapPropertiesMapper.getUsername();
                String filter = ldapPropertiesMapper.getUserFilter();
                String baseDN = ldapPropertiesMapper.getAttribute("ldap.basedn");
                String attributeForName = ldapPropertiesMapper.getUserNameAttribute();
                String[] attribs = new String[]{attributeForName, attributeSecSignID};
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", contextFactory);
                env.put("java.naming.provider.url", url);
                env.put("java.naming.security.authentication", securityAuthType);
                env.put("java.naming.security.principal", username);
                env.put("java.naming.security.credentials", password);
                env.put("java.naming.referral", "follow");
                InitialDirContext context = new InitialDirContext(env);
                SearchControls ctrl = new SearchControls();
                ctrl.setSearchScope(2);
                ctrl.setReturningAttributes(attribs);
                NamingEnumeration<SearchResult> enumeration = context.search(baseDN, filter, ctrl);
                while (enumeration.hasMore()) {
                    SearchResult result = enumeration.next();
                    Attributes attributesObject = result.getAttributes();
                    if (attributesObject.get(attributeForName) == null || attributesObject.get(attributeSecSignID) == null) continue;
                    resultMap.put(attributesObject.get(attributeForName).get().toString().toLowerCase(), SecSignIDMappingUtils.getArrayOfSecSignIds(attributesObject.get(attributeSecSignID).get().toString()));
                }
            }
        }
        catch (PartialResultException e) {
            logger.debug("Received partial result exception. Return the result map as filled until now.");
        }
        catch (ClassCastException e) {
            logger.debug("No Success in ClassCast, since directory is no LDAPDirectory in directory '" + dir);
        }
        catch (Exception e) {
            logger.error("Could not get mappings for directory '" + dir + "': " + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    public static void writeSecSignIDMappingsToLDAP(String user, String[] secSignIdArray, long directoryId) throws NamingException, OperationFailedException {
        logger.debug("Write mappings for user '" + user + "' in directoty with ID '" + directoryId + " into LDAP.");
        DirectoryInstanceLoader dirLoader = SecSignIDStaticAccessor.getDirectoryInstanceLoader();
        try {
            Directory dir = SecSignIDStaticAccessor.getDirectoryManager().findDirectoryById(directoryId);
            if (dir.getType().equals((Object)DirectoryType.CONNECTOR)) {
                RemoteDirectory remoteDir = dirLoader.getDirectory(dir);
                LDAPPropertiesMapper ldapPropertiesMapper = ((SpringLDAPConnector)remoteDir.getAuthoritativeDirectory()).getLdapPropertiesMapper();
                String password = ldapPropertiesMapper.getPassword();
                String url = ldapPropertiesMapper.getConnectionURL();
                String username = ldapPropertiesMapper.getUsername();
                String filter = ldapPropertiesMapper.getUserFilter();
                String baseDN = ldapPropertiesMapper.getAttribute("ldap.basedn");
                String distinguishedName = "distinguishedName";
                filter = filter.replace("*", user);
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", contextFactory);
                env.put("java.naming.provider.url", url);
                env.put("java.naming.security.authentication", securityAuthType);
                env.put("java.naming.security.principal", username);
                env.put("java.naming.security.credentials", password);
                env.put("java.naming.referral", "follow");
                InitialDirContext context = new InitialDirContext(env);
                String[] attribs = new String[]{distinguishedName};
                SearchControls ctrl = new SearchControls();
                ctrl.setSearchScope(2);
                ctrl.setReturningAttributes(attribs);
                NamingEnumeration<SearchResult> enumeration = context.search(baseDN, filter, ctrl);
                if (enumeration.hasMore()) {
                    SearchResult result = enumeration.next();
                    Attributes attributesObject = result.getAttributes();
                    ModificationItem[] mods = new ModificationItem[1];
                    if (secSignIdArray == null || secSignIdArray.length < 1) {
                        BasicAttribute idMod = new BasicAttribute(SecSignIDCommonStaticAccessor.getLDAPSecSignIDAttr());
                        mods[0] = new ModificationItem(3, idMod);
                    } else {
                        String secsignidString = SecSignIDMappingUtils.getSecSignIdString(secSignIdArray);
                        BasicAttribute idMod = new BasicAttribute(SecSignIDCommonStaticAccessor.getLDAPSecSignIDAttr(), secsignidString);
                        mods[0] = new ModificationItem(2, idMod);
                    }
                    context.modifyAttributes(attributesObject.get(distinguishedName).get().toString(), mods);
                }
            }
        }
        catch (PartialResultException e) {
            logger.debug("Received partial result exception. Return the result map as filled until now.");
        }
        catch (ClassCastException e) {
            logger.debug("No Success in ClassCast, since directory is no LDAPDirectory for writing user '" + user);
        }
        catch (Exception e) {
            logger.error("Could not write mappings for user '" + user + "' into ldap: " + e.getMessage(), (Throwable)e);
        }
    }
}

