/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.util;

public class SecSignIDArrayUtil {
    public static byte[] maskRightmostBits(byte[] ba, int leftbitsLenNotToMask) {
        byte[] masked = new byte[ba.length];
        System.arraycopy(ba, 0, masked, 0, leftbitsLenNotToMask / 8);
        int leftbitsLenNotToMaskInPartialByte = leftbitsLenNotToMask % 8;
        if (leftbitsLenNotToMaskInPartialByte > 0) {
            int indexOfPartialByte = leftbitsLenNotToMask / 8;
            byte partialByte = ba[indexOfPartialByte];
            switch (leftbitsLenNotToMaskInPartialByte) {
                case 1: {
                    partialByte = (byte)(partialByte & 0x80);
                    break;
                }
                case 2: {
                    partialByte = (byte)(partialByte & 0xC0);
                    break;
                }
                case 3: {
                    partialByte = (byte)(partialByte & 0xE0);
                    break;
                }
                case 4: {
                    partialByte = (byte)(partialByte & 0xF0);
                    break;
                }
                case 5: {
                    partialByte = (byte)(partialByte & 0xF8);
                    break;
                }
                case 6: {
                    partialByte = (byte)(partialByte & 0xFC);
                    break;
                }
                case 7: {
                    partialByte = (byte)(partialByte & 0xFE);
                    break;
                }
                default: {
                    throw new IllegalStateException("leftbitsLenNotToMaskInPartialByte = " + leftbitsLenNotToMaskInPartialByte);
                }
            }
            masked[indexOfPartialByte] = partialByte;
        }
        return masked;
    }

    public static boolean areEqual(byte[] arrayA, byte[] arrayB) {
        if (arrayA == null && arrayB == null) {
            return true;
        }
        if (arrayA == null || arrayB == null) {
            return false;
        }
        int lengthArrayA = arrayA.length;
        if (lengthArrayA != arrayB.length) {
            return false;
        }
        for (int i = 0; i < lengthArrayA; ++i) {
            if (arrayA[i] == arrayB[i]) continue;
            return false;
        }
        return true;
    }
}

