/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet.filter;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.util.SecSignIDCharArrayWriter;
import com.secsign.atlassian.common.util.SecSignIDServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class SecSignIDFrontPageFilter
implements Filter {
    private final String FRONT_PAGE_TEMPLATE = "/templates/secsignid-frontpage.vm";
    private final TemplateRenderer templateRenderer;
    private final SecSignIDDataAccessor dataAccessor;

    public SecSignIDFrontPageFilter(TemplateRenderer templateRenderer, SecSignIDDataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
        this.templateRenderer = templateRenderer;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        boolean isAdmin = user != null && this.dataAccessor.isUserAdmin(user);
        HashMap<String, Boolean> context = new HashMap<String, Boolean>();
        if (!isAdmin) {
            chain.doFilter(request, response);
            return;
        }
        SecSignIDServletResponseWrapper responseWrapper = new SecSignIDServletResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)responseWrapper);
        if (!SecSignIDCommonStaticAccessor.getFirstStart() && SecSignIDCommonStaticAccessor.isUsingCloudServer() && !SecSignIDCommonStaticAccessor.hasPluginPinAccount()) {
            context.put("pluginPinAccount", Boolean.TRUE);
        }
        SecSignIDCharArrayWriter renderedTemplate = new SecSignIDCharArrayWriter();
        this.templateRenderer.render("/templates/secsignid-frontpage.vm", context, (Writer)renderedTemplate);
        responseWrapper.inject(renderedTemplate);
        try {
            PrintWriter responseOutput = response.getWriter();
            response.setContentLength(responseWrapper.length());
            responseOutput.write(responseWrapper.toString());
            responseOutput.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

