/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDRESTRestorationResponse {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDRESTRestorationResponse.class);
    private final String secSignId;
    private final String restoreUrl;
    private final String qrCodeBase64;

    public static SecSignIDRESTRestorationResponse fromJson(String json, String secSignId) throws JSONException, SecSignIDRESTException {
        JSONObject rootObject = new JSONObject(json);
        if (!rootObject.has(secSignId)) {
            logger.debug("Key '" + secSignId + "' not found");
            throw new SecSignIDRESTException("No secsignid information available");
        }
        JSONObject secSignObject = rootObject.getJSONObject(secSignId);
        if (!secSignObject.has("restoration")) {
            logger.debug("Key 'restoration' not found");
            throw new SecSignIDRESTException("No totp information available");
        }
        JSONObject restorationObject = secSignObject.getJSONObject("restoration");
        String restoreUrl = restorationObject.optString("restoreurl", null);
        if (restoreUrl == null) {
            logger.debug("Key 'restoreurl' not found");
            throw new SecSignIDRESTException("No restoreurl information available");
        }
        String qrCodeBase64 = restorationObject.optString("qrcodebase64", null);
        if (qrCodeBase64 == null) {
            logger.debug("Key 'qrcodebase64' not found");
            throw new SecSignIDRESTException("No qrcodebase64 information available");
        }
        return new SecSignIDRESTRestorationResponse(secSignId, restoreUrl, qrCodeBase64);
    }

    private SecSignIDRESTRestorationResponse(String secSignId, String restoreUrl, String qrCodeBase64) {
        this.secSignId = secSignId;
        this.restoreUrl = restoreUrl;
        this.qrCodeBase64 = qrCodeBase64;
    }

    public String getSecSignId() {
        return this.secSignId;
    }

    public String getRestoreUrl() {
        return this.restoreUrl;
    }

    public String getQrCodeBase64() {
        return this.qrCodeBase64;
    }
}

