/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDRESTCheckAuthSessionStateResponse {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDRESTCheckAuthSessionStateResponse.class);
    private final int authSessionStateValue;
    private final State authSessionState;

    public static SecSignIDRESTCheckAuthSessionStateResponse fromJson(String json) throws JSONException, SecSignIDRESTException {
        JSONObject rootObject = new JSONObject(json);
        int authSessionState = rootObject.optInt("authsessionstate", -1);
        if (authSessionState == -1) {
            logger.debug("Key 'authsessionstate' not found");
            throw new SecSignIDRESTException("Key 'authsessionstate' not found");
        }
        return new SecSignIDRESTCheckAuthSessionStateResponse(authSessionState, SecSignIDRESTCheckAuthSessionStateResponse.getStateFromValue(authSessionState));
    }

    private SecSignIDRESTCheckAuthSessionStateResponse(int authSessionStateValue, State authSessionState) {
        this.authSessionStateValue = authSessionStateValue;
        this.authSessionState = authSessionState;
    }

    public int getAuthSessionStateValue() {
        return this.authSessionStateValue;
    }

    public State getAuthSessionState() {
        return this.authSessionState;
    }

    private static State getStateFromValue(int value) {
        switch (value) {
            case 1: {
                return State.PENDING;
            }
            case 2: {
                return State.EXPIRED;
            }
            case 3: {
                return State.AUTHENTICATED;
            }
            case 4: {
                return State.DENIED;
            }
            case 5: {
                return State.SUSPENDED;
            }
            case 6: {
                return State.CANCELED;
            }
            case 7: {
                return State.FETCHED;
            }
            case 8: {
                return State.INVALID;
            }
        }
        return State.NO_STATE;
    }

    public static enum State {
        NO_STATE,
        PENDING,
        EXPIRED,
        AUTHENTICATED,
        DENIED,
        SUSPENDED,
        CANCELED,
        FETCHED,
        INVALID;

    }
}

