/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.crypto;

import com.secsign.atlassian.common.crypto.SHA256HMAC;

public final class PwdBasedKeyDerivFunc {
    public static byte[] pbkdf2(byte[] pwd, byte[] salt) {
        SHA256HMAC hmac = new SHA256HMAC();
        int hLen = hmac.getDigestLen();
        int dkLen = 32;
        byte[] output = new byte[dkLen];
        int missingOctets = dkLen;
        int outputOffset = 0;
        int blockIndex = 1;
        int iterationCount = 2048;
        while (missingOctets > 0) {
            byte[] block = PwdBasedKeyDerivFunc.funcFForPbkdf2(hmac, pwd, salt, iterationCount, blockIndex);
            int octetsToCopyLen = Math.min(missingOctets, hLen);
            System.arraycopy(block, 0, output, outputOffset, octetsToCopyLen);
            missingOctets -= octetsToCopyLen;
            outputOffset += octetsToCopyLen;
            ++blockIndex;
        }
        return output;
    }

    private static byte[] funcFForPbkdf2(SHA256HMAC hmac, byte[] pwd, byte[] salt, int iterationCount, int blockIndex) {
        byte[] f = null;
        byte[] blockIndexAsArray = PwdBasedKeyDerivFunc.integerToByteArray(blockIndex);
        byte[] u = new byte[salt.length + 4];
        System.arraycopy(salt, 0, u, 0, salt.length);
        System.arraycopy(blockIndexAsArray, 0, u, salt.length, 4);
        for (int a = 0; a < iterationCount; ++a) {
            u = hmac.getDigest(u, pwd);
            f = f == null ? u : PwdBasedKeyDerivFunc.xor(f, 0, u, 0, f.length);
        }
        return f;
    }

    private static byte[] integerToByteArray(int i) {
        byte[] ret = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return ret;
    }

    private static byte[] xor(byte[] a, int aOffset, byte[] b, int bOffset, int len) {
        if (a.length < aOffset + len) {
            throw new ArrayIndexOutOfBoundsException("Byte array a for XOR too short.");
        }
        if (b.length < bOffset + len) {
            throw new ArrayIndexOutOfBoundsException("Byte array b for XOR too short.");
        }
        byte[] output = new byte[len];
        for (int i = 0; i < len; ++i) {
            output[i] = (byte)(a[aOffset + i] ^ b[bOffset + i]);
        }
        return output;
    }
}

