/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.accessor.directories;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.accessor.SecSignIDMappingExtractor;
import com.secsign.atlassian.common.accessor.directories.DirectoryWrapper;
import com.secsign.atlassian.common.data.EmbeddedCrowdGroup;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalDirectoryWrapper
extends DirectoryWrapper {
    private static final Logger logger = LoggerFactory.getLogger(InternalDirectoryWrapper.class);
    private final DirectoryManager directoryManager = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getDirectoryManager();

    public InternalDirectoryWrapper(Directory directory) {
        super(directory);
    }

    @Override
    public UserWithAttributes findUserWithAttributesByName(String username) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        return this.directoryManager.findUserWithAttributesByName(this.getDirectoryId(), username);
    }

    @Override
    protected void storeUserAttributesUnsafe(String userKey, HashMap<String, Set<String>> attributeMap) throws UserNotFoundException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException {
        String username = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUsernameForUserKey(userKey);
        this.directoryManager.storeUserAttributes(this.getDirectoryId(), username, attributeMap);
    }

    @Override
    public GroupWithAttributes findGroupWithAttributesByName(String groupName) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        return EmbeddedCrowdGroup.convertGroupToEmbedded(this.directoryManager.findGroupWithAttributesByName(this.getDirectoryId(), groupName));
    }

    @Override
    public void storeGroupAttributesUnsafe(String groupName, HashMap<String, Set<String>> attributeMap) throws OperationFailedException, GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException {
        this.directoryManager.storeGroupAttributes(this.getDirectoryId(), groupName, attributeMap);
    }

    @Override
    public HashMap<String, SecSignID2FASettings> getGroupMappingsWithOptions() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        HashMap<String, SecSignID2FASettings> result = new HashMap<String, SecSignID2FASettings>();
        List groupNames = this.directoryManager.searchGroups(this.getDirectoryId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.twofa")).containing((Object)"01")).startingAt(0).returningAtMost(-1));
        for (String string : groupNames) {
            result.putAll(SecSignIDMappingExtractor.get2FAGroupMappingsForGroup(string, this.getDirectoryId()));
        }
        return result;
    }

    @Override
    public void deleteAllUserAttributesWithKey(String string) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException, DirectoryPermissionException, UserNotFoundException {
        EntityQuery queryUser = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)string)).startingWith((Object)"")).startingAt(0).returningAtMost(-1);
        List users = this.directoryManager.searchUsers(this.getDirectoryId(), queryUser);
        for (User user : users) {
            String userKey = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(user.getName());
            this.removeUserAttribute(userKey, string);
        }
    }

    @Override
    public void deleteAllGroupAttributesWithKey(String string) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException {
        EntityQuery queryGroup = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)string)).startingWith((Object)"")).startingAt(0).returningAtMost(-1);
        List groupList = this.directoryManager.searchGroups(this.getDirectoryId(), queryGroup);
        for (String groupName : groupList) {
            this.removeGroupAttribute(groupName, string);
        }
    }

    @Override
    public List<String> findUsersWithAttributeMatchesValue(String keyOfValue, String valueToMatch) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        ArrayList<String> listOfMappings = new ArrayList<String>();
        EntityQuery queryUser = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)keyOfValue)).exactlyMatching((Object)valueToMatch)).startingAt(0).returningAtMost(-1);
        List users = this.directoryManager.searchUsers(this.getDirectoryId(), queryUser);
        for (User user : users) {
            String userKey = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(user.getName());
            listOfMappings.add(userKey + ":" + this.getDirectoryId());
        }
        return listOfMappings;
    }

    @Override
    public List<String> getActivatedFIDOMappings() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        ArrayList<String> listOfMappings = new ArrayList<String>();
        EntityQuery queryUser1 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"0001")).startingAt(0).returningAtMost(-1);
        EntityQuery queryUser2 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"0011")).startingAt(0).returningAtMost(-1);
        EntityQuery queryUser3 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"0101")).startingAt(0).returningAtMost(-1);
        EntityQuery queryUser4 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"0111")).startingAt(0).returningAtMost(-1);
        EntityQuery queryUser5 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"1001")).startingAt(0).returningAtMost(-1);
        EntityQuery queryUser6 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"1011")).startingAt(0).returningAtMost(-1);
        EntityQuery queryUser7 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"1101")).startingAt(0).returningAtMost(-1);
        EntityQuery queryUser8 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign.activated")).exactlyMatching((Object)"1111")).startingAt(0).returningAtMost(-1);
        ArrayList userlist = new ArrayList();
        userlist.addAll(this.directoryManager.searchUsers(this.getDirectoryId(), queryUser1));
        userlist.addAll(this.directoryManager.searchUsers(this.getDirectoryId(), queryUser2));
        userlist.addAll(this.directoryManager.searchUsers(this.getDirectoryId(), queryUser3));
        userlist.addAll(this.directoryManager.searchUsers(this.getDirectoryId(), queryUser4));
        userlist.addAll(this.directoryManager.searchUsers(this.getDirectoryId(), queryUser5));
        userlist.addAll(this.directoryManager.searchUsers(this.getDirectoryId(), queryUser6));
        userlist.addAll(this.directoryManager.searchUsers(this.getDirectoryId(), queryUser7));
        userlist.addAll(this.directoryManager.searchUsers(this.getDirectoryId(), queryUser8));
        for (User user : userlist) {
            String userKey = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(user.getName());
            listOfMappings.add(userKey + ":" + this.getDirectoryId());
        }
        return listOfMappings;
    }
}

