/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.servlet.filter;

import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.contextprovider.SecSignIDUserInfoProvider;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.util.SecSignIDCharArrayWriter;
import com.secsign.atlassian.common.util.SecSignIDServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecSignIDViewUserProfileFilter
implements Filter {
    private final TemplateRenderer templateRenderer;
    private final DirectoryManager directoryManager;
    private String viewUserTemplate = "/templates/secsignid-viewuser.vm";
    private SecSignIDDataAccessor dataAccessor;

    public SecSignIDViewUserProfileFilter(TemplateRenderer templateRenderer, DirectoryManager directoryManager, SecSignIDDataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
        this.templateRenderer = templateRenderer;
        this.directoryManager = directoryManager;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecSignIDServletResponseWrapper responseWrapper = new SecSignIDServletResponseWrapper((HttpServletResponse)response);
        HttpServletRequest httpServletReq = (HttpServletRequest)request;
        chain.doFilter(request, (ServletResponse)responseWrapper);
        boolean localEnable = SecSignIDCommonStaticAccessor.getLocalEnable();
        boolean writeLDAPEnable = SecSignIDCommonStaticAccessor.getWriteLDAPEnable();
        boolean remoteWritable = true;
        String username = httpServletReq.getParameter("name");
        if (username == null) {
            username = httpServletReq.getParameter("entityName");
        }
        String diridString = httpServletReq.getParameter("directoryID");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("name", username);
        context.put("dirid", diridString);
        context.put("req", request);
        SecSignIDUserInfoProvider infoProvider = new SecSignIDUserInfoProvider();
        context.putAll(infoProvider.getContextMap(context));
        SecSignIDCharArrayWriter renderedTemplate = new SecSignIDCharArrayWriter();
        this.templateRenderer.render(this.viewUserTemplate, context, (Writer)renderedTemplate);
        responseWrapper.inject(renderedTemplate);
        PrintWriter responseOutput = response.getWriter();
        response.setContentLength(responseWrapper.length());
        responseOutput.write(responseWrapper.toString());
        responseOutput.close();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

