/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.util;

import com.secsign.atlassian.common.util.SecSignIDArrayUtil;
import java.net.InetAddress;

public class SecSignIDIPHelper {
    public static boolean isIpInRange(String ip, String rangeStart, String rangeStop) {
        long ipLong = SecSignIDIPHelper.ipToLong(ip);
        long startLong = SecSignIDIPHelper.ipToLong(rangeStart);
        long stopLong = SecSignIDIPHelper.ipToLong(rangeStop);
        return ipLong >= startLong && ipLong <= stopLong;
    }

    private static long ipToLong(String ipAddress) {
        String[] ipAddressInArray = ipAddress.split("\\.");
        long result = 0L;
        for (int i = 0; i < ipAddressInArray.length; ++i) {
            int power = 3 - i;
            int ip = Integer.parseInt(ipAddressInArray[i]);
            result = (long)((double)result + (double)ip * Math.pow(256.0, power));
        }
        return result;
    }

    public static boolean isHostAddressInSubnet(InetAddress hostAddress, InetAddress subnet, int prefixLen) {
        byte[] networkAddrBytesMasked = SecSignIDArrayUtil.maskRightmostBits(subnet.getAddress(), prefixLen);
        byte[] hostAddrBytes = hostAddress.getAddress();
        if (hostAddrBytes.length != networkAddrBytesMasked.length) {
            return false;
        }
        byte[] hostAddrMasked = SecSignIDArrayUtil.maskRightmostBits(hostAddrBytes, prefixLen);
        return SecSignIDArrayUtil.areEqual(hostAddrMasked, networkAddrBytesMasked);
    }

    public static boolean isEqual(InetAddress hostAddress, InetAddress addressOnWhitelist) {
        return hostAddress.getCanonicalHostName().equals(addressOnWhitelist.getCanonicalHostName());
    }
}

