/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDUserPicker
extends HttpServlet {
    private static final long serialVersionUID = 6842235411471448500L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDUserPicker.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, User> _searchUsersSet = new HashMap<String, User>();
        String searchString = req.getParameter("username");
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchString), (int)0, (int)-1);
        try {
            List<User> list = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().searchUsers((EntityQuery<User>)query);
            for (User user : list) {
                _searchUsersSet.put(user.getName(), user);
            }
        }
        catch (OperationFailedException e1) {
            logger.error("OperationFailedException on UserPicker for searchTerm " + searchString);
        }
        catch (DirectoryNotFoundException e1) {
            logger.error("DirectoryNotFoundException on UserPicker for searchTerm " + searchString);
        }
        catch (InvalidAuthenticationException e1) {
            logger.error("InvalidAuthenticationException on UserPicker for searchTerm " + searchString);
        }
        catch (ApplicationPermissionException e1) {
            logger.error("ApplicationPermissionException on UserPicker for searchTerm " + searchString);
        }
        JSONArray json = new JSONArray();
        try {
            for (User userObject : _searchUsersSet.values()) {
                JSONObject user = new JSONObject();
                user.put("id", (Object)userObject.getName());
                user.put("text", (Object)userObject.getDisplayName());
                json.put((Object)user);
            }
            resp.setContentType("application/json");
            resp.getWriter().write(json.toString());
        }
        catch (JSONException jSONException) {
            logger.error("JSON Exception on UserPicker-Request");
        }
    }
}

