/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDGroupActivationServlet
extends HttpServlet {
    private static final long serialVersionUID = 6842235411471448500L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDGroupActivationServlet.class);
    private SecSignIDDataAccessor dataAccessor;
    JSONObject answerObject;
    HashMap<String, String> groupMappings;

    public SecSignIDGroupActivationServlet(SecSignIDDataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
    }

    @AdminOnly
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        block47: {
            this.answerObject = new JSONObject();
            User user = this.dataAccessor.getUserCurrentlyLoggedIn();
            try {
                Map map = httpServletRequest.getParameterMap();
                if (httpServletRequest.getParameter("secsignid-save-all-group") != null) {
                    Set<String> allUserGroups = this.dataAccessor.getAllUserGroupsMappingKeys();
                    for (String string : allUserGroups) {
                        String groupName = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
                        long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
                        boolean pwdAllowed = Boolean.valueOf(httpServletRequest.getParameter("pwdAllowedValue"));
                        boolean passwordlessAllowed = Boolean.valueOf(httpServletRequest.getParameter("passwordlessValue"));
                        boolean twostepAllowed = Boolean.valueOf(httpServletRequest.getParameter("twoStepValue"));
                        boolean mailotpAllowed = Boolean.valueOf(httpServletRequest.getParameter("mailotpValue"));
                        boolean totpAllowed = Boolean.valueOf(httpServletRequest.getParameter("totpValue"));
                        boolean fidoAllowed = Boolean.valueOf(httpServletRequest.getParameter("fidoValue"));
                        HashMap<String, String> allowedMapping = new HashMap<String, String>();
                        allowedMapping.put(groupName.toLowerCase().replace(" ", "___") + ";" + dirid, "activate");
                        HashMap<String, String> notAllowedMapping = new HashMap<String, String>();
                        notAllowedMapping.put(groupName.toLowerCase().replace(" ", "___") + ";" + dirid, "deactivate");
                        SecSignID2FASettings settingsToSave = new SecSignID2FASettings();
                        try {
                            if (!pwdAllowed) {
                                if (passwordlessAllowed) {
                                    settingsToSave.setPasswordlessAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                                } else {
                                    settingsToSave.setPasswordlessAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
                                }
                                if (twostepAllowed) {
                                    settingsToSave.setTwoStepAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                                } else {
                                    settingsToSave.setTwoStepAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
                                }
                                if (mailotpAllowed) {
                                    settingsToSave.setMailOtpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                                } else {
                                    settingsToSave.setMailOtpAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
                                }
                                if (totpAllowed) {
                                    settingsToSave.setTotpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                                } else {
                                    settingsToSave.setTotpAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
                                }
                                if (totpAllowed) {
                                    settingsToSave.setFidoAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                                } else {
                                    settingsToSave.setFidoAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
                                }
                            }
                            HashMap<String, SecSignID2FASettings> toSaveMappings = new HashMap<String, SecSignID2FASettings>();
                            toSaveMappings.put(groupName.toLowerCase().replace(" ", "___") + ";" + dirid, settingsToSave);
                            this.dataAccessor.save2FAGroupMappings(toSaveMappings);
                            this.dataAccessor.logGroup2FAChangeToAuditLog(groupName, dirid, pwdAllowed, passwordlessAllowed, twostepAllowed, mailotpAllowed, totpAllowed, fidoAllowed, httpServletRequest.getRemoteAddr());
                            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                                this.dataAccessor.mail2FAChangeOfGroupToInformGroup(groupName, dirid, pwdAllowed, passwordlessAllowed, twostepAllowed, mailotpAllowed, totpAllowed, fidoAllowed, this.dataAccessor.getUserCurrentlyLoggedIn().getName(), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId());
                            }
                            if (!SecSignIDCommonStaticAccessor.getInformUser()) continue;
                            this.dataAccessor.mail2FAChangeToGroupMembers(groupName, dirid);
                        }
                        catch (GroupNotFoundException e) {
                            logger.error("GroupNotFoundException on changing GroupMappings: " + e.getMessage());
                            this.answerObject.put("success", false);
                            httpServletResponse.setContentType("application/json");
                            this.answerObject.put("errorMsg", (Object)"GroupNotFoundException on changing mappings");
                            httpServletResponse.getWriter().write(this.answerObject.toString());
                            return;
                        }
                        catch (OperationFailedException e) {
                            logger.error("OperationFailedException on changing GroupMappings: " + e.getMessage());
                            this.answerObject.put("success", false);
                            httpServletResponse.setContentType("application/json");
                            this.answerObject.put("errorMsg", (Object)"OperationFailedException on changing mappings");
                            httpServletResponse.getWriter().write(this.answerObject.toString());
                            return;
                        }
                        catch (DirectoryNotFoundException e) {
                            logger.error("DirectoryNotFoundException on changing GroupMappings: " + e.getMessage());
                            this.answerObject.put("success", false);
                            httpServletResponse.setContentType("application/json");
                            this.answerObject.put("errorMsg", (Object)"DirectoryNotFoundException on changing mappings");
                            httpServletResponse.getWriter().write(this.answerObject.toString());
                            return;
                        }
                        catch (DirectoryPermissionException e) {
                            logger.error("DirectoryPermissionException on changing GroupMappings: " + e.getMessage());
                            this.answerObject.put("success", false);
                            this.answerObject.put("errorMsg", (Object)"DirectoryPermissionException on changing mappings");
                            httpServletResponse.setContentType("application/json");
                            httpServletResponse.getWriter().write(this.answerObject.toString());
                            return;
                        }
                        catch (ApplicationPermissionException e) {
                            logger.error("ApplicationPermissionException on changing GroupMappings: " + e.getMessage());
                            this.answerObject.put("success", false);
                            this.answerObject.put("errorMsg", (Object)"ApplicationPermissionException on changing mappings");
                            httpServletResponse.setContentType("application/json");
                            httpServletResponse.getWriter().write(this.answerObject.toString());
                            return;
                        }
                        catch (InvalidAuthenticationException e) {
                            logger.error("InvalidAuthenticationException on changing GroupMappings: " + e.getMessage());
                            this.answerObject.put("success", false);
                            this.answerObject.put("errorMsg", (Object)"InvalidAuthenticationException on changing mappings");
                            httpServletResponse.setContentType("application/json");
                            httpServletResponse.getWriter().write(this.answerObject.toString());
                            return;
                        }
                    }
                    this.answerObject.put("success", true);
                    httpServletResponse.setContentType("application/json");
                    httpServletResponse.getWriter().write(this.answerObject.toString());
                }
                if (httpServletRequest.getParameter("secsignid-save-auth-group") == null) break block47;
                String groupName = httpServletRequest.getParameter("groupname");
                String diridString = httpServletRequest.getParameter("dirid");
                long dirid = Long.parseLong(diridString);
                boolean pwdAllowed = Boolean.valueOf(httpServletRequest.getParameter("pwdAllowedValue"));
                boolean passwordlessAllowed = Boolean.valueOf(httpServletRequest.getParameter("passwordlessValue"));
                boolean twostepAllowed = Boolean.valueOf(httpServletRequest.getParameter("twoStepValue"));
                boolean mailotpAllowed = Boolean.valueOf(httpServletRequest.getParameter("mailotpValue"));
                boolean totpAllowed = Boolean.valueOf(httpServletRequest.getParameter("totpValue"));
                boolean fidoAllowed = Boolean.valueOf(httpServletRequest.getParameter("fidoValue"));
                SecSignID2FASettings settingsToSave = new SecSignID2FASettings();
                try {
                    if (!pwdAllowed) {
                        if (passwordlessAllowed) {
                            settingsToSave.setPasswordlessAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                        } else {
                            settingsToSave.setPasswordlessAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
                        }
                        if (twostepAllowed) {
                            settingsToSave.setTwoStepAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                        } else {
                            settingsToSave.setTwoStepAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
                        }
                        if (mailotpAllowed) {
                            settingsToSave.setMailOtpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                        } else {
                            settingsToSave.setMailOtpAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
                        }
                        if (totpAllowed) {
                            settingsToSave.setTotpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                        } else {
                            settingsToSave.setTotpAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
                        }
                        if (fidoAllowed) {
                            settingsToSave.setFidoAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                        } else {
                            settingsToSave.setFidoAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
                        }
                    }
                    HashMap<String, SecSignID2FASettings> toSaveMappings = new HashMap<String, SecSignID2FASettings>();
                    toSaveMappings.put(groupName.toLowerCase().replace(" ", "___") + ";" + dirid, settingsToSave);
                    this.dataAccessor.save2FAGroupMappings(toSaveMappings);
                    this.dataAccessor.logGroup2FAChangeToAuditLog(groupName, dirid, pwdAllowed, passwordlessAllowed, twostepAllowed, mailotpAllowed, totpAllowed, fidoAllowed, httpServletRequest.getRemoteAddr());
                    if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                        this.dataAccessor.mail2FAChangeOfGroupToInformGroup(groupName, dirid, pwdAllowed, passwordlessAllowed, twostepAllowed, mailotpAllowed, totpAllowed, fidoAllowed, this.dataAccessor.getUserCurrentlyLoggedIn().getName(), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId());
                    }
                    if (SecSignIDCommonStaticAccessor.getInformUser()) {
                        this.dataAccessor.mail2FAChangeToGroupMembers(groupName, dirid);
                    }
                    this.answerObject.put("success", true);
                    httpServletResponse.setContentType("application/json");
                    httpServletResponse.getWriter().write(this.answerObject.toString());
                }
                catch (GroupNotFoundException e) {
                    logger.error("GroupNotFoundException on changing GroupMappings: " + e.getMessage());
                    this.answerObject.put("success", false);
                    httpServletResponse.setContentType("application/json");
                    this.answerObject.put("errorMsg", (Object)"GroupNotFoundException on changing mappings");
                    httpServletResponse.getWriter().write(this.answerObject.toString());
                    return;
                }
                catch (OperationFailedException e) {
                    logger.error("OperationFailedException on changing GroupMappings: " + e.getMessage());
                    this.answerObject.put("success", false);
                    httpServletResponse.setContentType("application/json");
                    this.answerObject.put("errorMsg", (Object)"OperationFailedException on changing mappings");
                    httpServletResponse.getWriter().write(this.answerObject.toString());
                    return;
                }
                catch (DirectoryNotFoundException e) {
                    logger.error("DirectoryNotFoundException on changing GroupMappings: " + e.getMessage());
                    this.answerObject.put("success", false);
                    httpServletResponse.setContentType("application/json");
                    this.answerObject.put("errorMsg", (Object)"DirectoryNotFoundException on changing mappings");
                    httpServletResponse.getWriter().write(this.answerObject.toString());
                    return;
                }
                catch (DirectoryPermissionException e) {
                    logger.error("DirectoryPermissionException on changing GroupMappings: " + e.getMessage());
                    this.answerObject.put("success", false);
                    this.answerObject.put("errorMsg", (Object)"DirectoryPermissionException on changing mappings");
                    httpServletResponse.setContentType("application/json");
                    httpServletResponse.getWriter().write(this.answerObject.toString());
                    return;
                }
                catch (ApplicationPermissionException e) {
                    logger.error("ApplicationPermissionException on changing GroupMappings: " + e.getMessage());
                    this.answerObject.put("success", false);
                    this.answerObject.put("errorMsg", (Object)"ApplicationPermissionException on changing mappings");
                    httpServletResponse.setContentType("application/json");
                    httpServletResponse.getWriter().write(this.answerObject.toString());
                    return;
                }
                catch (InvalidAuthenticationException e) {
                    logger.error("InvalidAuthenticationException on changing GroupMappings: " + e.getMessage());
                    this.answerObject.put("success", false);
                    this.answerObject.put("errorMsg", (Object)"InvalidAuthenticationException on changing mappings");
                    httpServletResponse.setContentType("application/json");
                    httpServletResponse.getWriter().write(this.answerObject.toString());
                    return;
                }
            }
            catch (DirectoryNotFoundException map) {
            }
            catch (OperationFailedException e1) {
                logger.error("OperationFailedException on changing GroupMappings: " + e1.getMessage());
                try {
                    this.answerObject.put("success", false);
                    httpServletResponse.setContentType("application/json");
                    this.answerObject.put("errorMsg", (Object)"DirectoryNotFoundException on changing mappings");
                    httpServletResponse.getWriter().write(this.answerObject.toString());
                    return;
                }
                catch (JSONException e) {
                    logger.error("JSON ERROR ON GROUPACTIVATIONSERVLET SENDING ERROR: " + e.getMessage());
                }
            }
            catch (JSONException e) {
                logger.error("JSON ERROR ON GROUPACTIVATIONSERVLET: " + e.getMessage());
            }
        }
    }
}

