/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.data.SecSignIDTrustDeviceToken;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenAuthorizationRequest;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenAuthorizationResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenFIDORequest;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenInfoResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenRequest;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenTOTPRequest;
import com.secsign.atlassian.common.rest.SecSignIDRESTAuthenticationMethod;
import com.secsign.atlassian.common.rest.SecSignIDRESTCheckAuthSessionStateResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTCreateAuthSessionResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTCreateQRCodeResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTCreateSecSignIDResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTDevicesResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import com.secsign.atlassian.common.rest.SecSignIDRESTFIDOAuthenticateStartResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTFIDORegisterStartResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTRestorationResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTTOTPResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTVerifyMailCodeResponse;
import com.secsign.atlassian.common.rest.SecSignIDServerRESTConnector;
import com.secsign.atlassian.common.util.SecSignIDAuthenticationUtil;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDHttpSessionUtil;
import com.secsign.atlassian.common.util.SecSignIDIPHelper;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class SecSignIDAuthenticator
extends HttpServlet {
    private static final long serialVersionUID = 4925328498249464512L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDAuthenticator.class);
    private static final String AUTH_SESSION_ID_KEY = "authenticator.authsession.id";
    private static final String AUTH_SESSION_ICON_KEY = "authenticator.authsession.icon";
    private static final String AUTH_SESSION_SECSIGN_ID_KEY = "authenticator.authsession.secsignid";
    private static final String AUTH_SESSION_USERNAME_KEY = "authenticator.authsession.username";
    private static final String AUTH_SESSION_STATE_KEY = "authenticator.authsession.state";
    private static final String SECSIGN_ID_KEY = "authenticator.secsignid";
    private static final String TWO_STEP_AUTHORIZATION_KEY = "authenticator.twostepauthorization";
    private static final String ACCESS_TOKEN_AUTHORIZATION_ID_KEY = "authenticator.accesstokenauthorizationid";
    private static final String ACCESS_TOKEN_KEY = "authenticator.accesstoken";
    private static final String TWO_STEP_KEY = "id";
    private static final String TOTP_KEY = "totp";
    private static final String MAIL_OTP_KEY = "mail-otp";
    public static final String SECSIGNID_AUTHENTICATOR = "seraph_secsignid_authenticator_user";
    private static final String FIDO_KEY = "fido";
    private final TemplateRenderer templateRenderer;
    private SecSignIDDataAccessor dataAccessor;
    private HashMap<String, String> tempMappings;
    private boolean safeZone;
    private boolean noAccesspass;
    private boolean customLogin;
    private boolean publicMode;

    public SecSignIDAuthenticator(TemplateRenderer templateRenderer, SecSignIDDataAccessor dataAccessor) {
        this.templateRenderer = templateRenderer;
        this.dataAccessor = dataAccessor;
        this.tempMappings = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOpenServiceDesk(HttpServletRequest httpServletReq) {
        if (this.dataAccessor.isJira7OrJira8()) {
            String jiraBaseUrl = this.dataAccessor.getBaseUrl();
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            try {
                HttpGet httpGet = new HttpGet(jiraBaseUrl + "/rest/servicedesk/1/customer/pages/user/login");
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                boolean bl = content.contains("sdUserSignUpEnabled&quot;:true");
                return bl;
            }
            catch (IOException e) {
                logger.error(e.getClass().getName() + " at isOpenServiceDesk: " + e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                try {
                    httpClient.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    @UnrestrictedAccess
    protected void doGet(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        HashMap<String, Object> context = this.dataAccessor.getAuthenticatorContextMap(httpServletReq);
        String returnUrl = httpServletReq.getParameter("returnUrl");
        context.put("req", new HttpServletRequestWrapper(httpServletReq));
        if (returnUrl != null) {
            if (returnUrl.contains("servicedesk")) {
                context.put("isServiceDesk", Boolean.TRUE);
                context.put("isOpen", this.isOpenServiceDesk(httpServletReq));
            } else {
                context.put("isServiceDesk", Boolean.FALSE);
                context.put("isOpen", this.isOpenServiceDesk(httpServletReq));
            }
        } else {
            context.put("isServiceDesk", Boolean.FALSE);
            context.put("isOpen", Boolean.FALSE);
        }
        this.publicMode = this.dataAccessor.isJiraPublicMode();
        context.put("publicMode", this.publicMode);
        context.put("secsignServletPath", "/plugins/servlet/secsignid");
        context.put("hidePasswordlessLink", !SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled());
        logger.debug("httpServletReq.getPathInfo()=" + httpServletReq.getPathInfo());
        logger.debug("parameter [get]: " + SecSignIDMappingUtils.toString(httpServletReq.getParameterMap()));
        logger.debug("header [get]: " + SecSignIDMappingUtils.headerToString(httpServletReq));
        httpServletResp.setContentType("text/html;charset=utf-8");
        this.getOptions(httpServletReq, context);
        if (httpServletReq.getParameter("create_success") != null) {
            context.put("warnmsg", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.signup.success"));
        }
        this.renderLogin(httpServletReq, httpServletResp, context);
    }

    @UnrestrictedAccess
    protected void doPost(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        boolean changeMethod;
        httpServletResp.setContentType("text/html;charset=utf-8");
        HashMap<String, Object> context = this.dataAccessor.getAuthenticatorContextMap(httpServletReq);
        this.publicMode = this.dataAccessor.isJiraPublicMode();
        context.put("publicMode", this.publicMode);
        context.put("req", new HttpServletRequestWrapper(httpServletReq));
        context.put("returnUrl", httpServletReq.getParameter("returnUrl"));
        String returnUrl = httpServletReq.getParameter("returnUrl");
        if (returnUrl != null) {
            if (returnUrl.contains("servicedesk")) {
                context.put("isServiceDesk", Boolean.TRUE);
                context.put("isOpen", this.isOpenServiceDesk(httpServletReq));
            } else {
                context.put("isServiceDesk", Boolean.FALSE);
                context.put("isOpen", this.isOpenServiceDesk(httpServletReq));
            }
        } else {
            context.put("isServiceDesk", Boolean.FALSE);
            context.put("isOpen", Boolean.FALSE);
        }
        logger.debug("httpServletReq.getPathInfo()=" + httpServletReq.getPathInfo());
        logger.debug("parameter [post]: " + SecSignIDMappingUtils.toString(httpServletReq.getParameterMap()));
        logger.debug("header [post]: " + SecSignIDMappingUtils.headerToString(httpServletReq));
        this.getOptions(httpServletReq, context);
        boolean bl = changeMethod = httpServletReq.getParameter("changeMethod") != null;
        if (changeMethod) {
            this.handleMethodSelection(httpServletReq, httpServletResp, null, null, context);
            return;
        }
        if (httpServletReq.getParameter("id-dialog-qr") != null) {
            this.handleQR(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("id-dialog-qr-create") != null) {
            this.handleQR(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("id-dialog") != null) {
            this.handleDialog(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("mail-login-button") != null) {
            this.handleMailLogin(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("otp-login-button") != null) {
            this.handleTOTPLogin(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("method-selection-button") != null) {
            this.handleMethodSelection(httpServletReq, httpServletResp, null, null, context);
            return;
        }
        if (this.safeZone && this.checkRemoteAddressInSafeZone(httpServletReq)) {
            context.put("safeZone", Boolean.TRUE);
        }
        if (httpServletReq.getParameter("show-standard-login") != null) {
            this.handleStandardLogin(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("secsignid-login") != null) {
            this.handleSecSignLogin(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("secsignid-cancel-button") != null) {
            this.handleCancelSecSign(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("secsignid-handleerror") != null) {
            this.handleError(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("secsignid-checkauthsession") != null) {
            this.handleCheckAuth(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("secsignid-handlesessionstate") != null) {
            this.handleSessionState(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("execute-mail-login") != null) {
            this.handleExecuteMailLogin(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("execute-mail-login-error") != null) {
            this.handleExecuteMailLoginError(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("fidoStartRegister") != null) {
            this.handleFIDORegisterStart(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("fidoFinishRegister") != null) {
            this.handleFIDORegisterFinish(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("fidoStartAuthenticate") != null) {
            this.handleFIDOAuthenticateStart(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("fidoFinishAuthenticate") != null) {
            this.handleFIDOAuthenticateFinish(httpServletReq, httpServletResp, context);
            return;
        }
        this.renderLogin(httpServletReq, httpServletResp, context);
    }

    private void getOptions(HttpServletRequest request, HashMap<String, Object> context) {
        String customLogo;
        this.safeZone = SecSignIDCommonStaticAccessor.getSafeZone();
        this.noAccesspass = SecSignIDCommonStaticAccessor.getNoAccessPass();
        context.put("noAccesspass", this.noAccesspass);
        this.customLogin = SecSignIDCommonStaticAccessor.getCustomLogin();
        context.put("customLogin", this.customLogin);
        if (this.customLogin) {
            String loginColor = SecSignIDCommonStaticAccessor.getLoginColor();
            context.put("loginColor", loginColor);
        }
        if ((customLogo = SecSignIDCommonStaticAccessor.getCustomLogo()) != null && !customLogo.equals("")) {
            context.put("customLogo", Boolean.TRUE);
            context.put("customLogoData", customLogo);
        } else {
            context.put("customLogo", Boolean.FALSE);
        }
        String title = SecSignIDCommonStaticAccessor.getLoginTitle();
        String subtitle = SecSignIDCommonStaticAccessor.getLoginSubtitle();
        String customLink = SecSignIDCommonStaticAccessor.getCustomLink();
        String customLinkText = SecSignIDCommonStaticAccessor.getCustomLinkText();
        context.put("title", title);
        context.put("subtitle", subtitle);
        context.put("customLink", customLink);
        context.put("customLinkText", customLinkText);
        String iOSUrl = SecSignIDCommonStaticAccessor.getIOSUrl();
        String androidUrl = SecSignIDCommonStaticAccessor.getAndroidUrl();
        String windowsUrl = SecSignIDCommonStaticAccessor.getWindowsUrl();
        String macOSUrl = SecSignIDCommonStaticAccessor.getMacOSUrl();
        context.put("iosUrl", iOSUrl);
        context.put("androidUrl", androidUrl);
        context.put("windowsUrl", windowsUrl);
        context.put("macUrl", macOSUrl);
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(request);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(request, this.dataAccessor);
        boolean otpActive = false;
        if (user != null) {
            try {
                SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(request, userKey, user.getDirectoryId());
                otpActive = activatedSettings.isTotpActive() || activatedSettings.isMailOtpActive();
                String selectedInactiveMethod = this.dataAccessor.getMethodToActivate(userKey, user.getDirectoryId());
                if (selectedInactiveMethod != null && !selectedInactiveMethod.equals("none") && !selectedInactiveMethod.equals("")) {
                    context.put("activatingMethod", Boolean.TRUE);
                }
            }
            catch (com.atlassian.crowd.exception.OperationFailedException e) {
                logger.error("OperationFailedException on getTOTPActiveForUserKey/getMailOTPActiveForUserKey on getOptions");
            }
            catch (ApplicationPermissionException e) {
                logger.error("ApplicationPermissionException on getTOTPActiveForUserKey/getMailOTPActiveForUserKey on getOptions");
            }
            catch (InvalidAuthenticationException e) {
                logger.error("InvalidAuthenticationException on getTOTPActiveForUserKey/getMailOTPActiveForUserKey on getOptions");
            }
            catch (SecSignIDRESTException e) {
                logger.error("SecSignIDRESTException on getTOTPActiveForUserKey/getMailOTPActiveForUserKey on getOptions");
            }
            catch (UserNotFoundException e) {
                logger.error("UserNotFoundException on getTOTPActiveForUserKey/getMailOTPActiveForUserKey on getOptions");
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on getTOTPActiveForUserKey/getMailOTPActiveForUserKey on getOptions");
            }
            catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
                logger.error("runtime.UserNotFoundException on getTOTPActiveForUserKey/getMailOTPActiveForUserKey on getOptions");
            }
        }
        boolean allowUserCreate = SecSignIDCommonStaticAccessor.getAllowUserCreate() && !otpActive;
        boolean allowUserExisting = SecSignIDCommonStaticAccessor.getAllowUserExisting() && !otpActive;
        context.put("allowUserCreate", allowUserCreate);
        context.put("allowUserExisting", allowUserExisting);
        boolean trustDeviceAllowed = SecSignIDCommonStaticAccessor.getTrustDeviceEnabled();
        context.put("trustDeviceAllowed", trustDeviceAllowed);
        context.put("secsignServletPath", "/plugins/servlet/secsignid");
        context.put("isNewLayout", this.dataAccessor.isNewCrowd());
        context.put("resetOnCrowd", SecSignIDCommonStaticAccessor.getResetOnCrowd());
        context.put("crowdForgetUrl", SecSignIDCommonStaticAccessor.getCrowdBaseUrl());
        context.put("isAdFree", SecSignIDCommonStaticAccessor.getIsAdFree());
    }

    private void handleMailLogin(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException {
        block19: {
            if (!this.canActivateMailOtp(httpServletReq)) {
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            HttpSession session = httpServletReq.getSession();
            String secSignID = (String)SecSignIDHttpSessionUtil.getAttribute(session, SECSIGN_ID_KEY);
            context.put("secSignID", secSignID);
            String mailCode = httpServletReq.getParameter("mailCode");
            String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(httpServletReq);
            User appUser = SecSignIDAuthenticationUtil.getUserFromRequest(httpServletReq, this.dataAccessor);
            if (appUser == null) {
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            try {
                this.fillContextWithAllowedOptions(httpServletReq, userKey, appUser.getDirectoryId(), context);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.user.nologin", null, context);
                return;
            }
            if (mailCode == null || mailCode.length() == 0) {
                this.addErrorToContext("secsignid.messages.error.mail.wrong", null, context);
                this.templateRenderer.render(this.getMailLoginTemplate(), context, (Writer)httpServletResp.getWriter());
                return;
            }
            try {
                SecSignIDRESTVerifyMailCodeResponse verifyMailCodeResponse = SecSignIDServerRESTConnector.verifyMailCode(secSignID, mailCode);
                if (verifyMailCodeResponse.getExists() && verifyMailCodeResponse.getValid()) {
                    if (appUser != null) {
                        this.dataAccessor.deleteUserCreated(appUser.getName());
                        if (this.handleActivatingInactiveMethod(httpServletReq, httpServletResp, MAIL_OTP_KEY, context)) {
                            return;
                        }
                        if (this.loginApplicationUser(appUser, httpServletReq, httpServletResp)) {
                            SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(httpServletReq, userKey, appUser.getDirectoryId());
                            boolean before = activatedSettings.isMailOtpActive();
                            activatedSettings.setMailOtpActive(true);
                            this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, appUser.getDirectoryId(), activatedSettings);
                            if (!before) {
                                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                                    this.dataAccessor.mailActivateMailOTPToUser(userKey, appUser.getDirectoryId());
                                }
                                this.dataAccessor.logActivateMailOTP(userKey, appUser.getDirectoryId(), httpServletReq.getRemoteAddr());
                                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, appUser.getDirectoryId()))) {
                                    this.dataAccessor.mailActivateMailOTPToInformGroup(userKey, appUser.getDirectoryId());
                                }
                            }
                            if (httpServletReq.getHeader("X-Forwarded-For") != null) {
                                Object[] clientIpAddresses = httpServletReq.getHeader("X-Forwarded-For").split(",");
                                this.dataAccessor.saveIPForUserKey(userKey, appUser.getDirectoryId(), "IP: " + httpServletReq.getRemoteAddr() + " Forwarded-For:" + SecSignIDMappingUtils.arrayToString(clientIpAddresses));
                            } else {
                                this.dataAccessor.saveIPForUserKey(userKey, appUser.getDirectoryId(), httpServletReq.getRemoteAddr());
                            }
                            this.dataAccessor.saveLastMethodUsed(userKey, appUser.getDirectoryId(), MAIL_OTP_KEY);
                            this.dataAccessor.deleteUserCreated(userKey);
                            this.clearAllSettingsFromSession(httpServletReq, userKey, appUser.getDirectoryId());
                            this.createTrustDeviceTokenIfActive(userKey, appUser.getDirectoryId(), httpServletReq, httpServletResp);
                            if (!this.handleSAMLLogin(httpServletReq, httpServletResp)) {
                                this.sendRedirect(httpServletReq, httpServletResp);
                                return;
                            }
                            logger.debug("Processed SAML Request. Redirect to SAML Service Provider.");
                            return;
                        }
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.login.contact.admin", null, context);
                        return;
                    }
                    break block19;
                }
                if (verifyMailCodeResponse.getExists()) {
                    this.addErrorToContext("secsignid.messages.error.mail.wrong", null, context);
                    this.templateRenderer.render(this.getMailLoginTemplate(), context, (Writer)httpServletResp.getWriter());
                    break block19;
                }
                this.addErrorToContext("secsignid.messages.error.mail.notexist", null, context);
                this.templateRenderer.render(this.getMailLoginTemplate(), context, (Writer)httpServletResp.getWriter());
                return;
            }
            catch (SecSignIDRESTException e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
                return;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
        }
    }

    private void handleTOTPLogin(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException {
        block34: {
            User appUser;
            String userKey;
            String otpCode;
            String secSignID;
            block33: {
                boolean activatingOtherMethod;
                if (!this.canActivateTOTP(httpServletReq)) {
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                    return;
                }
                HttpSession session = httpServletReq.getSession();
                secSignID = (String)SecSignIDHttpSessionUtil.getAttribute(session, SECSIGN_ID_KEY);
                context.put("secSignID", secSignID);
                otpCode = httpServletReq.getParameter("otpCode");
                userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(httpServletReq);
                appUser = SecSignIDAuthenticationUtil.getUserFromRequest(httpServletReq, this.dataAccessor);
                if (appUser == null) {
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                    return;
                }
                try {
                    this.fillContextWithAllowedOptions(httpServletReq, userKey, appUser.getDirectoryId(), context);
                }
                catch (Exception e) {
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.user.nologin", null, context);
                    return;
                }
                context.put("username", appUser.getName());
                try {
                    SecSignIDRESTAuthenticationMethod methodToActivate = this.getAuthenticationMethodFromMethodToActivate(userKey, appUser.getDirectoryId());
                    activatingOtherMethod = methodToActivate != SecSignIDRESTAuthenticationMethod.UNKNOWN && methodToActivate != SecSignIDRESTAuthenticationMethod.TOTP;
                }
                catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | UserNotFoundException e) {
                    logger.error(e.getMessage(), e);
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                    return;
                }
                if (!this.canActivateTOTP(httpServletReq) && !activatingOtherMethod) {
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                    return;
                }
                try {
                    boolean totpActive = this.get2FAActivatedSettingsFromUserKey(httpServletReq, userKey, appUser.getDirectoryId()).isTotpActive();
                    if (totpActive || activatingOtherMethod) break block33;
                    String totpQRCode = httpServletReq.getParameter("totpQRCode");
                    String totpQRUrl = httpServletReq.getParameter("totpQRUrl");
                    if (totpQRCode == null || totpQRUrl == null) break block33;
                    try {
                        context.put("totpQRCode", totpQRCode);
                        context.put("totpQRUrl", totpQRUrl);
                        String toExtract = totpQRUrl;
                        int startIndex = toExtract.indexOf("secret=") + 7;
                        int endIndex = toExtract.indexOf("&", startIndex);
                        String secret = toExtract.substring(startIndex, endIndex);
                        context.put("totpQRSecret", secret);
                    }
                    catch (IndexOutOfBoundsException e) {
                        logger.error("SecSignIDRESTException on getTOTPQRCode: No Code found, Server not ready?");
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
                        return;
                    }
                }
                catch (com.atlassian.crowd.exception.OperationFailedException e1) {
                    logger.error("OperationFailedException on getTOTPActiveForUserKey on handleTOTPLogin");
                }
                catch (ApplicationPermissionException e1) {
                    logger.error("ApplicationPermissionException on getTOTPActiveForUserKey on handleTOTPLogin");
                }
                catch (InvalidAuthenticationException e1) {
                    logger.error("InvalidAuthenticationException on getTOTPActiveForUserKey on handleTOTPLogin");
                }
                catch (SecSignIDRESTException e) {
                    logger.error("SecSignIDRESTException on on getTOTPActiveForUserKey on handleTOTPLogin");
                }
                catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e1) {
                    logger.error("runtime.UserNotFoundException on on getTOTPActiveForUserKey on handleTOTPLogin");
                }
                catch (UserNotFoundException e) {
                    logger.error("UserNotFoundException on on getTOTPActiveForUserKey on handleTOTPLogin");
                }
                catch (DirectoryNotFoundException e) {
                    logger.error("DirectoryNotFoundException on on getTOTPActiveForUserKey on handleTOTPLogin");
                }
            }
            if (otpCode == null || otpCode.length() == 0) {
                context.put("secSignID", secSignID);
                this.addErrorToContext("secsignid.messages.error.mail.wrong", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.otp.wrong"), context);
                this.templateRenderer.render(this.getTOTPLoginTemplate(), context, (Writer)httpServletResp.getWriter());
                return;
            }
            try {
                boolean result;
                SecSignIDRESTAuthenticationMethod methodToActivate = this.getAuthenticationMethodFromMethodToActivate(userKey, appUser.getDirectoryId());
                boolean accessTokenRequired = SecSignIDAuthenticationUtil.isAccessTokenRequiredForActivation(secSignID, methodToActivate);
                if (accessTokenRequired) {
                    this.requestAccessTokenAuthorization(httpServletReq, secSignID, SecSignIDRESTAuthenticationMethod.TOTP, methodToActivate);
                    result = this.requestAccessTokenForTOTPAuthentication(httpServletReq, otpCode);
                } else {
                    result = SecSignIDServerRESTConnector.verifyOTPCode(secSignID, otpCode);
                }
                if (result) {
                    if (appUser != null) {
                        this.dataAccessor.deleteUserCreated(appUser.getName());
                        if (this.handleActivatingInactiveMethod(httpServletReq, httpServletResp, TOTP_KEY, context)) {
                            return;
                        }
                        if (this.loginApplicationUser(appUser, httpServletReq, httpServletResp)) {
                            SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(httpServletReq, userKey, appUser.getDirectoryId());
                            boolean before = activatedSettings.isTotpActive();
                            activatedSettings.setTotpActive(true);
                            this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, appUser.getDirectoryId(), activatedSettings);
                            if (!before) {
                                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                                    this.dataAccessor.mailActivateTOTPToUser(userKey, appUser.getDirectoryId());
                                }
                                this.dataAccessor.logActivateTOTP(userKey, appUser.getDirectoryId(), httpServletReq.getRemoteAddr());
                                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, appUser.getDirectoryId()))) {
                                    this.dataAccessor.mailActivateTOTPToInformGroup(userKey, appUser.getDirectoryId());
                                }
                            }
                            if (httpServletReq.getHeader("X-Forwarded-For") != null) {
                                Object[] clientIpAddresses = httpServletReq.getHeader("X-Forwarded-For").split(",");
                                this.dataAccessor.saveIPForUserKey(userKey, appUser.getDirectoryId(), "IP: " + httpServletReq.getRemoteAddr() + " Forwarded-For:" + SecSignIDMappingUtils.arrayToString(clientIpAddresses));
                            } else {
                                this.dataAccessor.saveIPForUserKey(userKey, appUser.getDirectoryId(), httpServletReq.getRemoteAddr());
                            }
                            this.dataAccessor.saveLastMethodUsed(userKey, appUser.getDirectoryId(), TOTP_KEY);
                            this.dataAccessor.deleteUserCreated(userKey);
                            this.clearAllSettingsFromSession(httpServletReq, userKey, appUser.getDirectoryId());
                            this.createTrustDeviceTokenIfActive(userKey, appUser.getDirectoryId(), httpServletReq, httpServletResp);
                            if (!this.handleSAMLLogin(httpServletReq, httpServletResp)) {
                                this.sendRedirect(httpServletReq, httpServletResp);
                                return;
                            }
                            logger.debug("Processed SAML Request. Redirect to SAML Service Provider.");
                            return;
                        }
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.login.contact.admin", null, context);
                        return;
                    }
                    break block34;
                }
                this.addErrorToContext("secsignid.messages.error.mail.wrong", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.otp.wrong"), context);
                this.templateRenderer.render(this.getTOTPLoginTemplate(), context, (Writer)httpServletResp.getWriter());
                return;
            }
            catch (SecSignIDRESTException e) {
                logger.error(e.getMessage(), (Throwable)e);
                logger.error("SecSignIDRESTException on Mail Login on Authenticator: " + e.getMessage());
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
                return;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                logger.error("Exception on Mail Login on Authenticator: " + e.getMessage());
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
        }
    }

    private void handleSecSignLogin(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException {
        logger.debug("Handle SecSign Login");
        String secSignId = httpServletReq.getParameter("secsignid");
        boolean secSignIdCheckSuccessFull = true;
        if (secSignId == null || secSignId.length() < 1) {
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.nosecsignid", null, context);
            logger.debug("No SecsignID entered on SecSign Login");
            secSignIdCheckSuccessFull = false;
            return;
        }
        if (SecSignIDCommonStaticAccessor.secSignIdContainsIllegalCharacters(secSignId)) {
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.illegalcharacters", null, context);
            secSignIdCheckSuccessFull = false;
            logger.error("Cannot request authentication session for '" + secSignId + "' because the secsign contains illegal characters.");
            return;
        }
        User user = null;
        String userKey = null;
        try {
            SecSignID2FASettings settingsForUser;
            Integer pwdlessAllowed;
            String mappingKey = this.dataAccessor.getMappingKeyForSecSignID(secSignId);
            userKey = SecSignIDMappingUtils.getUserKeyFromMappingKey(mappingKey);
            if (userKey != null) {
                user = this.dataAccessor.getUserForKeyFirst(userKey);
            }
            if ((pwdlessAllowed = (settingsForUser = this.get2FASettingsFromUserKey(httpServletReq, userKey, user.getDirectoryId())).getPasswordlessAllowed()).equals(SecSignIDCommonConstants.AuthIsNotAllowed)) {
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.login.pwdless.not.allowed", null, context);
                return;
            }
            SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(httpServletReq, userKey, user.getDirectoryId());
            if (!activatedSettings.isTwoStepActive()) {
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.id.not.yet.configured", null, context);
                return;
            }
        }
        catch (Exception e) {
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            logger.error("Exception on SecSignLogin " + e.getMessage());
            return;
        }
        if (user != null && !user.isActive()) {
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.noactiveuser", null, context);
            secSignIdCheckSuccessFull = false;
            logger.error("Cannot request authentication session for '" + secSignId + "' because the jira user with the assigned secsign id is not active.");
            return;
        }
        if (!secSignIdCheckSuccessFull) {
            this.renderLogin(httpServletReq, httpServletResp, context);
            return;
        }
        context.put("idLogin", Boolean.TRUE);
        this.startAuth(httpServletReq, httpServletResp, secSignId, user.getName(), userKey, user.getDirectoryId(), context);
    }

    private String getUsernameFromRequest(HttpServletRequest httpServletReq) {
        String username = httpServletReq.getParameter("secsign_os_username").toLowerCase();
        return username;
    }

    private void renderLogin(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws RenderingException, IOException {
        HttpSession session = httpServletReq.getSession();
        if (this.safeZone && this.checkRemoteAddressInSafeZone(httpServletReq)) {
            this.templateRenderer.render(this.getSafeZoneLoginTemplate(), context, (Writer)httpServletResp.getWriter());
            return;
        }
        String authSessionId = (String)SecSignIDHttpSessionUtil.getAttribute(session, AUTH_SESSION_ID_KEY);
        if (authSessionId != null) {
            context.put("authsessionicondata", SecSignIDHttpSessionUtil.getAttribute(session, AUTH_SESSION_ICON_KEY));
            context.put("secsignid", SecSignIDHttpSessionUtil.getAttribute(session, AUTH_SESSION_SECSIGN_ID_KEY));
            context.put("req", httpServletReq);
            this.templateRenderer.render(this.getAccesspassTemplate(), context, (Writer)httpServletResp.getWriter());
            return;
        }
        this.templateRenderer.render(this.getBothLoginTemplate(), context, (Writer)httpServletResp.getWriter());
    }

    private void renderLoginWithError(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, String errorMessageKey, String errorMessage, HashMap<String, Object> context) throws RenderingException, IOException {
        this.addErrorToContext(errorMessageKey, errorMessage, context);
        this.renderLogin(httpServletReq, httpServletResp, context);
    }

    private void fillContextWithAllowedOptions(HttpServletRequest httpServletRequest, String userKey, long directoryID, HashMap<String, Object> contextToFill) throws UserNotFoundException, com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, DirectoryNotFoundException, SecSignIDRESTException {
        SecSignID2FASettings settingsForUser = this.get2FASettingsFromUserKey(httpServletRequest, userKey, directoryID);
        boolean passwordlessEnabled = settingsForUser.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean twoStepAllowed = settingsForUser.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean totpAllowed = settingsForUser.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean mailotpAllowed = settingsForUser.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean fidoAllowed = settingsForUser.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.isFIDOSupported();
        SecSignID2FAActivatedSettings activatedSettingsForUser = this.get2FAActivatedSettingsFromUserKey(httpServletRequest, userKey, directoryID);
        boolean usedTOTPBefore = activatedSettingsForUser.isTotpActive();
        contextToFill.put("usedTOTPBefore", usedTOTPBefore);
        if (contextToFill.containsKey("idLogin")) {
            contextToFill.put("changeAllowed", Boolean.FALSE);
        } else if (!(passwordlessEnabled || !twoStepAllowed || totpAllowed || mailotpAllowed || fidoAllowed)) {
            contextToFill.put("changeAllowed", Boolean.FALSE);
        } else if (!(passwordlessEnabled || twoStepAllowed || !totpAllowed || mailotpAllowed || fidoAllowed)) {
            contextToFill.put("changeAllowed", Boolean.FALSE);
        } else if (!(passwordlessEnabled || twoStepAllowed || totpAllowed || !mailotpAllowed || fidoAllowed)) {
            contextToFill.put("changeAllowed", Boolean.FALSE);
        } else if (!(passwordlessEnabled || twoStepAllowed || totpAllowed || mailotpAllowed || !fidoAllowed)) {
            contextToFill.put("changeAllowed", Boolean.FALSE);
        } else if (!(!passwordlessEnabled || twoStepAllowed || totpAllowed || mailotpAllowed || fidoAllowed)) {
            contextToFill.put("changeAllowed", Boolean.FALSE);
        } else {
            contextToFill.put("changeAllowed", Boolean.TRUE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleStandardLogin(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException {
        logger.debug("handle Standard Login");
        String username = this.getUsernameFromRequest(httpServletReq);
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        logger.debug("username for standard login is " + username + " and userkey is " + userKey);
        if (userKey == null) {
            logger.debug("auth user without finding userkey to check for delegated Authenticator with username " + username);
            String result = this.dataAccessor.loginWithUsernameAndPassword(httpServletReq, httpServletResp, this.getServletContext());
            if (result == null) {
                logger.debug("No username entered");
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.nousername", null, context);
                return;
            }
            logger.debug("result is " + result);
            if (!result.equals("success")) {
                logger.debug("Wrong username/password");
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.wronguserpwd", null, context);
                return;
            }
            userKey = this.dataAccessor.getUserKeyForUsername(username);
            logger.debug("username for standard login is " + username + " and userkey is " + userKey);
            if (!this.dataAccessor.logoutUser(httpServletReq, httpServletResp)) {
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.login.contact.admin", null, context);
                return;
            }
        }
        User user = null;
        try {
            user = this.dataAccessor.getUserForKeyFirst(userKey);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        if (user == null) {
            logger.debug("User " + username + " does not exist");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.wronguserpwd", null, context);
            return;
        }
        logger.debug("user for standard login is " + user.toString());
        try {
            this.dataAccessor.saveMethodToActivate(userKey, user.getDirectoryId(), "");
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e1) {
            logger.error("OperationFailedException on saveMethodToActivate on handleStandardLogin");
        }
        catch (DirectoryPermissionException e1) {
            logger.error("DirectoryPermissionException on saveMethodToActivate on handleStandardLogin");
        }
        catch (ApplicationPermissionException e1) {
            logger.error("ApplicationPermissionException on saveMethodToActivate on handleStandardLogin");
        }
        catch (InvalidAuthenticationException e1) {
            logger.error("InvalidAuthenticationException on saveMethodToActivate on handleStandardLogin");
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on saveMethodToActivate on handleStandardLogin");
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on saveMethodToActivate on handleStandardLogin");
        }
        logger.debug("check for SafeZone for username " + username);
        if (this.safeZone && httpServletReq.getParameter("isSafeLogin") != null) {
            logger.debug("is SafeZone for username " + username);
            this.handleSafeZoneLogin(httpServletReq, httpServletResp, context);
            return;
        }
        logger.debug("is not SafeZone for username " + username);
        SecSignID2FASettings settingsForUser = null;
        logger.debug("get 2FAsettings for username " + username);
        try {
            settingsForUser = this.get2FASettingsFromUserKey(httpServletReq, userKey, user.getDirectoryId());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        logger.debug("settings for username " + username + ":" + settingsForUser.toString());
        SecSignIDTrustDeviceToken trustDeviceToken = this.getTrustDeviceTokenFromRequest(userKey, user.getDirectoryId(), httpServletReq);
        if (settingsForUser.getPwdAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) || trustDeviceToken != null && SecSignIDCommonStaticAccessor.getTrustDeviceEnabled()) {
            logger.debug("login with username and password allowed for username " + username);
            String result = this.dataAccessor.loginWithUsernameAndPassword(httpServletReq, httpServletResp, this.getServletContext());
            logger.debug("result for login with username and password is:  " + result);
            this.handleFilterResultJira(httpServletReq, httpServletResp, result, context);
            logger.debug("handleFilterResult done");
            return;
        }
        String result = this.dataAccessor.checkLoginWithUsernameAndPassword(httpServletReq, httpServletResp, this.getServletContext());
        if (!result.equals("success") && !result.equals("OK")) {
            if (result.equals("auth_error_type")) {
                this.handleFilterResultJira(httpServletReq, httpServletResp, result, context);
                return;
            }
            result = "failed";
            this.handleFilterResultJira(httpServletReq, httpServletResp, result, context);
            return;
        }
        HttpSession session = httpServletReq.getSession();
        SecSignIDHttpSessionUtil.setUserMappingKey(session, userKey + ":" + user.getDirectoryId());
        SecSignIDHttpSessionUtil.setUsername(session, username);
        boolean twoStepEnabled = settingsForUser.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) || settingsForUser.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean totpEnabled = settingsForUser.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean mailOtpEnabled = settingsForUser.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean fidoEnabled = settingsForUser.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.isFIDOSupported();
        SecSignID2FAActivatedSettings activatedSettings = null;
        try {
            boolean canSelectedMailOtp;
            activatedSettings = this.get2FAActivatedSettingsFromUserKey(httpServletReq, userKey, user.getDirectoryId());
            boolean twoStepActive = activatedSettings.isTwoStepActive();
            boolean totpActive = activatedSettings.isTotpActive();
            boolean mailOtpActive = activatedSettings.isMailOtpActive();
            boolean fidoActive = activatedSettings.isFidoActive();
            boolean firstMethod = !(twoStepActive && twoStepEnabled || totpActive && totpEnabled || fidoActive && fidoEnabled || mailOtpActive && mailOtpEnabled);
            boolean canSelectedTwoStep = twoStepEnabled && (firstMethod || twoStepActive);
            boolean canSelectedTotp = totpEnabled && (firstMethod || totpActive);
            boolean canSelectedFIDO = fidoEnabled && (firstMethod || fidoActive);
            boolean bl = canSelectedMailOtp = mailOtpEnabled && (firstMethod || mailOtpActive);
            if (!(twoStepEnabled || totpEnabled || fidoEnabled || mailOtpEnabled)) {
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.user.nologin", null, context);
                return;
            }
            if (twoStepEnabled && !totpEnabled && !mailOtpEnabled && !fidoEnabled) {
                this.handleTwoStepAuth(httpServletReq, httpServletResp, user, userKey, context);
                return;
            }
            if (!twoStepEnabled && totpEnabled && !mailOtpEnabled && !fidoEnabled) {
                this.handleTwoStepOTPAuth(httpServletReq, httpServletResp, user, userKey, context);
                return;
            }
            if (!twoStepEnabled && !totpEnabled && mailOtpEnabled && !fidoEnabled) {
                this.handleTwoStepMailAuth(httpServletReq, httpServletResp, user, userKey, context);
                return;
            }
            if (!twoStepEnabled && !totpEnabled && !mailOtpEnabled && fidoEnabled) {
                this.handleTwoStepFIDOAuth(httpServletReq, httpServletResp, user, userKey, context);
                return;
            }
            if (!(twoStepEnabled || totpEnabled || mailOtpEnabled || fidoEnabled)) {
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.loginwithid", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.loginwithid"), context);
                return;
            }
            int methodsEnabled = (twoStepEnabled ? 1 : 0) + (totpEnabled ? 1 : 0) + (mailOtpEnabled ? 1 : 0) + (fidoEnabled ? 1 : 0);
            int methodsActive = (twoStepActive ? 1 : 0) + (totpActive ? 1 : 0) + (mailOtpActive ? 1 : 0) + (fidoActive ? 1 : 0);
            String lastMethodUsed = this.dataAccessor.getLastMethodUsed(userKey, user.getDirectoryId());
            if (lastMethodUsed != null) {
                if (lastMethodUsed.equals(TWO_STEP_KEY) && twoStepEnabled && twoStepActive) {
                    if (methodsEnabled == 2 && methodsActive == 1) {
                        if (totpEnabled && !totpActive) {
                            context.put("changeMethod", TOTP_KEY);
                        } else if (fidoEnabled && !fidoActive) {
                            context.put("changeMethod", FIDO_KEY);
                        } else if (mailOtpEnabled && !mailOtpActive) {
                            context.put("changeMethod", MAIL_OTP_KEY);
                        }
                    }
                    this.handleTwoStepAuth(httpServletReq, httpServletResp, user, userKey, context);
                    return;
                }
                if (lastMethodUsed.equals(TOTP_KEY) && totpEnabled && totpActive) {
                    if (methodsEnabled == 2 && methodsActive == 1) {
                        if (twoStepEnabled && !twoStepActive) {
                            context.put("changeMethod", TWO_STEP_KEY);
                        } else if (fidoEnabled && !fidoActive) {
                            context.put("changeMethod", FIDO_KEY);
                        } else if (mailOtpEnabled && !mailOtpActive) {
                            context.put("changeMethod", MAIL_OTP_KEY);
                        }
                    }
                    this.handleTwoStepOTPAuth(httpServletReq, httpServletResp, user, userKey, context);
                    return;
                }
                if (lastMethodUsed.equals(FIDO_KEY) && fidoEnabled && fidoActive) {
                    if (methodsEnabled == 2 && methodsActive == 1) {
                        if (twoStepEnabled && !twoStepActive) {
                            context.put("changeMethod", TWO_STEP_KEY);
                        } else if (totpEnabled && !totpActive) {
                            context.put("changeMethod", TOTP_KEY);
                        } else if (mailOtpEnabled && !mailOtpActive) {
                            context.put("changeMethod", MAIL_OTP_KEY);
                        }
                    }
                    this.handleTwoStepFIDOAuth(httpServletReq, httpServletResp, user, userKey, context);
                    return;
                }
                if (lastMethodUsed.equals(MAIL_OTP_KEY) && mailOtpEnabled && mailOtpActive) {
                    if (methodsEnabled == 2 && methodsActive == 1) {
                        if (twoStepEnabled && !twoStepActive) {
                            context.put("changeMethod", TWO_STEP_KEY);
                        } else if (totpEnabled && !totpActive) {
                            context.put("changeMethod", TOTP_KEY);
                        } else if (fidoEnabled && !fidoActive) {
                            context.put("changeMethod", FIDO_KEY);
                        }
                    }
                    this.handleTwoStepMailAuth(httpServletReq, httpServletResp, user, userKey, context);
                    return;
                }
            }
            if (methodsActive == 1) {
                if (canSelectedTwoStep) {
                    if (methodsEnabled == 2) {
                        if (totpEnabled && !totpActive) {
                            context.put("changeMethod", TOTP_KEY);
                        } else if (fidoEnabled && !fidoActive) {
                            context.put("changeMethod", FIDO_KEY);
                        } else if (mailOtpEnabled && !mailOtpActive) {
                            context.put("changeMethod", MAIL_OTP_KEY);
                        }
                    }
                    this.handleTwoStepAuth(httpServletReq, httpServletResp, user, userKey, context);
                    return;
                }
                if (canSelectedTotp) {
                    if (methodsEnabled == 2) {
                        if (twoStepEnabled && !twoStepActive) {
                            context.put("changeMethod", TWO_STEP_KEY);
                        } else if (fidoEnabled && !fidoActive) {
                            context.put("changeMethod", FIDO_KEY);
                        } else if (mailOtpEnabled && !mailOtpActive) {
                            context.put("changeMethod", MAIL_OTP_KEY);
                        }
                    }
                    this.handleTwoStepOTPAuth(httpServletReq, httpServletResp, user, userKey, context);
                    return;
                }
                if (canSelectedFIDO) {
                    if (methodsEnabled == 2) {
                        if (twoStepEnabled && !twoStepActive) {
                            context.put("changeMethod", TWO_STEP_KEY);
                        } else if (totpEnabled && !totpActive) {
                            context.put("changeMethod", TOTP_KEY);
                        } else if (mailOtpEnabled && !mailOtpActive) {
                            context.put("changeMethod", MAIL_OTP_KEY);
                        }
                    }
                    this.handleTwoStepFIDOAuth(httpServletReq, httpServletResp, user, userKey, context);
                    return;
                }
                if (canSelectedMailOtp) {
                    if (methodsEnabled == 2) {
                        if (twoStepEnabled && !twoStepActive) {
                            context.put("changeMethod", TWO_STEP_KEY);
                        } else if (totpEnabled && !totpActive) {
                            context.put("changeMethod", TOTP_KEY);
                        } else if (fidoEnabled && !fidoActive) {
                            context.put("changeMethod", FIDO_KEY);
                        }
                    }
                    this.handleTwoStepMailAuth(httpServletReq, httpServletResp, user, userKey, context);
                    return;
                }
            }
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error("OperationFailedException on handleStandardLogin");
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on handleStandardLogin");
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on handleStandardLogin");
        }
        catch (SecSignIDRESTException e) {
            logger.error("SecSignIDRESTException on handleStandardLogin");
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on handleStandardLogin");
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on handleStandardLogin");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("runtime.UserNotFoundException on handleStandardLogin");
        }
        this.handleMethodSelection(httpServletReq, httpServletResp, user, userKey, context);
    }

    private void handleSafeZoneLogin(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException {
        User user;
        String filterResult = "";
        String username = this.getUsernameFromRequest(httpServletReq);
        String userKey = this.dataAccessor.getUserKeyForUsername(username);
        try {
            user = this.dataAccessor.getUserForKeyFirst(userKey);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        filterResult = this.dataAccessor.loginWithUsernameAndPassword(httpServletReq, httpServletResp, this.getServletContext());
        if (filterResult.equals("success") || filterResult.equals("OK")) {
            try {
                if (httpServletReq.getHeader("X-Forwarded-For") != null) {
                    Object[] clientIpAddresses = httpServletReq.getHeader("X-Forwarded-For").split(",");
                    this.dataAccessor.saveIPForUserKey(userKey, user.getDirectoryId(), "IP: " + httpServletReq.getRemoteAddr() + " Forwarded-For:" + SecSignIDMappingUtils.arrayToString(clientIpAddresses));
                } else {
                    this.dataAccessor.saveIPForUserKey(userKey, user.getDirectoryId(), httpServletReq.getRemoteAddr());
                }
            }
            catch (Exception e) {
                logger.error("Exception on saving IP for SafeZone: " + e.getMessage());
            }
            this.clearAllSettingsFromSession(httpServletReq, userKey, user.getDirectoryId());
            if (!this.handleSAMLLogin(httpServletReq, httpServletResp)) {
                this.sendRedirect(httpServletReq, httpServletResp);
                return;
            }
            logger.debug("Processed SAML Request. Redirect to SAML Service Provider.");
            return;
        }
        this.handleFilterResultJira(httpServletReq, httpServletResp, filterResult, context);
    }

    private void handleTwoStepAuth(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, User user, String userKey, HashMap<String, Object> context) throws RenderingException, IOException {
        String[] idArray;
        String username = user.getName();
        try {
            String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
            idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
            this.fillContextWithAllowedOptions(httpServletReq, userKey, user.getDirectoryId(), context);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error("OperationFailedException on JiraLogin with twoStepAuth and no pwdallowed");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on JiraLogin with twoStepAuth and no pwdallowed");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on JiraLogin with twoStepAuth and no pwdallowed");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on JiraLogin with twoStepAuth and no pwdallowed");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on JiraLogin with twoStepAuth and no pwdallowed");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        catch (SecSignIDRESTException e) {
            logger.error("SecSignIDRESTException on JiraLogin with twoStepAuth and no pwdallowed");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
            return;
        }
        try {
            String secSignId;
            if (idArray.length != 0) {
                secSignId = idArray[0];
                if (SecSignIDServerRESTConnector.checkSecSignID(secSignId)) {
                    if (SecSignIDServerRESTConnector.getDevicesOfSecSignID(secSignId).getDeviceCount() != 0) {
                        this.startAuth(httpServletReq, httpServletResp, secSignId, username, userKey, user.getDirectoryId(), context);
                        return;
                    }
                    SecSignIDRESTRestorationResponse restorationResponse = SecSignIDServerRESTConnector.getRestoreQRCode(secSignId, this.getAccessToken(httpServletReq));
                    context.put("qrMail", user.getEmailAddress());
                    context.put("qrID", secSignId);
                    context.put("savedQRCode", restorationResponse.getQrCodeBase64());
                    context.put("savedUrl", URLEncoder.encode(restorationResponse.getRestoreUrl(), "UTF-8"));
                    context.put("qrExists", Boolean.TRUE);
                    this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
                    return;
                }
                this.createAndRenderSecSignId(httpServletReq, httpServletResp, user, secSignId, false, context);
                return;
            }
            secSignId = SecSignIDAuthenticationUtil.tryFindAutoFillSecSignId(user, false);
            if (SecSignIDServerRESTConnector.checkSecSignID(secSignId)) {
                boolean allowUserCreate = SecSignIDCommonStaticAccessor.getAllowUserCreate();
                boolean allowUserExisting = SecSignIDCommonStaticAccessor.getAllowUserExisting();
                if (allowUserCreate || allowUserExisting) {
                    context.put("allowUserCreate", allowUserCreate);
                    context.put("allowUserExisting", allowUserExisting);
                    context.put("warnmsg", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.signup.own.already.name") + " " + secSignId);
                    context.put("secSignID", secSignId);
                    context.put("username", username);
                    context.put("dirid", String.valueOf(user.getDirectoryId()));
                    context.put("companyName", SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName());
                    this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
                    return;
                }
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.noid.already", null, context);
                return;
            }
            this.createAndRenderSecSignId(httpServletReq, httpServletResp, user, secSignId, true, context);
        }
        catch (SecSignIDRESTException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
        }
    }

    private void createAndRenderSecSignId(HttpServletRequest request, HttpServletResponse response, User user, String secSignId, boolean saveSecSignId, HashMap<String, Object> context) throws IOException {
        try {
            String url;
            String qrCode;
            boolean useRestore = SecSignIDCommonStaticAccessor.getUseRestore();
            if (useRestore) {
                SecSignIDRESTCreateSecSignIDResponse createSecSignIDResponse = SecSignIDServerRESTConnector.createSecSignID(secSignId, user.getEmailAddress());
                qrCode = createSecSignIDResponse.getQrCodeBase64();
                url = createSecSignIDResponse.getRestoreUrl();
                context.put("qrMail", user.getEmailAddress());
            } else {
                SecSignIDRESTCreateQRCodeResponse createQRCodeResponse = SecSignIDServerRESTConnector.getCreateSecSignIDQrCode(secSignId);
                qrCode = createQRCodeResponse.getQrCodeBase64();
                url = createQRCodeResponse.getCreateUrl();
                context.put("create", Boolean.TRUE);
            }
            if (saveSecSignId) {
                SecSignIDAuthenticationUtil.saveSecSignIdForUser(request, this.dataAccessor, user, secSignId);
            }
            context.put("qrID", secSignId);
            context.put("savedQRCode", qrCode);
            context.put("savedUrl", URLEncoder.encode(url, "UTF-8"));
            context.put("qrExists", Boolean.TRUE);
            this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)response.getWriter());
        }
        catch (SecSignIDRESTException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.renderLoginWithError(request, response, "secsignid.messages.error.rest.normal.user", null, context);
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | OperationNotPermittedException | UserNotFoundException | OperationFailedException | DirectoryPermissionException | UnsupportedEncodingException | NamingException e) {
            logger.error(e.getMessage(), e);
            this.renderLoginWithError(request, response, "secsignid.messages.error.crowd.failed", null, context);
        }
    }

    private void handleTwoStepMailAuth(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, User user, String userKey, HashMap<String, Object> context) throws RenderingException, IOException {
        this.createNewIdForMailOTPIfRequired(httpServletReq, userKey, user);
        String[] idArray = null;
        try {
            String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
            idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
            this.fillContextWithAllowedOptions(httpServletReq, userKey, user.getDirectoryId(), context);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.debug("OperationFailedException on JiraLogin with twoStepAuth and no pwdallowed");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        catch (ApplicationPermissionException e) {
            logger.debug("ApplicationPermissionException on JiraLogin with twoStepAuth and no pwdallowed");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        catch (InvalidAuthenticationException e) {
            logger.debug("InvalidAuthenticationException on JiraLogin with twoStepAuth and no pwdallowed");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        catch (UserNotFoundException e) {
            logger.debug("UserNotFoundException on JiraLogin with twoStepAuth and no pwdallowed");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        catch (DirectoryNotFoundException e) {
            logger.debug("DirectoryNotFoundException on JiraLogin with twoStepAuth and no pwdallowed");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        catch (SecSignIDRESTException e) {
            logger.error("SecSignIDRESTException on JiraLogin with twoStepAuth and no pwdallowed");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
            return;
        }
        if (idArray == null || idArray.length == 0) {
            String otpID = "";
            try {
                boolean autofillMail = SecSignIDCommonStaticAccessor.getAutoFillMail();
                boolean autofillUser = SecSignIDCommonStaticAccessor.getAutoFillUsername();
                boolean autofillUsercompany = SecSignIDCommonStaticAccessor.getAutoFillUsernameCompany();
                boolean autoFillPattern = SecSignIDCommonStaticAccessor.getAutoFillPattern();
                if (autofillMail) {
                    if (!SecSignIDServerRESTConnector.checkSecSignID(user.getEmailAddress().toLowerCase())) {
                        SecSignIDServerRESTConnector.createSecSignID(user.getEmailAddress().toLowerCase(), user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getEmailAddress().toLowerCase());
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getEmailAddress().toLowerCase();
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(user.getEmailAddress() + indexToAdd)) {
                            ++indexToAdd;
                        }
                        SecSignIDServerRESTConnector.createSecSignID(user.getEmailAddress().toLowerCase() + indexToAdd, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getEmailAddress().toLowerCase() + indexToAdd);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getEmailAddress().toLowerCase() + indexToAdd;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    }
                } else if (autofillUser) {
                    if (!SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_"))) {
                        SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_"), user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_"));
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getName().toLowerCase().replace(" ", "_");
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + indexToAdd)) {
                            ++indexToAdd;
                        }
                        SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_") + indexToAdd, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_") + indexToAdd);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getName().toLowerCase().replace(" ", "_") + indexToAdd;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    }
                } else if (autofillUsercompany) {
                    if (!SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName())) {
                        SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName(), user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName());
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName();
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd)) {
                            ++indexToAdd;
                        }
                        SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    }
                } else if (autoFillPattern) {
                    String autoFillPatterPattern;
                    String result = autoFillPatterPattern = SecSignIDCommonStaticAccessor.getAutoFillPatternPattern();
                    result = result.replace("%username%", user.getName().toLowerCase().replace(" ", "_"));
                    result = result.replace("%displayname%", user.getDisplayName().replace(" ", "").toLowerCase());
                    result = result.replace("%mail%", user.getEmailAddress().toLowerCase());
                    result = result.replace("%index%", "");
                    if (!SecSignIDServerRESTConnector.checkSecSignID(result = result.toLowerCase())) {
                        SecSignIDServerRESTConnector.createSecSignID(result, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), result);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = result;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    } else {
                        int indexToAdd = 1;
                        while (SecSignIDServerRESTConnector.checkSecSignID(result + indexToAdd)) {
                            ++indexToAdd;
                        }
                        SecSignIDServerRESTConnector.createSecSignID(result + indexToAdd, user.getEmailAddress());
                        this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), result + indexToAdd);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                        otpID = result + indexToAdd;
                        this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                        if (SecSignIDCommonStaticAccessor.getInformUser()) {
                            this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                        if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                            this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                        }
                    }
                }
            }
            catch (SecSignIDRESTException e) {
                logger.error(e.getMessage(), (Throwable)e);
                logger.error("SecSignIDRESTException on creating ID for OTP:" + e.getMessage());
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
                return;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                logger.debug("OperationFailedException on creating ID for OTP:" + e.getMessage());
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            this.prepareAndRenderMailLogin(httpServletReq, httpServletResp, context, otpID, user.getEmailAddress());
            return;
        }
        String secSignId = idArray[0];
        this.prepareAndRenderMailLogin(httpServletReq, httpServletResp, context, secSignId, user.getEmailAddress());
    }

    private void handleFilterResultJira(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, String filterResult, HashMap<String, Object> context) throws IOException {
        if (filterResult == null || filterResult.equals("failed")) {
            logger.debug("check for Captcha needed");
            if (this.dataAccessor.checkForElevatedSecurityCheck(httpServletReq, httpServletResp)) {
                logger.debug("User needs Captcha");
                this.dataAccessor.prepareContextForCaptcha(httpServletReq, context);
                String reason = this.dataAccessor.getLoginReason(httpServletReq, httpServletResp, this.getServletContext());
                if (reason.equals("error")) {
                    logger.debug("reason is LOGIN_ERROR -> wrong captcha");
                    context.put("captchaError", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.wrongcaptcha"));
                }
                logger.debug("render Login with Error for LOGIN_ERROR -> show captcha");
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.wronguserpwdcaptcha", null, context);
                return;
            }
            logger.debug("Wrong username/password");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.wronguserpwd", null, context);
            return;
        }
        if (filterResult.equals("auth_error_type")) {
            if (this.dataAccessor.getApplication().equals("Crowd")) {
                this.showRenewPasswordForm(httpServletReq, httpServletResp);
                return;
            }
            logger.debug("Wrong username/password");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.wronguserpwd", null, context);
            return;
        }
        if (filterResult.equals("error")) {
            logger.debug("Error on login");
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.login.error", null, context);
            return;
        }
        if (filterResult.equals("success")) {
            logger.debug("Login success ");
            String username = this.getUsernameFromRequest(httpServletReq);
            String userKey = this.dataAccessor.getUserKeyForUsername(username);
            try {
                User user = this.dataAccessor.getUserForKeyFirst(userKey);
                if (httpServletReq.getHeader("X-Forwarded-For") != null) {
                    Object[] clientIpAddresses = httpServletReq.getHeader("X-Forwarded-For").split(",");
                    this.dataAccessor.saveIPForUserKey(userKey, user.getDirectoryId(), "IP: " + httpServletReq.getRemoteAddr() + " Forwarded-For:" + SecSignIDMappingUtils.arrayToString(clientIpAddresses));
                } else {
                    this.dataAccessor.saveIPForUserKey(userKey, user.getDirectoryId(), httpServletReq.getRemoteAddr());
                }
            }
            catch (Exception e) {
                logger.error("Exception on saving IP-Mapping: " + e.getLocalizedMessage());
            }
            this.dataAccessor.deleteUserCreated(userKey);
            logger.debug("Login Succes -> Redirect");
            if (this.handleSAMLLogin(httpServletReq, httpServletResp)) {
                logger.debug("Processed SAML Request. Redirect to SAML Service Provider.");
                return;
            }
            this.sendRedirect(httpServletReq, httpServletResp);
            return;
        }
        this.renderLogin(httpServletReq, httpServletResp, context);
    }

    private void showRenewPasswordForm(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        if (this.dataAccessor.getApplication().equals("Crowd")) {
            this.dataAccessor.showExpiredForCrowd(httpServletReq, httpServletResp, this.getUsernameFromRequest(httpServletReq));
            httpServletResp.sendRedirect(httpServletReq.getContextPath() + "/" + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.login.reset.password.link"));
        } else {
            httpServletResp.sendRedirect(httpServletReq.getContextPath() + "/" + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.login.forgot.link"));
        }
    }

    private boolean handleSAMLLogin(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        HttpSession httpServletSession = httpServletReq.getSession();
        if (httpServletSession.getAttribute("SAMLRequest") != null) {
            String samlRequest = String.valueOf(httpServletSession.getAttribute("SAMLRequest"));
            String relayState = String.valueOf(httpServletSession.getAttribute("RelayState"));
            boolean SAMLRequestEncoded = Boolean.TRUE.equals(httpServletSession.getAttribute("SAMLRequestEncoding"));
            String crowdBaseUrl = this.dataAccessor.getBaseUrl();
            logger.info("Redirect to SAML SSO url after secsign id login to: returnUrl='/console/secure/saml/sso.action', crowdBaseUrl='" + crowdBaseUrl + "'");
            StringBuilder SAMLRequestUrl = new StringBuilder(crowdBaseUrl);
            SAMLRequestUrl.append("/console/secure/saml/sso.action?");
            if (SAMLRequestEncoded) {
                SAMLRequestUrl.append("SAMLRequest=").append(samlRequest).append("&");
                SAMLRequestUrl.append("RelayState=").append(relayState);
            } else {
                SAMLRequestUrl.append("SAMLRequest=").append(URLEncoder.encode(samlRequest, "UTF-8")).append("&");
                SAMLRequestUrl.append("RelayState=").append(URLEncoder.encode(relayState, "UTF-8"));
            }
            httpServletResp.sendRedirect(SAMLRequestUrl.toString());
            return true;
        }
        logger.info("No SAMLRequest attribute in session");
        return false;
    }

    private void handleTwoStepFIDOAuth(HttpServletRequest request, HttpServletResponse response, User user, String userKey, HashMap<String, Object> context) throws RenderingException, IOException {
        try {
            String secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            if (secSignId != null) {
                if (!SecSignIDServerRESTConnector.checkSecSignID(secSignId)) {
                    SecSignIDRESTCreateSecSignIDResponse secSignIDRESTCreateSecSignIDResponse = SecSignIDServerRESTConnector.createSecSignID(secSignId, user.getEmailAddress());
                }
            } else {
                secSignId = SecSignIDAuthenticationUtil.tryFindAutoFillSecSignId(user, true);
                SecSignIDRESTCreateSecSignIDResponse createSecSignIDResponse = SecSignIDServerRESTConnector.createSecSignID(secSignId, user.getEmailAddress());
                SecSignIDAuthenticationUtil.saveSecSignIdForUser(request, this.dataAccessor, user, secSignId);
                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
            }
            this.fillContextWithAllowedOptions(request, userKey, user.getDirectoryId(), context);
            SecSignID2FAActivatedSettings activatedSettings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, user.getDirectoryId());
            if (activatedSettings.isFidoActive()) {
                context.put("fidoMode", "authenticate");
            } else {
                SecSignIDRESTAuthenticationMethod methodToActivate = this.getAuthenticationMethodFromMethodToActivate(userKey, user.getDirectoryId());
                if (methodToActivate != SecSignIDRESTAuthenticationMethod.UNKNOWN && methodToActivate != SecSignIDRESTAuthenticationMethod.FIDO) {
                    context.put("fidoMode", "authenticate");
                } else {
                    if (!this.canActivateFIDO(request, context)) {
                        this.renderLoginWithError(request, response, "secsignid.messages.error.crowd.failed", null, context);
                        return;
                    }
                    context.put("fidoMode", "register");
                }
            }
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | OperationNotPermittedException | UserNotFoundException | DirectoryPermissionException | NamingException e) {
            logger.error(e.getMessage(), e);
            this.renderLoginWithError(request, response, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        catch (SecSignIDRESTException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.renderLoginWithError(request, response, "secsignid.messages.error.rest.normal.user", e.getMessage(), context);
            return;
        }
        this.templateRenderer.render(this.getFIDOLoginTemplate(), context, (Writer)response.getWriter());
    }

    private void handleFIDORegisterStart(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.canActivateFIDO(request, null)) {
            return;
        }
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(request);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(request, this.dataAccessor);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        try {
            String secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            String credentialNickname = request.getParameter("credentialNickname");
            SecSignIDRESTFIDORegisterStartResponse registerStartResponse = SecSignIDServerRESTConnector.startFIDORegister(secSignId, credentialNickname, this.getAccessToken(request));
            jsonMap.put("success", Boolean.TRUE);
            jsonMap.put("creationOptions", registerStartResponse.getCreationOptions());
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | UserNotFoundException | SecSignIDRESTException e) {
            logger.error(e.getMessage(), e);
            jsonMap.put("success", Boolean.FALSE);
            jsonMap.put("errorMessage", e.getMessage());
        }
        try {
            JSONObject jsonObject = this.createJSONObjectFromMap(jsonMap);
            response.setContentType("application/json");
            response.getWriter().write(jsonObject.toString());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void handleFIDORegisterFinish(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.canActivateFIDO(request, null)) {
            return;
        }
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(request);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(request, this.dataAccessor);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        try {
            String secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            String credentialId = request.getParameter("credentialId");
            String clientDataJson = request.getParameter("clientDataJson");
            String attestationObject = request.getParameter("attestationObject");
            SecSignIDServerRESTConnector.finishFIDORegister(secSignId, credentialId, clientDataJson, attestationObject, this.getAccessToken(request));
            request.getSession().removeAttribute("accessToken");
            SecSignID2FAActivatedSettings activatedSettings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, user.getDirectoryId());
            activatedSettings.setFidoActive(true);
            this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
            if (SecSignIDCommonStaticAccessor.getInformUser()) {
                this.dataAccessor.mailActivateFIDOToUser(userKey, user.getDirectoryId());
            }
            this.dataAccessor.logActivateFIDO(userKey, user.getDirectoryId(), request.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                this.dataAccessor.mailActivateFIDOToInformGroup(userKey, user.getDirectoryId());
            }
            SecSignIDRESTFIDOAuthenticateStartResponse authenticateStartResponse = SecSignIDServerRESTConnector.startFIDOAuthenticate(secSignId);
            jsonMap.put("success", Boolean.TRUE);
            jsonMap.put("requestOptions", authenticateStartResponse.getRequestOptions());
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | UserNotFoundException | DirectoryPermissionException | SecSignIDRESTException e) {
            logger.error(e.getMessage(), e);
            jsonMap.put("success", Boolean.FALSE);
            jsonMap.put("errorMessage", e.getMessage());
        }
        try {
            JSONObject jsonObject = this.createJSONObjectFromMap(jsonMap);
            response.setContentType("application/json");
            response.getWriter().write(jsonObject.toString());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void handleFIDOAuthenticateStart(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.canActivateFIDO(request, null)) {
            return;
        }
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(request);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(request, this.dataAccessor);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        try {
            String requestOptions;
            String secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            SecSignIDRESTAuthenticationMethod methodToActivate = this.getAuthenticationMethodFromMethodToActivate(userKey, user.getDirectoryId());
            boolean accessTokenRequired = SecSignIDAuthenticationUtil.isAccessTokenRequiredForActivation(secSignId, methodToActivate);
            if (accessTokenRequired) {
                SecSignIDRESTAccessTokenAuthorizationResponse accessTokenAuthorizationResponse = this.requestAccessTokenAuthorization(request, secSignId, SecSignIDRESTAuthenticationMethod.FIDO, methodToActivate);
                requestOptions = accessTokenAuthorizationResponse.getFido();
            } else {
                SecSignIDRESTFIDOAuthenticateStartResponse authenticateStartResponse = SecSignIDServerRESTConnector.startFIDOAuthenticate(secSignId);
                requestOptions = authenticateStartResponse.getRequestOptions();
            }
            jsonMap.put("success", Boolean.TRUE);
            jsonMap.put("requestOptions", requestOptions);
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | UserNotFoundException | SecSignIDRESTException e) {
            logger.error(e.getMessage(), e);
            jsonMap.put("success", Boolean.FALSE);
            jsonMap.put("errorMessage", e.getMessage());
        }
        try {
            JSONObject jsonObject = this.createJSONObjectFromMap(jsonMap);
            response.setContentType("application/json");
            response.getWriter().write(jsonObject.toString());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void handleFIDOAuthenticateFinish(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> context) throws IOException {
        if (!this.canActivateFIDO(request, context)) {
            this.renderLoginWithError(request, response, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(request);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(request, this.dataAccessor);
        try {
            String secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            String credentialId = request.getParameter("credentialId");
            String clientDataJson = request.getParameter("clientDataJson");
            String authenticatorData = request.getParameter("authenticatorData");
            String signature = request.getParameter("signature");
            String userHandle = request.getParameter("userHandle");
            if (this.getAccessTokenAuthorizationId(request) != null) {
                this.requestAccessTokenForFIDOAuthentication(request, credentialId, clientDataJson, authenticatorData, signature, userHandle);
            } else {
                SecSignIDServerRESTConnector.finishFIDOAuthenticate(secSignId, credentialId, clientDataJson, authenticatorData, signature, userHandle);
            }
            if (this.handleActivatingInactiveMethod(request, response, FIDO_KEY, context)) {
                return;
            }
            if (this.loginApplicationUser(user, request, response)) {
                SecSignID2FAActivatedSettings activatedSettings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, user.getDirectoryId());
                activatedSettings.setFidoActive(true);
                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
                this.dataAccessor.saveLastMethodUsed(userKey, user.getDirectoryId(), FIDO_KEY);
                if (this.handleSAMLLogin(request, response)) {
                    logger.debug("Processed SAML Request. Redirect to SAML Service Provider.");
                    return;
                }
                this.sendRedirect(request, response);
                return;
            }
            this.renderLoginWithError(request, response, "secsignid.messages.error.login.contact.admin", null, context);
            return;
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | UserNotFoundException | DirectoryPermissionException | SecSignIDRESTException e) {
            logger.error(e.getMessage(), e);
            this.renderLoginWithError(request, response, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
    }

    private void handleMethodSelection(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, User user, String userKey, HashMap<String, Object> context) throws IOException {
        HttpSession session;
        String authSessionId;
        if (user == null) {
            userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(httpServletReq);
            user = SecSignIDAuthenticationUtil.getUserFromRequest(httpServletReq, this.dataAccessor);
            if (user == null) {
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
        }
        if ((authSessionId = (String)SecSignIDHttpSessionUtil.getAttribute(session = httpServletReq.getSession(), AUTH_SESSION_ID_KEY)) != null) {
            SecSignIDHttpSessionUtil.removeAttribute(session, AUTH_SESSION_ID_KEY, AUTH_SESSION_ICON_KEY, AUTH_SESSION_SECSIGN_ID_KEY, AUTH_SESSION_USERNAME_KEY, AUTH_SESSION_STATE_KEY);
            try {
                SecSignIDServerRESTConnector.cancelAuthSession(authSessionId);
            }
            catch (SecSignIDRESTException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        SecSignID2FASettings settingsForUser = null;
        Integer passwordlessAllowed = null;
        Integer twoStepAllowed = null;
        Integer totpAllowed = null;
        Integer mailotpAllowed = null;
        Integer fidoAllowed = null;
        try {
            settingsForUser = this.get2FASettingsFromUserKey(httpServletReq, userKey, user.getDirectoryId());
            passwordlessAllowed = settingsForUser.getPasswordlessAllowed();
            twoStepAllowed = settingsForUser.getTwoStepAllowed();
            totpAllowed = settingsForUser.getTotpAllowed();
            mailotpAllowed = settingsForUser.getMailOtpAllowed();
            fidoAllowed = settingsForUser.getFidoAllowed();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        if (twoStepAllowed == null || totpAllowed == null || mailotpAllowed == null) {
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
            return;
        }
        boolean twoStepEnabled = twoStepAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) || passwordlessAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean totpEnabled = totpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean mailOtpEnabled = mailotpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean fidoEnabled = fidoAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.isFIDOSupported();
        try {
            boolean canSelectedMailOtp;
            SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(httpServletReq, userKey, user.getDirectoryId());
            boolean twoStepActive = activatedSettings.isTwoStepActive();
            boolean totpActive = activatedSettings.isTotpActive();
            boolean mailOtpActive = activatedSettings.isMailOtpActive();
            boolean fidoActive = activatedSettings.isFidoActive();
            boolean firstMethod = !(twoStepActive && twoStepEnabled || totpActive && totpEnabled || fidoActive && fidoEnabled || mailOtpActive && mailOtpEnabled);
            boolean canSelectedTwoStep = twoStepEnabled && (firstMethod || twoStepActive);
            boolean canSelectedTotp = totpEnabled && (firstMethod || totpActive);
            boolean canSelectedFIDO = fidoEnabled && (firstMethod || fidoActive);
            boolean bl = canSelectedMailOtp = mailOtpEnabled && (firstMethod || mailOtpActive);
            if (!(twoStepEnabled || totpEnabled || mailOtpEnabled || fidoEnabled)) {
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.user.nologin", null, context);
                return;
            }
            int methodsEnabled = (twoStepEnabled ? 1 : 0) + (totpEnabled ? 1 : 0) + (fidoEnabled ? 1 : 0) + (mailOtpEnabled ? 1 : 0);
            int methodsActive = (twoStepActive ? 1 : 0) + (totpActive ? 1 : 0) + (fidoActive ? 1 : 0) + (mailOtpActive ? 1 : 0);
            String selectedMethod = null;
            String selectedInactiveMethod = null;
            String changeFromMethod = httpServletReq.getParameter("changeMethod");
            String secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            List<SecSignIDRESTAuthenticationMethod> authenticationMethods = SecSignIDAuthenticationUtil.getAvailableMethodsForActivation(httpServletReq, user, userKey, secSignId);
            if (changeFromMethod != null && methodsEnabled == 2) {
                if (methodsActive == 2) {
                    if (twoStepActive && !changeFromMethod.equals(TWO_STEP_KEY)) {
                        this.handleTwoStepAuth(httpServletReq, httpServletResp, user, userKey, context);
                        return;
                    }
                    if (totpActive && !changeFromMethod.equals(TOTP_KEY)) {
                        this.handleTwoStepOTPAuth(httpServletReq, httpServletResp, user, userKey, context);
                        return;
                    }
                    if (fidoActive && !changeFromMethod.equals(FIDO_KEY)) {
                        this.handleTwoStepFIDOAuth(httpServletReq, httpServletResp, user, userKey, context);
                        return;
                    }
                    if (mailOtpActive && !changeFromMethod.equals(MAIL_OTP_KEY)) {
                        this.handleTwoStepMailAuth(httpServletReq, httpServletResp, user, userKey, context);
                        return;
                    }
                } else if (methodsActive == 1) {
                    selectedMethod = changeFromMethod;
                    if (twoStepEnabled && !twoStepActive) {
                        selectedInactiveMethod = TWO_STEP_KEY;
                    } else if (totpEnabled && !totpActive) {
                        selectedInactiveMethod = TOTP_KEY;
                    } else if (fidoEnabled && !fidoActive) {
                        selectedInactiveMethod = FIDO_KEY;
                    } else if (mailOtpEnabled && !mailOtpActive) {
                        selectedInactiveMethod = MAIL_OTP_KEY;
                    }
                    this.dataAccessor.saveMethodToActivate(userKey, user.getDirectoryId(), selectedInactiveMethod);
                    if (!selectedInactiveMethod.equals("none") && !selectedInactiveMethod.equals("")) {
                        context.put("activatingMethod", Boolean.TRUE);
                        if (selectedMethod.equals(TWO_STEP_KEY) && authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.SEC_SIGN_ID)) {
                            this.handleTwoStepAuth(httpServletReq, httpServletResp, user, userKey, context);
                        } else if (selectedMethod.equals(TOTP_KEY) && authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.TOTP)) {
                            this.handleTwoStepOTPAuth(httpServletReq, httpServletResp, user, userKey, context);
                        } else if (selectedMethod.equals(FIDO_KEY) && authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.FIDO)) {
                            this.handleTwoStepFIDOAuth(httpServletReq, httpServletResp, user, userKey, context);
                        } else if (selectedMethod.equals(MAIL_OTP_KEY) && authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.MAIL_OTP)) {
                            this.handleTwoStepMailAuth(httpServletReq, httpServletResp, user, userKey, context);
                        } else {
                            this.renderLogin(httpServletReq, httpServletResp, context);
                        }
                        return;
                    }
                }
            }
            if (selectedMethod == null && (selectedMethod = httpServletReq.getParameter("selected-method")) == null) {
                context.put("firstMethod", firstMethod);
                context.put("hasInactiveMethods", twoStepEnabled && !twoStepActive || totpEnabled && !totpActive || fidoEnabled && !fidoActive || mailOtpEnabled && !mailOtpActive);
                context.put("twoStepEnabled", twoStepEnabled);
                context.put("totpEnabled", totpEnabled);
                context.put("mailOtpEnabled", mailOtpEnabled);
                context.put("fidoEnabled", fidoEnabled);
                context.put("twoStepActive", twoStepActive);
                context.put("totpActive", totpActive);
                context.put("mailOtpActive", mailOtpActive);
                context.put("fidoActive", fidoActive);
                context.put("twoStepAuthentication", authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.SEC_SIGN_ID));
                context.put("totpAuthentication", authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.TOTP));
                context.put("fidoAuthentication", authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.FIDO));
                context.put("mailOtpAuthentication", authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.MAIL_OTP));
                this.templateRenderer.render(this.getMethodSelectionTemplate(), context, (Writer)httpServletResp.getWriter());
                return;
            }
            if (selectedInactiveMethod == null) {
                selectedInactiveMethod = httpServletReq.getParameter("selected-inactive-method");
            }
            if (selectedInactiveMethod != null) {
                this.dataAccessor.saveMethodToActivate(userKey, user.getDirectoryId(), selectedInactiveMethod);
                if (!selectedInactiveMethod.equals("none") && !selectedInactiveMethod.equals("")) {
                    context.put("activatingMethod", Boolean.TRUE);
                    if (selectedMethod.equals(TWO_STEP_KEY) && authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.SEC_SIGN_ID)) {
                        this.handleTwoStepAuth(httpServletReq, httpServletResp, user, userKey, context);
                    } else if (selectedMethod.equals(TOTP_KEY) && authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.TOTP)) {
                        this.handleTwoStepOTPAuth(httpServletReq, httpServletResp, user, userKey, context);
                    } else if (selectedMethod.equals(FIDO_KEY) && authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.FIDO)) {
                        this.handleTwoStepFIDOAuth(httpServletReq, httpServletResp, user, userKey, context);
                    } else if (selectedMethod.equals(MAIL_OTP_KEY) && authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.MAIL_OTP)) {
                        this.handleTwoStepMailAuth(httpServletReq, httpServletResp, user, userKey, context);
                    } else {
                        this.renderLogin(httpServletReq, httpServletResp, context);
                    }
                    return;
                }
            }
            if (selectedMethod.equals(TWO_STEP_KEY) && canSelectedTwoStep) {
                this.handleTwoStepAuth(httpServletReq, httpServletResp, user, userKey, context);
                return;
            }
            if (selectedMethod.equals(TOTP_KEY) && canSelectedTotp) {
                this.handleTwoStepOTPAuth(httpServletReq, httpServletResp, user, userKey, context);
                return;
            }
            if (selectedMethod.equals(FIDO_KEY) && canSelectedFIDO) {
                this.handleTwoStepFIDOAuth(httpServletReq, httpServletResp, user, userKey, context);
                return;
            }
            if (selectedMethod.equals(MAIL_OTP_KEY) && canSelectedMailOtp) {
                this.handleTwoStepMailAuth(httpServletReq, httpServletResp, user, userKey, context);
                return;
            }
            this.renderLogin(httpServletReq, httpServletResp, context);
            return;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error("OperationFailedException on handleStandardLogin");
            this.renderLogin(httpServletReq, httpServletResp, context);
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on handleStandardLogin");
            this.renderLogin(httpServletReq, httpServletResp, context);
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on handleStandardLogin");
            this.renderLogin(httpServletReq, httpServletResp, context);
        }
        catch (SecSignIDRESTException e) {
            logger.error("SecSignIDRESTException on handleStandardLogin");
            this.renderLogin(httpServletReq, httpServletResp, context);
        }
        catch (DirectoryPermissionException e) {
            logger.error("DirectoryPermissionException on handleStandardLogin");
            this.renderLogin(httpServletReq, httpServletResp, context);
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on handleStandardLogin");
            this.renderLogin(httpServletReq, httpServletResp, context);
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on handleStandardLogin");
            this.renderLogin(httpServletReq, httpServletResp, context);
        }
    }

    private boolean handleActivatingInactiveMethod(HttpServletRequest request, HttpServletResponse response, String currentMethod, HashMap<String, Object> context) {
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(request);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(request, this.dataAccessor);
        if (user == null) {
            return false;
        }
        try {
            String selectedInactiveMethod = this.dataAccessor.getMethodToActivate(userKey, user.getDirectoryId());
            if (selectedInactiveMethod == null || selectedInactiveMethod.equals("none") || selectedInactiveMethod.equals("")) {
                return false;
            }
            if (selectedInactiveMethod.equals(currentMethod)) {
                this.dataAccessor.saveMethodToActivate(userKey, user.getDirectoryId(), "");
                return false;
            }
            HttpSession session = request.getSession();
            SecSignIDHttpSessionUtil.setAttribute(session, TWO_STEP_AUTHORIZATION_KEY, Boolean.TRUE);
            try {
                if (selectedInactiveMethod.equals(TWO_STEP_KEY)) {
                    this.handleTwoStepAuth(request, response, user, userKey, context);
                } else if (selectedInactiveMethod.equals(TOTP_KEY)) {
                    this.handleTwoStepOTPAuth(request, response, user, userKey, context);
                } else if (selectedInactiveMethod.equals(FIDO_KEY)) {
                    this.handleTwoStepFIDOAuth(request, response, user, userKey, context);
                } else if (selectedInactiveMethod.equals(MAIL_OTP_KEY)) {
                    this.handleTwoStepMailAuth(request, response, user, userKey, context);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e1) {
            logger.error("OperationFailedException on getMethodToActivate on handleActivatingInactiveMethod");
            return false;
        }
        catch (ApplicationPermissionException e1) {
            logger.error("ApplicationPermissionException on getMethodToActivate on handleActivatingInactiveMethod");
            return false;
        }
        catch (InvalidAuthenticationException e1) {
            logger.error("InvalidAuthenticationException on getMethodToActivate on handleActivatingInactiveMethod");
            return false;
        }
        catch (DirectoryPermissionException e) {
            logger.error("DirectoryPermissionException on saveMethodToActivate on handleActivatingInactiveMethod");
            return false;
        }
        catch (UserNotFoundException e1) {
            logger.error("UserNotFoundException on saveMethodToActivate on handleActivatingInactiveMethod");
            return false;
        }
        catch (DirectoryNotFoundException e1) {
            logger.error("DirectoryNotFoundException on saveMethodToActivate on handleActivatingInactiveMethod");
            return false;
        }
        return true;
    }

    private boolean canActivateTwoStep(HttpServletRequest request) {
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(request);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(request, this.dataAccessor);
        if (user == null) {
            return false;
        }
        SecSignID2FASettings settingsForUser = null;
        Integer passwordlessAllowed = null;
        Integer twoStepAllowed = null;
        Integer totpAllowed = null;
        Integer mailotpAllowed = null;
        Integer fidoAllowed = null;
        try {
            settingsForUser = this.get2FASettingsFromUserKey(request, userKey, user.getDirectoryId());
            passwordlessAllowed = settingsForUser.getPasswordlessAllowed();
            twoStepAllowed = settingsForUser.getTwoStepAllowed();
            totpAllowed = settingsForUser.getTotpAllowed();
            fidoAllowed = settingsForUser.getFidoAllowed();
            mailotpAllowed = settingsForUser.getMailOtpAllowed();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        boolean twoStepEnabled = twoStepAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) || passwordlessAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean totpEnabled = totpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean mailOtpEnabled = mailotpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean fidoEnabled = fidoAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.isFIDOSupported();
        try {
            boolean firstMethod;
            SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(request, userKey, user.getDirectoryId());
            boolean twoStepActive = activatedSettings.isTwoStepActive();
            boolean totpActive = activatedSettings.isTotpActive();
            boolean fidoActive = activatedSettings.isFidoActive();
            boolean mailOtpActive = activatedSettings.isMailOtpActive();
            boolean bl = firstMethod = !(twoStepActive && twoStepEnabled || totpActive && totpEnabled || fidoActive && fidoEnabled || mailOtpActive && mailOtpEnabled);
            if (!twoStepEnabled) {
                return false;
            }
            if (twoStepActive || firstMethod) {
                return true;
            }
            String selectedInactiveMethod = this.dataAccessor.getMethodToActivate(userKey, user.getDirectoryId());
            if (selectedInactiveMethod == null) {
                return false;
            }
            if (!selectedInactiveMethod.equals(TWO_STEP_KEY)) {
                return false;
            }
            HttpSession session = request.getSession();
            Boolean twoStepAuthorized = (Boolean)SecSignIDHttpSessionUtil.getAttribute(session, TWO_STEP_AUTHORIZATION_KEY);
            if (!twoStepAuthorized.equals(Boolean.TRUE)) {
                return false;
            }
            String mappingKey = SecSignIDAuthenticationUtil.getMappingKeyFromRequest(request);
            if (mappingKey != null) {
                return userKey.equals(SecSignIDMappingUtils.getUserKeyFromMappingKey(mappingKey));
            }
            return false;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error("OperationFailedException on handleStandardLogin");
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on handleStandardLogin");
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on handleStandardLogin");
        }
        catch (SecSignIDRESTException e) {
            logger.error("SecSignIDRESTException on handleStandardLogin");
        }
        catch (DirectoryNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (UserNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private boolean canActivateMailOtp(HttpServletRequest request) {
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(request);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(request, this.dataAccessor);
        if (user == null) {
            return false;
        }
        SecSignID2FASettings settingsForUser = null;
        Integer passwordlessAllowed = null;
        Integer twoStepAllowed = null;
        Integer totpAllowed = null;
        Integer mailotpAllowed = null;
        Integer fidoAllowed = null;
        try {
            settingsForUser = this.get2FASettingsFromUserKey(request, userKey, user.getDirectoryId());
            passwordlessAllowed = settingsForUser.getPasswordlessAllowed();
            twoStepAllowed = settingsForUser.getTwoStepAllowed();
            totpAllowed = settingsForUser.getTotpAllowed();
            fidoAllowed = settingsForUser.getFidoAllowed();
            mailotpAllowed = settingsForUser.getMailOtpAllowed();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        boolean twoStepEnabled = twoStepAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) || passwordlessAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean totpEnabled = totpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean mailOtpEnabled = mailotpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean fidoEnabled = fidoAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.isFIDOSupported();
        try {
            boolean firstMethod;
            SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(request, userKey, user.getDirectoryId());
            boolean twoStepActive = activatedSettings.isTwoStepActive();
            boolean totpActive = activatedSettings.isTotpActive();
            boolean mailOtpActive = activatedSettings.isMailOtpActive();
            boolean fidoActive = activatedSettings.isFidoActive();
            boolean bl = firstMethod = !(twoStepActive && twoStepEnabled || totpActive && totpEnabled || fidoActive && fidoEnabled || mailOtpActive && mailOtpEnabled);
            if (!mailOtpEnabled) {
                return false;
            }
            if (mailOtpActive || firstMethod) {
                return true;
            }
            String selectedInactiveMethod = this.dataAccessor.getMethodToActivate(userKey, user.getDirectoryId());
            if (selectedInactiveMethod == null) {
                return false;
            }
            if (!selectedInactiveMethod.equals(MAIL_OTP_KEY)) {
                return false;
            }
            HttpSession session = request.getSession();
            Boolean twoStepAuthorized = (Boolean)SecSignIDHttpSessionUtil.getAttribute(session, TWO_STEP_AUTHORIZATION_KEY);
            if (!twoStepAuthorized.equals(Boolean.TRUE)) {
                return false;
            }
            String mappingKey = SecSignIDAuthenticationUtil.getMappingKeyFromRequest(request);
            if (mappingKey != null) {
                return userKey.equals(SecSignIDMappingUtils.getUserKeyFromMappingKey(mappingKey));
            }
            return false;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error("OperationFailedException on handleStandardLogin");
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on handleStandardLogin");
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on handleStandardLogin");
        }
        catch (SecSignIDRESTException e) {
            logger.error("SecSignIDRESTException on handleStandardLogin");
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on handleStandardLogin");
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on handleStandardLogin");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("runtime.UserNotFoundException on handleStandardLogin");
        }
        return false;
    }

    private boolean canActivateTOTP(HttpServletRequest request) {
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(request);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(request, this.dataAccessor);
        if (user == null) {
            return false;
        }
        SecSignID2FASettings settingsForUser = null;
        Integer passwordlessAllowed = null;
        Integer twoStepAllowed = null;
        Integer totpAllowed = null;
        Integer mailotpAllowed = null;
        Integer fidoAllowed = null;
        try {
            settingsForUser = this.get2FASettingsFromUserKey(request, userKey, user.getDirectoryId());
            passwordlessAllowed = settingsForUser.getPasswordlessAllowed();
            twoStepAllowed = settingsForUser.getTwoStepAllowed();
            totpAllowed = settingsForUser.getTotpAllowed();
            fidoAllowed = settingsForUser.getFidoAllowed();
            mailotpAllowed = settingsForUser.getMailOtpAllowed();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        boolean twoStepEnabled = twoStepAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) || passwordlessAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean totpEnabled = totpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean mailOtpEnabled = mailotpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean fidoEnabled = fidoAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.isFIDOSupported();
        try {
            boolean firstMethod;
            SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(request, userKey, user.getDirectoryId());
            boolean twoStepActive = activatedSettings.isTwoStepActive();
            boolean totpActive = activatedSettings.isTotpActive();
            boolean fidoActive = activatedSettings.isFidoActive();
            boolean mailOtpActive = activatedSettings.isMailOtpActive();
            boolean bl = firstMethod = !(twoStepActive && twoStepEnabled || totpActive && totpEnabled || fidoActive && fidoEnabled || mailOtpActive && mailOtpEnabled);
            if (!totpEnabled) {
                return false;
            }
            if (totpActive || firstMethod) {
                return true;
            }
            String selectedInactiveMethod = this.dataAccessor.getMethodToActivate(userKey, user.getDirectoryId());
            if (selectedInactiveMethod == null) {
                return false;
            }
            if (!selectedInactiveMethod.equals(TOTP_KEY)) {
                return false;
            }
            HttpSession session = request.getSession();
            Boolean twoStepAuthorized = (Boolean)SecSignIDHttpSessionUtil.getAttribute(session, TWO_STEP_AUTHORIZATION_KEY);
            if (!twoStepAuthorized.equals(Boolean.TRUE)) {
                return false;
            }
            String mappingKey = SecSignIDAuthenticationUtil.getMappingKeyFromRequest(request);
            if (mappingKey != null) {
                return userKey.equals(SecSignIDMappingUtils.getUserKeyFromMappingKey(mappingKey));
            }
            return false;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error("OperationFailedException on handleStandardLogin");
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on handleStandardLogin");
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on handleStandardLogin");
        }
        catch (SecSignIDRESTException e) {
            logger.error("SecSignIDRESTException on handleStandardLogin");
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on handleStandardLogin");
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on handleStandardLogin");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("runtime.UserNotFoundException on handleStandardLogin");
        }
        return false;
    }

    private boolean canActivateFIDO(HttpServletRequest request, HashMap<String, Object> context) {
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(request);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(request, this.dataAccessor);
        if (user == null) {
            return false;
        }
        Integer passwordlessAllowed = null;
        Integer twoStepAllowed = null;
        Integer totpAllowed = null;
        Integer mailotpAllowed = null;
        Integer fidoAllowed = null;
        try {
            SecSignID2FASettings settingsForUser = this.get2FASettingsFromUserKey(request, userKey, user.getDirectoryId());
            passwordlessAllowed = settingsForUser.getPasswordlessAllowed();
            twoStepAllowed = settingsForUser.getTwoStepAllowed();
            totpAllowed = settingsForUser.getTotpAllowed();
            mailotpAllowed = settingsForUser.getMailOtpAllowed();
            fidoAllowed = settingsForUser.getFidoAllowed();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        boolean twoStepEnabled = twoStepAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) || passwordlessAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean totpEnabled = totpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean mailOtpEnabled = mailotpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed);
        boolean fidoEnabled = fidoAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.isFIDOSupported();
        try {
            boolean firstMethod;
            SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(request, userKey, user.getDirectoryId());
            boolean twoStepActive = activatedSettings.isTwoStepActive();
            boolean totpActive = activatedSettings.isTotpActive();
            boolean mailOtpActive = activatedSettings.isMailOtpActive();
            boolean fidoActive = activatedSettings.isFidoActive();
            boolean bl = firstMethod = !(twoStepActive && twoStepEnabled || totpActive && totpEnabled || fidoActive && fidoEnabled || mailOtpActive && mailOtpEnabled);
            if (!fidoEnabled) {
                return false;
            }
            if (fidoActive || firstMethod) {
                return true;
            }
            String selectedInactiveMethod = this.dataAccessor.getMethodToActivate(userKey, user.getDirectoryId());
            if (selectedInactiveMethod == null) {
                return false;
            }
            if (!selectedInactiveMethod.equals(FIDO_KEY)) {
                return false;
            }
            HttpSession session = request.getSession();
            Boolean twoStepAuthorized = (Boolean)SecSignIDHttpSessionUtil.getAttribute(session, TWO_STEP_AUTHORIZATION_KEY);
            if (!twoStepAuthorized.equals(Boolean.TRUE)) {
                return false;
            }
            String mappingKey = SecSignIDAuthenticationUtil.getMappingKeyFromRequest(request);
            if (mappingKey != null) {
                return userKey.equals(SecSignIDMappingUtils.getUserKeyFromMappingKey(mappingKey));
            }
            return false;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error("OperationFailedException on handleStandardLogin");
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on handleStandardLogin");
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on handleStandardLogin");
        }
        catch (SecSignIDRESTException e) {
            logger.error("SecSignIDRESTException on handleStandardLogin");
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on handleStandardLogin");
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on handleStandardLogin");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("runtime.UserNotFoundException on handleStandardLogin");
        }
        return false;
    }

    private void handleCancelSecSign(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException {
        HttpSession session = httpServletReq.getSession();
        String authSessionId = (String)SecSignIDHttpSessionUtil.getAttribute(session, AUTH_SESSION_ID_KEY);
        if (authSessionId == null) {
            logger.info("No authentication session to cancel.");
            return;
        }
        String secsignId = (String)SecSignIDHttpSessionUtil.getAttribute(session, AUTH_SESSION_SECSIGN_ID_KEY);
        logger.info("cancel authentication session for '" + secsignId + "'.");
        try {
            SecSignIDServerRESTConnector.cancelAuthSession(authSessionId);
        }
        catch (Exception e) {
            context.put("errormsg", e.getMessage());
            logger.error(e.getClass().getName() + " on cancelAuthSession: " + e.getMessage(), (Throwable)e);
        }
        logger.debug("SecSign Login canceled");
        context.put("warnmsg", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.warning.canceled"));
        context.put("warnmsgkey", "secsignid.messages.warning.canceled");
        SecSignIDHttpSessionUtil.removeAttribute(session, AUTH_SESSION_ID_KEY, AUTH_SESSION_ICON_KEY, AUTH_SESSION_SECSIGN_ID_KEY, AUTH_SESSION_USERNAME_KEY, AUTH_SESSION_STATE_KEY);
        this.renderLogin(httpServletReq, httpServletResp, context);
    }

    private void handleError(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException {
        String errormsg = httpServletReq.getParameter("secsignid-handleerror");
        if (errormsg.equals("404")) {
            context.put("errormsg", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.session.not.found"));
        }
        if (errormsg.equals("400")) {
            context.put("errormsg", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.session.bad"));
        }
        if (errormsg.equals("500")) {
            context.put("errormsg", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.session.error"));
        }
        this.renderLogin(httpServletReq, httpServletResp, context);
    }

    private void handleCheckAuth(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException {
        HttpSession session = httpServletReq.getSession();
        String authSessionId = (String)SecSignIDHttpSessionUtil.getAttribute(session, AUTH_SESSION_ID_KEY);
        if (authSessionId == null) {
            logger.debug("No Auth Session ID was found");
            authSessionId = "null";
        }
        try {
            SecSignIDRESTCheckAuthSessionStateResponse sessionStateResponse = SecSignIDServerRESTConnector.checkAuth(authSessionId);
            SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_STATE_KEY, sessionStateResponse.getAuthSessionStateValue());
            JSONObject answerObject = new JSONObject();
            answerObject.put("success", true);
            answerObject.put("authSessionState", sessionStateResponse.getAuthSessionStateValue());
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (SecSignIDRESTException e) {
            JSONObject answerObject = new JSONObject();
            try {
                answerObject.put("success", false);
                answerObject.put("errormsg", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (JSONException e) {
            return;
        }
    }

    private void handleSessionState(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException {
        HttpSession session = httpServletReq.getSession();
        int sessionState = (Integer)SecSignIDHttpSessionUtil.getAttribute(session, AUTH_SESSION_STATE_KEY);
        String secsignidAuthed = (String)SecSignIDHttpSessionUtil.getAttribute(session, AUTH_SESSION_SECSIGN_ID_KEY);
        SecSignIDHttpSessionUtil.removeAttribute(session, AUTH_SESSION_ID_KEY, AUTH_SESSION_ICON_KEY, AUTH_SESSION_SECSIGN_ID_KEY, AUTH_SESSION_USERNAME_KEY, AUTH_SESSION_STATE_KEY);
        User user = null;
        String userKey = null;
        if (sessionState == 3) {
            if (this.tempMappings.containsKey(secsignidAuthed)) {
                try {
                    userKey = this.tempMappings.get(secsignidAuthed);
                    user = this.dataAccessor.getUserForKeyFirst(userKey);
                    if (user == null) {
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.action.noappuser", null, context);
                        return;
                    }
                    this.dataAccessor.saveSecSignIDForUserKey(userKey, user.getDirectoryId(), secsignidAuthed);
                    this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), secsignidAuthed, httpServletReq.getRemoteAddr());
                    if (SecSignIDCommonStaticAccessor.getInformUser()) {
                        this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), secsignidAuthed);
                    }
                    if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                        this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), secsignidAuthed);
                    }
                    SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(httpServletReq, userKey, user.getDirectoryId());
                    activatedSettings.setTwoStepActive(true);
                    this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
                }
                catch (com.atlassian.crowd.exception.OperationFailedException e) {
                    logger.error("OperationFailedException on saveMappings on handleSessionState");
                    logger.error(e.getMessage(), (Throwable)e);
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                    return;
                }
                catch (OperationFailedException e) {
                    logger.error("runtime.OperationFailedException on saveMappings on handleSessionState");
                    logger.error(e.getMessage(), (Throwable)e);
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                    return;
                }
                catch (Exception e) {
                    logger.error("ApplicationPermissionException on saveMappings on handleSessionState");
                    logger.error(e.getMessage(), (Throwable)e);
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                    return;
                }
            }
            try {
                String mappingKey = this.dataAccessor.getMappingKeyForSecSignID(secsignidAuthed);
                userKey = SecSignIDMappingUtils.getUserKeyFromMappingKey(mappingKey);
                user = this.dataAccessor.getUserForKeyFirst(userKey);
                if (user == null) {
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.action.noappuser", null, context);
                    return;
                }
                SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(httpServletReq, userKey, user.getDirectoryId());
                activatedSettings.setTwoStepActive(true);
                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
            }
            catch (com.atlassian.crowd.exception.OperationFailedException e) {
                logger.error("OperationFailedException on handleSessionState " + e.getMessage());
                this.printStackTrace(e.getStackTrace());
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            catch (DirectoryPermissionException e) {
                logger.error("DirectoryPermissionException on handleSessionState " + e.getMessage());
                this.printStackTrace(e.getStackTrace());
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            catch (ApplicationPermissionException e) {
                logger.error("ApplicationPermissionException on handleSessionState " + e.getMessage());
                this.printStackTrace(e.getStackTrace());
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            catch (InvalidAuthenticationException e) {
                logger.error("InvalidAuthenticationException on handleSessionState " + e.getMessage());
                this.printStackTrace(e.getStackTrace());
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            catch (UserNotFoundException e) {
                logger.error("UserNotFoundException on handleSessionState " + e.getMessage());
                this.printStackTrace(e.getStackTrace());
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on handleSessionState " + e.getMessage());
                this.printStackTrace(e.getStackTrace());
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            catch (SecSignIDRESTException e) {
                logger.error("SecSignIDRESTException on handleSessionState " + e.getMessage());
                this.printStackTrace(e.getStackTrace());
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            this.tempMappings.remove(secsignidAuthed);
            if (user != null) {
                logger.info("auth session authenticated, login secsign id '" + secsignidAuthed + "' assigned to app user '" + user.getName() + "'");
                this.dataAccessor.deleteUserCreated(user.getName());
                this.requestAccessTokenForTwoStepAuthentication(httpServletReq);
                if (this.handleActivatingInactiveMethod(httpServletReq, httpServletResp, TWO_STEP_KEY, context)) {
                    return;
                }
                if (this.loginApplicationUser(user, httpServletReq, httpServletResp)) {
                    try {
                        if (httpServletReq.getHeader("X-Forwarded-For") != null) {
                            Object[] clientIpAddresses = httpServletReq.getHeader("X-Forwarded-For").split(",");
                            this.dataAccessor.saveIPForUserKey(userKey, user.getDirectoryId(), "IP: " + httpServletReq.getRemoteAddr() + " Forwarded-For:" + SecSignIDMappingUtils.arrayToString(clientIpAddresses));
                        } else {
                            this.dataAccessor.saveIPForUserKey(userKey, user.getDirectoryId(), httpServletReq.getRemoteAddr());
                        }
                        this.dataAccessor.saveLastMethodUsed(userKey, user.getDirectoryId(), TWO_STEP_KEY);
                    }
                    catch (Exception e) {
                        logger.error("Exception on saving IP-Mapping: " + e.getLocalizedMessage());
                    }
                    this.dataAccessor.deleteUserCreated(userKey);
                    this.clearAllSettingsFromSession(httpServletReq, userKey, user.getDirectoryId());
                    this.createTrustDeviceTokenIfActive(userKey, user.getDirectoryId(), httpServletReq, httpServletResp);
                    if (!this.handleSAMLLogin(httpServletReq, httpServletResp)) {
                        this.sendRedirect(httpServletReq, httpServletResp);
                        return;
                    }
                    logger.debug("Processed SAML Request. Redirect to SAML Service Provider.");
                    return;
                }
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.login.contact.admin", null, context);
                return;
            }
        } else {
            switch (sessionState) {
                case 5: {
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.session.suspended", null, context);
                    return;
                }
                case 4: {
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.session.denied", null, context);
                    return;
                }
                case 6: {
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.warning.canceled", null, context);
                    return;
                }
                case 2: {
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.session.expired", null, context);
                    return;
                }
            }
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.session.invalid", null, context);
            return;
        }
    }

    private void printStackTrace(StackTraceElement[] stackTrace) {
        for (StackTraceElement stackTraceElement : stackTrace) {
            logger.error(stackTraceElement.toString());
        }
    }

    private boolean checkRemoteAddressInSafeZone(HttpServletRequest httpServletReq) {
        block19: {
            List<String> ipRangesArray;
            block17: {
                block18: {
                    String[] clientIpAddresses;
                    ipRangesArray = SecSignIDCommonStaticAccessor.getIPRanges();
                    logger.debug("IP-Ranges defined for DMZ were set to '" + ipRangesArray.toString() + "'");
                    if (!SecSignIDCommonStaticAccessor.getUseForwardedHeader()) break block17;
                    String[] xForwardedFor = null;
                    if (httpServletReq.getHeader("X-Forwarded-For") == null) break block18;
                    logger.debug("Request has set header field X-Forwarded-For to '" + httpServletReq.getHeader("X-Forwarded-For") + "'");
                    LinkedList<String> clientIpAddrList = new LinkedList<String>();
                    for (String clientIpAddress : clientIpAddresses = httpServletReq.getHeader("X-Forwarded-For").split(",")) {
                        String clientIpAddrTrimmed = clientIpAddress.trim();
                        if (clientIpAddrTrimmed.isEmpty()) continue;
                        clientIpAddrList.add(clientIpAddrTrimmed);
                    }
                    xForwardedFor = clientIpAddrList.toArray(new String[clientIpAddrList.size()]);
                    if (xForwardedFor == null) break block19;
                    for (String forwardedFor : xForwardedFor) {
                        for (String ipInRange : ipRangesArray) {
                            InetAddress subnetAddress;
                            int suffixIndex;
                            if (ipInRange.equals("") || (suffixIndex = ipInRange.indexOf("/")) < 1) continue;
                            String subnetIP = ipInRange.substring(0, suffixIndex);
                            int suffixInt = Integer.parseInt(ipInRange.substring(suffixIndex + 1, ipInRange.length()));
                            try {
                                subnetAddress = InetAddress.getByName(subnetIP);
                            }
                            catch (UnknownHostException ex) {
                                logger.error(ex.getMessage());
                                return false;
                            }
                            try {
                                InetAddress forwardedIpAddress = InetAddress.getByName(forwardedFor);
                                if (!SecSignIDIPHelper.isHostAddressInSubnet(forwardedIpAddress, subnetAddress, suffixInt)) continue;
                                return true;
                            }
                            catch (Exception ex) {
                                logger.error(ex.getMessage());
                            }
                        }
                    }
                    break block19;
                }
                String ip = httpServletReq.getRemoteAddr();
                InetAddress hostAddress = null;
                try {
                    hostAddress = InetAddress.getByName(ip);
                }
                catch (UnknownHostException ex) {
                    logger.error(ex.getMessage());
                    return false;
                }
                logger.debug("Request has has remoteAddresse set to '" + hostAddress + "'");
                for (String ipInRange : ipRangesArray) {
                    InetAddress subnetAddress;
                    int suffixIndex;
                    if (ipInRange.equals("") || (suffixIndex = ipInRange.indexOf("/")) < 1) continue;
                    String subnetIP = ipInRange.substring(0, suffixIndex);
                    int suffixInt = Integer.parseInt(ipInRange.substring(suffixIndex + 1, ipInRange.length()));
                    try {
                        subnetAddress = InetAddress.getByName(subnetIP);
                    }
                    catch (UnknownHostException ex) {
                        logger.error(ex.getMessage());
                        return false;
                    }
                    if (!SecSignIDIPHelper.isHostAddressInSubnet(hostAddress, subnetAddress, suffixInt)) continue;
                    return true;
                }
                break block19;
            }
            String ip = httpServletReq.getRemoteAddr();
            InetAddress hostAddress = null;
            try {
                hostAddress = InetAddress.getByName(ip);
            }
            catch (UnknownHostException ex) {
                logger.error(ex.getMessage());
                return false;
            }
            logger.debug("Request has has remoteAddresse set to '" + hostAddress + "'");
            for (String ipInRange : ipRangesArray) {
                InetAddress subnetAddress;
                int suffixIndex;
                if (ipInRange.equals("") || (suffixIndex = ipInRange.indexOf("/")) < 1) continue;
                String subnetIP = ipInRange.substring(0, suffixIndex);
                int suffixInt = Integer.parseInt(ipInRange.substring(suffixIndex + 1, ipInRange.length()));
                try {
                    subnetAddress = InetAddress.getByName(subnetIP);
                }
                catch (UnknownHostException ex) {
                    logger.error(ex.getMessage());
                    return false;
                }
                if (!SecSignIDIPHelper.isHostAddressInSubnet(hostAddress, subnetAddress, suffixInt)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean loginApplicationUser(User appUser, HttpServletRequest request, HttpServletResponse response) {
        try {
            logger.info("login application user '" + appUser.getName() + "'.");
            this.dataAccessor.loginUserWithoutPassword(request, response, appUser);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void startAuth(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, String secSignId, String username, String userKey, long directoryId, HashMap<String, Object> context) throws RenderingException, IOException {
        String serviceName = SecSignIDCommonStaticAccessor.getServiceName();
        String serviceAddress = this.dataAccessor.getBaseUrl();
        this.noAccesspass = SecSignIDCommonStaticAccessor.getNoAccessPass();
        try {
            this.fillContextWithAllowedOptions(httpServletReq, userKey, directoryId, context);
        }
        catch (Exception e) {
            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.user.nologin", null, context);
            return;
        }
        logger.info("create a new authentication session for '" + secSignId + "' and service '" + serviceName + ".");
        try {
            SecSignIDRESTAuthenticationMethod methodToActivate = this.getAuthenticationMethodFromMethodToActivate(userKey, directoryId);
            boolean accessTokenRequired = SecSignIDAuthenticationUtil.isAccessTokenRequiredForActivation(secSignId, methodToActivate);
            if (accessTokenRequired && methodToActivate != SecSignIDRESTAuthenticationMethod.SEC_SIGN_ID) {
                SecSignIDRESTAccessTokenAuthorizationResponse accessTokenResponse = this.requestAccessTokenAuthorization(httpServletReq, secSignId, SecSignIDRESTAuthenticationMethod.SEC_SIGN_ID, methodToActivate);
                HttpSession session = httpServletReq.getSession();
                SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_ID_KEY, String.valueOf(accessTokenResponse.getAuthSessionId()));
                SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_SECSIGN_ID_KEY, secSignId);
                SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_USERNAME_KEY, username);
                context.put("secsignid", secSignId);
                context.put("authsessionid", String.valueOf(accessTokenResponse.getAuthSessionId()));
                context.put("accessTokenAuthorization", Boolean.TRUE);
            } else {
                SecSignIDRESTCreateAuthSessionResponse createAuthSessionResponse = SecSignIDServerRESTConnector.getAuthSession(secSignId, serviceName, serviceAddress, !this.noAccesspass);
                if (createAuthSessionResponse.getFrozen()) {
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.secsignid.frozen", null, context);
                    return;
                }
                HttpSession session = httpServletReq.getSession();
                SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_ID_KEY, String.valueOf(createAuthSessionResponse.getAuthSessionId()));
                SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_ICON_KEY, createAuthSessionResponse.getAuthSessionIconData());
                SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_SECSIGN_ID_KEY, secSignId);
                SecSignIDHttpSessionUtil.setAttribute(session, AUTH_SESSION_USERNAME_KEY, username);
                context.put("secsignid", secSignId);
                context.put("authsessionid", String.valueOf(createAuthSessionResponse.getAuthSessionId()));
                context.put("authsessionicondata", createAuthSessionResponse.getAuthSessionIconData());
            }
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | UserNotFoundException | SecSignIDRESTException e) {
            context.put("errormsg", e.getMessage());
            this.renderLogin(httpServletReq, httpServletResp, context);
            return;
        }
        this.templateRenderer.render(this.getAccesspassTemplate(), context, (Writer)httpServletResp.getWriter());
    }

    private void handleTwoStepOTPAuth(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, User user, String userKey, HashMap<String, Object> context) throws RenderingException, IOException {
        block77: {
            context.put("username", user.getName());
            this.createNewIdForTOTPIfRequired(httpServletReq, userKey, user);
            String[] idArray = null;
            try {
                String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
                idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
                this.fillContextWithAllowedOptions(httpServletReq, userKey, user.getDirectoryId(), context);
            }
            catch (com.atlassian.crowd.exception.OperationFailedException e) {
                logger.debug("OperationFailedException on JiraLogin with twoStepAuth and no pwdallowed");
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            catch (ApplicationPermissionException e) {
                logger.debug("ApplicationPermissionException on JiraLogin with twoStepAuth and no pwdallowed");
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            catch (InvalidAuthenticationException e) {
                logger.debug("InvalidAuthenticationException on JiraLogin with twoStepAuth and no pwdallowed");
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            catch (UserNotFoundException e) {
                logger.debug("UserNotFoundException on JiraLogin with twoStepAuth and no pwdallowed");
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            catch (DirectoryNotFoundException e) {
                logger.debug("DirectoryNotFoundException on JiraLogin with twoStepAuth and no pwdallowed");
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                return;
            }
            catch (SecSignIDRESTException e) {
                logger.error("SecSignIDRESTException on JiraLogin with twoStepAuth and no pwdallowed");
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
                return;
            }
            if (idArray == null || idArray.length == 0) {
                block76: {
                    String otpID = "";
                    try {
                        boolean autofillMail = SecSignIDCommonStaticAccessor.getAutoFillMail();
                        boolean autofillUser = SecSignIDCommonStaticAccessor.getAutoFillUsername();
                        boolean autofillUsercompany = SecSignIDCommonStaticAccessor.getAutoFillUsernameCompany();
                        boolean autoFillPattern = SecSignIDCommonStaticAccessor.getAutoFillPattern();
                        if (autofillMail) {
                            if (!SecSignIDServerRESTConnector.checkSecSignID(user.getEmailAddress().toLowerCase())) {
                                SecSignIDServerRESTConnector.createSecSignID(user.getEmailAddress().toLowerCase(), user.getEmailAddress());
                                this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getEmailAddress().toLowerCase());
                                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                                otpID = user.getEmailAddress().toLowerCase();
                                this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                                    this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                                    this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                            } else {
                                int indexToAdd = 1;
                                while (SecSignIDServerRESTConnector.checkSecSignID(user.getEmailAddress().toLowerCase() + indexToAdd)) {
                                    ++indexToAdd;
                                }
                                SecSignIDServerRESTConnector.createSecSignID(user.getEmailAddress().toLowerCase() + indexToAdd, user.getEmailAddress());
                                this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getEmailAddress().toLowerCase() + indexToAdd);
                                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                                otpID = user.getEmailAddress().toLowerCase() + indexToAdd;
                                this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                                    this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                                    this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                            }
                        } else if (autofillUser) {
                            if (!SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_"))) {
                                SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_"), user.getEmailAddress());
                                this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_"));
                                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                                otpID = user.getName().toLowerCase().replace(" ", "_");
                                this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                                    this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                                    this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                            } else {
                                int indexToAdd = 1;
                                while (SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + indexToAdd)) {
                                    ++indexToAdd;
                                }
                                SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_") + indexToAdd, user.getEmailAddress());
                                this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_") + indexToAdd);
                                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                                otpID = user.getName().toLowerCase().replace(" ", "_") + indexToAdd;
                                this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                                    this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                                    this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                            }
                        } else if (autofillUsercompany) {
                            if (!SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName())) {
                                SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName(), user.getEmailAddress());
                                this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName());
                                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                                otpID = user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName();
                                this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                                    this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                                    this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                            } else {
                                int indexToAdd = 1;
                                while (SecSignIDServerRESTConnector.checkSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd)) {
                                    ++indexToAdd;
                                }
                                SecSignIDServerRESTConnector.createSecSignID(user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd, user.getEmailAddress());
                                this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd);
                                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                                otpID = user.getName().toLowerCase().replace(" ", "_") + "@" + SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName() + indexToAdd;
                                this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                                    this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                                    this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                            }
                        } else if (autoFillPattern) {
                            String autoFillPatterPattern;
                            String result = autoFillPatterPattern = SecSignIDCommonStaticAccessor.getAutoFillPatternPattern();
                            result = result.replace("%username%", user.getName().toLowerCase().replace(" ", "_"));
                            result = result.replace("%displayname%", user.getDisplayName().replace(" ", "").toLowerCase());
                            result = result.replace("%mail%", user.getEmailAddress().toLowerCase());
                            result = result.replace("%index%", "");
                            if (!SecSignIDServerRESTConnector.checkSecSignID(result = result.toLowerCase())) {
                                SecSignIDServerRESTConnector.createSecSignID(result, user.getEmailAddress());
                                this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), result);
                                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                                otpID = result;
                                this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                                    this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                                    this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                            } else {
                                int indexToAdd = 1;
                                while (SecSignIDServerRESTConnector.checkSecSignID(result + indexToAdd)) {
                                    ++indexToAdd;
                                }
                                SecSignIDServerRESTConnector.createSecSignID(result + indexToAdd, user.getEmailAddress());
                                this.dataAccessor.saveSecSignIDForUserKey(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId(), result + indexToAdd);
                                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                                otpID = result + indexToAdd;
                                this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), otpID, httpServletReq.getRemoteAddr());
                                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                                    this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                                    this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), otpID);
                                }
                            }
                        }
                    }
                    catch (SecSignIDRESTException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.error("SecSignIDRESTException on creating ID for OTP:" + e.getMessage());
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
                        return;
                    }
                    catch (com.atlassian.crowd.exception.OperationFailedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.debug("OperationFailedException on creating ID for OTP:" + e.getMessage());
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                        return;
                    }
                    catch (ApplicationPermissionException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.debug("ApplicationPermissionException on creating ID for OTP:" + e.getMessage());
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                        return;
                    }
                    catch (InvalidAuthenticationException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.debug("InvalidAuthenticationException on creating ID for OTP:" + e.getMessage());
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                        return;
                    }
                    catch (DirectoryPermissionException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.debug("DirectoryPermissionException on creating ID for OTP:" + e.getMessage());
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                        return;
                    }
                    catch (OperationFailedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.debug("runtime.OperationFailedException on creating ID for OTP:" + e.getMessage());
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                        return;
                    }
                    catch (OperationNotPermittedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.debug("OperationNotPermittedException on creating ID for OTP:" + e.getMessage());
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                        return;
                    }
                    catch (NamingException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.debug("NamingException on creating ID for OTP:" + e.getMessage());
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                        return;
                    }
                    catch (DirectoryNotFoundException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.debug("DirectoryNotFoundException on creating ID for OTP:" + e.getMessage());
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                        return;
                    }
                    catch (UserNotFoundException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.debug("UserNotFoundException on creating ID for OTP:" + e.getMessage());
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.crowd.failed", null, context);
                        return;
                    }
                    SecSignIDHttpSessionUtil.setAttribute(httpServletReq.getSession(), SECSIGN_ID_KEY, otpID);
                    context.put("secSignID", otpID);
                    try {
                        boolean totpActive = false;
                        try {
                            SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(httpServletReq, userKey, user.getDirectoryId());
                            totpActive = activatedSettings.isTotpActive();
                        }
                        catch (com.atlassian.crowd.exception.OperationFailedException e1) {
                            logger.error("OperationFailedException on getTOTPActiveForUserKey on handleTwoStepOTPAuth");
                        }
                        catch (ApplicationPermissionException e1) {
                            logger.error("ApplicationPermissionException on getTOTPActiveForUserKey on handleTwoStepOTPAuth");
                        }
                        catch (InvalidAuthenticationException e1) {
                            logger.error("InvalidAuthenticationException on getTOTPActiveForUserKey on handleTwoStepOTPAuth");
                        }
                        if (totpActive) break block76;
                        SecSignIDRESTTOTPResponse totpResponse = SecSignIDServerRESTConnector.getTOTPQRCode(otpID, this.getAccessToken(httpServletReq));
                        String qrCode = totpResponse.getTotpQRCodeBase64();
                        String secretUrl = totpResponse.getTotpKeyUri();
                        if (totpResponse.getTotpKeyUri().equals("") && totpResponse.getTotpQRCodeBase64().equals("")) {
                            logger.error("SecSignIDRESTException on getTOTPQRCode: No Code found, Server not ready?");
                            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
                            return;
                        }
                        context.put("totpQRUrl", secretUrl);
                        context.put("totpQRCode", qrCode);
                        try {
                            String toExtract = secretUrl;
                            int startIndex = toExtract.indexOf("secret=") + 7;
                            int endIndex = toExtract.indexOf("&", startIndex);
                            String secret = toExtract.substring(startIndex, endIndex);
                            context.put("totpQRSecret", secret);
                        }
                        catch (IndexOutOfBoundsException e) {
                            logger.error("SecSignIDRESTException on getTOTPQRCode: No Code found, Server not ready?");
                            this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
                            return;
                        }
                    }
                    catch (SecSignIDRESTException e1) {
                        logger.error("SecSignIDRESTException on getTOTPQRCode: " + e1.getMessage());
                        this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + ":" + e1.getMessage(), context);
                        return;
                    }
                    catch (UserNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (DirectoryNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                this.templateRenderer.render(this.getTOTPLoginTemplate(), context, (Writer)httpServletResp.getWriter());
                return;
            }
            String secSignId = idArray[0];
            SecSignIDHttpSessionUtil.setAttribute(httpServletReq.getSession(), SECSIGN_ID_KEY, secSignId);
            context.put("secSignID", secSignId);
            try {
                boolean totpActive = false;
                try {
                    SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(httpServletReq, userKey, user.getDirectoryId());
                    totpActive = activatedSettings.isTotpActive();
                }
                catch (com.atlassian.crowd.exception.OperationFailedException e1) {
                    logger.error("OperationFailedException on getTOTPActiveForUserKey on handleTwoStepOTPAuth");
                }
                catch (ApplicationPermissionException e1) {
                    logger.error("ApplicationPermissionException on getTOTPActiveForUserKey on handleTwoStepOTPAuth");
                }
                catch (InvalidAuthenticationException e1) {
                    logger.error("InvalidAuthenticationException on getTOTPActiveForUserKey on handleTwoStepOTPAuth");
                }
                if (totpActive) break block77;
                SecSignIDRESTTOTPResponse totpResponse = SecSignIDServerRESTConnector.getTOTPQRCode(idArray[0], this.getAccessToken(httpServletReq));
                String qrCode = totpResponse.getTotpQRCodeBase64();
                String secretUrl = totpResponse.getTotpKeyUri();
                if (totpResponse.getTotpKeyUri().equals("") && totpResponse.getTotpQRCodeBase64().equals("")) {
                    logger.error("SecSignIDRESTException on getTOTPQRCode: No Code found, Server not ready?");
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
                    return;
                }
                context.put("totpQRUrl", secretUrl);
                context.put("totpQRCode", qrCode);
                try {
                    String toExtract = secretUrl;
                    int startIndex = toExtract.indexOf("secret=") + 7;
                    int endIndex = toExtract.indexOf("&", startIndex);
                    String secret = toExtract.substring(startIndex, endIndex);
                    context.put("totpQRSecret", secret);
                }
                catch (IndexOutOfBoundsException e) {
                    logger.error("SecSignIDRESTException on getTOTPQRCode: No Code found, Server not ready?");
                    this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", null, context);
                    return;
                }
            }
            catch (SecSignIDRESTException e1) {
                logger.error("SecSignIDRESTException on getTOTPQRCode: " + e1.getMessage());
                this.renderLoginWithError(httpServletReq, httpServletResp, "secsignid.messages.error.rest.normal.user", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + ":" + e1.getMessage(), context);
                return;
            }
            catch (UserNotFoundException e) {
                e.printStackTrace();
            }
            catch (DirectoryNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.templateRenderer.render(this.getTOTPLoginTemplate(), context, (Writer)httpServletResp.getWriter());
    }

    private void handleQR(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException {
        logger.debug("Handle QR on Authenticator");
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(httpServletReq);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(httpServletReq, this.dataAccessor);
        if (httpServletReq.getParameter("standard-id-cancel-button") != null) {
            logger.debug("Adding ID canceled on Authenticator");
            context.put("warnmsg", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.secsignidassign.cancel"));
            context.put("warnmsgkey", "secsignid.messages.error.secsignidassign.cancel");
            this.renderLogin(httpServletReq, httpServletResp, context);
            return;
        }
        if (httpServletReq.getParameter("standard-qrcode-cancel-button") != null) {
            logger.debug("Canceled QR on Authenticator");
            context.put("warnmsg", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.secsignidassign.cancel"));
            context.put("warnmsgkey", "secsignid.messages.error.secsignidassign.cancel");
            try {
                this.dataAccessor.saveSecSignIDForUserKey(userKey, user.getDirectoryId(), "");
                this.dataAccessor.logAutomaticUserChangeToAuditLog(userKey, user.getDirectoryId(), "", httpServletReq.getRemoteAddr());
                if (SecSignIDCommonStaticAccessor.getInformUser()) {
                    this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), "");
                }
                if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                    this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), userKey, user.getDirectoryId(), "");
                }
                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
                this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
                return;
            }
            catch (Exception e) {
                logger.debug("Problem deleting QR-Code for user: " + user.getName());
            }
        }
        if (httpServletReq.getParameter("standard-qrcode-dialog-button") != null) {
            logger.debug("QRCode scanned on Authenticator");
            try {
                String idToAdd = httpServletReq.getParameter("secsign_id");
                this.tempMappings.put(idToAdd, userKey);
                this.startAuth(httpServletReq, httpServletResp, idToAdd, user.getName(), userKey, user.getDirectoryId(), context);
                return;
            }
            catch (Exception e) {
                logger.debug("Problem deleting QR-Code for user: " + user.getName());
            }
        }
        if (httpServletReq.getParameter("standard-qrcode-dialog-button-create") != null) {
            String idToAdd = httpServletReq.getParameter("secsign_id");
            try {
                this.tempMappings.put(idToAdd, userKey);
                this.startAuth(httpServletReq, httpServletResp, idToAdd, user.getName(), userKey, user.getDirectoryId(), context);
                return;
            }
            catch (Exception e) {
                logger.debug("Problem deleting QR-Code for user: " + user.getName());
            }
        }
    }

    private void handleDialog(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, HashMap<String, Object> context) throws IOException {
        logger.debug("Handle Dialog on Authenticator");
        context.put("add", Boolean.TRUE);
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(httpServletReq);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(httpServletReq, this.dataAccessor);
        if (httpServletReq.getParameter("standard-id-cancel-button") != null) {
            logger.debug("Dialog canceled on Authenticator");
            context.put("warnmsg", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.secsignidassign.cancel"));
            context.put("warnmsgkey", "secsignid.messages.error.secsignidassign.cancel");
            this.renderLogin(httpServletReq, httpServletResp, context);
            return;
        }
        String idToAdd = httpServletReq.getParameter("secsign_id").toLowerCase();
        Object[] duplicateTest = new Object[3];
        try {
            duplicateTest = this.dataAccessor.checkDuplicates(idToAdd);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.debug("OperationFailedException on Dialog on Authenticator");
            this.addErrorToContext("secsignid.messages.error.crowd.failed", null, context);
            this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
            return;
        }
        catch (ApplicationPermissionException e) {
            logger.debug("ApplicationPermissionException on Dialog on Authenticator");
            this.addErrorToContext("secsignid.messages.error.crowd.failed", null, context);
            this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
            return;
        }
        catch (InvalidAuthenticationException e) {
            logger.debug("InvalidAuthenticationException on Dialog on Authenticator");
            this.addErrorToContext("secsignid.messages.error.crowd.failed", null, context);
            this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
            return;
        }
        catch (DirectoryNotFoundException e) {
            logger.debug("DirectoryNotFoundException on Dialog on Authenticator");
            this.addErrorToContext("secsignid.messages.error.crowd.failed", null, context);
            this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
            return;
        }
        boolean duplicate = (Boolean)duplicateTest[0];
        if (duplicate) {
            logger.debug("Duplicate found for SecSign ID " + idToAdd + " on Dialog on Authenticator");
            this.addErrorToContext("secsignid.dialog.addid.exists", null, context);
            this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
            return;
        }
        if (SecSignIDCommonStaticAccessor.secSignIdContainsIllegalCharacters(idToAdd)) {
            logger.debug("Illegal Chars found for SecSign ID " + idToAdd + " on Dialog on Authenticator");
            this.addErrorToContext("secsignid.messages.error.illegalcharacters", null, context);
            this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
            return;
        }
        try {
            boolean exist = SecSignIDServerRESTConnector.checkSecSignID(idToAdd);
            if (!exist) {
                this.addErrorToContext("secsignid.messages.error.secsignid.notexisting", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.secsignid.notexisting", new Serializable[]{idToAdd}), context);
                logger.debug("SecSign ID " + idToAdd + " not exists on Dialog on Authenticator");
                this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
                return;
            }
        }
        catch (SecSignIDRESTException e) {
            this.addErrorToContext("secsignid.messages.error.rest.normal.user", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + ":" + e.getMessage(), context);
            logger.debug("SecSignIDRESTException on Dialog on Authenticator: " + e.getMessage());
            this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
            return;
        }
        try {
            boolean restored;
            SecSignIDRESTDevicesResponse devicesResponse = SecSignIDServerRESTConnector.getDevicesOfSecSignID(idToAdd);
            boolean bl = restored = devicesResponse.getDeviceCount() != 0;
            if (!restored) {
                this.addErrorToContext("secsignid.messages.error.secsignid.notexisting", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.secsignid.notexisting", new Serializable[]{idToAdd}), context);
                logger.debug("SecSign ID " + idToAdd + " not exists on Dialog on Authenticator");
                this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
                return;
            }
        }
        catch (IOException e) {
            this.addErrorToContext("secsignid.messages.error.server.notreached", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.server.notreached", new Serializable[]{idToAdd}), context);
            logger.debug("IOException on Dialog on Authenticator");
            this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
            return;
        }
        catch (SecSignIDRESTException e) {
            this.addErrorToContext("secsignid.messages.error.rest.normal.user", SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.messages.error.rest.normal.user") + ":" + e.getMessage(), context);
            logger.debug("SecSignIDRESTException on Dialog on Authenticator: " + e.getMessage());
            this.templateRenderer.render(this.getIdDialogTemplate(), context, (Writer)httpServletResp.getWriter());
            return;
        }
        this.tempMappings.put(idToAdd, userKey);
        this.startAuth(httpServletReq, httpServletResp, idToAdd, user.getName(), userKey, user.getDirectoryId(), context);
    }

    private void sendRedirect(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        this.dataAccessor.sendRedirect(httpServletReq, httpServletResp);
    }

    private void addErrorToContext(String errorMessageKey, String errorMessage, HashMap<String, Object> context) {
        context.put("errormsgkey", errorMessageKey);
        if (errorMessage == null) {
            context.put("errormsg", SecSignIDCommonStaticAccessor.getI18nResolver().getText(errorMessageKey));
        } else {
            context.put("errormsg", errorMessage);
        }
    }

    private SecSignIDTrustDeviceToken getTrustDeviceTokenFromRequest(String userKey, long dirId, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        String tokenValue = null;
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals("secsignid_trustdevicetoken_" + this.dataAccessor.getApplication().toLowerCase())) continue;
            tokenValue = cookie.getValue();
            break;
        }
        if (tokenValue == null) {
            return null;
        }
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null || userAgent.equals("")) {
            userAgent = "empty";
        }
        try {
            return this.dataAccessor.getTrustDeviceToken(userKey, dirId, tokenValue, userAgent);
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return null;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error("OperationFailedException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return null;
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return null;
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return null;
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return null;
        }
        catch (DirectoryPermissionException e) {
            logger.error("DirectoryPermissionException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return null;
        }
    }

    private void createTrustDeviceTokenIfActive(String userKey, long dirId, HttpServletRequest request, HttpServletResponse response) {
        SecSignIDTrustDeviceToken token;
        boolean trustDevice;
        boolean bl = trustDevice = request.getParameter("trustDevice") != null;
        if (!trustDevice) {
            return;
        }
        if (!SecSignIDCommonStaticAccessor.getTrustDeviceEnabled()) {
            return;
        }
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null || userAgent.equals("")) {
            userAgent = "empty";
        }
        try {
            token = this.dataAccessor.createTrustDeviceToken(userKey, dirId, userAgent);
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on createTrustDeviceTokenIfActive");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            token = null;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error("OperationFailedException on createTrustDeviceTokenIfActive");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            token = null;
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on createTrustDeviceTokenIfActive");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            token = null;
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on createTrustDeviceTokenIfActive");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            token = null;
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on createTrustDeviceTokenIfActive");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            token = null;
        }
        catch (DirectoryPermissionException e) {
            logger.error("DirectoryPermissionException on createTrustDeviceTokenIfActive");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            token = null;
        }
        if (token == null) {
            return;
        }
        Cookie cookie = new Cookie("secsignid_trustdevicetoken_" + this.dataAccessor.getApplication().toLowerCase(), token.getToken());
        cookie.setPath("/");
        cookie.setMaxAge(SecSignIDCommonStaticAccessor.getTrustDeviceDuration() * 24 * 60 * 60);
        response.addCookie(cookie);
    }

    private SecSignIDRESTAuthenticationMethod getAuthenticationMethodFromMethodToActivate(String userKey, long directoryId) throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, DirectoryNotFoundException, UserNotFoundException {
        SecSignIDRESTAuthenticationMethod methodToActivate = SecSignIDRESTAuthenticationMethod.UNKNOWN;
        String selectedInactiveMethod = this.dataAccessor.getMethodToActivate(userKey, directoryId);
        if (selectedInactiveMethod != null && !selectedInactiveMethod.equals("none") && !selectedInactiveMethod.equals("")) {
            switch (selectedInactiveMethod) {
                case "id": {
                    methodToActivate = SecSignIDRESTAuthenticationMethod.SEC_SIGN_ID;
                    break;
                }
                case "totp": {
                    methodToActivate = SecSignIDRESTAuthenticationMethod.TOTP;
                    break;
                }
                case "fido": {
                    methodToActivate = SecSignIDRESTAuthenticationMethod.FIDO;
                    break;
                }
                case "mail-otp": {
                    methodToActivate = SecSignIDRESTAuthenticationMethod.MAIL_OTP;
                    break;
                }
                default: {
                    methodToActivate = SecSignIDRESTAuthenticationMethod.UNKNOWN;
                }
            }
        }
        return methodToActivate;
    }

    private SecSignIDRESTAccessTokenAuthorizationResponse requestAccessTokenAuthorization(HttpServletRequest request, String secSignId, SecSignIDRESTAuthenticationMethod authenticationMethod, SecSignIDRESTAuthenticationMethod methodToActivate) throws SecSignIDRESTException {
        SecSignIDRESTAccessTokenAuthorizationRequest.Capability capability;
        if (methodToActivate == SecSignIDRESTAuthenticationMethod.TOTP) {
            capability = SecSignIDRESTAccessTokenAuthorizationRequest.Capability.TOTP_SECRET;
        } else if (methodToActivate == SecSignIDRESTAuthenticationMethod.SEC_SIGN_ID) {
            capability = SecSignIDRESTAccessTokenAuthorizationRequest.Capability.SEC_SIGN_ID_DEVICE;
        } else if (methodToActivate == SecSignIDRESTAuthenticationMethod.FIDO) {
            capability = SecSignIDRESTAccessTokenAuthorizationRequest.Capability.FIDO_DEVICE;
        } else {
            logger.debug("No Capability was found for " + (Object)((Object)methodToActivate) + ". Using " + (Object)((Object)SecSignIDRESTAccessTokenAuthorizationRequest.Capability.SEC_SIGN_ID_DEVICE));
            capability = SecSignIDRESTAccessTokenAuthorizationRequest.Capability.SEC_SIGN_ID_DEVICE;
        }
        SecSignIDRESTAccessTokenAuthorizationResponse accessTokenAuthorizationResponse = SecSignIDServerRESTConnector.requestAccessTokenAuthorization(secSignId, authenticationMethod, capability);
        SecSignIDHttpSessionUtil.setAttribute(request.getSession(), ACCESS_TOKEN_AUTHORIZATION_ID_KEY, accessTokenAuthorizationResponse.getTokenId());
        return accessTokenAuthorizationResponse;
    }

    private String getAccessTokenAuthorizationId(HttpServletRequest request) {
        return (String)SecSignIDHttpSessionUtil.getAttribute(request.getSession(), ACCESS_TOKEN_AUTHORIZATION_ID_KEY);
    }

    private void requestAccessTokenForTwoStepAuthentication(HttpServletRequest request) {
        String tokenId = this.getAccessTokenAuthorizationId(request);
        if (tokenId == null) {
            return;
        }
        SecSignIDRESTAccessTokenRequest accessTokenRequest = new SecSignIDRESTAccessTokenRequest(tokenId);
        try {
            SecSignIDRESTAccessTokenResponse accessTokenResponse = SecSignIDServerRESTConnector.requestAccessToken(accessTokenRequest);
            SecSignIDHttpSessionUtil.setAttribute(request.getSession(), ACCESS_TOKEN_KEY, accessTokenResponse.getToken());
        }
        catch (SecSignIDRESTException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean requestAccessTokenForTOTPAuthentication(HttpServletRequest request, String totp) {
        String tokenId = this.getAccessTokenAuthorizationId(request);
        if (tokenId == null) {
            return false;
        }
        SecSignIDRESTAccessTokenTOTPRequest accessTokenRequest = new SecSignIDRESTAccessTokenTOTPRequest(tokenId, totp);
        try {
            SecSignIDRESTAccessTokenResponse accessTokenResponse = SecSignIDServerRESTConnector.requestAccessToken(accessTokenRequest);
            SecSignIDHttpSessionUtil.setAttribute(request.getSession(), ACCESS_TOKEN_KEY, accessTokenResponse.getToken());
            return true;
        }
        catch (SecSignIDRESTException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean requestAccessTokenForFIDOAuthentication(HttpServletRequest request, String credentialId, String clientDataJson, String authenticatorData, String signature, String userHandle) {
        String tokenId = this.getAccessTokenAuthorizationId(request);
        if (tokenId == null) {
            return false;
        }
        SecSignIDRESTAccessTokenFIDORequest accessTokenRequest = new SecSignIDRESTAccessTokenFIDORequest(tokenId, credentialId, clientDataJson, authenticatorData, signature, userHandle);
        try {
            SecSignIDRESTAccessTokenResponse accessTokenResponse = SecSignIDServerRESTConnector.requestAccessToken(accessTokenRequest);
            SecSignIDHttpSessionUtil.setAttribute(request.getSession(), ACCESS_TOKEN_KEY, accessTokenResponse.getToken());
            return true;
        }
        catch (SecSignIDRESTException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private String getAccessToken(HttpServletRequest request) {
        return (String)SecSignIDHttpSessionUtil.getAttribute(request.getSession(), ACCESS_TOKEN_KEY);
    }

    private String getSecSignLoginTemplate() {
        if (SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) {
            return "/templates/login/secsignid-crowd-secsign-login.vm";
        }
        return "/templates/login/login/secsignid-secsign-login.vm";
    }

    private String getBothLoginTemplate() {
        if (SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) {
            return "/templates/login/secsignid-crowd-both-login.vm";
        }
        return "/templates/login/secsignid-both-login.vm";
    }

    private String getNormalLoginTemplate() {
        if (SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) {
            return "/templates/login/secsignid-crowd-normal-login.vm";
        }
        return "/templates/login/secsignid-normal-login.vm";
    }

    private String getSafeZoneLoginTemplate() {
        if (SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) {
            return "/templates/login/secsignid-crowd-safezone-login.vm";
        }
        return "/templates/login/secsignid-safezone-login.vm";
    }

    private String getAccesspassTemplate() {
        if (SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) {
            return "/templates/login/secsignid-crowd-accesspass.vm";
        }
        return "/templates/login/secsignid-accesspass.vm";
    }

    private String getIdDialogTemplate() {
        if (SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) {
            return "/templates/login/secsignid-crowd-add-id-dialog.vm";
        }
        return "/templates/login/secsignid-add-id-dialog.vm";
    }

    private String getMailLoginTemplate() {
        if (SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) {
            return "/templates/login/secsignid-crowd-mail-login.vm";
        }
        return "/templates/login/secsignid-mail-login.vm";
    }

    private String getTOTPLoginTemplate() {
        if (SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) {
            return "/templates/login/secsignid-crowd-totp-login.vm";
        }
        return "/templates/login/secsignid-totp-login.vm";
    }

    private String getFIDOLoginTemplate() {
        if (SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) {
            return "/templates/login/secsignid-crowd-fido-login.vm";
        }
        return "/templates/login/secsignid-fido-login.vm";
    }

    private String getMethodSelectionTemplate() {
        if (SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) {
            return "/templates/login/secsignid-crowd-method-selection.vm";
        }
        return "/templates/login/secsignid-method-selection.vm";
    }

    private SecSignID2FASettings get2FASettingsFromUserKey(HttpServletRequest request, String userKey, long dirid) throws com.atlassian.crowd.exception.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        Object attributeTime = request.getSession().getAttribute(userKey + dirid + "settingstime");
        if (attributeTime != null) {
            Date timeNow = new Date();
            Date timeAttribute = (Date)attributeTime;
            if (timeNow.getTime() - timeAttribute.getTime() < 120000L) {
                Object fromSession = request.getSession().getAttribute(userKey + dirid + "2fasettings");
                if (fromSession != null) {
                    return new SecSignID2FASettings((String)fromSession);
                }
                SecSignID2FASettings settings = this.dataAccessor.get2FASettingsFromUserKey(userKey, dirid);
                request.getSession().setAttribute(userKey + dirid + "2fasettings", (Object)settings.toString());
                request.getSession().setAttribute(userKey + dirid + "settingstime", (Object)new Date());
                return settings;
            }
            SecSignID2FASettings settings = this.dataAccessor.get2FASettingsFromUserKey(userKey, dirid);
            request.getSession().setAttribute(userKey + dirid + "2fasettings", (Object)settings.toString());
            request.getSession().setAttribute(userKey + dirid + "settingstime", (Object)new Date());
            return settings;
        }
        SecSignID2FASettings settings = this.dataAccessor.get2FASettingsFromUserKey(userKey, dirid);
        request.getSession().setAttribute(userKey + dirid + "2fasettings", (Object)settings.toString());
        request.getSession().setAttribute(userKey + dirid + "settingstime", (Object)new Date());
        return settings;
    }

    private SecSignID2FAActivatedSettings get2FAActivatedSettingsFromUserKey(HttpServletRequest request, String userKey, long dirid) throws com.atlassian.crowd.exception.OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, SecSignIDRESTException, UserNotFoundException, DirectoryNotFoundException {
        Object attributeTime = request.getSession().getAttribute(userKey + dirid + "activatedsettingstime");
        if (attributeTime != null) {
            Date timeNow = new Date();
            Date timeAttribute = (Date)attributeTime;
            if (timeNow.getTime() - timeAttribute.getTime() < 120000L) {
                Object fromSession = request.getSession().getAttribute(userKey + dirid + "2faactivatedsettings");
                if (fromSession != null) {
                    return new SecSignID2FAActivatedSettings((String)fromSession);
                }
                SecSignID2FAActivatedSettings settings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, dirid);
                request.getSession().setAttribute(userKey + dirid + "2faactivatedsettings", (Object)settings.toString());
                request.getSession().setAttribute(userKey + dirid + "activatedsettingstime", (Object)new Date());
                return settings;
            }
            SecSignID2FAActivatedSettings settings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, dirid);
            request.getSession().setAttribute(userKey + dirid + "2faactivatedsettings", (Object)settings.toString());
            request.getSession().setAttribute(userKey + dirid + "activatedsettingstime", (Object)new Date());
            return settings;
        }
        SecSignID2FAActivatedSettings settings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, dirid);
        request.getSession().setAttribute(userKey + dirid + "2faactivatedsettings", (Object)settings.toString());
        request.getSession().setAttribute(userKey + dirid + "activatedsettingstime", (Object)new Date());
        return settings;
    }

    private void clearAllSettingsFromSession(HttpServletRequest request, String userKey, long dirid) {
        request.getSession().removeAttribute(userKey + dirid + "2faactivatedsettings");
        request.getSession().removeAttribute(userKey + dirid + "activatedsettingstime");
        request.getSession().removeAttribute(userKey + dirid + "2fasettings");
        request.getSession().removeAttribute(userKey + dirid + "settingstime");
    }

    private void prepareAndRenderMailLogin(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> context, String secSignId, String email) throws IOException {
        context.put("secSignID", secSignId);
        HttpSession session = request.getSession();
        session.setAttribute("mailotp.secsignid", (Object)secSignId);
        session.setAttribute("mailotp.email", (Object)email);
        this.templateRenderer.render(this.getMailLoginTemplate(), context, (Writer)response.getWriter());
    }

    private void handleExecuteMailLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        String secSignId = (String)session.getAttribute("mailotp.secsignid");
        String email = (String)session.getAttribute("mailotp.email");
        session.removeAttribute("mailotp.secsignid");
        session.removeAttribute("mailotp.email");
        if (secSignId == null || email == null) {
            session.setAttribute("mailotp.error", (Object)"secsignid.messages.error.crowd.failed");
            try {
                this.sendJSONSuccessResponse(response, false);
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return;
        }
        try {
            SecSignIDHttpSessionUtil.setAttribute(session, SECSIGN_ID_KEY, secSignId);
            SecSignIDServerRESTConnector.startMailAuth(secSignId, email);
        }
        catch (SecSignIDRESTException e) {
            session.setAttribute("mailotp.error", (Object)"secsignid.messages.error.rest.normal.user");
            try {
                this.sendJSONSuccessResponse(response, false);
            }
            catch (JSONException e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
            return;
        }
        try {
            this.sendJSONSuccessResponse(response, true);
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void handleExecuteMailLoginError(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> context) throws IOException {
        String error = (String)request.getSession().getAttribute("mailotp.error");
        request.getSession().removeAttribute("mailotp.error");
        if (error == null) {
            error = "secsignid.messages.error.crowd.failed";
        }
        this.renderLoginWithError(request, response, error, null, context);
    }

    private void sendJSONSuccessResponse(HttpServletResponse response, boolean success) throws IOException, JSONException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("success", success);
        JSONObject object = this.createJSONObjectFromMap(responseMap);
        this.sendJSONResponse(response, object);
    }

    private void sendJSONResponse(HttpServletResponse response, JSONObject object) throws IOException {
        response.setContentType("application/json");
        response.getWriter().write(object.toString());
    }

    private JSONObject createJSONObjectFromMap(Map<String, Object> map) throws JSONException {
        JSONObject object = new JSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            object.put(entry.getKey(), entry.getValue());
        }
        return object;
    }

    private void createNewIdForMailOTPIfRequired(HttpServletRequest request, String userKey, User user) {
        if (!SecSignIDCommonStaticAccessor.isUsingCloudServer()) {
            return;
        }
        if (!SecSignIDCommonStaticAccessor.hasPluginPinAccount()) {
            return;
        }
        try {
            String secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            if (secSignId == null) {
                return;
            }
            SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(request, userKey, user.getDirectoryId());
            if (!activatedSettings.isMailOtpActive() || activatedSettings.isTwoStepActive() || activatedSettings.isTotpActive() || activatedSettings.isFidoActive()) {
                return;
            }
            if (!SecSignIDServerRESTConnector.checkSecSignID(secSignId)) {
                SecSignIDServerRESTConnector.createSecSignID(secSignId, user.getEmailAddress());
                return;
            }
            SecSignIDRESTAccessTokenInfoResponse infoResponse = SecSignIDServerRESTConnector.getAccessTokenInfo(secSignId);
            if (infoResponse.isAccessAllowedWithoutToken()) {
                return;
            }
            if (infoResponse.getAuthenticationMethods().length > 0) {
                return;
            }
            String newSecSignId = SecSignIDAuthenticationUtil.tryFindAutoFillSecSignId(user, true);
            SecSignIDAuthenticationUtil.saveSecSignIdForUser(request, this.dataAccessor, user, newSecSignId);
            this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | OperationNotPermittedException | UserNotFoundException | DirectoryPermissionException | SecSignIDRESTException | NamingException e) {
            logger.error("Couldn't check if new ID is required for Mail OTP");
            logger.error(e.getMessage(), e);
        }
    }

    private void createNewIdForTOTPIfRequired(HttpServletRequest request, String userKey, User user) {
        if (!SecSignIDCommonStaticAccessor.isUsingCloudServer()) {
            return;
        }
        if (!SecSignIDCommonStaticAccessor.hasPluginPinAccount()) {
            return;
        }
        try {
            String secSignId = SecSignIDAuthenticationUtil.getSecSignIdForUser(this.dataAccessor, user, userKey);
            if (secSignId == null) {
                return;
            }
            SecSignID2FAActivatedSettings activatedSettings = this.get2FAActivatedSettingsFromUserKey(request, userKey, user.getDirectoryId());
            if (activatedSettings.isMailOtpActive() || activatedSettings.isTwoStepActive() || activatedSettings.isTotpActive() || activatedSettings.isFidoActive()) {
                return;
            }
            if (!SecSignIDServerRESTConnector.checkSecSignID(secSignId)) {
                SecSignIDServerRESTConnector.createSecSignID(secSignId, user.getEmailAddress());
                return;
            }
            SecSignIDRESTAccessTokenInfoResponse infoResponse = SecSignIDServerRESTConnector.getAccessTokenInfo(secSignId);
            if (infoResponse.isAccessAllowedWithoutToken()) {
                return;
            }
            List<SecSignIDRESTAuthenticationMethod> authenticationMethods = Arrays.asList(infoResponse.getAuthenticationMethods());
            if (authenticationMethods.size() > 1) {
                return;
            }
            if (!authenticationMethods.contains((Object)SecSignIDRESTAuthenticationMethod.TOTP)) {
                return;
            }
            String newSecSignId = SecSignIDAuthenticationUtil.tryFindAutoFillSecSignId(user, true);
            SecSignIDServerRESTConnector.createSecSignID(newSecSignId, user.getEmailAddress());
            SecSignIDAuthenticationUtil.saveSecSignIdForUser(request, this.dataAccessor, user, newSecSignId);
            this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
        }
        catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException | OperationNotPermittedException | UserNotFoundException | DirectoryPermissionException | SecSignIDRESTException | NamingException e) {
            logger.error("Couldn't check if new ID is required for Mail OTP");
            logger.error(e.getMessage(), e);
        }
    }
}

