/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDRESTCreateQRCodeResponse {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDRESTCreateQRCodeResponse.class);
    private final String createUrl;
    private final String qrCodeBase64;

    public static SecSignIDRESTCreateQRCodeResponse fromJson(String json) throws JSONException, SecSignIDRESTException {
        JSONObject rootObject = new JSONObject(json);
        String createUrl = rootObject.optString("createurl", null);
        if (createUrl == null) {
            logger.debug("Key 'createurl' not found");
            throw new SecSignIDRESTException("Key 'createurl' not found");
        }
        String qrCodeBase64 = rootObject.optString("qrcodebase64", null);
        if (qrCodeBase64 == null) {
            logger.debug("Key 'qrcodebase64' not found");
            throw new SecSignIDRESTException("Key 'qrcodebase64' not found");
        }
        return new SecSignIDRESTCreateQRCodeResponse(createUrl, qrCodeBase64);
    }

    private SecSignIDRESTCreateQRCodeResponse(String createUrl, String qrCodeBase64) {
        this.createUrl = createUrl;
        this.qrCodeBase64 = qrCodeBase64;
    }

    public String getCreateUrl() {
        return this.createUrl;
    }

    public String getQrCodeBase64() {
        return this.qrCodeBase64;
    }
}

