/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.jobs;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.jobs.SecSignIDTelemetryJobRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDSchedulerUtil {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDSchedulerUtil.class);

    public static void registerJobRunner(SchedulerService schedulerService, SecSignIDDataAccessor dataAccessor) {
        logger.debug("Registering job runner");
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"com.secsign.atlassian.common.jobs.telemetry");
        schedulerService.registerJobRunner(jobRunnerKey, (JobRunner)new SecSignIDTelemetryJobRunner(dataAccessor));
        JobId jobId = JobId.of((String)"com.secsign.atlassian.common.jobs.telemetry:job");
        if (schedulerService.getJobDetails(jobId) != null) {
            return;
        }
        long interval = 604800000L;
        Schedule schedule = Schedule.forInterval((long)interval, null);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withSchedule(schedule).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        try {
            schedulerService.scheduleJob(jobId, jobConfig);
        }
        catch (SchedulerServiceException e) {
            logger.error("Couldn't schedule job: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void unregisterJobRunner(SchedulerService schedulerService) {
        logger.debug("Unregistering job runner");
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"com.secsign.atlassian.common.jobs.telemetry");
        JobId jobId = JobId.of((String)"com.secsign.atlassian.common.jobs.telemetry:job");
        schedulerService.unscheduleJob(jobId);
        schedulerService.unregisterJobRunner(jobRunnerKey);
    }
}

