/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.crypto;

import com.secsign.atlassian.common.crypto.AES;
import com.secsign.atlassian.common.crypto.SecSignExceptionKey;
import java.io.IOException;
import java.io.OutputStream;

public class CBCEncryptOutputStream
extends OutputStream {
    private int blockSize;
    private byte[] inputBlock;
    private byte[] previousCipherTextBlock;
    private int inputBlockOffset = 0;
    private OutputStream outStream;
    private AES aes;
    private boolean initVectorWritten = false;
    private byte[] randomPaddingBytes;
    private int padCount;

    protected CBCEncryptOutputStream(OutputStream outStream, AES aes, byte[] initVector) throws SecSignExceptionKey {
        this.outStream = outStream;
        this.aes = aes;
        this.blockSize = aes.getBlockSize();
        this.inputBlock = new byte[this.blockSize];
        if (initVector.length != this.blockSize) {
            throw new SecSignExceptionKey("Wrong init vector len: " + initVector.length + ". Use " + this.blockSize + ".");
        }
        boolean writeInitVector = true;
        this.previousCipherTextBlock = initVector;
        boolean bl = this.initVectorWritten = !writeInitVector;
        if (null != this.randomPaddingBytes && this.randomPaddingBytes.length < this.blockSize) {
            throw new SecSignExceptionKey("Not enough random padding bytes given: " + initVector.length + ". Need " + this.blockSize + ".");
        }
        this.randomPaddingBytes = null;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.initVectorWritten) {
            this.initVectorWritten = true;
            this.outStream.write(this.previousCipherTextBlock);
        }
        this.inputBlock[this.inputBlockOffset] = (byte)(b & 0xFF);
        ++this.inputBlockOffset;
        if (this.inputBlockOffset >= this.blockSize) {
            this.previousCipherTextBlock = this.blockEncryptCBC(this.inputBlock);
            this.outStream.write(this.previousCipherTextBlock);
            this.inputBlockOffset = 0;
        }
    }

    @Override
    public void write(byte[] b, int startOffset, int len) throws IOException {
        int bytesToCopy;
        if (!this.initVectorWritten) {
            this.initVectorWritten = true;
            this.outStream.write(this.previousCipherTextBlock);
        }
        int offset = startOffset;
        for (int bytesLeft = len; bytesLeft > 0; bytesLeft -= bytesToCopy) {
            bytesToCopy = Math.min(bytesLeft, this.blockSize - this.inputBlockOffset);
            System.arraycopy(b, offset, this.inputBlock, this.inputBlockOffset, bytesToCopy);
            offset += bytesToCopy;
            this.inputBlockOffset += bytesToCopy;
            if (this.inputBlockOffset < this.blockSize) continue;
            this.previousCipherTextBlock = this.blockEncryptCBC(this.inputBlock);
            this.outStream.write(this.previousCipherTextBlock);
            this.inputBlockOffset = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.initVectorWritten) {
            this.initVectorWritten = true;
            this.outStream.write(this.previousCipherTextBlock);
        }
        this.padCount = this.blockSize - this.inputBlockOffset;
        if (this.padCount > 255) {
            throw new RuntimeException("This padding method works only up to 255 padding bytes");
        }
        if (this.randomPaddingBytes != null) {
            System.arraycopy(this.randomPaddingBytes, 0, this.inputBlock, this.inputBlockOffset, this.blockSize - this.inputBlockOffset);
        } else {
            while (this.inputBlockOffset < this.blockSize) {
                this.inputBlock[this.inputBlockOffset] = (byte)this.padCount;
                ++this.inputBlockOffset;
            }
        }
        this.outStream.write(this.blockEncryptCBC(this.inputBlock));
    }

    private byte[] blockEncryptCBC(byte[] paddedInputBlock) {
        byte[] plainTextXorBlock = new byte[this.blockSize];
        for (int j = 0; j < this.blockSize; ++j) {
            plainTextXorBlock[j] = (byte)(this.previousCipherTextBlock[j] ^ paddedInputBlock[j]);
        }
        return this.aes.blockEncrypt(plainTextXorBlock);
    }
}

