/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.accessor;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.secsign.atlassian.common.crypto.AES;
import com.secsign.atlassian.common.crypto.SecSignExceptionKey;
import com.secsign.atlassian.common.data.SecSignIDServerVersion;
import com.secsign.atlassian.common.data.SecSignIDTrustDeviceToken;
import com.secsign.atlassian.common.data.SecSignIDWhiteListItem;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import com.secsign.atlassian.common.rest.SecSignIDServerRESTConnector;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDDefaultValues;
import com.secsign.atlassian.common.util.SecSignIDLoggingHelper;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import com.secsign.atlassian.common.util.SecSignIDOTPGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SecSignIDCommonStaticAccessor {
    private static String allowedCharacters = "-_.@";
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDCommonStaticAccessor.class);
    private static PluginSettingsFactory pluginSettingsFactory;
    private static ApplicationProperties applicationProperties;
    private static SecSignIDDataAccessor dataAccessor;
    private static I18nResolver i18nResolver;

    public SecSignIDCommonStaticAccessor(SecSignIDDataAccessor dataAccessor, PluginSettingsFactory pluginSettingsFactory, ApplicationProperties applicationProperties, I18nResolver i18nResolver) {
        SecSignIDCommonStaticAccessor.pluginSettingsFactory = pluginSettingsFactory;
        SecSignIDCommonStaticAccessor.applicationProperties = applicationProperties;
        SecSignIDCommonStaticAccessor.i18nResolver = i18nResolver;
        SecSignIDCommonStaticAccessor.dataAccessor = dataAccessor;
    }

    public static PluginSettingsFactory getPluginSettingsFactory() {
        return pluginSettingsFactory;
    }

    public static SecSignIDDataAccessor getSecSignIDDataAccessor() {
        return dataAccessor;
    }

    public static I18nResolver getI18nResolver() {
        return i18nResolver;
    }

    public static ApplicationProperties getApplicationProperties() {
        return applicationProperties;
    }

    public static String getCleanLowerCaseCompanyName() {
        String companyName = SecSignIDCommonStaticAccessor.getCompanyName();
        companyName = companyName.replace(" ", "").toLowerCase();
        return companyName;
    }

    public static String getCompanyName() {
        String companyName = null;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.companyname");
        if (value != null) {
            companyName = value.toString();
        }
        if (companyName == null || companyName.length() < 1) {
            companyName = "";
        }
        return companyName;
    }

    public static void saveCompanyName(String companyName) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.companyname", (Object)companyName);
    }

    public static boolean isDefaultServer() {
        String idServerUrl = null;
        if (pluginSettingsFactory != null) {
            idServerUrl = (String)pluginSettingsFactory.createGlobalSettings().get("com.secsign.idserverurl");
        }
        if (idServerUrl == null || idServerUrl.length() < 1) {
            return true;
        }
        return idServerUrl.equals("https://httpapi.secsign.com");
    }

    public static String getServiceName() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        String serviceName = (String)globalPluginSettings.get("com.secsign.servicename");
        if (serviceName == null || serviceName.length() < 1) {
            serviceName = applicationProperties.getDisplayName();
        }
        return serviceName;
    }

    public static void saveServiceName(String serviceName) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.servicename", (Object)serviceName);
    }

    public static String getServiceDeskGroups() {
        String serviceDeskGroups = "";
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = pluginSettings.get("com.secsign.servicedeskgroup");
        if (value != null) {
            serviceDeskGroups = value.toString();
        }
        return serviceDeskGroups;
    }

    public static void saveServiceDeskGroups(String serviceDeskGroups) {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put("com.secsign.servicedeskgroup", (Object)serviceDeskGroups);
    }

    public static boolean getUseFallback() {
        boolean usefallback = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.usefallback");
        if (value != null) {
            usefallback = Boolean.parseBoolean(value.toString());
        }
        if (value == null) {
            usefallback = true;
        }
        return usefallback;
    }

    @Deprecated
    public static boolean getNoFallback() {
        boolean usefallback = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.nofallback");
        if (value != null) {
            usefallback = Boolean.parseBoolean(value.toString());
        }
        if (value == null) {
            usefallback = false;
        }
        return usefallback;
    }

    public static void saveUseFallback(boolean useFallback) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.usefallback", (Object)String.valueOf(useFallback));
    }

    public static boolean getFirstStart() {
        boolean firstStart = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.firststart");
        if (value != null) {
            firstStart = Boolean.parseBoolean(value.toString());
        }
        if (value == null) {
            firstStart = true;
        }
        return firstStart;
    }

    public static void saveFirstStart(boolean firstStart) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.firststart", (Object)String.valueOf(firstStart));
    }

    public static boolean getNoAccessPass() {
        boolean noAccessPass = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value4 = globalPluginSettings.get("com.secsign.noaccesspass");
        noAccessPass = value4 != null ? Boolean.parseBoolean((String)value4) : false;
        return noAccessPass;
    }

    public static void saveNoAccesspass(boolean noAccesspass) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.noaccesspass", (Object)String.valueOf(noAccesspass));
    }

    public static void savePasswordlessEnabled(boolean passwordlessEnabled) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.passwordless.enabled", (Object)String.valueOf(passwordlessEnabled));
    }

    public static void saveSecSignEnabled(boolean secsignEnabled) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.secsign.enabled", (Object)String.valueOf(secsignEnabled));
    }

    public static void saveFIDOEnabled(boolean fidoEnabled) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.fido.enabled", (Object)String.valueOf(fidoEnabled));
    }

    public static void saveTOTPEnabled(boolean totpEnabled) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.totp.enabled", (Object)String.valueOf(totpEnabled));
    }

    public static void saveMailOTPEnabled(boolean mailotpEnabled) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.mailotp.enabled", (Object)String.valueOf(mailotpEnabled));
    }

    public static boolean getPasswordlessAuthEnabled() {
        return SecSignIDCommonStaticAccessor.getGlobalSettingsBoolean("com.secsign.passwordless.enabled", true);
    }

    public static boolean getTwoStepAuthEnabled() {
        return SecSignIDCommonStaticAccessor.getGlobalSettingsBoolean("com.secsign.secsign.enabled", true);
    }

    public static boolean getMailotpAuthEnabled() {
        return SecSignIDCommonStaticAccessor.getGlobalSettingsBoolean("com.secsign.mailotp.enabled", true);
    }

    public static boolean getTotpAuthEnabled() {
        return SecSignIDCommonStaticAccessor.getGlobalSettingsBoolean("com.secsign.totp.enabled", true);
    }

    public static boolean getFidoAuthEnabled() {
        return SecSignIDCommonStaticAccessor.getGlobalSettingsBoolean("com.secsign.fido.enabled", true);
    }

    public static boolean getCustomLogin() {
        boolean customLogin = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value4 = globalPluginSettings.get("com.secsign.customlogin");
        customLogin = value4 != null ? Boolean.parseBoolean((String)value4) : false;
        return customLogin;
    }

    public static void saveCustomLogin(boolean customLogin) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.customlogin", (Object)String.valueOf(customLogin));
    }

    public static boolean getUserChange() {
        boolean userchange = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value4 = globalPluginSettings.get("com.secsign.userchange");
        userchange = value4 != null ? Boolean.parseBoolean((String)value4) : true;
        return userchange;
    }

    public static void saveUserChange(boolean userChange) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.userchange", (Object)String.valueOf(userChange));
    }

    public static boolean getSafeZone() {
        boolean safeZone = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value4 = globalPluginSettings.get("com.secsign.safezone");
        safeZone = value4 != null ? Boolean.parseBoolean((String)value4) : false;
        return safeZone;
    }

    public static void saveSafeZone(boolean safeZone) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.safezone", (Object)String.valueOf(safeZone));
    }

    public static boolean getUseForwardedHeader() {
        boolean useForwardedHeader = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value4 = globalPluginSettings.get("com.secsign.useforwardedheader");
        useForwardedHeader = value4 != null ? Boolean.parseBoolean((String)value4) : false;
        return useForwardedHeader;
    }

    public static void saveUseForwardedHeader(boolean useForwardedHeader) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.useforwardedheader", (Object)String.valueOf(useForwardedHeader));
    }

    public static List<String> getIPRanges() {
        ArrayList<String> ipRanges = new ArrayList();
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.safezonerange");
        if (value != null) {
            ipRanges = new ArrayList<String>(Arrays.asList(value.toString().split(";")));
            SecSignIDCommonStaticAccessor.saveIPRange(ipRanges);
            globalPluginSettings.remove("com.secsign.safezonerange");
            return ipRanges;
        }
        int i = 0;
        String newStyleRangeString = "";
        value = globalPluginSettings.get("com.secsign.safezonerange" + i);
        if (value != null) {
            newStyleRangeString = newStyleRangeString + value;
            ++i;
            while (globalPluginSettings.get("com.secsign.safezonerange" + i) != null) {
                value = globalPluginSettings.get("com.secsign.safezonerange" + i);
                newStyleRangeString = newStyleRangeString + value;
                ++i;
            }
            ipRanges = new ArrayList<String>(Arrays.asList(newStyleRangeString.split(";")));
            return ipRanges;
        }
        return new ArrayList<String>();
    }

    public static void saveIPRange(List<String> ipRange) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        int i = 0;
        while (globalPluginSettings.get("com.secsign.safezonerange" + i) != null) {
            globalPluginSettings.remove("com.secsign.safezonerange" + i);
            ++i;
        }
        String ipRangeString = "";
        for (String string : ipRange) {
            ipRangeString = ipRangeString + string + ";";
        }
        List<String> ipRangeParts = SecSignIDCommonStaticAccessor.getStringParts(ipRangeString);
        i = 0;
        for (String string : ipRangeParts) {
            globalPluginSettings.put("com.secsign.safezonerange" + i, (Object)String.valueOf(string));
            ++i;
        }
    }

    private static List<String> getStringParts(String fullString) {
        ArrayList<String> parts = new ArrayList<String>();
        int len = fullString.length();
        for (int i = 0; i < len; i += 255) {
            parts.add(fullString.substring(i, Math.min(len, i + 255)));
        }
        return parts;
    }

    public static String getLoginColor() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value4 = globalPluginSettings.get("com.secsign.logincolor");
        String loginColor = value4 != null ? (String)value4 : "#00a2e2";
        return loginColor;
    }

    public static void saveLoginColor(String loginColor) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.logincolor", (Object)loginColor);
    }

    public static boolean getUseNewCrowdLogin() {
        boolean useNewCrowdLogin = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.crowdnewlogin");
        if (value != null) {
            useNewCrowdLogin = Boolean.parseBoolean(value.toString());
        }
        return useNewCrowdLogin;
    }

    public static void saveUseNewCrowdLogin(boolean useNewCrowdLogin) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.crowdnewlogin", (Object)String.valueOf(useNewCrowdLogin));
    }

    public static String getLoginTitle() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.logintitle");
        if (value != null) {
            return value.toString();
        }
        return "Hello there!";
    }

    public static void saveLoginTitle(String loginTitle) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.logintitle", (Object)loginTitle);
    }

    public static String getLoginSubtitle() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.loginsubtitle");
        if (value != null) {
            return value.toString();
        }
        return "Lets get some work done";
    }

    public static void saveLoginSubtitle(String loginSubtitle) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.loginsubtitle", (Object)loginSubtitle);
    }

    public static String getCustomLink() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.logincustomlink");
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public static void saveCustomLink(String customLink) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.logincustomlink", (Object)customLink);
    }

    public static String getCustomLinkText() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.logincustomlinktext");
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public static void saveCustomLinkText(String customLinkText) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.logincustomlinktext", (Object)customLinkText);
    }

    public static boolean getHidePasswordlessLink() {
        boolean hidePasswordlessLink = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.hidepasswordlesslink");
        if (value != null) {
            hidePasswordlessLink = Boolean.parseBoolean(value.toString());
        }
        return hidePasswordlessLink;
    }

    public static void saveHidePasswordlessLink(boolean hidePasswordlessLink) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.hidepasswordlesslink", (Object)String.valueOf(hidePasswordlessLink));
    }

    public static boolean getSessionTimeoutEnabled() {
        boolean sessionTimeoutEnabled = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.sessiontimeout");
        if (value != null) {
            sessionTimeoutEnabled = Boolean.parseBoolean(value.toString());
        }
        return sessionTimeoutEnabled;
    }

    public static void saveSessionTimeoutEnabled(boolean sessionTimeoutEnabled) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.sessiontimeout", (Object)String.valueOf(sessionTimeoutEnabled));
    }

    public static int getSessionTimeoutDuration() {
        int sessionTimeoutDuration = 300;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.sessiontimeout.duration");
        if (value != null) {
            sessionTimeoutDuration = Integer.parseInt(value.toString());
        }
        return sessionTimeoutDuration;
    }

    public static void saveSessionTimeoutDuration(int sessionTimeoutDuration) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.sessiontimeout.duration", (Object)String.valueOf(sessionTimeoutDuration));
    }

    public static boolean getTrustDeviceEnabled() {
        boolean trustDeviceEnabled = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.trustdevice");
        if (value != null) {
            trustDeviceEnabled = Boolean.parseBoolean(value.toString());
        }
        return trustDeviceEnabled;
    }

    public static void saveTrustDeviceEnabled(boolean trustDeviceEnabled) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.trustdevice", (Object)String.valueOf(trustDeviceEnabled));
    }

    public static int getTrustDeviceDuration() {
        int trustDeviceDuration = 30;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.trustdevice.duration");
        if (value != null) {
            trustDeviceDuration = Integer.parseInt(value.toString());
        }
        return trustDeviceDuration;
    }

    public static void saveTrustDeviceDuration(int trustDeviceDuration) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.trustdevice.duration", (Object)String.valueOf(trustDeviceDuration));
    }

    public static String getCustomLogo() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value4 = globalPluginSettings.get("com.secsign.customlogo");
        String customLogo = value4 != null ? (String)value4 : "";
        return customLogo;
    }

    public static void saveCustomLogo(String customLogo) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.customlogo", (Object)customLogo);
    }

    public static String getIOSUrl() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value4 = globalPluginSettings.get("com.secsign.iOSUrl");
        String url = value4 != null ? (String)value4 : i18nResolver.getText("secsignid.messages.activatetwofa.itunes.link");
        return url;
    }

    public static void saveIOSUrl(String url) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.iOSUrl", (Object)url);
    }

    public static String getAndroidUrl() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value4 = globalPluginSettings.get("com.secsign.androidUrl");
        String url = value4 != null ? (String)value4 : i18nResolver.getText("secsignid.messages.activatetwofa.google.link");
        return url;
    }

    public static void saveAndroidUrl(String url) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.androidUrl", (Object)url);
    }

    public static String getWindowsUrl() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value4 = globalPluginSettings.get("com.secsign.windowsUrl");
        String url = value4 != null ? (String)value4 : i18nResolver.getText("secsignid.messages.activatetwofa.windows.link");
        return url;
    }

    public static void saveWindowsUrl(String url) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.windowsUrl", (Object)url);
    }

    public static String getMacOSUrl() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value4 = globalPluginSettings.get("com.secsign.macOSUrl");
        String url = value4 != null ? (String)value4 : i18nResolver.getText("secsignid.messages.activatetwofa.mac.link");
        return url;
    }

    public static void saveMacOSUrl(String url) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.macOSUrl", (Object)url);
    }

    public static boolean getAutoFillUsername() {
        boolean fillUsername = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.autofillusername");
        if (value != null) {
            fillUsername = Boolean.parseBoolean(value.toString());
        }
        return fillUsername;
    }

    public static void saveAutoFillUsername(boolean autoFillUsername) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.autofillusername", (Object)String.valueOf(autoFillUsername));
    }

    public static boolean getAutoFillUsernameCompany() {
        boolean fillUsername = true;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.autofillusernamecompany");
        if (value != null) {
            fillUsername = Boolean.parseBoolean(value.toString());
        }
        return fillUsername;
    }

    public static void saveAutoFillUsernameCompany(boolean autoFillUsernameCompany) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.autofillusernamecompany", (Object)String.valueOf(autoFillUsernameCompany));
    }

    public static boolean getAutoFillMail() {
        boolean fillUsername = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.autofillmail");
        if (value != null) {
            fillUsername = Boolean.parseBoolean(value.toString());
        }
        return fillUsername;
    }

    public static void saveAutoFillMail(boolean autoFillMail) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.autofillmail", (Object)String.valueOf(autoFillMail));
    }

    public static boolean getAutoFillPattern() {
        boolean fillPattern = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.autofillpattern");
        if (value != null) {
            fillPattern = Boolean.parseBoolean(value.toString());
        }
        return fillPattern;
    }

    public static void saveAutoFillPattern(boolean autoFillPattern) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.autofillpattern", (Object)String.valueOf(autoFillPattern));
    }

    public static String getAutoFillPatternPattern() {
        String fillPatternPattern = "";
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.autofillpatternpattern");
        if (value != null) {
            fillPatternPattern = value.toString();
        }
        return fillPatternPattern;
    }

    public static void saveAutoFillPatternPattern(String autoFillPatternPattern) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.autofillpatternpattern", (Object)String.valueOf(autoFillPatternPattern));
    }

    public static boolean isBasicAuthDisabled() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.basicauth");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    public static void saveDisableBasicAuth(boolean basicAuth) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.basicauth", (Object)String.valueOf(basicAuth));
    }

    public static boolean isAccessTokenDisabled() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.accesstoken");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    public static void saveDisableAccessToken(boolean accessToken) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.accesstoken", (Object)String.valueOf(accessToken));
    }

    public static boolean isSynchronizable() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.synchid");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        logger.debug("Use default value for IsSynchronizable: false");
        return false;
    }

    public static void saveSynchronizable(boolean synchronizable) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.synchid", (Object)String.valueOf(synchronizable));
    }

    public static boolean isSynchronizableWrite() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.synchwrite");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        logger.debug("Use default value for isSynchronizableWrite: false");
        return false;
    }

    public static void saveSynchronizableWrite(boolean synchronizableWrite) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.synchwrite", (Object)String.valueOf(synchronizableWrite));
    }

    public static boolean secSignIdContainsIllegalCharacters(String secSignId) {
        for (int kk = 0; kk < secSignId.length(); ++kk) {
            char c = secSignId.charAt(kk);
            if (Character.isLetterOrDigit(c) || allowedCharacters.indexOf(c) >= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean getUseRestore() {
        boolean useRestore = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.userestore");
        if (value != null) {
            useRestore = Boolean.parseBoolean(value.toString());
        }
        return useRestore;
    }

    public static void saveUseRestore(boolean useRestore) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.userestore", (Object)String.valueOf(useRestore));
    }

    public static boolean hasOwnPinAccount() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.pinuser");
        return value != null;
    }

    public static String[] getPinAccount() {
        Object pinAccountPasswordFromData;
        String[] pinAccount = new String[2];
        String pinAccountUser = "";
        String pinAccountPassword = "";
        byte[] pinAccountPasswordUnEncrypted = null;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object pinAccountUserFromData = globalPluginSettings.get("com.secsign.pinuser");
        if (pinAccountUserFromData != null && !pinAccountUserFromData.toString().equals("")) {
            pinAccountUser = pinAccountUserFromData.toString();
        }
        if (pinAccountUserFromData == null) {
            pinAccountUser = "ATLASSIAN_ADDONS";
        }
        if ((pinAccountPasswordFromData = globalPluginSettings.get("com.secsign.pinpassword")) != null) {
            if (pinAccountPasswordFromData.getClass().equals(String.class)) {
                pinAccountPassword = (String)pinAccountPasswordFromData;
                byte[] encryptedPassword = SecSignIDMappingUtils.stringToByteArray(pinAccountPassword);
                try {
                    String unencryptedPassword = new String(AES.decrypt(encryptedPassword, "VQoPSHgRPLnZfnWfnBJHylZyTP1aQWbjOfwVlyNon6Q97MIjdCja98ASSj0TlrUWcp8Id1QqJpl4AHF5xrdTSqHI32XDwk9TogtNTpXNAvKQ1TwmALMP2pon"));
                    pinAccount[0] = pinAccountUser;
                    pinAccount[1] = unencryptedPassword;
                    return pinAccount;
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    logger.error("Exception on decrypt password: " + e.getLocalizedMessage());
                    return null;
                }
                catch (SecSignExceptionKey e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    logger.error("Exception on decrypt password: " + e.getLocalizedMessage());
                    return null;
                }
            }
            ArrayList list = (ArrayList)pinAccountPasswordFromData;
            pinAccountPasswordUnEncrypted = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                pinAccountPasswordUnEncrypted[i] = Byte.parseByte((String)list.get(i));
            }
            try {
                pinAccountPassword = new String(AES.decrypt(pinAccountPasswordUnEncrypted, "VQoPSHgRPLnZfnWfnBJHylZyTP1aQWbjOfwVlyNon6Q97MIjdCja98ASSj0TlrUWcp8Id1QqJpl4AHF5xrdTSqHI32XDwk9TogtNTpXNAvKQ1TwmALMP2pon"));
                pinAccount[0] = pinAccountUser;
                pinAccount[1] = pinAccountPassword;
                return pinAccount;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                logger.error("Exception on decrypt password: " + e.getLocalizedMessage());
                return null;
            }
        }
        pinAccountPasswordUnEncrypted = SecSignIDCommonConstants.DefaultPinAccountPassword;
        try {
            pinAccountPassword = new String(AES.decrypt(pinAccountPasswordUnEncrypted, "VQoPSHgRPLnZfnWfnBJHylZyTP1aQWbjOfwVlyNon6Q97MIjdCja98ASSj0TlrUWcp8Id1QqJpl4AHF5xrdTSqHI32XDwk9TogtNTpXNAvKQ1TwmALMP2pon"));
            pinAccount[0] = pinAccountUser;
            pinAccount[1] = pinAccountPassword;
            return pinAccount;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("Exception on decrypt password: " + e.getLocalizedMessage());
            return null;
        }
    }

    public static void deletePinAccount() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.remove("com.secsign.pinuser");
        globalPluginSettings.remove("com.secsign.pinpassword");
    }

    public static void savePinAccount(String[] pinAccount) throws IOException, SecSignExceptionKey {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.pinuser", (Object)pinAccount[0]);
        String plainPassword = pinAccount[1];
        byte[] plainPAsswordBytes = plainPassword.getBytes();
        byte[] encryptedPasswordBytes = AES.encrypt(plainPAsswordBytes, "VQoPSHgRPLnZfnWfnBJHylZyTP1aQWbjOfwVlyNon6Q97MIjdCja98ASSj0TlrUWcp8Id1QqJpl4AHF5xrdTSqHI32XDwk9TogtNTpXNAvKQ1TwmALMP2pon");
        globalPluginSettings.put("com.secsign.pinpassword", (Object)SecSignIDMappingUtils.arrayToString(encryptedPasswordBytes));
    }

    public static boolean isUsingCloudServer() {
        return SecSignIDCommonStaticAccessor.getSecSignIdServerUrl().equals("https://httpapi.secsign.com");
    }

    public static boolean hasPluginPinAccount() {
        if (!SecSignIDCommonStaticAccessor.hasOwnPinAccount()) {
            return false;
        }
        String[] pinAccount = SecSignIDCommonStaticAccessor.getPinAccount();
        if (pinAccount == null || pinAccount.length != 2) {
            return false;
        }
        return pinAccount[0].startsWith("PLUGIN_ATLASSIAN_");
    }

    public static String getSecSignIdServerUrl() {
        String idServerUrl = null;
        if (pluginSettingsFactory != null) {
            idServerUrl = (String)pluginSettingsFactory.createGlobalSettings().get("com.secsign.idserverurl");
        }
        if (idServerUrl == null || idServerUrl.length() < 1) {
            idServerUrl = "https://httpapi.secsign.com";
        }
        return idServerUrl;
    }

    public static String getFallbackSecSignIdServerUrl() {
        String idServerUrl = null;
        if (pluginSettingsFactory != null) {
            idServerUrl = (String)pluginSettingsFactory.createGlobalSettings().get("com.secsign.idserverurl.fallback");
        }
        if (idServerUrl == null || idServerUrl.equals("")) {
            idServerUrl = "https://httpapi2.secsign.com";
        }
        return idServerUrl;
    }

    public static String getCrowdBaseUrl() {
        String crowdBaseUrl = null;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.crowdurl");
        crowdBaseUrl = value != null && !value.equals("null") ? value.toString() : "";
        return crowdBaseUrl;
    }

    public static boolean getIsAdFree() {
        boolean isAdFree = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.isadfree");
        isAdFree = value != null && !value.equals("null") ? Boolean.parseBoolean((String)value) : false;
        return isAdFree;
    }

    public static void saveIsAdFree(boolean isAdFree) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.isadfree", (Object)String.valueOf(isAdFree));
    }

    public static void saveCrowdBaseUrl(String crowdBaseUrl) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.crowdurl", (Object)String.valueOf(crowdBaseUrl));
    }

    public static boolean getResetOnCrowd() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.resetcrowd");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    public static void saveResetOnCrowd(boolean resetOnCrowd) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.resetcrowd", (Object)String.valueOf(resetOnCrowd));
    }

    public static boolean getServiceDesk() {
        boolean serviceDesk2FA = true;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.servicedesk");
        if (value != null) {
            serviceDesk2FA = Boolean.parseBoolean(value.toString());
        }
        return serviceDesk2FA;
    }

    public static void saveServiceDesk(boolean serviceDesk) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.servicedesk", (Object)String.valueOf(serviceDesk));
    }

    public static boolean getServiceDesk2FA() {
        boolean serviceDesk2FA = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.servicedesk.2fa");
        if (value != null) {
            serviceDesk2FA = Boolean.parseBoolean(String.valueOf(value.toString()));
        }
        return serviceDesk2FA;
    }

    public static void saveServiceDesk2FA(boolean serviceDesk2FA) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.servicedesk.2fa", (Object)String.valueOf(serviceDesk2FA));
    }

    public static void saveServerUrl(String serverUrl) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.idserverurl", (Object)serverUrl);
    }

    public static void saveFallbackServerUrl(String fallbackServerUrl) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.idserverurl.fallback", (Object)fallbackServerUrl);
    }

    public static String getLDAPSecSignIDAttr() {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = pluginSettings.get("com.secsign.ldapattr");
        if (value != null) {
            return (String)value;
        }
        return "secsignid";
    }

    public static boolean getLDAPEnable() {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = pluginSettings.get("com.secsign.ldapenable");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        return Boolean.parseBoolean("false");
    }

    public static boolean getWriteLDAPEnable() {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = pluginSettings.get("com.secsign.writeldap");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        return Boolean.parseBoolean("false");
    }

    public static boolean getLocalEnable() {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = pluginSettings.get("com.secsign.localenable");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        return Boolean.parseBoolean("true");
    }

    public static void saveLDAPSecSignIDAttr(String attribute) {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put("com.secsign.ldapattr", (Object)attribute);
    }

    public static void saveLDAPEnable(boolean value) {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put("com.secsign.ldapenable", (Object)String.valueOf(value));
    }

    public static void saveWriteLDAPEnable(boolean value) {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put("com.secsign.writeldap", (Object)String.valueOf(value));
    }

    public static void saveLocalEnable(boolean value) {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put("com.secsign.localenable", (Object)String.valueOf(value));
    }

    public static boolean getAllowUserCreate() {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = pluginSettings.get("com.secsign.allow.user.create");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        return Boolean.parseBoolean("true");
    }

    public static boolean getAllowUserExisting() {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = pluginSettings.get("com.secsign.allow.user.existing");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        return Boolean.parseBoolean("true");
    }

    public static void saveAllowUserCreate(boolean value) {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put("com.secsign.allow.user.create", (Object)String.valueOf(value));
    }

    public static void saveAllowUserExisting(boolean value) {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put("com.secsign.allow.user.existing", (Object)String.valueOf(value));
    }

    public static boolean getGitAccessSecuredBy2FA() {
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = pluginSettings.get("com.secsign.gitaccess.2fa.enabled");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    public static void saveGitAccessSecuredBy2FA(boolean gitAccess) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.gitaccess.2fa.enabled", (Object)String.valueOf(gitAccess));
    }

    public static boolean getGitAccessIPSafeZoneEnabled() {
        boolean gitAccessIPSafeZoneEnabled = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.gitaccess.ipsafezone.enabled");
        if (value != null && value instanceof String) {
            gitAccessIPSafeZoneEnabled = Boolean.parseBoolean((String)value);
        }
        return gitAccessIPSafeZoneEnabled;
    }

    public static void saveGitAccessIPSafeZoneEnabled(boolean gitAccessIPSafeZoneEnabled) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.gitaccess.ipsafezone.enabled", (Object)String.valueOf(gitAccessIPSafeZoneEnabled));
    }

    public static boolean getGitAccessBlockUserWithoutSecSignId() {
        boolean blockUserWithoutSecSignId = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.gitaccess.block.user.without.secsignid");
        if (value != null && value instanceof String) {
            blockUserWithoutSecSignId = Boolean.parseBoolean((String)value);
        }
        return blockUserWithoutSecSignId;
    }

    public static void saveGitAccessBlockUserWithoutSecSignId(boolean blockUserWithoutSecSignId) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.gitaccess.block.user.without.secsignid", (Object)String.valueOf(blockUserWithoutSecSignId));
    }

    public static Integer getGitAccessNew2FARequiredAfterHours() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.gitaccess.new2fa.required.after.hours");
        if (value != null && value instanceof String) {
            try {
                return Integer.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                return SecSignIDCommonConstants.GitAccessNew2FARequiredAfterHoursDefaultValue;
            }
        }
        return SecSignIDCommonConstants.GitAccessNew2FARequiredAfterHoursDefaultValue;
    }

    public static void saveGitAccessNew2FARequiredAfterHours(Integer hours) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.gitaccess.new2fa.required.after.hours", (Object)hours.toString());
    }

    public static String getGitAccessEnabledForGroups() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.gitaccess.enabled.for.group");
        if (value != null && value instanceof String) {
            String groups = (String)value;
            if (groups.equals("")) {
                return null;
            }
            return groups;
        }
        return null;
    }

    public static void saveGitAccessEnabledForGroups(String groups) {
        if (groups == null) {
            groups = "";
        }
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.gitaccess.enabled.for.group", (Object)groups);
    }

    public static boolean getGitAccessProtectReadAccessBy2FA() {
        boolean protectReadAccessBy2fa = false;
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.gitaccess.protect.read.commands");
        if (value != null && value instanceof String) {
            protectReadAccessBy2fa = Boolean.parseBoolean((String)value);
        }
        return protectReadAccessBy2fa;
    }

    public static void saveGitAccessProtectReadAccessBy2FA(boolean protectReadAccessBy2fa) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.gitaccess.protect.read.commands", (Object)String.valueOf(protectReadAccessBy2fa));
    }

    public static boolean newAuthenticationFixStarted() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("fixFor4_5_0_groups_started");
        return value != null;
    }

    public static void saveAuthenticationFixStarted() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("fixFor4_5_0_groups_started", (Object)"true");
    }

    public static boolean newAuthenticationFixed() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("fixFor4_5_0_groups_done");
        return value != null;
    }

    public static void saveAuthenticationFixed() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("fixFor4_5_0_groups_done", (Object)"true");
    }

    public static void saveInformUser(boolean informUser) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.inform.user", (Object)String.valueOf(informUser));
    }

    public static boolean getInformUser() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.inform.user");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    public static void saveInformAdmin(boolean informAdmin) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.inform.admin", (Object)String.valueOf(informAdmin));
    }

    public static boolean getInformAdmin() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.inform.admin");
        if (value != null) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    public static void saveInformGroup(String informGroup) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.inform.group", (Object)informGroup);
    }

    public static String getInformGroup() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.inform.group");
        if (value != null) {
            return (String)value;
        }
        return "";
    }

    public static void saveObserveGroup(String observeGroup) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put("com.secsign.observe.group", (Object)observeGroup);
    }

    public static String getObserveGroup() {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.observe.group");
        if (value != null) {
            return (String)value;
        }
        return "";
    }

    public static boolean isUserObserved(List<String> mappingKeysOfGroupOfUser) {
        String observeGroupString = SecSignIDCommonStaticAccessor.getObserveGroup();
        if (observeGroupString != null && !observeGroupString.equals("")) {
            String[] mappingKeysToObserver = observeGroupString.split(",");
            for (String mappingKeyOfGroupOfUser : mappingKeysOfGroupOfUser) {
                String groupNameUser = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKeyOfGroupOfUser);
                long diridUser = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKeyOfGroupOfUser);
                for (String string : mappingKeysToObserver) {
                    String groupNameObserve = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
                    long diridOberserve = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
                    if (!groupNameObserve.equals(groupNameUser) || diridUser != diridOberserve) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isGroupObserved(String groupname, long dirid) {
        String observeGroupString = SecSignIDCommonStaticAccessor.getObserveGroup();
        if (observeGroupString != null && !observeGroupString.equals("")) {
            String[] mappingKeysToObserver;
            for (String string : mappingKeysToObserver = observeGroupString.split(",")) {
                String groupNameObserve = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
                long diridOberserve = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
                if (!groupNameObserve.equals(groupname) || dirid != diridOberserve) continue;
                return true;
            }
        }
        return false;
    }

    public static SecSignIDTrustDeviceToken getTrustDeviceTokenFromRequest(String userKey, long dirId, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        String tokenValue = null;
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals("secsignid_trustdevicetoken_" + dataAccessor.getApplication().toLowerCase())) continue;
            tokenValue = cookie.getValue();
            break;
        }
        if (tokenValue == null) {
            return null;
        }
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null || userAgent.equals("")) {
            userAgent = "empty";
        }
        try {
            return dataAccessor.getTrustDeviceToken(userKey, dirId, tokenValue, userAgent);
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (DirectoryPermissionException e) {
            logger.error("DirectoryPermissionException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        return null;
    }

    public static String getStackTraceOfError(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static void saveWhiteList(List<SecSignIDWhiteListItem> _whiteList) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        int i = 0;
        while (globalPluginSettings.get("com.secsign.whitelist" + i) != null) {
            globalPluginSettings.remove("com.secsign.whitelist" + i);
            ++i;
        }
        String whitelistString = "";
        for (SecSignIDWhiteListItem item : _whiteList) {
            whitelistString = whitelistString + item + ";";
        }
        List<String> whiteListParts = SecSignIDCommonStaticAccessor.getStringParts(whitelistString);
        i = 0;
        for (String string : whiteListParts) {
            globalPluginSettings.put("com.secsign.whitelist" + i, (Object)String.valueOf(string));
            ++i;
        }
    }

    public static List<SecSignIDWhiteListItem> getWhiteList() {
        ArrayList<SecSignIDWhiteListItem> whiteList = new ArrayList();
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        int i = 0;
        String whiteListstring = "";
        Object value = globalPluginSettings.get("com.secsign.whitelist" + i);
        if (value != null) {
            whiteListstring = whiteListstring + value;
            ++i;
            while (globalPluginSettings.get("com.secsign.whitelist" + i) != null) {
                value = globalPluginSettings.get("com.secsign.whitelist" + i);
                whiteListstring = whiteListstring + value;
                ++i;
            }
            whiteList = SecSignIDWhiteListItem.getListFromString(whiteListstring);
            return whiteList;
        }
        return new ArrayList<SecSignIDWhiteListItem>();
    }

    public static boolean isFIDOSupported() {
        SecSignIDServerVersion serverVersion = SecSignIDServerRESTConnector.getServerVersion();
        return serverVersion.isGreaterOrEquals(SecSignIDServerVersion.VERSION_10_7_5);
    }

    public static void updateBaseUrl(String baseUrl) {
        if (!SecSignIDCommonStaticAccessor.isUsingCloudServer() || !SecSignIDCommonStaticAccessor.hasPluginPinAccount()) {
            return;
        }
        String cachedBaseUrl = SecSignIDCommonStaticAccessor.getGlobalSettingsString("com.secsign.cachedbaseurl");
        if (cachedBaseUrl.equals(baseUrl)) {
            return;
        }
        try {
            SecSignIDServerRESTConnector.updatePluginRegistration(null, null, null, baseUrl);
            SecSignIDCommonStaticAccessor.putGlobalSettings("com.secsign.cachedbaseurl", baseUrl);
            logger.debug("Successfully updated Base-URL from '" + cachedBaseUrl + "' to '" + baseUrl + "' for plugin registration.");
        }
        catch (SecSignIDRESTException e) {
            logger.error("Couldn't update Base-URL for plugin registration.");
            logger.debug(e.getMessage(), (Throwable)e);
        }
        if (!cachedBaseUrl.equals("")) {
            try {
                URI baseUri = new URI(baseUrl);
                URI cachedBaseUri = new URI(cachedBaseUrl);
                String baseHost = baseUri.getHost();
                String cachedHost = cachedBaseUri.getHost();
                if (!baseHost.equalsIgnoreCase(cachedHost)) {
                    logger.error("---------------- WARNING ----------------");
                    logger.error("Hostname changed from " + cachedHost + " to " + baseHost + ": FIDO for all users resetting because it requires the same Hostname");
                    logger.error("---------------- WARNING ----------------");
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                dataAccessor.resetAllFIDO();
                            }
                            catch (ApplicationPermissionException | DirectoryNotFoundException | InvalidAuthenticationException | OperationFailedException e) {
                                logger.error("Cannot reset FIDO");
                                logger.error(e.getMessage(), e);
                            }
                        }
                    }.start();
                }
            }
            catch (URISyntaxException e) {
                logger.error("Cannot convert to URI for plugin registration");
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static boolean isTelemetryEnabled() {
        return SecSignIDCommonStaticAccessor.getGlobalSettingsBoolean("com.secsign.telemetry", false);
    }

    public static void saveTelemetryEnabled(boolean enabled) {
        SecSignIDCommonStaticAccessor.putGlobalSettings("com.secsign.telemetry", String.valueOf(enabled));
    }

    private static String getGlobalSettingsString(String key) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        Object value = globalPluginSettings.get(key);
        if (value == null) {
            return "";
        }
        return (String)value;
    }

    private static boolean getGlobalSettingsBoolean(String key, boolean defaultValue) {
        String valueString = SecSignIDCommonStaticAccessor.getGlobalSettingsString(key);
        if (valueString.equals("")) {
            return defaultValue;
        }
        return Boolean.valueOf(valueString);
    }

    private static void putGlobalSettings(String key, Object value) {
        PluginSettings globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        globalPluginSettings.put(key, value);
    }

    public static String createAndStoreOTPForSharingSettings() {
        String otp = SecSignIDOTPGenerator.generateOTP();
        Date date = new Date();
        SecSignIDCommonStaticAccessor.putGlobalSettings("com.secsign.share.settings", otp + ";" + date.getTime());
        return otp;
    }

    public static boolean checkOTPForSharingSettings(String otp) {
        String otpFromStore = SecSignIDCommonStaticAccessor.getGlobalSettingsString("com.secsign.share.settings");
        if (!otpFromStore.equals("")) {
            String otpToFit = otpFromStore.substring(0, otpFromStore.indexOf(";"));
            long millisToFit = Long.parseLong(otpFromStore.substring(otpFromStore.indexOf(";") + 1, otpFromStore.length()));
            Date now = new Date();
            long nowMillis = now.getTime();
            if (nowMillis - 300000L < millisToFit && otpToFit.equals(otp)) {
                SecSignIDCommonStaticAccessor.putGlobalSettings("com.secsign.share.settings", "");
                return true;
            }
        }
        return false;
    }

    public static void saveSettingsFromJSON(JSONObject objectWithSettings) {
        try {
            JSONObject settings = objectWithSettings.getJSONObject("settings");
            SecSignIDCommonStaticAccessor.saveServerUrl(settings.getString("com.secsign.share.server.url"));
            SecSignIDCommonStaticAccessor.saveUseFallback(settings.getBoolean("com.secsign.share.use.fallback"));
            SecSignIDCommonStaticAccessor.saveFallbackServerUrl(settings.getString("com.secsign.share.fallback.server.url"));
            SecSignIDCommonStaticAccessor.saveCompanyName(settings.getString("com.secsign.share.company.name"));
            SecSignIDCommonStaticAccessor.saveUseRestore(settings.getBoolean("com.secsign.share.use.restore"));
            SecSignIDCommonStaticAccessor.saveNoAccesspass(settings.getBoolean("com.secsign.share.noaccesspass"));
            SecSignIDCommonStaticAccessor.saveAutoFillUsername(settings.getBoolean("com.secsign.share.autofillusername"));
            SecSignIDCommonStaticAccessor.saveAutoFillUsernameCompany(settings.getBoolean("com.secsign.share.autofillusernamecompany"));
            SecSignIDCommonStaticAccessor.saveAutoFillMail(settings.getBoolean("com.secsign.share.autofillmail"));
            SecSignIDCommonStaticAccessor.saveAutoFillPattern(settings.getBoolean("com.secsign.share.autofillpattern"));
            SecSignIDCommonStaticAccessor.saveAutoFillPatternPattern(settings.getString("com.secsign.share.autofillpatternpattern"));
            SecSignIDCommonStaticAccessor.saveAllowUserCreate(settings.getBoolean("com.secsign.share.user.create"));
            SecSignIDCommonStaticAccessor.saveAllowUserExisting(settings.getBoolean("com.secsign.share.user.existing"));
            SecSignIDCommonStaticAccessor.saveDisableBasicAuth(settings.getBoolean("com.secsign.share.basicauth"));
            SecSignIDCommonStaticAccessor.saveDisableAccessToken(settings.getBoolean("com.secsign.share.accesstoken"));
            SecSignIDCommonStaticAccessor.saveSafeZone(settings.getBoolean("com.secsign.share.safezone"));
            SecSignIDCommonStaticAccessor.saveUserChange(settings.getBoolean("com.secsign.share.user.change"));
            SecSignIDCommonStaticAccessor.saveCustomLogin(settings.getBoolean("com.secsign.share.customlogin"));
            SecSignIDCommonStaticAccessor.saveLoginColor(settings.getString("com.secsign.share.logincolor"));
            SecSignIDCommonStaticAccessor.saveUseNewCrowdLogin(settings.getBoolean("com.secsign.share.crowdnewlogin"));
            SecSignIDCommonStaticAccessor.saveLoginTitle(settings.getString("com.secsign.share.logintitle"));
            SecSignIDCommonStaticAccessor.saveLoginSubtitle(settings.getString("com.secsign.share.loginsubtitle"));
            SecSignIDCommonStaticAccessor.saveCustomLogo(settings.getString("com.secsign.share.customlogo"));
            SecSignIDCommonStaticAccessor.saveIOSUrl(settings.getString("com.secsign.share.iOSUrl"));
            SecSignIDCommonStaticAccessor.saveAndroidUrl(settings.getString("com.secsign.share.androidUrl"));
            SecSignIDCommonStaticAccessor.saveWindowsUrl(settings.getString("com.secsign.share.windowsUrl"));
            SecSignIDCommonStaticAccessor.saveMacOSUrl(settings.getString("com.secsign.share.macOSUrl"));
            SecSignIDCommonStaticAccessor.saveSessionTimeoutEnabled(settings.getBoolean("com.secsign.share.sessiontimeout"));
            SecSignIDCommonStaticAccessor.saveSessionTimeoutDuration(settings.getInt("com.secsign.share.sessiontimeout.duration"));
            SecSignIDCommonStaticAccessor.saveTrustDeviceEnabled(settings.getBoolean("com.secsign.share.trustdevice"));
            SecSignIDCommonStaticAccessor.saveTrustDeviceDuration(settings.getInt("com.secsign.share.trustdevice.duration"));
            SecSignIDCommonStaticAccessor.savePasswordlessEnabled(settings.getBoolean("com.secsign.share.passwordless.enabled"));
            SecSignIDCommonStaticAccessor.saveSecSignEnabled(settings.getBoolean("com.secsign.share.secsign.enabled"));
            SecSignIDCommonStaticAccessor.saveMailOTPEnabled(settings.getBoolean("com.secsign.share.mailotp.enabled"));
            SecSignIDCommonStaticAccessor.saveTOTPEnabled(settings.getBoolean("com.secsign.share.totp.enabled"));
            SecSignIDCommonStaticAccessor.saveFIDOEnabled(settings.getBoolean("com.secsign.share.fido.enabled"));
        }
        catch (JSONException e) {
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
    }

    public static JSONObject getSettingsToShare() {
        JSONObject object = new JSONObject();
        try {
            object.put("com.secsign.share.server.url", (Object)SecSignIDCommonStaticAccessor.getSecSignIdServerUrl());
            object.put("com.secsign.share.use.fallback", (Object)SecSignIDCommonStaticAccessor.getUseFallback());
            object.put("com.secsign.share.fallback.server.url", (Object)SecSignIDCommonStaticAccessor.getFallbackSecSignIdServerUrl());
            object.put("com.secsign.share.company.name", (Object)SecSignIDCommonStaticAccessor.getCompanyName());
            object.put("com.secsign.share.use.restore", (Object)SecSignIDCommonStaticAccessor.getUseRestore());
            object.put("com.secsign.share.noaccesspass", (Object)SecSignIDCommonStaticAccessor.getNoAccessPass());
            object.put("com.secsign.share.autofillusername", (Object)SecSignIDCommonStaticAccessor.getAutoFillUsername());
            object.put("com.secsign.share.autofillusernamecompany", (Object)SecSignIDCommonStaticAccessor.getAutoFillUsernameCompany());
            object.put("com.secsign.share.autofillmail", (Object)SecSignIDCommonStaticAccessor.getAutoFillMail());
            object.put("com.secsign.share.autofillpattern", (Object)SecSignIDCommonStaticAccessor.getAutoFillPattern());
            object.put("com.secsign.share.autofillpatternpattern", (Object)SecSignIDCommonStaticAccessor.getAutoFillPatternPattern());
            object.put("com.secsign.share.user.create", (Object)SecSignIDCommonStaticAccessor.getAllowUserCreate());
            object.put("com.secsign.share.user.existing", (Object)SecSignIDCommonStaticAccessor.getAllowUserExisting());
            object.put("com.secsign.share.basicauth", (Object)SecSignIDCommonStaticAccessor.isBasicAuthDisabled());
            object.put("com.secsign.share.accesstoken", (Object)SecSignIDCommonStaticAccessor.isAccessTokenDisabled());
            object.put("com.secsign.share.safezone", (Object)SecSignIDCommonStaticAccessor.getSafeZone());
            object.put("com.secsign.share.safezonerange", SecSignIDCommonStaticAccessor.getIPRanges());
            object.put("com.secsign.share.user.change", (Object)SecSignIDCommonStaticAccessor.getUserChange());
            object.put("com.secsign.share.customlogin", (Object)SecSignIDCommonStaticAccessor.getCustomLogin());
            object.put("com.secsign.share.logincolor", (Object)SecSignIDCommonStaticAccessor.getLoginColor());
            object.put("com.secsign.share.crowdnewlogin", (Object)SecSignIDCommonStaticAccessor.getUseNewCrowdLogin());
            object.put("com.secsign.share.logintitle", (Object)SecSignIDCommonStaticAccessor.getLoginTitle());
            object.put("com.secsign.share.loginsubtitle", (Object)SecSignIDCommonStaticAccessor.getLoginSubtitle());
            object.put("com.secsign.share.customlogo", (Object)SecSignIDCommonStaticAccessor.getCustomLogo());
            object.put("com.secsign.share.iOSUrl", (Object)SecSignIDCommonStaticAccessor.getIOSUrl());
            object.put("com.secsign.share.androidUrl", (Object)SecSignIDCommonStaticAccessor.getAndroidUrl());
            object.put("com.secsign.share.windowsUrl", (Object)SecSignIDCommonStaticAccessor.getWindowsUrl());
            object.put("com.secsign.share.macOSUrl", (Object)SecSignIDCommonStaticAccessor.getMacOSUrl());
            object.put("com.secsign.share.sessiontimeout", (Object)SecSignIDCommonStaticAccessor.getSessionTimeoutEnabled());
            object.put("com.secsign.share.sessiontimeout.duration", (Object)SecSignIDCommonStaticAccessor.getSessionTimeoutDuration());
            object.put("com.secsign.share.trustdevice", (Object)SecSignIDCommonStaticAccessor.getTrustDeviceEnabled());
            object.put("com.secsign.share.trustdevice.duration", (Object)SecSignIDCommonStaticAccessor.getTrustDeviceDuration());
            object.put("com.secsign.share.passwordless.enabled", (Object)SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled());
            object.put("com.secsign.share.secsign.enabled", (Object)SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled());
            object.put("com.secsign.share.mailotp.enabled", (Object)SecSignIDCommonStaticAccessor.getMailotpAuthEnabled());
            object.put("com.secsign.share.totp.enabled", (Object)SecSignIDCommonStaticAccessor.getTotpAuthEnabled());
            object.put("com.secsign.share.fido.enabled", (Object)SecSignIDCommonStaticAccessor.getFidoAuthEnabled());
            logger.debug(SecSignIDLoggingHelper.jsonTOString(object));
        }
        catch (JSONException e) {
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        return object;
    }

    private static boolean checkValueIsDefault(String key, String value) {
        String defaultValueKey = key + ".default";
        defaultValueKey = defaultValueKey.replaceAll("\\.", "_");
        try {
            String defaultValue = String.valueOf(SecSignIDDefaultValues.class.getField(defaultValueKey).get(null));
            return value.equals(defaultValue);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static TreeMap<String, String> getChangeMapFromJSON(JSONObject jsonObject) {
        TreeMap<String, String> resultMap = new TreeMap<String, String>();
        Iterator keyIterator = jsonObject.keys();
        try {
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                if (SecSignIDCommonStaticAccessor.checkValueIsDefault(key, jsonObject.getString(key))) continue;
                resultMap.put(i18nResolver.getText(key), jsonObject.getString(key));
            }
            return resultMap;
        }
        catch (JSONException e) {
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return null;
        }
    }

    public static void saveGroupsCreated(boolean created) {
        SecSignIDCommonStaticAccessor.putGlobalSettings("com.secsign.groups.created", String.valueOf(created));
    }

    public static boolean getGroupsCreated() {
        return SecSignIDCommonStaticAccessor.getGlobalSettingsBoolean("com.secsign.groups.created", false);
    }
}

