/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.servlet.filter;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.util.SecSignIDCharArrayWriter;
import com.secsign.atlassian.common.util.SecSignIDServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDAddUserFilter
implements Filter {
    private final int USE_SETTING_FOR_ID = 0;
    private final int USE_CUSTOM_ID = 1;
    private final int USE_EXISTING_ID = 2;
    private final Logger logger = LoggerFactory.getLogger(SecSignIDAddUserFilter.class);
    private final TemplateRenderer templateRenderer;
    private final PluginSettingsFactory pluginSettingsFactory;
    private SecSignIDDataAccessor dataAccessor;
    private String createUserTemplate = "/templates/secsignid-adduser.vm";

    public SecSignIDAddUserFilter(TemplateRenderer templateRenderer, PluginSettingsFactory pluginSettingsFactory, SecSignIDDataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
        this.templateRenderer = templateRenderer;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecSignIDServletResponseWrapper responseWrapper = new SecSignIDServletResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)responseWrapper);
        HttpServletRequest httpServletReq = (HttpServletRequest)request;
        String secSignId = httpServletReq.getParameter("secsignid");
        boolean pwdAllowed = httpServletReq.getParameter("pwdAllowed") != null;
        HashMap<String, Object> context = new HashMap<String, Object>();
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        boolean localEnable = SecSignIDCommonStaticAccessor.getLocalEnable();
        boolean writeLDAPEnable = SecSignIDCommonStaticAccessor.getWriteLDAPEnable();
        if (httpServletReq.getParameter("idMethod") != null) {
            context.put("idMethod", httpServletReq.getParameter("idMethod"));
        }
        context.put("secsign_id", secSignId);
        context.put("pwdallowed", pwdAllowed);
        context.put("showpwdloginoption", "none");
        context.put("contextPath", httpServletReq.getContextPath());
        context.put("companyName", SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName());
        context.put("useMail", !SecSignIDCommonStaticAccessor.getAutoFillUsername());
        context.put("writeLDAPEnable", String.valueOf(writeLDAPEnable));
        context.put("localEnable", String.valueOf(localEnable));
        SecSignIDCharArrayWriter renderedTemplate = new SecSignIDCharArrayWriter();
        this.templateRenderer.render(this.createUserTemplate, context, (Writer)renderedTemplate);
        responseWrapper.inject(renderedTemplate, "</form>");
        PrintWriter responseOutput = response.getWriter();
        response.setContentLength(responseWrapper.length());
        responseOutput.write(responseWrapper.toString());
        responseOutput.close();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

