/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.sal.api.message.I18nResolver;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.crypto.SecSignExceptionKey;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import com.secsign.atlassian.common.rest.SecSignIDRESTPluginRegistrationResponse;
import com.secsign.atlassian.common.rest.SecSignIDServerRESTConnector;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDLoggingHelper;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDTutorialServlet
extends HttpServlet {
    private static final long serialVersionUID = 6842235411471448500L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDTutorialServlet.class);
    private SecSignIDDataAccessor dataAccessor;
    private final I18nResolver i18nResolver;

    public SecSignIDTutorialServlet(I18nResolver i18nResolver, SecSignIDDataAccessor staticAccessor) {
        this.i18nResolver = i18nResolver;
        this.dataAccessor = staticAccessor;
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        boolean basicAuthUsed;
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        boolean bl = basicAuthUsed = httpServletRequest.getSession().getAttribute("secsign.basicAuth") != null;
        if (user == null || !this.dataAccessor.isUserAdmin(user) || basicAuthUsed) {
            this.sendJSONAnswer(false, "User not authorized", httpServletResp);
            return;
        }
        if (httpServletRequest.getParameter("activateSynch") != null) {
            this.handleActivateSynch(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("activateSynchWrite") != null) {
            this.handleActivateSynchWrite(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("sameuseractivate") != null) {
            this.handleSameUserActivateRequest(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("getsharedsettings") != null) {
            this.getSettingsFromOtherAddOn(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("serverQuestion") != null) {
            this.handleServerQuestionRequest(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("server") != null) {
            this.handleServerRequest(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("methods") != null) {
            this.handle2FAMethodsRequest(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("extern") != null) {
            this.handleExternRequest(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("autoid") != null) {
            this.handleAutoIDRequest(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("alreadyExisting") != null) {
            this.handleAlreadyExistingRequest(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("sameusernext") != null) {
            this.handleSameUserNextRequest(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("groupQuestion") != null) {
            this.handleGroupQuestionRequest(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("add-admin-to-passwordless") != null) {
            this.addAdminToPasswordless(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("add-admin-to-twostep") != null) {
            this.addAdminToTwoStep(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("add-admin-to-mailotp") != null) {
            this.addAdminToMailOTP(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("add-admin-to-totp") != null) {
            this.addAdminToTOTP(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("add-admin-to-fido") != null) {
            this.addAdminToFIDO(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("get-data-for-admin") != null) {
            this.getDataForAdminUser(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("check-admin-2fa") != null) {
            this.checkAdminIsIn2FAGroup(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("check-admin-secsignid") != null) {
            this.checkAdminIsInSecSignGroup(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("get-groups-with-options") != null) {
            this.getGroupsWithOptions(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("admin-save-already-id") != null) {
            this.saveAlreadyIDForAdmin(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("admin-save-created-id") != null) {
            this.saveCreatedIDForAdmin(httpServletRequest, httpServletResp);
        }
        if (httpServletRequest.getParameter("tutDone") != null) {
            this.saveTutorialDone(httpServletRequest, httpServletResp);
        }
    }

    private void handleActivateSynch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        boolean synchronizable = Boolean.parseBoolean(httpServletRequest.getParameter("synchronizable"));
        SecSignIDCommonStaticAccessor.saveSynchronizable(synchronizable);
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void handleActivateSynchWrite(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        boolean synchronizableWrite = Boolean.parseBoolean(httpServletRequest.getParameter("synchronizableWrite"));
        SecSignIDCommonStaticAccessor.saveSynchronizableWrite(synchronizableWrite);
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void handleSameUserActivateRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        boolean enableCreate = Boolean.parseBoolean(httpServletRequest.getParameter("allowCreate"));
        boolean enableExisting = Boolean.parseBoolean(httpServletRequest.getParameter("allowExisting"));
        SecSignIDCommonStaticAccessor.saveAllowUserCreate(enableCreate);
        SecSignIDCommonStaticAccessor.saveAllowUserExisting(enableExisting);
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void getSettingsFromOtherAddOn(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            String baseUrl = httpServletRequest.getParameter("addon-base-url");
            String otpFromPara = httpServletRequest.getParameter("otp");
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            JSONObject requestObject = new JSONObject();
            requestObject.put("otp", (Object)otpFromPara);
            StringEntity entity = new StringEntity(requestObject.toString());
            HttpPost httpPost = new HttpPost(baseUrl + "plugins/servlet/secsignsharesetting");
            httpPost.setEntity((HttpEntity)entity);
            try {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                if (response.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entityResponse = response.getEntity();
                    JSONObject answer = new JSONObject(EntityUtils.toString((HttpEntity)entityResponse));
                    logger.debug(SecSignIDLoggingHelper.jsonTOString(answer));
                    if (answer.getBoolean("success")) {
                        SecSignIDCommonStaticAccessor.saveSettingsFromJSON(answer);
                        TreeMap<String, String> answerMap = SecSignIDCommonStaticAccessor.getChangeMapFromJSON(answer.getJSONObject("settings"));
                        this.sendJSONAnswerWithMapParameterAndSettings(true, "importedData", answerMap, null, httpServletResp, answer.getJSONObject("settings"));
                        return;
                    }
                    this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.tutorial.share.error.wrong.otp"), httpServletResp);
                    return;
                }
                this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.tutorial.share.error.url"), httpServletResp);
                return;
            }
            catch (UnknownHostException | ClientProtocolException e) {
                this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.tutorial.share.error.url"), httpServletResp);
                return;
            }
        }
        catch (JSONException e) {
            logger.error("JSONException on getSettingsFromOtherAddOn");
            return;
        }
    }

    private void saveTutorialDone(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        SecSignIDCommonStaticAccessor.saveFirstStart(false);
        SecSignIDCommonStaticAccessor.saveAuthenticationFixStarted();
        SecSignIDCommonStaticAccessor.saveAuthenticationFixed();
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void saveAlreadyIDForAdmin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        Object[] result;
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String _wishID = httpServletRequest.getParameter("wishID");
        if (SecSignIDCommonStaticAccessor.secSignIdContainsIllegalCharacters(_wishID)) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.action.illegalcharacters2", new Serializable[]{_wishID}) + " " + _wishID, httpServletResp);
            return;
        }
        try {
            result = this.dataAccessor.checkDuplicatesWithUserKey(_wishID, user.getDirectoryId(), this.dataAccessor.getUserKeyForUsername(user.getName()));
        }
        catch (Exception e) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.synch"), httpServletResp);
            logger.error(e.getLocalizedMessage() + "on checkDuplicates");
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        if (((Boolean)result[0]).booleanValue()) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.action.duplicate2", new Serializable[]{_wishID, (String)result[1]}) + " " + _wishID, httpServletResp);
            return;
        }
        try {
            if (!SecSignIDServerRESTConnector.checkSecSignID(_wishID)) {
                this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.secsignid.notexisting") + " " + _wishID, httpServletResp);
                return;
            }
        }
        catch (IOException e) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.server.notreached"), httpServletResp);
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.rest"), httpServletResp);
            logger.error("SecSignIDRESTException on checkSecSignID: " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        String userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
        try {
            this.dataAccessor.saveSecSignIDForUserKey(userKey, user.getDirectoryId(), _wishID);
            this.dataAccessor.logChangeSecSignIDToAuditLog(userKey, user.getDirectoryId(), _wishID, httpServletRequest.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformUser()) {
                this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), this.dataAccessor.getUserCurrentlyLoggedIn().getName(), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId(), _wishID);
            }
            if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), this.dataAccessor.getUserCurrentlyLoggedIn().getName(), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId(), _wishID);
            }
            this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
        }
        catch (Exception e) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.tutorial.qrshow.admin.error.writing"), httpServletResp);
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void saveCreatedIDForAdmin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        String _wishID = httpServletRequest.getParameter("wishID");
        String userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
        try {
            this.dataAccessor.saveSecSignIDForUserKey(userKey, user.getDirectoryId(), _wishID);
            this.dataAccessor.logChangeSecSignIDToAuditLog(userKey, user.getDirectoryId(), _wishID, httpServletRequest.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformUser()) {
                this.dataAccessor.mailChangeSecSignIDToUser(userKey, user.getDirectoryId(), this.dataAccessor.getUserCurrentlyLoggedIn().getName(), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId(), _wishID);
            }
            if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId()))) {
                this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, user.getDirectoryId(), this.dataAccessor.getUserCurrentlyLoggedIn().getName(), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId(), _wishID);
            }
            this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), new SecSignID2FAActivatedSettings());
        }
        catch (Exception e) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.tutorial.qrshow.admin.error.writing"), httpServletResp);
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void getGroupsWithOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        HashMap<Object, Object> mappings = new HashMap();
        try {
            mappings = this.dataAccessor.getGroupMappingsWithOptions();
        }
        catch (OperationFailedException e1) {
            logger.error("OperationFailedException on getGroupsWithOptions on TutorialServlet");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e1)));
        }
        catch (InvalidAuthenticationException e1) {
            logger.error("OperationFailedException on getGroupsWithOptions on TutorialServlet");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e1)));
        }
        catch (ApplicationPermissionException e1) {
            logger.error("OperationFailedException on getGroupsWithOptions on TutorialServlet");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e1)));
        }
        HashMap<Object, String> toSend = new HashMap<Object, String>();
        for (Map.Entry<Object, Object> entry : mappings.entrySet()) {
            toSend.put(entry.getKey(), ((SecSignID2FASettings)entry.getValue()).getActivatedAsString());
        }
        JSONObject answerObject = new JSONObject();
        try {
            answerObject.put("success", true);
            answerObject.put("mappings", toSend);
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
        }
        catch (Exception e) {
            logger.error("Exception on success msg with reason: " + e.getMessage(), (Throwable)e);
            httpServletResp.sendError(400, e.getMessage());
        }
    }

    private void checkAdminIsInSecSignGroup(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        try {
            if (this.dataAccessor.checkLoggedinAdminIsInSecSignGroup()) {
                this.sendJSONAnswerWithBooleanParameter(true, "isInSecSignGroups", true, null, httpServletResp);
                return;
            }
            this.sendJSONAnswerWithBooleanParameter(true, "isInSecSignGroups", false, null, httpServletResp);
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, "OperationFailedException on checking admin in SecSign group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, "ApplicationPermissionException on checking admin in SecSign group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, "InvalidAuthenticationException on checking admin in SecSign group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, "DirectoryNotFoundException on checking admin in SecSign group: " + e.getMessage(), httpServletResp);
            return;
        }
    }

    private void checkAdminIsIn2FAGroup(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        try {
            if (this.dataAccessor.checkLoggedinAdminIsIn2FAGroup()) {
                this.sendJSONAnswerWithBooleanParameter(true, "isIn2FaGroups", true, null, httpServletResp);
                return;
            }
            this.sendJSONAnswerWithBooleanParameter(true, "isIn2FaGroups", false, null, httpServletResp);
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, "OperationFailedException on checking admin in 2FA group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, "ApplicationPermissionException on checking admin in 2FA group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, "InvalidAuthenticationException on checking admin in 2FA group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, "DirectoryNotFoundException on checking admin in 2FA group: " + e.getMessage(), httpServletResp);
            return;
        }
    }

    private void getDataForAdminUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        try {
            User user = this.dataAccessor.getUserCurrentlyLoggedIn();
            String userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
            SecSignID2FASettings settingsForAdmin = this.dataAccessor.get2FASettingsFromUserKey(userKey, user.getDirectoryId());
            boolean pwdAllowed = settingsForAdmin.getPwdAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
            boolean passwordlessAllowed = settingsForAdmin.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
            boolean twoStepAllowed = settingsForAdmin.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
            boolean totpAllowed = settingsForAdmin.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
            boolean mailOTPAllowed = settingsForAdmin.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
            boolean fidoAllowed = settingsForAdmin.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
            JSONObject answerObject = new JSONObject();
            try {
                answerObject.put("success", true);
                answerObject.put("ispwdallowed", pwdAllowed);
                answerObject.put("ispwdless", passwordlessAllowed);
                answerObject.put("istwostep", twoStepAllowed);
                answerObject.put("ismailotp", mailOTPAllowed);
                answerObject.put("istotp", totpAllowed);
                answerObject.put("isfido", fidoAllowed);
                answerObject.put("settingsForAdmin", (Object)SecSignIDMappingUtils.getShortFormOf2FAMethods(settingsForAdmin));
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
                return;
            }
            catch (Exception e) {
                logger.error("Exception on success msg '" + e + "' with reason: " + e.getMessage(), (Throwable)e);
                httpServletResp.sendError(400, e.getMessage());
                return;
            }
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, "OperationFailedException on checking data for admin: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (ApplicationPermissionException e) {
            this.sendJSONAnswer(false, "ApplicationPermissionException on checking data for admin: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.sendJSONAnswer(false, "InvalidAuthenticationException on checking data for admin: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, "DirectoryNotFoundException on checking data for admin: " + e.getMessage(), httpServletResp);
            return;
        }
    }

    private void addAdminToPasswordless(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        try {
            User user = this.dataAccessor.getUserCurrentlyLoggedIn();
            this.dataAccessor.addUserToPasswordless(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId());
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, "UserNotFoundException on adding admin to passwordless group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (GroupNotFoundException e) {
            this.sendJSONAnswer(false, "GroupNotFoundException on adding admin to passwordless group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryPermissionException e) {
            this.sendJSONAnswer(false, "DirectoryPermissionException on adding admin to passwordless group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, "DirectoryNotFoundException on adding admin to passwordless group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, "OperationFailedException on adding admin to passwordless group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (ReadOnlyGroupException e) {
            this.sendJSONAnswer(false, "ReadOnlyGroupException on adding admin to passwordless group: " + e.getMessage(), httpServletResp);
            return;
        }
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void addAdminToTwoStep(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        try {
            User user = this.dataAccessor.getUserCurrentlyLoggedIn();
            this.dataAccessor.addUserToTwoStep(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId());
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, "UserNotFoundException on adding admin to twostep group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (GroupNotFoundException e) {
            this.sendJSONAnswer(false, "GroupNotFoundException on adding admin to twostep group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryPermissionException e) {
            this.sendJSONAnswer(false, "DirectoryPermissionException on adding admin to twostep group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, "DirectoryNotFoundException on adding admin to twostep group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, "OperationFailedException on adding admin to twostep group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (ReadOnlyGroupException e) {
            this.sendJSONAnswer(false, "ReadOnlyGroupException on adding admin to twostep group: " + e.getMessage(), httpServletResp);
            return;
        }
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void addAdminToMailOTP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        try {
            User user = this.dataAccessor.getUserCurrentlyLoggedIn();
            this.dataAccessor.addUserToMailOTP(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId());
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, "UserNotFoundException on adding admin to mailotp group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (GroupNotFoundException e) {
            this.sendJSONAnswer(false, "GroupNotFoundException on adding admin to mailotp group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryPermissionException e) {
            this.sendJSONAnswer(false, "DirectoryPermissionException on adding admin to mailotp group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, "DirectoryNotFoundException on adding admin to mailotp group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, "OperationFailedException on adding admin to mailotp group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (ReadOnlyGroupException e) {
            this.sendJSONAnswer(false, "ReadOnlyGroupException on adding admin to mailotp group: " + e.getMessage(), httpServletResp);
            return;
        }
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void addAdminToTOTP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        try {
            User user = this.dataAccessor.getUserCurrentlyLoggedIn();
            this.dataAccessor.addUserToTOTP(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId());
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, "UserNotFoundException on adding admin to totp group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (GroupNotFoundException e) {
            this.sendJSONAnswer(false, "GroupNotFoundException on adding admin to totp group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryPermissionException e) {
            this.sendJSONAnswer(false, "DirectoryPermissionException on adding admin to totp group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, "DirectoryNotFoundException on adding admin to totp group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, "OperationFailedException on adding admin to totp group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (ReadOnlyGroupException e) {
            this.sendJSONAnswer(false, "ReadOnlyGroupException on adding admin to totp group: " + e.getMessage(), httpServletResp);
            return;
        }
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void addAdminToFIDO(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        try {
            User user = this.dataAccessor.getUserCurrentlyLoggedIn();
            this.dataAccessor.addUserToFIDO(this.dataAccessor.getUserKeyForUsername(user.getName()), user.getDirectoryId());
        }
        catch (UserNotFoundException e) {
            this.sendJSONAnswer(false, "UserNotFoundException on adding admin to fido group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (GroupNotFoundException e) {
            this.sendJSONAnswer(false, "GroupNotFoundException on adding admin to fido group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryPermissionException e) {
            this.sendJSONAnswer(false, "DirectoryPermissionException on adding admin to fido group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.sendJSONAnswer(false, "DirectoryNotFoundException on adding admin to fido group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (OperationFailedException e) {
            this.sendJSONAnswer(false, "OperationFailedException on adding admin to fido group: " + e.getMessage(), httpServletResp);
            return;
        }
        catch (ReadOnlyGroupException e) {
            this.sendJSONAnswer(false, "ReadOnlyGroupException on adding admin to fido group: " + e.getMessage(), httpServletResp);
            return;
        }
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void handleGroupQuestionRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        boolean createGroups = Boolean.parseBoolean(httpServletRequest.getParameter("createGroups"));
        if (createGroups) {
            try {
                this.dataAccessor.createGroupsWithSettings();
                SecSignIDCommonStaticAccessor.saveGroupsCreated(true);
            }
            catch (InvalidGroupException e) {
                this.sendJSONAnswer(false, "InvalidGroupException on creating groups: " + e.getMessage(), httpServletResp);
                return;
            }
            catch (DirectoryPermissionException e) {
                this.sendJSONAnswer(false, "DirectoryPermissionException on creating groups: " + e.getMessage(), httpServletResp);
                return;
            }
            catch (DirectoryNotFoundException e) {
                this.sendJSONAnswer(false, "DirectoryNotFoundException on creating groups: " + e.getMessage(), httpServletResp);
                return;
            }
            catch (OperationFailedException e) {
                this.sendJSONAnswer(false, "OperationFailedException on creating groups: " + e.getMessage(), httpServletResp);
                return;
            }
            catch (GroupNotFoundException e) {
                this.sendJSONAnswer(false, "GroupNotFoundException on creating groups: " + e.getMessage(), httpServletResp);
                return;
            }
            catch (ApplicationPermissionException e) {
                this.sendJSONAnswer(false, "ApplicationPermissionException on creating groups: " + e.getMessage(), httpServletResp);
                return;
            }
            catch (InvalidAuthenticationException e) {
                this.sendJSONAnswer(false, "InvalidAuthenticationException on creating groups: " + e.getMessage(), httpServletResp);
                return;
            }
        } else {
            SecSignIDCommonStaticAccessor.saveGroupsCreated(false);
        }
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void handleAutoIDRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        String pattern;
        boolean fillUsername = Boolean.parseBoolean(httpServletRequest.getParameter("fillUsername"));
        boolean fillUsernameCompany = Boolean.parseBoolean(httpServletRequest.getParameter("fillUsernameCompany"));
        boolean fillMail = Boolean.parseBoolean(httpServletRequest.getParameter("fillMail"));
        boolean fillPattern = Boolean.parseBoolean(httpServletRequest.getParameter("fillPattern"));
        if (fillPattern && ((pattern = httpServletRequest.getParameter("pattern")) == null || pattern.equals("") || !pattern.contains("%username%") && !pattern.contains("%displayname%") && !pattern.contains("%mail%") && !pattern.contains("%index%"))) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.users.pattern.illegal"), httpServletResp);
            return;
        }
        SecSignIDCommonStaticAccessor.saveAutoFillUsername(fillUsername);
        SecSignIDCommonStaticAccessor.saveAutoFillUsernameCompany(fillUsernameCompany);
        SecSignIDCommonStaticAccessor.saveAutoFillMail(fillMail);
        SecSignIDCommonStaticAccessor.saveAutoFillPattern(fillPattern);
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void handleAlreadyExistingRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        boolean allowUserCreate = Boolean.parseBoolean(httpServletRequest.getParameter("allowUserCreate"));
        boolean allowUserExisting = Boolean.parseBoolean(httpServletRequest.getParameter("allowUserExisting"));
        SecSignIDCommonStaticAccessor.saveAllowUserCreate(allowUserCreate);
        SecSignIDCommonStaticAccessor.saveAllowUserExisting(allowUserExisting);
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void handleSameUserNextRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        String pattern;
        boolean fillUsername = Boolean.parseBoolean(httpServletRequest.getParameter("fillUsername"));
        boolean fillUsernameCompany = Boolean.parseBoolean(httpServletRequest.getParameter("fillUsernameCompany"));
        boolean fillMail = Boolean.parseBoolean(httpServletRequest.getParameter("fillMail"));
        boolean fillPattern = Boolean.parseBoolean(httpServletRequest.getParameter("fillPattern"));
        if (fillPattern && ((pattern = httpServletRequest.getParameter("pattern")) == null || pattern.equals("") || !pattern.contains("%username%") && !pattern.contains("%displayname%") && !pattern.contains("%mail%") && !pattern.contains("%index%"))) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.users.pattern.illegal"), httpServletResp);
            return;
        }
        SecSignIDCommonStaticAccessor.saveAutoFillUsername(fillUsername);
        SecSignIDCommonStaticAccessor.saveAutoFillUsernameCompany(fillUsernameCompany);
        SecSignIDCommonStaticAccessor.saveAutoFillMail(fillMail);
        SecSignIDCommonStaticAccessor.saveAutoFillPattern(fillPattern);
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void handleExternRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        boolean disableBasicAuth = Boolean.parseBoolean(httpServletRequest.getParameter("disableBasicAuth"));
        boolean disableAccessToken = Boolean.parseBoolean(httpServletRequest.getParameter("disableAccessToken"));
        SecSignIDCommonStaticAccessor.saveDisableAccessToken(disableAccessToken);
        SecSignIDCommonStaticAccessor.saveDisableBasicAuth(disableBasicAuth);
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void handle2FAMethodsRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        boolean passwordless = Boolean.parseBoolean(httpServletRequest.getParameter("passwordless"));
        boolean secsign = Boolean.parseBoolean(httpServletRequest.getParameter("secsign"));
        boolean fido = Boolean.parseBoolean(httpServletRequest.getParameter("fido"));
        boolean totp = Boolean.parseBoolean(httpServletRequest.getParameter("totp"));
        boolean mailotp = Boolean.parseBoolean(httpServletRequest.getParameter("mailotp"));
        if (!(passwordless || secsign || fido || totp || mailotp)) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.options.auth.no"), httpServletResp);
            return;
        }
        SecSignIDCommonStaticAccessor.savePasswordlessEnabled(passwordless);
        SecSignIDCommonStaticAccessor.saveSecSignEnabled(secsign);
        SecSignIDCommonStaticAccessor.saveFIDOEnabled(fido);
        SecSignIDCommonStaticAccessor.saveTOTPEnabled(totp);
        SecSignIDCommonStaticAccessor.saveMailOTPEnabled(mailotp);
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void handleServerQuestionRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        String serviceName = httpServletRequest.getParameter("serviceName");
        String companyName = httpServletRequest.getParameter("companyName");
        if (companyName.equals("")) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.options.companyname.error"), httpServletResp);
            return;
        }
        if (serviceName.equals("")) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.options.servicename.error"), httpServletResp);
            return;
        }
        SecSignIDCommonStaticAccessor.saveCompanyName(companyName);
        SecSignIDCommonStaticAccessor.saveServiceName(serviceName);
        String ownServerString = httpServletRequest.getParameter("ownServer");
        boolean ownServer = Boolean.parseBoolean(ownServerString);
        if (!ownServer) {
            SecSignIDCommonStaticAccessor.saveServerUrl("");
            SecSignIDCommonStaticAccessor.saveUseFallback(true);
            SecSignIDCommonStaticAccessor.saveFallbackServerUrl("");
            if (!SecSignIDCommonStaticAccessor.hasPluginPinAccount()) {
                try {
                    SecSignIDRESTPluginRegistrationResponse pluginRegisterResponse = SecSignIDServerRESTConnector.registerPlugin();
                    SecSignIDCommonStaticAccessor.savePinAccount(new String[]{pluginRegisterResponse.getAccountName(), pluginRegisterResponse.getPassword()});
                }
                catch (SecSignIDRESTException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    this.sendJSONAnswer(false, e.getMessage(), httpServletResp);
                    return;
                }
                catch (SecSignExceptionKey e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    this.sendJSONAnswer(false, e.getMessage(), httpServletResp);
                    return;
                }
            }
        }
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void handleServerRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResp) throws IOException {
        String ownPinAccountString;
        boolean ownPinAccount;
        String fallbackServerURL = "";
        String[] pinAccount = null;
        String serverURL = httpServletRequest.getParameter("serverURL");
        if (!serverURL.contains("http://") && !serverURL.contains("https://")) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.server.notreached.http") + serverURL, httpServletResp);
            logger.debug("https/https missing at server url");
            return;
        }
        logger.debug("Testing main Server URL: " + serverURL);
        boolean mainServerTest = false;
        try {
            mainServerTest = SecSignIDServerRESTConnector.testSecSignIDServerUrl(serverURL);
        }
        catch (SecSignIDRESTException e) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.rest") + " " + serverURL, httpServletResp);
            logger.error("SecSignIDRESTException on check main id server (" + serverURL + ") : " + e.getMessage());
            return;
        }
        if (!mainServerTest) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.server.notreached") + serverURL, httpServletResp);
            logger.error("serverUrl wrong");
            return;
        }
        String useFallbackString = httpServletRequest.getParameter("useFallback");
        boolean useFallback = Boolean.parseBoolean(useFallbackString);
        if (useFallback) {
            fallbackServerURL = httpServletRequest.getParameter("fallbackServerURL");
            if (!fallbackServerURL.contains("http://") && !fallbackServerURL.contains("https://")) {
                this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.server.notreached.http") + fallbackServerURL, httpServletResp);
                logger.debug("https/https missing at fallback server url");
                return;
            }
            logger.debug("Testing fallback Server URL: " + fallbackServerURL);
            try {
                boolean testFallbackUrl = SecSignIDServerRESTConnector.testSecSignIDServerUrl(fallbackServerURL);
                if (!testFallbackUrl) {
                    this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.server.notreached") + fallbackServerURL, httpServletResp);
                    logger.debug("serverUrl wrong");
                    return;
                }
            }
            catch (SecSignIDRESTException e) {
                this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.rest") + fallbackServerURL, httpServletResp);
                logger.error("SecSignIDRESTException on check fallback id server (" + fallbackServerURL + ") : " + e.getMessage());
                return;
            }
        }
        if (ownPinAccount = Boolean.parseBoolean(ownPinAccountString = httpServletRequest.getParameter("ownPinAccount"))) {
            String pinAccountUser = httpServletRequest.getParameter("pinAccountUser");
            String pinAccountPassword = httpServletRequest.getParameter("pinAccountPassword");
            pinAccount = new String[]{pinAccountUser, pinAccountPassword};
            if (pinAccountUser.equals("")) {
                this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.ownpin.name"), httpServletResp);
                return;
            }
            if (pinAccountPassword.equals("")) {
                this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.ownpin.password"), httpServletResp);
                return;
            }
            try {
                SecSignIDCommonStaticAccessor.savePinAccount(pinAccount);
            }
            catch (Exception e) {
                this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.ownpin.save"), httpServletResp);
                logger.error(e.getClass().getName() + " on saving PinAccount " + e.getMessage(), (Throwable)e);
                return;
            }
        }
        try {
            SecSignIDCommonStaticAccessor.deletePinAccount();
        }
        catch (Exception e) {
            this.sendJSONAnswer(false, this.i18nResolver.getText("secsignid.messages.error.ownpin.save"), httpServletResp);
            logger.error(e.getClass().getName() + " on deleting PinAccount " + e.getMessage(), (Throwable)e);
            return;
        }
        SecSignIDCommonStaticAccessor.saveServerUrl(serverURL);
        SecSignIDCommonStaticAccessor.saveUseFallback(useFallback);
        if (useFallback) {
            SecSignIDCommonStaticAccessor.saveFallbackServerUrl(fallbackServerURL);
        }
        this.sendJSONAnswer(true, null, httpServletResp);
    }

    private void sendJSONAnswer(boolean success, String errormsg, HttpServletResponse httpServletResp) throws IOException {
        JSONObject answerObject = new JSONObject();
        if (success) {
            try {
                answerObject.put("success", true);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
            }
            catch (Exception e) {
                logger.error("Exception on success msg '" + errormsg + "' with reason: " + e.getMessage(), (Throwable)e);
                httpServletResp.sendError(400, e.getMessage());
            }
        } else {
            try {
                answerObject.put("success", false);
                answerObject.put("errormsg", (Object)errormsg);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
            }
            catch (Exception e) {
                logger.error("Exception on error msg '" + errormsg + "' with reason: " + e.getMessage(), (Throwable)e);
                httpServletResp.sendError(400, e.getMessage());
            }
        }
    }

    private void sendJSONAnswerWithBooleanParameter(boolean success, String parameterKey, boolean paramaterValue, String errormsg, HttpServletResponse httpServletResp) throws IOException {
        JSONObject answerObject = new JSONObject();
        if (success) {
            try {
                answerObject.put("success", true);
                answerObject.put(parameterKey, paramaterValue);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
            }
            catch (Exception e) {
                logger.error("Exception on success msg '" + errormsg + "' with reason: " + e.getMessage(), (Throwable)e);
                httpServletResp.sendError(400, e.getMessage());
            }
        } else {
            try {
                answerObject.put("success", false);
                answerObject.put("errormsg", (Object)errormsg);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
            }
            catch (Exception e) {
                logger.error("Exception on error msg '" + errormsg + "' with reason: " + e.getMessage(), (Throwable)e);
                httpServletResp.sendError(400, e.getMessage());
            }
        }
    }

    private void sendJSONAnswerWithMapParameterAndSettings(boolean success, String parameterKey, TreeMap<String, String> paramaterValue, String errormsg, HttpServletResponse httpServletResp, JSONObject answer) throws IOException {
        JSONObject answerObject = new JSONObject();
        if (success) {
            try {
                if (answer.getBoolean("com.secsign.share.passwordless.enabled")) {
                    answerObject.put("passwordlessEnabled", true);
                } else {
                    answerObject.put("passwordlessEnabled", false);
                }
                if (answer.getBoolean("com.secsign.share.secsign.enabled")) {
                    answerObject.put("secsignEnabled", true);
                } else {
                    answerObject.put("secsignEnabled", false);
                }
                if (answer.getBoolean("com.secsign.share.fido.enabled")) {
                    answerObject.put("fidoEnabled", true);
                } else {
                    answerObject.put("fidoEnabled", false);
                }
                if (answer.getBoolean("com.secsign.share.totp.enabled")) {
                    answerObject.put("totpEnabled", true);
                } else {
                    answerObject.put("totpEnabled", false);
                }
                if (answer.getBoolean("com.secsign.share.mailotp.enabled")) {
                    answerObject.put("mailotpEnabled", true);
                } else {
                    answerObject.put("mailotpEnabled", false);
                }
                answerObject.put("success", true);
                answerObject.put(parameterKey + "_keys", (Object)paramaterValue.keySet().toArray());
                answerObject.put(parameterKey, paramaterValue);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
            }
            catch (Exception e) {
                logger.error("Exception on success msg '" + errormsg + "' with reason: " + e.getMessage(), (Throwable)e);
                httpServletResp.sendError(400, e.getMessage());
            }
        } else {
            try {
                answerObject.put("success", false);
                answerObject.put("errormsg", (Object)errormsg);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
            }
            catch (Exception e) {
                logger.error("Exception on error msg '" + errormsg + "' with reason: " + e.getMessage(), (Throwable)e);
                httpServletResp.sendError(400, e.getMessage());
            }
        }
    }
}

