/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.sal.api.message.I18nResolver;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.rest.SecSignIDRESTCreateQRCodeResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTCreateSecSignIDResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTDevicesResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import com.secsign.atlassian.common.rest.SecSignIDServerRESTConnector;
import com.secsign.atlassian.common.util.SecSignIDAuthenticationUtil;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDQRServlet
extends HttpServlet {
    public static final String USERNAME_SESSION_ATTRIBUTE_KEY = "qr.username";
    private static final long serialVersionUID = 6842235411471448500L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDQRServlet.class);
    private final I18nResolver i18nResolver;
    private SecSignIDDataAccessor dataAccessor;

    public SecSignIDQRServlet(I18nResolver i18nResolver, SecSignIDDataAccessor staticAccessor) {
        this.i18nResolver = i18nResolver;
        this.dataAccessor = staticAccessor;
    }

    protected void doPost(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        JSONObject answerJSONObject = new JSONObject();
        if (httpServletReq.getParameter("checkRestore") != null) {
            try {
                this.checkRestore(httpServletReq, httpServletResp, answerJSONObject);
            }
            catch (JSONException e) {
                logger.debug("JSONException on QRServlet");
            }
        } else if (httpServletReq.getParameter("checkCreate") != null) {
            try {
                this.checkCreate(httpServletReq, httpServletResp, answerJSONObject);
            }
            catch (JSONException e) {
                logger.debug("JSONException on QRServlet");
            }
        } else {
            try {
                if (this.createID(httpServletReq, httpServletResp, answerJSONObject)) {
                    answerJSONObject.put("success", (Object)Boolean.TRUE);
                } else {
                    answerJSONObject.put("success", (Object)Boolean.FALSE);
                }
            }
            catch (JSONException e) {
                logger.debug("JSONException on QRServlet");
            }
        }
        httpServletResp.setContentType("application/json");
        httpServletResp.getWriter().write(answerJSONObject.toString());
    }

    private boolean checkRestore(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, JSONObject answerJSONObject) throws JSONException {
        try {
            boolean restored;
            String SecSignIDToTest = httpServletReq.getParameter("idToRestore");
            SecSignIDRESTDevicesResponse devicesResponse = SecSignIDServerRESTConnector.getDevicesOfSecSignID(SecSignIDToTest);
            boolean bl = restored = devicesResponse.getDeviceCount() != 0;
            if (restored) {
                answerJSONObject.put("restored", true);
            } else {
                answerJSONObject.put("restored", false);
            }
            return true;
        }
        catch (SecSignIDRESTException e) {
            answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.rest.normal.user"));
        }
        catch (Exception e) {
            answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
        }
        return false;
    }

    private boolean checkCreate(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, JSONObject answerJSONObject) throws JSONException {
        try {
            String SecSignIDToTest = httpServletReq.getParameter("idToRestore");
            boolean created = SecSignIDServerRESTConnector.checkSecSignID(SecSignIDToTest);
            if (created) {
                answerJSONObject.put("created", true);
            } else {
                answerJSONObject.put("created", false);
            }
            return true;
        }
        catch (SecSignIDRESTException e) {
            answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.rest.normal.user"));
            return false;
        }
        catch (Exception e) {
            answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
            return false;
        }
    }

    private boolean createID(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, JSONObject answerJSONObject) throws JSONException {
        if (httpServletReq.getParameter("wishID") == null || httpServletReq.getParameter("wishID").equals("")) {
            answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.noidentered"));
            return false;
        }
        String _wishID = httpServletReq.getParameter("wishID");
        String userKey = SecSignIDAuthenticationUtil.getUserKeyFromRequest(httpServletReq);
        User user = SecSignIDAuthenticationUtil.getUserFromRequest(httpServletReq, this.dataAccessor);
        if (userKey == null || user == null) {
            user = this.dataAccessor.getUserCurrentlyLoggedIn();
            userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
        }
        if (_wishID.toLowerCase().equals("admin") || _wishID.toLowerCase().equals("admintest")) {
            answerJSONObject.put("errormsg", (Object)(this.i18nResolver.getText("secsignid.messages.error.action.duplicate2") + " " + _wishID));
            return false;
        }
        if (SecSignIDCommonStaticAccessor.secSignIdContainsIllegalCharacters(_wishID)) {
            answerJSONObject.put("errormsg", (Object)(this.i18nResolver.getText("secsignid.messages.error.action.illegalcharacters2") + " " + _wishID));
            return false;
        }
        try {
            Object[] result = this.dataAccessor.checkDuplicates(_wishID);
            if (((Boolean)result[0]).booleanValue()) {
                answerJSONObject.put("errormsg", (Object)(this.i18nResolver.getText("secsignid.messages.error.action.duplicate2") + " " + _wishID));
                return false;
            }
        }
        catch (Exception e) {
            answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
            return false;
        }
        boolean exist = false;
        try {
            exist = SecSignIDServerRESTConnector.checkSecSignID(_wishID);
        }
        catch (SecSignIDRESTException e) {
            answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.rest.normal.user"));
            logger.error("SecSignIDRESTException on createID: " + e.getMessage());
            return false;
        }
        if (!exist) {
            String email;
            if (!SecSignIDCommonStaticAccessor.getUseRestore() || httpServletReq.getParameter("tutorial") != null) {
                String url;
                String qrCode;
                try {
                    SecSignIDRESTCreateQRCodeResponse createQRCodeResponse = SecSignIDServerRESTConnector.getCreateSecSignIDQrCode(_wishID);
                    qrCode = createQRCodeResponse.getQrCodeBase64();
                    url = createQRCodeResponse.getCreateUrl();
                }
                catch (SecSignIDRESTException e) {
                    answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.rest.normal.user"));
                    logger.error("SecSignIDRESTException on createID: " + e.getMessage());
                    return false;
                }
                if (qrCode != null && url != null) {
                    try {
                        SecSignID2FAActivatedSettings activatedSettings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, user.getDirectoryId());
                        activatedSettings.setTwoStepActive(true);
                        this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
                    }
                    catch (OperationFailedException e) {
                        logger.error("OperationFailedException on createID without Restore: " + e.getMessage());
                        logger.error(e.getMessage(), (Throwable)e);
                        answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                        return false;
                    }
                    catch (ApplicationPermissionException e) {
                        logger.error("ApplicationPermissionException on createID without Restore: " + e.getMessage());
                        logger.error(e.getMessage(), (Throwable)e);
                        answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                        return false;
                    }
                    catch (InvalidAuthenticationException e) {
                        logger.error("InvalidAuthenticationException on createID without Restore: " + e.getMessage());
                        logger.error(e.getMessage(), (Throwable)e);
                        answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                        return false;
                    }
                    catch (DirectoryPermissionException e) {
                        logger.error("DirectoryPermissionException on createID without Restore: " + e.getMessage());
                        logger.error(e.getMessage(), (Throwable)e);
                        answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                        return false;
                    }
                    catch (Exception e) {
                        logger.error(e.toString() + " on createID without Restore: " + e.getMessage());
                        logger.error(e.getMessage(), (Throwable)e);
                        answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                        return false;
                    }
                    answerJSONObject.put("qrCode", (Object)qrCode);
                    answerJSONObject.put("url", (Object)url);
                    answerJSONObject.put("id", (Object)_wishID);
                    answerJSONObject.put("created", true);
                    return true;
                }
                return false;
            }
            try {
                email = this.dataAccessor.getEmailForUserKey(userKey, user.getDirectoryId());
            }
            catch (UserNotFoundException e1) {
                logger.error(e1.toString() + " on createID without Restore: " + e1.getMessage());
                logger.error(e1.getMessage(), (Throwable)e1);
                answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                return false;
            }
            catch (ApplicationNotFoundException e1) {
                logger.error(e1.toString() + " on createID without Restore: " + e1.getMessage());
                logger.error(e1.getMessage(), (Throwable)e1);
                answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                return false;
            }
            catch (OperationFailedException e1) {
                logger.error(e1.toString() + " on createID without Restore: " + e1.getMessage());
                logger.error(e1.getMessage(), (Throwable)e1);
                answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                return false;
            }
            catch (DirectoryNotFoundException e1) {
                logger.error(e1.toString() + " on createID without Restore: " + e1.getMessage());
                logger.error(e1.getMessage(), (Throwable)e1);
                answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                return false;
            }
            String qrCode = null;
            String url = null;
            try {
                SecSignIDRESTCreateSecSignIDResponse createSecSignIDResponse = SecSignIDServerRESTConnector.createSecSignID(_wishID, email);
                qrCode = createSecSignIDResponse.getQrCodeBase64();
                url = createSecSignIDResponse.getRestoreUrl();
            }
            catch (SecSignIDRESTException e) {
                answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.rest.normal.user"));
                logger.error("SecSignIDRESTException on createID: " + e.getMessage());
                return false;
            }
            if (qrCode != null) {
                try {
                    SecSignID2FAActivatedSettings activatedSettings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, user.getDirectoryId());
                    activatedSettings.setTwoStepActive(true);
                    this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, user.getDirectoryId(), activatedSettings);
                }
                catch (OperationFailedException e) {
                    logger.error("OperationFailedException on createID with Restore: " + e.getMessage());
                    logger.error(e.getMessage(), (Throwable)e);
                    answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                    return false;
                }
                catch (ApplicationPermissionException e) {
                    logger.error("ApplicationPermissionException on createID with Restore: " + e.getMessage());
                    logger.error(e.getMessage(), (Throwable)e);
                    answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                    return false;
                }
                catch (InvalidAuthenticationException e) {
                    logger.error("InvalidAuthenticationException on createID with Restore: " + e.getMessage());
                    logger.error(e.getMessage(), (Throwable)e);
                    answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                    return false;
                }
                catch (DirectoryPermissionException e) {
                    logger.error("DirectoryPermissionException on createID with Restore: " + e.getMessage());
                    logger.error(e.getMessage(), (Throwable)e);
                    answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                    return false;
                }
                catch (Exception e) {
                    logger.error(e.toString() + " on createID with Restore: " + e.getMessage());
                    logger.error(e.getMessage(), (Throwable)e);
                    answerJSONObject.put("errormsg", (Object)this.i18nResolver.getText("secsignid.messages.error.synch.normal.user "));
                    return false;
                }
                answerJSONObject.put("qrCode", (Object)qrCode);
                answerJSONObject.put("id", (Object)_wishID);
                answerJSONObject.put("url", (Object)url);
                answerJSONObject.put("created", false);
                answerJSONObject.put("mail", (Object)email);
                return true;
            }
            return false;
        }
        answerJSONObject.put("errormsg", (Object)(this.i18nResolver.getText("secsignid.tutorial.first.admin.id.exists") + " " + _wishID));
        return false;
    }
}

