/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.contextprovider.SecSignIDUserInfoProvider;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDProfileTabServlet
extends HttpServlet {
    private static final long serialVersionUID = 6021643587383083271L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDProfileTabServlet.class);
    private String profileTabTemplate = "/templates/secsignid-profiletab.vm";
    private final TemplateRenderer templateRenderer;
    private final I18nResolver i18nResolver;
    private final WebResourceManager webResourceManager;
    private SecSignIDDataAccessor dataAccessor;

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }

    public SecSignIDProfileTabServlet(TemplateRenderer templateRenderer, I18nResolver i18nResolver, WebResourceManager webResourceManager, SecSignIDDataAccessor dataAccessor) {
        this.templateRenderer = templateRenderer;
        this.i18nResolver = i18nResolver;
        this.webResourceManager = webResourceManager;
        this.dataAccessor = dataAccessor;
    }

    protected void doGet(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        boolean basicAuthUsed;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("contextPath", httpServletReq.getContextPath());
        User appUser = this.dataAccessor.getUserCurrentlyLoggedIn();
        boolean bl = basicAuthUsed = httpServletReq.getSession().getAttribute("secsign.basicAuth") != null;
        if (appUser == null || basicAuthUsed) {
            httpServletResp.sendRedirect(this.dataAccessor.getBaseUrl());
            return;
        }
        String userKey = this.dataAccessor.getUserKeyForUsername(appUser.getName());
        context.put("name", appUser.getName());
        context.put("req", httpServletReq);
        SecSignIDUserInfoProvider infoProvider = new SecSignIDUserInfoProvider();
        context.putAll(infoProvider.getContextMap(context));
        context.put("profileUser", appUser);
        context.put("bitbucketuser", appUser.getName());
        context.put("bitbucketuserurldec", URLEncoder.encode(appUser.getName(), "utf-8"));
        httpServletResp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(this.profileTabTemplate, context, (Writer)httpServletResp.getWriter());
    }

    private String getSecSignIdForUser(User user, String userKey) throws ApplicationPermissionException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException, InvalidAuthenticationException {
        String idString = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
        String[] idArray = SecSignIDMappingUtils.getArrayOfSecSignIds(idString);
        if (idArray.length != 0) {
            return idArray[0];
        }
        return null;
    }
}

