/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.secsign.atlassian.common.data.SecSignIDServerVersion;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDRESTDevicesResponse {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDRESTDevicesResponse.class);
    private final int deviceCount;

    public static SecSignIDRESTDevicesResponse fromJson(String json, String secSignId, SecSignIDServerVersion serverVersion) throws JSONException, SecSignIDRESTException {
        JSONObject rootObject = new JSONObject(json);
        if (serverVersion.isGreaterOrEquals(SecSignIDServerVersion.VERSION_10_7_5)) {
            int deviceCount = rootObject.optInt("count", -1);
            if (deviceCount == -1) {
                logger.debug("Key 'count' not found");
                throw new SecSignIDRESTException("Key 'count' not found");
            }
            return new SecSignIDRESTDevicesResponse(deviceCount);
        }
        if (!rootObject.has(secSignId)) {
            logger.debug("Key '" + secSignId + "' not found");
            throw new SecSignIDRESTException("No secsignid information available");
        }
        JSONObject secSignObject = rootObject.getJSONObject(secSignId);
        if (!secSignObject.has("devices")) {
            logger.debug("Key 'devices' not found");
            throw new SecSignIDRESTException("No devices information available");
        }
        JSONObject devicesObject = secSignObject.getJSONObject("devices");
        return new SecSignIDRESTDevicesResponse(devicesObject.length());
    }

    private SecSignIDRESTDevicesResponse(int deviceCount) {
        this.deviceCount = deviceCount;
    }

    public int getDeviceCount() {
        return this.deviceCount;
    }
}

