/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.servlet.filter;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.util.SecSignIDCharArrayWriter;
import com.secsign.atlassian.common.util.SecSignIDServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDForgotFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(SecSignIDForgotFilter.class);
    private final TemplateRenderer templateRenderer;
    private final PluginSettingsFactory pluginSettingsFactory;
    private String forgotLoginTemplate = "/templates/secsignid-forgot.vm";

    public SecSignIDForgotFilter(TemplateRenderer templateRenderer, PluginSettingsFactory pluginSettingsFactory) {
        this.templateRenderer = templateRenderer;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecSignIDServletResponseWrapper responseWrapper = new SecSignIDServletResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)responseWrapper);
        HttpServletRequest httpServletReq = (HttpServletRequest)request;
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("contextPath", httpServletReq.getContextPath());
        SecSignIDCharArrayWriter renderedTemplate = new SecSignIDCharArrayWriter();
        this.templateRenderer.render(this.forgotLoginTemplate, context, (Writer)renderedTemplate);
        responseWrapper.inject(renderedTemplate, "</head>");
        PrintWriter responseOutput = response.getWriter();
        response.setContentLength(responseWrapper.length());
        responseOutput.write(responseWrapper.toString());
        responseOutput.close();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

