/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.atlassian.sal.api.message.I18nResolver;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignIDServerVersion;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenAuthorizationRequest;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenAuthorizationResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenInfoResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenRequest;
import com.secsign.atlassian.common.rest.SecSignIDRESTAccessTokenResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTAuthenticationMethod;
import com.secsign.atlassian.common.rest.SecSignIDRESTCheckAuthSessionStateResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTCreateAuthSessionResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTCreateQRCodeResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTCreateSecSignIDResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTDevicesResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import com.secsign.atlassian.common.rest.SecSignIDRESTExistResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTFIDOAuthenticateStartResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTFIDORegisterStartResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTPluginRegistrationResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTPluginRegistrationUpdateRequest;
import com.secsign.atlassian.common.rest.SecSignIDRESTResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTRestorationResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTServerInfoResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTTOTPResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTVerifyMailCodeResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTVerifyOTPCodeResponse;
import com.secsign.atlassian.common.util.SecSignIDPublicSuffixInterpreter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecSignIDServerRESTConnector {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDServerRESTConnector.class);
    private static I18nResolver i18nResolver;
    private static SecSignIDDataAccessor dataAccessor;
    private static final long CACHE_TIME_SERVER_VERSION = 1800000L;
    private static long lastServerVersionCacheTime;
    private static SecSignIDServerVersion cachedServerVersion;

    private SecSignIDServerRESTConnector(I18nResolver i18nResolver, SecSignIDDataAccessor dataAccessor) {
        SecSignIDServerRESTConnector.i18nResolver = i18nResolver;
        SecSignIDServerRESTConnector.dataAccessor = dataAccessor;
    }

    public static boolean testSecSignIDServerUrl(String url) throws SecSignIDRESTException {
        boolean connected = false;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(5000).build();
        CloseableHttpClient httpClient = HttpClients.custom().useSystemProperties().setDefaultRequestConfig(requestConfig).build();
        try {
            HttpGet httpGet = new HttpGet(url);
            httpClient.execute((HttpUriRequest)httpGet);
            connected = true;
        }
        catch (Exception e) {
            logger.error("Exception on testSecSignIDServerUrl: " + e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("Exception on testSecSignIDServerUrl: " + e.getMessage());
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
        return connected;
    }

    public static SecSignIDRESTDevicesResponse getDevicesOfSecSignID(String secSignID) throws SecSignIDRESTException {
        logger.debug("Get devices of SecSign ID '" + secSignID + "'.");
        SecSignIDServerVersion serverVersion = SecSignIDServerRESTConnector.getServerVersion();
        String endpointUrl = serverVersion.isGreaterOrEquals(SecSignIDServerVersion.VERSION_10_7_5) ? "/rest/v1/Device/" + secSignID.toLowerCase() + "/Count" : "/rest/v2/SecSignId/" + secSignID.toLowerCase() + "?devices";
        SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getGetResponse(endpointUrl, null);
        if (response.getStatusLine().getStatusCode() == 200) {
            try {
                return SecSignIDRESTDevicesResponse.fromJson(response.getContent(), secSignID, serverVersion);
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("JSONException: " + e.getMessage());
            }
        }
        throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
    }

    public static boolean checkSecSignID(String secSignID) throws SecSignIDRESTException {
        logger.debug("Check if SecSign ID '" + secSignID + "' exists.");
        String endpointUrl = "/rest/v2/SecSignId/" + secSignID.toLowerCase() + "?exist";
        SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getGetResponse(endpointUrl, null);
        if (response.getStatusLine().getStatusCode() == 200) {
            try {
                SecSignIDRESTExistResponse existResponse = SecSignIDRESTExistResponse.fromJson(response.getContent());
                return existResponse.getExist();
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("JSONException: " + e.getMessage());
            }
        }
        throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
    }

    public static SecSignIDRESTCreateSecSignIDResponse createSecSignID(String secSignId, String email) throws SecSignIDRESTException {
        String endpointUrl = "/rest/v2/SecSignId/";
        try {
            JSONObject requestObject = new JSONObject();
            requestObject.put("secsignid", (Object)secSignId);
            requestObject.put("email", (Object)email);
            requestObject.put("enable", (Object)"true");
            StringEntity entity = new StringEntity(requestObject.toString());
            SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getPostResponse(endpointUrl, (HttpEntity)entity, null);
            if (response.getStatusLine().getStatusCode() == 200) {
                return SecSignIDRESTCreateSecSignIDResponse.fromJson(response.getContent());
            }
            throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("JSONException: " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
    }

    public static SecSignIDRESTRestorationResponse getRestoreQRCode(String secSignId, String accessToken) throws SecSignIDRESTException {
        SecSignIDRESTResponse response;
        String endpointUrl = "/rest/v1/SecSignId/" + secSignId + "?restoration";
        if (accessToken != null) {
            endpointUrl = endpointUrl + "&accesstoken=" + accessToken;
        }
        if ((response = SecSignIDServerRESTConnector.getGetResponse(endpointUrl, null)).getStatusLine().getStatusCode() == 200) {
            try {
                return SecSignIDRESTRestorationResponse.fromJson(response.getContent(), secSignId);
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("JSONException: " + e.getMessage());
            }
        }
        throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
    }

    public static SecSignIDRESTCreateQRCodeResponse getCreateSecSignIDQrCode(String secSignId) throws SecSignIDRESTException {
        String endpointUrl = "/rest/v2/SecSignId/" + secSignId + "?createqrcode";
        SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getGetResponse(endpointUrl, null);
        if (response.getStatusLine().getStatusCode() == 200) {
            try {
                return SecSignIDRESTCreateQRCodeResponse.fromJson(response.getContent());
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("JSONException: " + e.getMessage());
            }
        }
        throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
    }

    public static boolean startMailAuth(String secSignId, String mail) throws SecSignIDRESTException {
        String encodedMail;
        String encodedSecSignId;
        logger.debug("Starting mail auth for SecSign ID '" + secSignId + "' and mail '" + mail + "'.");
        try {
            encodedSecSignId = URLEncoder.encode(secSignId, "UTF-8");
            encodedMail = URLEncoder.encode(mail, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
        String endpointUrl = "/rest/v2/OTP?secsignid=" + encodedSecSignId.toLowerCase() + "&email=" + encodedMail;
        SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getGetResponse(endpointUrl, null);
        if (response.getStatusLine().getStatusCode() == 200) {
            return true;
        }
        throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
    }

    public static SecSignIDRESTVerifyMailCodeResponse verifyMailCode(String secSignId, String mailCode) throws SecSignIDRESTException {
        String encodedMailCode;
        String encodedSecSignId;
        logger.debug("Verifying mail code for SecSign ID '" + secSignId + "' and mail code '" + mailCode + "'.");
        if (secSignId == null || secSignId.length() == 0) {
            throw new SecSignIDRESTException("No SecSign ID provided for Mail-OTP.");
        }
        try {
            encodedSecSignId = URLEncoder.encode(secSignId, "UTF-8");
            encodedMailCode = URLEncoder.encode(mailCode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
        String endpointUrl = "/rest/v2/OTP/valid/" + encodedMailCode + "?secsignid=" + encodedSecSignId.toLowerCase();
        SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getGetResponse(endpointUrl, null);
        if (response.getStatusLine().getStatusCode() == 200) {
            try {
                return SecSignIDRESTVerifyMailCodeResponse.fromJson(response.getContent());
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("JSONException: " + e.getMessage());
            }
        }
        throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
    }

    public static boolean verifyOTPCode(String secSignId, String otpCode) throws SecSignIDRESTException {
        String encodedOTPCode;
        String encodedSecSignId;
        logger.debug("Verifying OTP code for SecSign ID '" + secSignId + "' and OTP code '" + otpCode + "'.");
        try {
            encodedSecSignId = URLEncoder.encode(secSignId, "UTF-8");
            encodedOTPCode = URLEncoder.encode(otpCode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
        String endpointUrl = "/rest/v2/TOTP/Verify/" + encodedOTPCode + "?secsignid=" + encodedSecSignId.toLowerCase();
        SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getGetResponse(endpointUrl, null);
        if (response.getStatusLine().getStatusCode() == 200) {
            try {
                SecSignIDRESTVerifyOTPCodeResponse verifyOTPCodeResponse = SecSignIDRESTVerifyOTPCodeResponse.fromJson(response.getContent());
                return verifyOTPCodeResponse.getValid();
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("JSONException: " + e.getMessage());
            }
        }
        throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
    }

    public static boolean isAccessTokenForTOTPRequired(String secSignId) throws SecSignIDRESTException {
        if (SecSignIDServerRESTConnector.getServerVersion().isLower(SecSignIDServerVersion.VERSION_10_7_5)) {
            return false;
        }
        SecSignIDRESTAccessTokenInfoResponse response = SecSignIDServerRESTConnector.getAccessTokenInfo(secSignId);
        return !response.isAccessAllowedWithoutToken();
    }

    public static SecSignIDRESTTOTPResponse getTOTPQRCode(String secSignId, String accessToken) throws SecSignIDRESTException {
        SecSignIDServerVersion serverVersion = SecSignIDServerRESTConnector.getServerVersion();
        if (serverVersion.isGreaterOrEquals(SecSignIDServerVersion.VERSION_10_7_5)) {
            return SecSignIDServerRESTConnector.getTOTPQRCodeInformations(secSignId, accessToken, serverVersion);
        }
        SecSignIDRESTTOTPResponse response = SecSignIDServerRESTConnector.getTOTPQRCodeInformations(secSignId, null, serverVersion);
        if (response.getTotpKeyUri().equals("") && response.getTotpQRCodeBase64().equals("")) {
            SecSignIDServerRESTConnector.activateTOTP(secSignId);
            response = SecSignIDServerRESTConnector.getTOTPQRCodeInformations(secSignId, null, serverVersion);
        }
        return response;
    }

    private static SecSignIDRESTTOTPResponse getTOTPQRCodeInformations(String secSignId, String accessToken, SecSignIDServerVersion serverVersion) throws SecSignIDRESTException {
        SecSignIDRESTResponse response;
        String endpointUrl;
        String encodedSecSignId;
        try {
            encodedSecSignId = URLEncoder.encode(secSignId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
        if (serverVersion.isGreaterOrEquals(SecSignIDServerVersion.VERSION_10_7_5)) {
            endpointUrl = "/rest/v2/TOTP?secsignid=" + encodedSecSignId.toLowerCase();
            if (accessToken != null) {
                endpointUrl = endpointUrl + "&accesstoken=" + accessToken;
            }
        } else {
            endpointUrl = "/rest/v1/SecSignId/" + encodedSecSignId.toLowerCase() + "?totp&json";
        }
        if ((response = SecSignIDServerRESTConnector.getGetResponse(endpointUrl, null)).getStatusLine().getStatusCode() == 200) {
            try {
                return SecSignIDRESTTOTPResponse.fromJson(response.getContent(), secSignId, serverVersion);
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("JSONException: " + e.getMessage());
            }
        }
        throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
    }

    private static void activateTOTP(String secSignId) throws SecSignIDRESTException {
        String encodedSecSignId;
        try {
            encodedSecSignId = URLEncoder.encode(secSignId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
        SecSignIDServerVersion serverVersion = SecSignIDServerRESTConnector.getServerVersion();
        if (serverVersion.isLower(SecSignIDServerVersion.VERSION_10_7_5)) {
            String endpointUrl = "/rest/v1/SecSignId/" + encodedSecSignId.toLowerCase();
            try {
                JSONObject requestObject = new JSONObject();
                requestObject.put("update", (Object)"totpsecret");
                requestObject.put("generatetotpsecret", true);
                StringEntity entity = new StringEntity(requestObject.toString());
                SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getPostResponse(endpointUrl, (HttpEntity)entity, null);
                if (response.getStatusLine().getStatusCode() == 200) {
                    return;
                }
                throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("JSONException: " + e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
            }
        }
    }

    public static SecSignIDRESTCreateAuthSessionResponse getAuthSession(String secSignId, String serviceName, String serviceAddress, boolean showaccesspassicons) throws SecSignIDRESTException {
        return SecSignIDServerRESTConnector.getAuthSession(secSignId, serviceName, serviceAddress, showaccesspassicons, null, null, null);
    }

    public static SecSignIDRESTCreateAuthSessionResponse getAuthSession(String secSignId, String serviceName, String serviceAddress, boolean showaccesspassicons, String transactionTitle, String transactionDescription, String transactionData) throws SecSignIDRESTException {
        String encodedParameters;
        try {
            String encodedSecSignId = URLEncoder.encode(secSignId, "UTF-8");
            String encodedServiceName = URLEncoder.encode(serviceName, "UTF-8");
            String encodedServiceAddress = URLEncoder.encode(serviceAddress, "UTF-8");
            encodedParameters = "secsignid=" + encodedSecSignId + "&servicename=" + encodedServiceName + "&serviceaddress=" + encodedServiceAddress + "&showaccesspassicons=" + showaccesspassicons;
            if (transactionTitle != null) {
                String encodedTransactionTitle = URLEncoder.encode(transactionTitle, "UTF-8");
                encodedParameters = encodedParameters + "&transactiontitle=" + encodedTransactionTitle;
            }
            if (transactionDescription != null) {
                String encodedTransactionDescription = URLEncoder.encode(transactionDescription, "UTF-8");
                encodedParameters = encodedParameters + "&transactiondescr=" + encodedTransactionDescription;
            }
            if (transactionData != null) {
                String encodedTransactionData = URLEncoder.encode(transactionData, "UTF-8");
                encodedParameters = encodedParameters + "&transactiondata=" + encodedTransactionData;
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
        String endpointUrl = "/rest/v2/AuthSession?" + encodedParameters;
        SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getGetResponse(endpointUrl, null);
        if (response.getStatusLine().getStatusCode() == 200) {
            try {
                return SecSignIDRESTCreateAuthSessionResponse.fromJson(response.getContent());
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("JSONException: " + e.getMessage());
            }
        }
        if (response.getStatusLine().getStatusCode() == 409) {
            return SecSignIDRESTCreateAuthSessionResponse.FROZEN;
        }
        throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
    }

    public static SecSignIDRESTCheckAuthSessionStateResponse checkAuth(String authSessionId) throws SecSignIDRESTException {
        String endpointUrl = "/rest/v2/AuthSession/" + authSessionId;
        SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getGetResponse(endpointUrl, null);
        if (response.getStatusLine().getStatusCode() == 200) {
            try {
                return SecSignIDRESTCheckAuthSessionStateResponse.fromJson(response.getContent());
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("JSONException: " + e.getMessage());
            }
        }
        throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
    }

    public static boolean cancelAuthSession(String authSessionId) throws SecSignIDRESTException {
        String endpointUrl = "/rest/v2/AuthSession/" + authSessionId;
        SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getDeleteResponse(endpointUrl, null);
        if (response.getStatusLine().getStatusCode() == 200) {
            return true;
        }
        throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
    }

    public static SecSignIDRESTPluginRegistrationResponse registerPlugin() throws SecSignIDRESTException {
        UsernamePasswordCredentials credentials = SecSignIDServerRESTConnector.getHttpBasicAuthCredentials();
        try {
            JSONObject requestObject = new JSONObject();
            requestObject.put("url", (Object)dataAccessor.getBaseUrl());
            requestObject.put("siteName", (Object)(dataAccessor.getApplication() + " (" + dataAccessor.getBaseUrl() + ")"));
            requestObject.put("pluginName", (Object)("SecSign ID Atlassian " + dataAccessor.getApplication() + " Plugin " + dataAccessor.getVersion()));
            requestObject.put("pluginType", (Object)"1");
            StringEntity entity = new StringEntity(requestObject.toString());
            SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getPostResponse("/rest/v2/PluginRegistration", (HttpEntity)entity, credentials);
            if (response.getStatusLine().getStatusCode() == 200) {
                return SecSignIDRESTPluginRegistrationResponse.fromJson(response.getContent());
            }
            throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("JSONException: " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
    }

    public static void updatePluginRegistration(String secSignId, String email, String pluginName, String url) throws SecSignIDRESTException {
        String endpointUrl = "/rest/v2/PluginRegistration/Update";
        SecSignIDRESTPluginRegistrationUpdateRequest request = new SecSignIDRESTPluginRegistrationUpdateRequest(secSignId, email, pluginName, url);
        try {
            StringEntity entity = new StringEntity(request.toJSONObject().toString());
            SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getPostResponse(endpointUrl, (HttpEntity)entity, null);
            if (response.getStatusLine().getStatusCode() == 200) {
                return;
            }
            throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("JSONException: " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
    }

    public static SecSignIDServerVersion getServerVersion() {
        boolean cacheExpired;
        boolean bl = cacheExpired = System.currentTimeMillis() - lastServerVersionCacheTime >= 1800000L;
        if (cachedServerVersion != null && !cacheExpired) {
            logger.trace("Using cached server version " + cachedServerVersion.toString());
            return cachedServerVersion;
        }
        String endpointUrl = "/rest/v2/PluginRegistration/ServerInfo";
        SecSignIDServerVersion serverVersion = SecSignIDServerVersion.VERSION_UNKNOWN;
        try {
            SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getGetResponse(endpointUrl, null);
            SecSignIDRESTServerInfoResponse serverInfoResponse = SecSignIDRESTServerInfoResponse.fromJson(response.getContent());
            serverVersion = serverInfoResponse.getVersion();
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SecSignIDRESTException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        cachedServerVersion = serverVersion;
        lastServerVersionCacheTime = System.currentTimeMillis();
        return serverVersion;
    }

    public static SecSignIDRESTAccessTokenInfoResponse getAccessTokenInfo(String secSignId) throws SecSignIDRESTException {
        if (SecSignIDServerRESTConnector.getServerVersion().isLower(SecSignIDServerVersion.VERSION_10_7_5)) {
            return SecSignIDRESTAccessTokenInfoResponse.NO_ACCESS_TOKEN_RESPONSE;
        }
        String serviceUrl = dataAccessor.getBaseUrl();
        try {
            JSONObject requestObject = new JSONObject();
            requestObject.put("secsignid", (Object)secSignId);
            requestObject.put("serviceurl", (Object)serviceUrl);
            StringEntity entity = new StringEntity(requestObject.toString());
            SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getPostResponse("/rest/v2/AccessToken/Info", (HttpEntity)entity, null);
            if (response.getStatusLine().getStatusCode() == 200) {
                return SecSignIDRESTAccessTokenInfoResponse.fromJson(response.getContent());
            }
            throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("JSONException: " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
    }

    public static SecSignIDRESTAccessTokenAuthorizationResponse requestAccessTokenAuthorization(String secSignId, SecSignIDRESTAuthenticationMethod authenticationMethod, SecSignIDRESTAccessTokenAuthorizationRequest.Capability capability) throws SecSignIDRESTException {
        SecSignIDRESTAccessTokenAuthorizationRequest request = new SecSignIDRESTAccessTokenAuthorizationRequest(dataAccessor.getBaseUrl(), secSignId, authenticationMethod, capability);
        try {
            StringEntity entity = new StringEntity(request.toJSONObject().toString());
            SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getPostResponse("/rest/v2/AccessToken", (HttpEntity)entity, null);
            if (response.getStatusLine().getStatusCode() == 200) {
                return SecSignIDRESTAccessTokenAuthorizationResponse.fromJson(response.getContent());
            }
            throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("JSONException: " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
    }

    public static SecSignIDRESTAccessTokenResponse requestAccessToken(SecSignIDRESTAccessTokenRequest request) throws SecSignIDRESTException {
        try {
            StringEntity entity = new StringEntity(request.toJSONObject().toString());
            SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getPostResponse("/rest/v2/AccessToken/" + request.getTokenId(), (HttpEntity)entity, null);
            if (response.getStatusLine().getStatusCode() == 200) {
                return SecSignIDRESTAccessTokenResponse.fromJson(response.getContent());
            }
            throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("JSONException: " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
    }

    public static SecSignIDRESTFIDORegisterStartResponse startFIDORegister(String secSignId, String credentialNickname, String accessToken) throws SecSignIDRESTException {
        try {
            URI uri = new URI(dataAccessor.getBaseUrl());
            String host = uri.getHost();
            String rpId = SecSignIDServerRESTConnector.getTopDomainFromURI(uri);
            if (rpId == null) {
                rpId = host;
            }
            String rpName = host;
            JSONObject requestObject = new JSONObject();
            requestObject.put("rpId", (Object)rpId);
            requestObject.put("rpName", (Object)rpName);
            requestObject.put("userName", (Object)secSignId);
            requestObject.put("credentialNickname", (Object)credentialNickname);
            requestObject.put("accesstoken", (Object)accessToken);
            StringEntity entity = new StringEntity(requestObject.toString());
            SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getPostResponse("/rest/v2/FIDO/Register/Start", (HttpEntity)entity, null);
            if (response.getStatusLine().getStatusCode() == 200) {
                return SecSignIDRESTFIDORegisterStartResponse.fromJson(response.getContent());
            }
            throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("JSONException: " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("URISyntaxException: " + e.getMessage());
        }
    }

    public static void finishFIDORegister(String secSignId, String credentialId, String clientDataJson, String attestationObject, String accessToken) throws SecSignIDRESTException {
        try {
            JSONObject requestObject = new JSONObject();
            requestObject.put("userName", (Object)secSignId);
            requestObject.put("credentialId", (Object)credentialId);
            requestObject.put("clientDataJSON", (Object)clientDataJson);
            requestObject.put("attestationObject", (Object)attestationObject);
            requestObject.put("accesstoken", (Object)accessToken);
            StringEntity entity = new StringEntity(requestObject.toString());
            SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getPostResponse("/rest/v2/FIDO/Register/Finish", (HttpEntity)entity, null);
            if (response.getStatusLine().getStatusCode() == 200) {
                return;
            }
            throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("JSONException: " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
    }

    public static SecSignIDRESTFIDOAuthenticateStartResponse startFIDOAuthenticate(String secSignId) throws SecSignIDRESTException {
        try {
            URI uri = new URI(dataAccessor.getBaseUrl());
            String rpId = SecSignIDServerRESTConnector.getTopDomainFromURI(uri);
            if (rpId == null) {
                rpId = uri.getHost();
            }
            JSONObject requestObject = new JSONObject();
            requestObject.put("rpId", (Object)rpId);
            requestObject.put("userName", (Object)secSignId);
            StringEntity entity = new StringEntity(requestObject.toString());
            SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getPostResponse("/rest/v2/FIDO/Authenticate/Start", (HttpEntity)entity, null);
            if (response.getStatusLine().getStatusCode() == 200) {
                return SecSignIDRESTFIDOAuthenticateStartResponse.fromJson(response.getContent());
            }
            if (response.getStatusLine().getStatusCode() == 403 && !rpId.equals(uri.getHost())) {
                rpId = uri.getHost();
                requestObject = new JSONObject();
                requestObject.put("rpId", (Object)rpId);
                requestObject.put("userName", (Object)secSignId);
                entity = new StringEntity(requestObject.toString());
                response = SecSignIDServerRESTConnector.getPostResponse("/rest/v2/FIDO/Authenticate/Start", (HttpEntity)entity, null);
                if (response.getStatusLine().getStatusCode() == 200) {
                    return SecSignIDRESTFIDOAuthenticateStartResponse.fromJson(response.getContent());
                }
            }
            throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("JSONException: " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("URISyntaxException: " + e.getMessage());
        }
    }

    public static void finishFIDOAuthenticate(String secSignId, String credentialId, String clientDataJson, String authenticatorData, String signature, String userHandle) throws SecSignIDRESTException {
        try {
            JSONObject requestObject = new JSONObject();
            requestObject.put("userName", (Object)secSignId);
            requestObject.put("credentialId", (Object)credentialId);
            requestObject.put("clientDataJSON", (Object)clientDataJson);
            requestObject.put("authenticatorData", (Object)authenticatorData);
            requestObject.put("signature", (Object)signature);
            requestObject.put("userHandle", (Object)userHandle);
            StringEntity entity = new StringEntity(requestObject.toString());
            SecSignIDRESTResponse response = SecSignIDServerRESTConnector.getPostResponse("/rest/v2/FIDO/Authenticate/Finish", (HttpEntity)entity, null);
            if (response.getStatusLine().getStatusCode() == 200) {
                return;
            }
            throw SecSignIDServerRESTConnector.getExceptionForStatusCode(response.getStatusLine().getStatusCode());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("JSONException: " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("UnsupportedEncodingException: " + e.getMessage());
        }
    }

    private static UsernamePasswordCredentials getHttpBasicAuthCredentials() {
        String[] pinAccount = SecSignIDCommonStaticAccessor.getPinAccount();
        return new UsernamePasswordCredentials(pinAccount[0], pinAccount[1]);
    }

    private static SecSignIDRESTResponse getGetResponse(String endpointUrl, UsernamePasswordCredentials credentials) throws SecSignIDRESTException {
        try {
            HttpResponse response = null;
            try {
                response = SecSignIDServerRESTConnector.executeGet(endpointUrl, credentials);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("Cannot reach ID server.");
            }
            catch (AuthenticationException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("REST AuthenticationException: " + e.getMessage());
            }
            StatusLine status = response.getStatusLine();
            String content = null;
            try {
                content = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("REST IOException: " + e.getMessage());
            }
            logger.debug(endpointUrl + " [" + status.getStatusCode() + "] " + String.valueOf(content));
            return SecSignIDRESTResponse.createSuccessResponse(status, content);
        }
        catch (SecSignIDRESTException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("REST Exception: " + e.getMessage());
        }
    }

    private static SecSignIDRESTResponse getPostResponse(String endpointUrl, HttpEntity entity, UsernamePasswordCredentials credentials) throws SecSignIDRESTException {
        try {
            HttpResponse response = null;
            try {
                response = SecSignIDServerRESTConnector.executePost(endpointUrl, entity, credentials);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("Cannot reach ID server.");
            }
            catch (AuthenticationException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("REST AuthenticationException: " + e.getMessage());
            }
            StatusLine status = response.getStatusLine();
            String content = null;
            try {
                content = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("REST IOException: " + e.getMessage());
            }
            logger.debug(endpointUrl + " [" + status.getStatusCode() + "] " + String.valueOf(content));
            return SecSignIDRESTResponse.createSuccessResponse(status, content);
        }
        catch (SecSignIDRESTException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("REST Exception: " + e.getMessage());
        }
    }

    private static SecSignIDRESTResponse getDeleteResponse(String endpointUrl, UsernamePasswordCredentials credentials) throws SecSignIDRESTException {
        try {
            HttpResponse response = null;
            try {
                response = SecSignIDServerRESTConnector.executeDelete(endpointUrl, credentials);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("Cannot reach ID server.");
            }
            catch (AuthenticationException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("REST AuthenticationException: " + e.getMessage());
            }
            StatusLine status = response.getStatusLine();
            String content = null;
            try {
                content = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new SecSignIDRESTException("REST IOException: " + e.getMessage());
            }
            logger.debug(endpointUrl + " [" + status.getStatusCode() + "] " + String.valueOf(content));
            return SecSignIDRESTResponse.createSuccessResponse(status, content);
        }
        catch (SecSignIDRESTException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecSignIDRESTException("REST Exception: " + e.getMessage());
        }
    }

    private static HttpGet createHttpGet(String serverUrl, String endpointUrl, UsernamePasswordCredentials credentials) throws AuthenticationException {
        HttpGet httpGet = new HttpGet(serverUrl + endpointUrl);
        SecSignIDServerRESTConnector.addPluginUserAgentHeader((HttpRequest)httpGet);
        SecSignIDServerRESTConnector.addRequiredHeadersToRequest((HttpRequest)httpGet, credentials);
        return httpGet;
    }

    private static HttpPost createHttpPost(String serverUrl, String endpointUrl, UsernamePasswordCredentials credentials) throws AuthenticationException {
        HttpPost httpPost = new HttpPost(serverUrl + endpointUrl);
        SecSignIDServerRESTConnector.addPluginUserAgentHeader((HttpRequest)httpPost);
        SecSignIDServerRESTConnector.addRequiredHeadersToRequest((HttpRequest)httpPost, credentials);
        return httpPost;
    }

    private static HttpDelete createHttpDelete(String serverUrl, String endpointUrl, UsernamePasswordCredentials credentials) throws AuthenticationException {
        HttpDelete httpDelete = new HttpDelete(serverUrl + endpointUrl);
        SecSignIDServerRESTConnector.addPluginUserAgentHeader((HttpRequest)httpDelete);
        SecSignIDServerRESTConnector.addRequiredHeadersToRequest((HttpRequest)httpDelete, credentials);
        return httpDelete;
    }

    private static void addRequiredHeadersToRequest(HttpRequest request, UsernamePasswordCredentials credentials) throws AuthenticationException {
        Header basicAuthHeader = credentials == null ? new BasicScheme(StandardCharsets.UTF_8).authenticate((Credentials)SecSignIDServerRESTConnector.getHttpBasicAuthCredentials(), request, null) : new BasicScheme(StandardCharsets.UTF_8).authenticate((Credentials)credentials, request, null);
        request.addHeader(basicAuthHeader);
        request.addHeader("Content-type", "application/json");
    }

    private static HttpResponse executeGet(String endpointUrl, UsernamePasswordCredentials credentials) throws IOException, AuthenticationException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().build();
        String serverUrl = SecSignIDCommonStaticAccessor.getSecSignIdServerUrl();
        try {
            return SecSignIDServerRESTConnector.executeGetForServer((HttpClient)httpClient, serverUrl, endpointUrl, credentials);
        }
        catch (IOException e) {
            logger.error("Cannot reach server with URL '" + serverUrl + "'.");
            logger.error(e.getMessage(), (Throwable)e);
            if (SecSignIDCommonStaticAccessor.getUseFallback()) {
                throw e;
            }
            String fallbackServerUrl = SecSignIDCommonStaticAccessor.getFallbackSecSignIdServerUrl();
            return SecSignIDServerRESTConnector.executeGetForServer((HttpClient)httpClient, fallbackServerUrl, endpointUrl, credentials);
        }
    }

    private static HttpResponse executePost(String endpointUrl, HttpEntity entity, UsernamePasswordCredentials credentials) throws IOException, AuthenticationException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().build();
        String serverUrl = SecSignIDCommonStaticAccessor.getSecSignIdServerUrl();
        try {
            return SecSignIDServerRESTConnector.executePostForServer((HttpClient)httpClient, serverUrl, endpointUrl, entity, credentials);
        }
        catch (IOException e) {
            logger.error("Cannot reach server with URL '" + serverUrl + "'.");
            logger.error(e.getMessage(), (Throwable)e);
            if (SecSignIDCommonStaticAccessor.getUseFallback()) {
                throw e;
            }
            String fallbackServerUrl = SecSignIDCommonStaticAccessor.getFallbackSecSignIdServerUrl();
            return SecSignIDServerRESTConnector.executePostForServer((HttpClient)httpClient, fallbackServerUrl, endpointUrl, entity, credentials);
        }
    }

    private static HttpResponse executeDelete(String endpointUrl, UsernamePasswordCredentials credentials) throws IOException, AuthenticationException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().build();
        String serverUrl = SecSignIDCommonStaticAccessor.getSecSignIdServerUrl();
        try {
            return SecSignIDServerRESTConnector.executeDeleteForServer((HttpClient)httpClient, serverUrl, endpointUrl, credentials);
        }
        catch (IOException e) {
            logger.error("Cannot reach server with URL '" + serverUrl + "'.");
            logger.error(e.getMessage(), (Throwable)e);
            if (SecSignIDCommonStaticAccessor.getUseFallback()) {
                throw e;
            }
            String fallbackServerUrl = SecSignIDCommonStaticAccessor.getFallbackSecSignIdServerUrl();
            return SecSignIDServerRESTConnector.executeDeleteForServer((HttpClient)httpClient, fallbackServerUrl, endpointUrl, credentials);
        }
    }

    private static HttpResponse executeGetForServer(HttpClient httpClient, String serverUrl, String endpointUrl, UsernamePasswordCredentials credentials) throws IOException, AuthenticationException {
        HttpGet httpGet = SecSignIDServerRESTConnector.createHttpGet(serverUrl, endpointUrl, credentials);
        logger.debug("Call: " + httpGet.getMethod() + " on " + httpGet.getURI().toString());
        return httpClient.execute((HttpUriRequest)httpGet);
    }

    private static HttpResponse executePostForServer(HttpClient httpClient, String serverUrl, String endpointUrl, HttpEntity entity, UsernamePasswordCredentials credentials) throws IOException, AuthenticationException {
        HttpPost httpPost = SecSignIDServerRESTConnector.createHttpPost(serverUrl, endpointUrl, credentials);
        httpPost.setEntity(entity);
        logger.debug("Call: " + httpPost.getMethod() + " on " + httpPost.getURI().toString());
        return httpClient.execute((HttpUriRequest)httpPost);
    }

    private static HttpResponse executeDeleteForServer(HttpClient httpClient, String serverUrl, String endpointUrl, UsernamePasswordCredentials credentials) throws IOException, AuthenticationException {
        HttpDelete httpDelete = SecSignIDServerRESTConnector.createHttpDelete(serverUrl, endpointUrl, credentials);
        logger.debug("Call: " + httpDelete.getMethod() + " on " + httpDelete.getURI().toString());
        return httpClient.execute((HttpUriRequest)httpDelete);
    }

    private static SecSignIDRESTException getExceptionForStatusCode(int statusCode) {
        if (statusCode == 404) {
            return new SecSignIDRESTException(i18nResolver.getText("secsignid.messages.error.rest.not.found"));
        }
        if (statusCode == 403) {
            return new SecSignIDRESTException(i18nResolver.getText("secsignid.messages.error.rest.unauthorized"));
        }
        if (statusCode == 400) {
            return new SecSignIDRESTException(i18nResolver.getText("secsignid.messages.error.rest.bad"));
        }
        return new SecSignIDRESTException(i18nResolver.getText("secsignid.messages.error.rest.error"));
    }

    private static String getTopDomainFromURI(URI uri) {
        return new SecSignIDPublicSuffixInterpreter().getRegisteredDomain(uri);
    }

    private static void addPluginUserAgentHeader(HttpRequest httpRequest) {
        httpRequest.addHeader("User-Agent", "SecSign ID Atlassian " + dataAccessor.getApplication() + " Plugin/" + dataAccessor.getVersion());
    }
}

