/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.jobs;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import com.secsign.atlassian.common.rest.SecSignIDServerRESTConnector;

public class SecSignIDTelemetryJobRunner
implements JobRunner {
    public static final String KEY = "com.secsign.atlassian.common.jobs.telemetry";
    private final SecSignIDDataAccessor dataAccessor;

    public SecSignIDTelemetryJobRunner(SecSignIDDataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        if (!(SecSignIDCommonStaticAccessor.isUsingCloudServer() && SecSignIDCommonStaticAccessor.hasPluginPinAccount() && SecSignIDCommonStaticAccessor.isTelemetryEnabled())) {
            return JobRunnerResponse.aborted((String)"Telemetry not enabled.");
        }
        String pluginName = "SecSign ID Atlassian " + this.dataAccessor.getApplication() + " Plugin " + this.dataAccessor.getVersion();
        try {
            SecSignIDServerRESTConnector.updatePluginRegistration(null, null, pluginName, null);
        }
        catch (SecSignIDRESTException e) {
            return JobRunnerResponse.failed((Throwable)e);
        }
        return JobRunnerResponse.success();
    }
}

