/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.data;

import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;

public class SecSignID2FASettings {
    private Integer pwdAllowed;
    private Integer passwordlessAllowed;
    private Integer twoStepAllowed;
    private Integer mailOtpAllowed;
    private Integer totpAllowed;
    private Integer fidoAllowed;

    public SecSignID2FASettings() {
        this.pwdAllowed = SecSignIDCommonConstants.AuthIsAllowed;
        this.passwordlessAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
        this.twoStepAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
        this.mailOtpAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
        this.totpAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
        this.fidoAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
    }

    public SecSignID2FASettings(String allSettings) {
        this.pwdAllowed = Character.getNumericValue(allSettings.charAt(0)) == SecSignIDCommonConstants.AuthIsAllowed ? SecSignIDCommonConstants.AuthIsAllowed : SecSignIDCommonConstants.AuthIsNotAllowed;
        this.passwordlessAllowed = Character.getNumericValue(allSettings.charAt(1)) == SecSignIDCommonConstants.AuthIsAllowed && SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled() ? SecSignIDCommonConstants.AuthIsAllowed : SecSignIDCommonConstants.AuthIsNotAllowed;
        this.twoStepAllowed = Character.getNumericValue(allSettings.charAt(2)) == SecSignIDCommonConstants.AuthIsAllowed && SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled() ? SecSignIDCommonConstants.AuthIsAllowed : SecSignIDCommonConstants.AuthIsNotAllowed;
        this.mailOtpAllowed = Character.getNumericValue(allSettings.charAt(3)) == SecSignIDCommonConstants.AuthIsAllowed && SecSignIDCommonStaticAccessor.getMailotpAuthEnabled() ? SecSignIDCommonConstants.AuthIsAllowed : SecSignIDCommonConstants.AuthIsNotAllowed;
        this.totpAllowed = Character.getNumericValue(allSettings.charAt(4)) == SecSignIDCommonConstants.AuthIsAllowed && SecSignIDCommonStaticAccessor.getTotpAuthEnabled() ? SecSignIDCommonConstants.AuthIsAllowed : SecSignIDCommonConstants.AuthIsNotAllowed;
        this.fidoAllowed = allSettings.length() > 5 ? (Character.getNumericValue(allSettings.charAt(5)) == SecSignIDCommonConstants.AuthIsAllowed ? SecSignIDCommonConstants.AuthIsAllowed : SecSignIDCommonConstants.AuthIsNotAllowed) : SecSignIDCommonConstants.AuthIsNotAllowed;
    }

    public Integer getPwdAllowed() {
        return this.pwdAllowed;
    }

    public void setPwdAllowed(Integer pwdAllowed) {
        this.pwdAllowed = pwdAllowed;
    }

    public Integer getPasswordlessAllowed() {
        return this.passwordlessAllowed;
    }

    public void setPasswordlessAllowed(Integer passwordlessAllowed) {
        this.passwordlessAllowed = passwordlessAllowed;
        if (passwordlessAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled()) {
            this.pwdAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
        }
    }

    public Integer getTwoStepAllowed() {
        return this.twoStepAllowed;
    }

    public void setTwoStepAllowed(Integer twoStepAllowed) {
        this.twoStepAllowed = twoStepAllowed;
        if (twoStepAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled()) {
            this.pwdAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
        }
    }

    public Integer getMailOtpAllowed() {
        return this.mailOtpAllowed;
    }

    public void setMailOtpAllowed(Integer mailOtpAllowed) {
        this.mailOtpAllowed = mailOtpAllowed;
        if (mailOtpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getMailotpAuthEnabled()) {
            this.pwdAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
        }
    }

    public Integer getTotpAllowed() {
        return this.totpAllowed;
    }

    public void setTotpAllowed(Integer totpAllowed) {
        this.totpAllowed = totpAllowed;
        if (totpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getTotpAuthEnabled()) {
            this.pwdAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
        }
    }

    public Integer getFidoAllowed() {
        return this.fidoAllowed;
    }

    public void setFidoAllowed(Integer fidoAllowed) {
        this.fidoAllowed = fidoAllowed;
        if (fidoAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getFidoAuthEnabled()) {
            this.pwdAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
        }
    }

    public SecSignID2FASettings changeForGroupMapping(SecSignID2FASettings setting) {
        if (setting.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled()) {
            this.setPwdAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
            this.setPasswordlessAllowed(SecSignIDCommonConstants.AuthIsAllowed);
        }
        if (setting.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled()) {
            this.setPwdAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
            this.setTwoStepAllowed(SecSignIDCommonConstants.AuthIsAllowed);
        }
        if (setting.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getMailotpAuthEnabled()) {
            this.setPwdAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
            this.setMailOtpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
        }
        if (setting.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getTotpAuthEnabled()) {
            this.setPwdAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
            this.setTotpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
        }
        if (setting.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getFidoAuthEnabled()) {
            this.setPwdAllowed(SecSignIDCommonConstants.AuthIsNotAllowed);
            this.setFidoAllowed(SecSignIDCommonConstants.AuthIsAllowed);
        }
        return this;
    }

    public String toString() {
        return "" + this.pwdAllowed + this.passwordlessAllowed + this.twoStepAllowed + this.mailOtpAllowed + this.totpAllowed + this.fidoAllowed;
    }

    public String getActivatedAsString() {
        String result = "";
        boolean alreadyAdded = false;
        if (this.twoStepAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled()) {
            if (alreadyAdded) {
                result = result + ", " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.twoStepAuth.name.short") + " ";
            } else {
                result = result + " " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.twoStepAuth.name.short") + " ";
                alreadyAdded = true;
            }
        }
        if (this.fidoAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getFidoAuthEnabled()) {
            if (alreadyAdded) {
                result = result + ", " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.fido.name.short") + " ";
            } else {
                result = result + " " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.fido.name.short") + " ";
                alreadyAdded = true;
            }
        }
        if (this.totpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getTotpAuthEnabled()) {
            if (alreadyAdded) {
                result = result + ", " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.totp.name.short") + " ";
            } else {
                result = result + " " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.totp.name.short") + " ";
                alreadyAdded = true;
            }
        }
        if (this.mailOtpAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getMailotpAuthEnabled()) {
            if (alreadyAdded) {
                result = result + ", " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.mailotp.name.short") + " ";
            } else {
                result = result + " " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.mailotp.name.short") + " ";
                alreadyAdded = true;
            }
        }
        if (this.passwordlessAllowed.equals(SecSignIDCommonConstants.AuthIsAllowed) && SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled()) {
            if (alreadyAdded) {
                result = result + ", " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.passwordlesAuth.name.short") + " ";
            } else {
                result = result + " " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.options.passwordlesAuth.name.short") + " ";
                alreadyAdded = true;
            }
        }
        return result;
    }
}

