/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.ao;

import com.atlassian.sal.api.transaction.TransactionCallback;
import com.secsign.atlassian.common.ao.SecSignIDAOWrapper;
import com.secsign.atlassian.common.ao.SecSignIDSession;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class SecSignIDSessionStorage {
    public long getLastAccessTime(final String id) {
        Long lastAccessTime = (Long)SecSignIDAOWrapper.getActiveObjects().executeInTransaction((TransactionCallback)new TransactionCallback<Long>(){

            public Long doInTransaction() {
                SecSignIDSession session = (SecSignIDSession)SecSignIDAOWrapper.getActiveObjects().get(SecSignIDSession.class, (Object)id);
                if (session == null) {
                    session = (SecSignIDSession)SecSignIDAOWrapper.getActiveObjects().create(SecSignIDSession.class, new DBParam[]{new DBParam("ID", (Object)id), new DBParam("LAST_ACCESS_TIME", (Object)System.currentTimeMillis())});
                }
                return session.getLastAccessTime();
            }
        });
        return lastAccessTime;
    }

    public void setLastAccessTime(final String id, final long lastAccessTime) {
        SecSignIDAOWrapper.getActiveObjects().executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                SecSignIDSession session = (SecSignIDSession)SecSignIDAOWrapper.getActiveObjects().get(SecSignIDSession.class, (Object)id);
                if (session != null) {
                    session.setLastAccessTime(lastAccessTime);
                    session.save();
                } else {
                    SecSignIDAOWrapper.getActiveObjects().create(SecSignIDSession.class, new DBParam[]{new DBParam("ID", (Object)id), new DBParam("LAST_ACCESS_TIME", (Object)lastAccessTime)});
                }
                return null;
            }
        });
    }

    public void invalidate(final String id) {
        SecSignIDAOWrapper.getActiveObjects().executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                SecSignIDSession session = (SecSignIDSession)SecSignIDAOWrapper.getActiveObjects().get(SecSignIDSession.class, (Object)id);
                if (session != null) {
                    SecSignIDAOWrapper.getActiveObjects().delete(new RawEntity[]{session});
                }
                return null;
            }
        });
    }

    public void invalidateInactive(long inactiveDuration) {
        final long inactiveTime = System.currentTimeMillis() - inactiveDuration;
        SecSignIDAOWrapper.getActiveObjects().executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                RawEntity[] inactiveSessions = (SecSignIDSession[])SecSignIDAOWrapper.getActiveObjects().find(SecSignIDSession.class, "LAST_ACCESS_TIME < ?", new Object[]{inactiveTime});
                SecSignIDAOWrapper.getActiveObjects().delete(inactiveSessions);
                return null;
            }
        });
    }
}

