/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.accessor;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.service.client.CrowdClient;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.accessor.directories.CrowdClientDirectoryWrapper;
import com.secsign.atlassian.common.accessor.directories.DirectoryWrapper;
import com.secsign.atlassian.common.accessor.directories.InternalDirectoryWrapper;
import com.secsign.atlassian.common.data.EmbeddedCrowdGroup;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.data.SecSignIDTrustDeviceToken;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDMappingExtractor {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDMappingExtractor.class);

    public static String getSecSignIdStringForApplicationUserKey(String userKey, long dirid) throws OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException {
        User user = null;
        try {
            user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirid);
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on getUserForKey");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return null;
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getUserForKey");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return null;
        }
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            String secsignid = directoryWrapper.getUserAttribute(userKey, "secsignid");
            return secsignid;
        }
        return null;
    }

    public static void saveSecSignIDForUserKey(String userKey, long dirID, String secSignID) throws OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, DirectoryPermissionException, UserNotFoundException, DirectoryNotFoundException {
        User user = null;
        try {
            user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirID);
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on getUserForKey");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getUserForKey");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            return;
        }
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            directoryWrapper.storeUserAttributeForKey(userKey, "secsignid", secSignID);
        }
    }

    public static Map<String, String[]> getSecSignIDMappingsForUsers(List<User> _userInGroup) throws OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        logger.debug("getMappingsCrowd");
        for (User user : _userInGroup) {
            String userKey = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(user.getName());
            String mappingKey = userKey + ":" + user.getDirectoryId();
            String secsignid = SecSignIDMappingExtractor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
            String[] secSignArray = SecSignIDMappingUtils.getArrayOfSecSignIds(secsignid);
            result.put(mappingKey, secSignArray);
        }
        return result;
    }

    public static String getMethodToActivate(String userKey, long dirId) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirId);
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            String methodToActivate = directoryWrapper.getUserAttribute(userKey, "activemethod");
            return methodToActivate;
        }
        return null;
    }

    public static void saveMethodToActivate(String userKey, long dirId, String method) throws UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirId);
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            directoryWrapper.storeUserAttributeForKey(userKey, "activemethod", method);
        }
    }

    public static String getLastMethodUsed(String userKey, long dirId) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirId);
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            String value = directoryWrapper.getUserAttribute(userKey, "lastmethodused");
            return value;
        }
        return null;
    }

    public static void saveLastMethodUsed(String userKey, long dirId, String method) throws UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirId);
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            directoryWrapper.storeUserAttributeForKey(userKey, "lastmethodused", method);
        }
    }

    public static SecSignIDTrustDeviceToken createTrustDeviceToken(String userKey, long dirId, String userAgent) throws UserNotFoundException, OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryPermissionException {
        String tokenValue = SecSignIDMappingExtractor.generateRandomTokenAsBase64();
        long creation = System.currentTimeMillis();
        SecSignIDTrustDeviceToken token = new SecSignIDTrustDeviceToken(tokenValue, userAgent, creation);
        User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirId);
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            Set<String> tokenPairs = directoryWrapper.getUserAttributeSet(userKey, "trustdevicetoken");
            tokenPairs = tokenPairs == null ? new HashSet<String>() : new HashSet<String>(tokenPairs);
            tokenPairs.add(token.getSerializableString());
            directoryWrapper.storeUserAttributeSetForKey(userKey, "trustdevicetoken", tokenPairs);
        }
        return token;
    }

    public static void removeTrustDeviceToken(String userKey, long dirId, SecSignIDTrustDeviceToken token) throws UserNotFoundException, OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryPermissionException {
        User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirId);
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            Set<String> tokenPairs = directoryWrapper.getUserAttributeSet(userKey, "trustdevicetoken");
            if (tokenPairs == null) {
                return;
            }
            tokenPairs = new HashSet<String>(tokenPairs);
            for (String tokenPair : tokenPairs) {
                SecSignIDTrustDeviceToken trustDeviceToken = SecSignIDTrustDeviceToken.createFromSerializableString(tokenPair);
                if (!token.equals(trustDeviceToken)) continue;
                tokenPairs.remove(tokenPair);
                break;
            }
            directoryWrapper.storeUserAttributeSetForKey(userKey, "trustdevicetoken", tokenPairs);
        }
    }

    public static SecSignIDTrustDeviceToken getTrustDeviceToken(String userKey, long dirId, String token, String userAgent) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException {
        User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirId);
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            Set<String> tokenPairs = directoryWrapper.getUserAttributeSet(userKey, "trustdevicetoken");
            if (tokenPairs == null) {
                return null;
            }
            tokenPairs = new HashSet<String>(tokenPairs);
            SecSignIDMappingExtractor.removeExpiredTrustDeviceTokens(userKey, dirId, tokenPairs);
            for (String tokenPair : tokenPairs) {
                SecSignIDTrustDeviceToken trustDeviceToken = SecSignIDTrustDeviceToken.createFromSerializableString(tokenPair);
                if (trustDeviceToken == null || !trustDeviceToken.getToken().equals(token) || !trustDeviceToken.getUserAgent().equals(userAgent)) continue;
                return trustDeviceToken;
            }
        }
        return null;
    }

    public static List<SecSignIDTrustDeviceToken> getAllTrustDeviceTokens(String userKey, long dirId) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException {
        User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirId);
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            Set<String> tokenPairs = directoryWrapper.getUserAttributeSet(userKey, "trustdevicetoken");
            if (tokenPairs == null) {
                return Collections.emptyList();
            }
            tokenPairs = new HashSet<String>(tokenPairs);
            SecSignIDMappingExtractor.removeExpiredTrustDeviceTokens(userKey, dirId, tokenPairs);
            ArrayList<SecSignIDTrustDeviceToken> tokens = new ArrayList<SecSignIDTrustDeviceToken>();
            for (String tokenPair : tokenPairs) {
                SecSignIDTrustDeviceToken trustDeviceToken = SecSignIDTrustDeviceToken.createFromSerializableString(tokenPair);
                if (trustDeviceToken == null) continue;
                tokens.add(trustDeviceToken);
            }
            return tokens;
        }
        return Collections.emptyList();
    }

    public static void removeAllTrustDeviceTokens(String userKey, long dirId) throws UserNotFoundException, OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, DirectoryPermissionException, ApplicationPermissionException {
        User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirId);
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            directoryWrapper.removeUserAttribute(userKey, "trustdevicetoken");
        }
    }

    private static void removeExpiredTrustDeviceTokens(String userKey, long dirId, Set<String> tokenPairs) throws UserNotFoundException, InvalidAuthenticationException, DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException, ApplicationPermissionException {
        long expirationDuration = (long)SecSignIDCommonStaticAccessor.getTrustDeviceDuration() * 24L * 60L * 60L * 1000L;
        long now = System.currentTimeMillis();
        Iterator<String> iterator = tokenPairs.iterator();
        while (iterator.hasNext()) {
            long expiration;
            String tokenPair = iterator.next();
            SecSignIDTrustDeviceToken trustDeviceToken = SecSignIDTrustDeviceToken.createFromSerializableString(tokenPair);
            if (trustDeviceToken == null || now < (expiration = trustDeviceToken.getCreation() + expirationDuration)) continue;
            iterator.remove();
        }
        User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirId);
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            directoryWrapper.storeUserAttributeSetForKey(userKey, "trustdevicetoken", tokenPairs);
        }
    }

    public static void save2FAGroupMappings(HashMap<String, SecSignID2FASettings> groupMappings) throws GroupNotFoundException, OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, DirectoryPermissionException, DirectoryNotFoundException {
        for (Map.Entry<String, SecSignID2FASettings> entry : groupMappings.entrySet()) {
            String fullKey = entry.getKey();
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(fullKey);
            String groupName = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(fullKey);
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(dirid);
            if (directoryWrapper == null) continue;
            directoryWrapper.storeGroupAttributeForKey(groupName, "secsign.twofa", entry.getValue().toString());
        }
    }

    public static void save2FAActivatedSettingsForUserKey(String userKey, long directoryID, SecSignID2FAActivatedSettings settings) throws DirectoryPermissionException, OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, UserNotFoundException, DirectoryNotFoundException {
        User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, directoryID);
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            directoryWrapper.storeUserAttributeForKey(userKey, "secsign.activated", settings.toString());
        }
    }

    public static Map<String, SecSignID2FASettings> get2FAGroupMappingsForGroup(String groupname, long dirid) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(dirid);
        HashMap<String, SecSignID2FASettings> result = new HashMap<String, SecSignID2FASettings>();
        if (directoryWrapper == null) {
            return result;
        }
        String settings = directoryWrapper.getGroupAttribute(groupname, "secsign.twofa");
        if (settings != null) {
            result.put(groupname.toLowerCase().replace(" ", "___") + ";" + dirid, new SecSignID2FASettings(settings));
            return result;
        }
        result.put(groupname.toLowerCase().replace(" ", "___") + ";" + dirid, new SecSignID2FASettings());
        return result;
    }

    public static SecSignID2FAActivatedSettings get2FAActivatedSettingsFromUserKey(String userKey, long directoryID) throws UserNotFoundException, ApplicationPermissionException, OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException {
        User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, directoryID);
        if (user != null) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            String settings = directoryWrapper.getUserAttribute(userKey, "secsign.activated");
            if (settings != null) {
                return new SecSignID2FAActivatedSettings(settings);
            }
            return new SecSignID2FAActivatedSettings();
        }
        return new SecSignID2FAActivatedSettings();
    }

    public static void deleteAllUser2FASettings() throws DirectoryPermissionException, OperationFailedException, UserNotFoundException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        List<Directory> dirs = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getAllDirectories();
        for (Directory dir : dirs) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(dir.getId());
            directoryWrapper.deleteAllUser2FASettings();
        }
    }

    public static void deleteAllGroup2FASettings() throws OperationFailedException, DirectoryPermissionException, GroupNotFoundException, InvalidAuthenticationException, DirectoryNotFoundException, ApplicationPermissionException {
        List<Directory> dirs = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getAllDirectories();
        for (Directory dir : dirs) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(dir.getId());
            directoryWrapper.deleteAllGroup2FASettings();
        }
    }

    public static void deleteLocalMappings() throws DirectoryPermissionException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        logger.info("deleteLocalMappings called");
        List<Directory> allDir = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getAllDirectories();
        for (Directory dir : allDir) {
            logger.debug("Delete Local Mappings for dir: " + dir.getName() + "(" + dir.getId() + ")");
            try {
                if (dir.getType().equals((Object)DirectoryType.INTERNAL)) {
                    DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(dir.getId());
                    directoryWrapper.deleteAllUserAttributesWithKey("secsignid");
                    directoryWrapper.deleteAllUserAttributesWithKey("qruser");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrurl");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart1");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart2");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart3");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart4");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart5");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart6");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart7");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart8");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart9");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart10");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart11");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart12");
                    directoryWrapper.deleteAllUserAttributesWithKey("qrpart13");
                    directoryWrapper.deleteAllUserAttributesWithKey("lastmethodused");
                    directoryWrapper.deleteAllUserAttributesWithKey("usedtotpbefore");
                    directoryWrapper.deleteAllUserAttributesWithKey("mailotpactive");
                    directoryWrapper.deleteAllUserAttributesWithKey("logintoken");
                    directoryWrapper.deleteAllUserAttributesWithKey("activemethod");
                    directoryWrapper.deleteAllUserAttributesWithKey("twostepallowed");
                    directoryWrapper.deleteAllUserAttributesWithKey("twosteptoken");
                    logger.debug("All users done");
                }
                logger.debug("Directory is not local: " + dir.getName() + "(" + dir.getId() + ")");
            }
            catch (UserNotFoundException e) {
                logger.error("UserNotFoundException on deleteLocalMappings");
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on deleteLocalMappings");
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String getMappingKeyForSecSignId(String secSignId) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        List<Directory> dirs = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getAllDirectories();
        for (Directory directory : dirs) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(directory.getId());
            List<String> mappingKeys = directoryWrapper.findUsersWithAttributeMatchesValue("secsignid", secSignId);
            if (mappingKeys.size() <= 0) continue;
            return mappingKeys.get(0);
        }
        return null;
    }

    private static String getMappingKeyForSecSignIdNotSame(String secSignId, long dirid, String userKey) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        List<Directory> dirs = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getAllDirectories();
        for (Directory directory : dirs) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(directory.getId());
            List<String> mappingKeys = directoryWrapper.findUsersWithAttributeMatchesValue("secsignid", secSignId);
            for (String mappingKey : mappingKeys) {
                if (mappingKey.equals(userKey + ":" + dirid)) continue;
                return mappingKey;
            }
        }
        return null;
    }

    public static List<User> getAllUsers() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        ArrayList<User> allUsers = new ArrayList<User>();
        List<Directory> dirs = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getAllDirectories();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(0).returningAtMost(-1);
        for (Directory directory : dirs) {
            try {
                allUsers.addAll(SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().searchUsers(directory.getId(), (EntityQuery<User>)query));
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on getAllUsers");
            }
        }
        return allUsers;
    }

    public static Object[] checkDuplicates(String secsignid, long dirid, String userKey) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        logger.debug("checkDuplicates");
        Object[] result = new Object[3];
        String duplicateUserMappingKey = SecSignIDMappingExtractor.getMappingKeyForSecSignIdNotSame(secsignid, dirid, userKey);
        if (duplicateUserMappingKey != null && !duplicateUserMappingKey.equals("")) {
            int index = duplicateUserMappingKey.indexOf(":");
            String diridString = duplicateUserMappingKey.substring(index + 1);
            String userKeyFound = duplicateUserMappingKey.substring(0, index);
            result[0] = Boolean.TRUE;
            result[1] = diridString;
            result[2] = userKeyFound;
            return result;
        }
        result[0] = Boolean.FALSE;
        result[1] = null;
        return result;
    }

    public static Object[] checkDuplicates(String secsignid) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException {
        logger.debug("checkDuplicates");
        Object[] result = new Object[3];
        String duplicateUserMappingKey = SecSignIDMappingExtractor.getMappingKeyForSecSignId(secsignid);
        if (duplicateUserMappingKey != null && !duplicateUserMappingKey.equals("")) {
            int index = duplicateUserMappingKey.indexOf(":");
            String diridString = duplicateUserMappingKey.substring(index + 1);
            String userKey = duplicateUserMappingKey.substring(0, index);
            result[0] = Boolean.TRUE;
            result[1] = diridString;
            result[2] = userKey;
            return result;
        }
        result[0] = Boolean.FALSE;
        result[1] = null;
        return result;
    }

    private static String generateRandomTokenAsBase64() {
        byte[] token = new byte[32];
        SecureRandom random = new SecureRandom();
        random.nextBytes(token);
        return Base64.getEncoder().encodeToString(token);
    }

    public static void resetAllFIDO() throws ApplicationPermissionException, DirectoryNotFoundException, OperationFailedException, InvalidAuthenticationException {
        List<Directory> dirs = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getAllDirectories();
        for (Directory directory : dirs) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(directory.getId());
            List<String> users = directoryWrapper.getActivatedFIDOMappings();
            for (String mappingKey : users) {
                String userKey = SecSignIDMappingUtils.getUserKeyFromMappingKey(mappingKey);
                long dirid = SecSignIDMappingUtils.getDirIDFromMappingKey(mappingKey);
                try {
                    SecSignID2FAActivatedSettings activatedSettings = SecSignIDMappingExtractor.get2FAActivatedSettingsFromUserKey(userKey, dirid);
                    activatedSettings.setFidoActive(false);
                    SecSignIDMappingExtractor.save2FAActivatedSettingsForUserKey(userKey, dirid, activatedSettings);
                }
                catch (ApplicationPermissionException | InvalidAuthenticationException | UserNotFoundException | DirectoryPermissionException e) {
                    logger.error("Cannot reset FIDO for user " + userKey + " (" + dirid + ")");
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    private static DirectoryType getDirectoryType(Directory directory) {
        if (SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getApplication().equals("Crowd")) {
            return DirectoryType.INTERNAL;
        }
        return directory.getType();
    }

    private static DirectoryWrapper getDirectoryWrapperForDirectoryId(long directoryId) {
        Directory directory;
        try {
            directory = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getDirectory(directoryId);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            logger.error(e.getMessage(), e);
            return null;
        }
        DirectoryType type = SecSignIDMappingExtractor.getDirectoryType(directory);
        logger.debug("DirectoryType of directory " + directory.getName() + "(" + directory.getId() + ") is " + type);
        if (type.equals((Object)DirectoryType.CROWD)) {
            return new CrowdClientDirectoryWrapper(directory);
        }
        return new InternalDirectoryWrapper(directory);
    }

    public static HashMap<String, SecSignID2FASettings> getGroupMappingsWithOptions() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, SecSignID2FASettings> result = new HashMap<String, SecSignID2FASettings>();
        List<Directory> dirs = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getAllDirectories();
        for (Directory directory : dirs) {
            DirectoryWrapper directoryWrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(directory.getId());
            if (directoryWrapper == null) continue;
            try {
                result.putAll(directoryWrapper.getGroupMappingsWithOptions());
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on getGroupMappingsWithOptions");
            }
        }
        return result;
    }

    @Deprecated
    public static Map<String, Integer> getPwdAllowedMappingsForUsers(List<User> _userInGroup) throws OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        logger.debug("getMappingsCrowd");
        for (User user : _userInGroup) {
            DirectoryWrapper wrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(user.getDirectoryId());
            String pwdAllowed = wrapper.getUserAttribute(SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(user.getName()), "pwdallowed");
            if (SecSignIDMappingExtractor.isAttributeEmpty(pwdAllowed) || pwdAllowed.equals(SecSignIDCommonConstants.PasswordLoginIsAllowed.toString())) {
                logger.debug("Put in PwdMapping: " + user.getName().toLowerCase() + ":" + SecSignIDCommonConstants.PasswordLoginIsAllowed);
                result.put(user.getName() + ":" + user.getDirectoryId(), SecSignIDCommonConstants.PasswordLoginIsAllowed);
                continue;
            }
            logger.debug("Put in PwdMapping: " + user.getName().toLowerCase() + ":" + SecSignIDCommonConstants.PasswordLoginIsNotAllowed);
            result.put(user.getName() + ":" + user.getDirectoryId(), SecSignIDCommonConstants.PasswordLoginIsNotAllowed);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static HashMap<String, String> getPasswordlessMappingsForGroup(String groupName, long dirID) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        Directory dir;
        HashMap<String, String> result = new HashMap<String, String>();
        logger.debug("getGroupMappings");
        try {
            dir = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getDirectory(dirID);
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getMappings for group" + groupName);
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        DirectoryType directoryType = SecSignIDMappingExtractor.getDirectoryType(dir);
        if (directoryType.equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getCrowdClientForDir(dir);
            if (client != null) {
                GroupWithAttributes groupAttr;
                try {
                    logger.debug("Get group with attributes in Crowd for group: " + groupName);
                    try {
                        groupAttr = EmbeddedCrowdGroup.convertGroupToEmbedded(client.getGroupWithAttributes(groupName));
                    }
                    catch (OperationFailedException e) {
                        if (!e.getMessage().contains("timed out")) throw e;
                        groupAttr = EmbeddedCrowdGroup.convertGroupToEmbedded(client.getGroupWithAttributes(groupName));
                    }
                }
                catch (GroupNotFoundException e) {
                    logger.error("GroupNotFoundException on getGroupMappings for CrowdDirectory and group " + groupName);
                    logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
                if (groupAttr == null) return result;
                String pwdAllowed = groupAttr.getValue("passwordlessallowed");
                if (SecSignIDMappingExtractor.isAttributeEmpty(pwdAllowed) || pwdAllowed.equals("deactivate")) {
                    result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "deactivate");
                    return result;
                }
                if (pwdAllowed.equals("activate")) {
                    result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "activate");
                    return result;
                }
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "peruser");
                return result;
            }
            logger.debug("No CrowdClient created, so cannot get mapping for group: " + groupName);
            return null;
        }
        if (directoryType.equals((Object)DirectoryType.INTERNAL)) {
            GroupWithAttributes groupAttr;
            try {
                groupAttr = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().findGroupWithAttributesByName(dir.getId(), groupName);
            }
            catch (GroupNotFoundException e) {
                logger.error("GroupNotFoundException on getMappings for Internal Directory and group " + groupName);
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on getMappings for Internal Directory and group " + groupName);
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            if (groupAttr == null) return result;
            String pwdAllowed = groupAttr.getValue("passwordlessallowed");
            if (SecSignIDMappingExtractor.isAttributeEmpty(pwdAllowed) || pwdAllowed.equals("deactivate")) {
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "deactivate");
                return result;
            }
            if (pwdAllowed.equals("activate")) {
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "activate");
                return result;
            }
            result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "peruser");
            return result;
        }
        logger.debug("Directory is neither Internal nor Crowd for group " + groupName);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static HashMap<String, String> getTwoStepMappingsForGroup(String groupName, long dirID) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        Directory dir;
        HashMap<String, String> result = new HashMap<String, String>();
        logger.debug("getGroupMappings");
        try {
            dir = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getDirectory(dirID);
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getMappings for group" + groupName);
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        DirectoryType directoryType = SecSignIDMappingExtractor.getDirectoryType(dir);
        if (directoryType.equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getCrowdClientForDir(dir);
            if (client != null) {
                GroupWithAttributes groupAttr;
                try {
                    logger.debug("Get group with attributes in Crowd for group: " + groupName);
                    try {
                        groupAttr = EmbeddedCrowdGroup.convertGroupToEmbedded(client.getGroupWithAttributes(groupName));
                    }
                    catch (OperationFailedException e) {
                        if (!e.getMessage().contains("timed out")) throw e;
                        groupAttr = EmbeddedCrowdGroup.convertGroupToEmbedded(client.getGroupWithAttributes(groupName));
                    }
                }
                catch (GroupNotFoundException e) {
                    logger.error("GroupNotFoundException on getGroupMappings for CrowdDirectory and group " + groupName);
                    logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
                if (groupAttr == null) return result;
                String pwdAllowed = groupAttr.getValue("twostepallowed");
                if (SecSignIDMappingExtractor.isAttributeEmpty(pwdAllowed) || pwdAllowed.equals("deactivate")) {
                    result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "deactivate");
                    return result;
                }
                if (pwdAllowed.equals("activate")) {
                    result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "activate");
                    return result;
                }
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "peruser");
                return result;
            }
            logger.debug("No CrowdClient created, so cannot get mapping for group: " + groupName);
            return null;
        }
        if (directoryType.equals((Object)DirectoryType.INTERNAL)) {
            GroupWithAttributes groupAttr;
            try {
                groupAttr = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().findGroupWithAttributesByName(dir.getId(), groupName);
            }
            catch (GroupNotFoundException e) {
                logger.error("GroupNotFoundException on getMappings for Internal Directory and group " + groupName);
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on getMappings for Internal Directory and group " + groupName);
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            if (groupAttr == null) return result;
            String pwdAllowed = groupAttr.getValue("twostepallowed");
            if (SecSignIDMappingExtractor.isAttributeEmpty(pwdAllowed) || pwdAllowed.equals("deactivate")) {
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "deactivate");
                return result;
            }
            if (pwdAllowed.equals("activate")) {
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "activate");
                return result;
            }
            result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "peruser");
            return result;
        }
        logger.debug("Directory is neither Internal nor Crowd for group " + groupName);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static HashMap<String, String> getTOTPMappingsForGroup(String groupName, long dirID) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        Directory dir;
        HashMap<String, String> result = new HashMap<String, String>();
        logger.debug("getGroupMappings");
        try {
            dir = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getDirectory(dirID);
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getMappings for group" + groupName);
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        DirectoryType directoryType = SecSignIDMappingExtractor.getDirectoryType(dir);
        if (directoryType.equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getCrowdClientForDir(dir);
            if (client != null) {
                GroupWithAttributes groupAttr;
                try {
                    logger.debug("Get group with attributes in Crowd for group: " + groupName);
                    try {
                        groupAttr = EmbeddedCrowdGroup.convertGroupToEmbedded(client.getGroupWithAttributes(groupName));
                    }
                    catch (OperationFailedException e) {
                        if (!e.getMessage().contains("timed out")) throw e;
                        groupAttr = EmbeddedCrowdGroup.convertGroupToEmbedded(client.getGroupWithAttributes(groupName));
                    }
                }
                catch (GroupNotFoundException e) {
                    logger.error("GroupNotFoundException on getGroupMappings for CrowdDirectory and group " + groupName);
                    logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
                if (groupAttr == null) return result;
                String pwdAllowed = groupAttr.getValue("totpallowed");
                if (SecSignIDMappingExtractor.isAttributeEmpty(pwdAllowed) || pwdAllowed.equals("deactivate")) {
                    result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "deactivate");
                    return result;
                }
                if (pwdAllowed.equals("activate")) {
                    result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "activate");
                    return result;
                }
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "peruser");
                return result;
            }
            logger.debug("No CrowdClient created, so cannot get mapping for group: " + groupName);
            return null;
        }
        if (directoryType.equals((Object)DirectoryType.INTERNAL)) {
            GroupWithAttributes groupAttr;
            try {
                groupAttr = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().findGroupWithAttributesByName(dir.getId(), groupName);
            }
            catch (GroupNotFoundException e) {
                logger.error("GroupNotFoundException on getMappings for Internal Directory and group " + groupName);
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on getMappings for Internal Directory and group " + groupName);
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            if (groupAttr == null) return result;
            String pwdAllowed = groupAttr.getValue("totpallowed");
            if (SecSignIDMappingExtractor.isAttributeEmpty(pwdAllowed) || pwdAllowed.equals("deactivate")) {
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "deactivate");
                return result;
            }
            if (pwdAllowed.equals("activate")) {
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "activate");
                return result;
            }
            result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "peruser");
            return result;
        }
        logger.debug("Directory is neither Internal nor Crowd for group " + groupName);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static HashMap<String, String> getFIDOMappingsForGroup(String groupName, long dirID) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        Directory dir;
        HashMap<String, String> result = new HashMap<String, String>();
        logger.debug("getGroupMappings");
        try {
            dir = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getDirectory(dirID);
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getMappings for group" + groupName);
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        DirectoryType directoryType = SecSignIDMappingExtractor.getDirectoryType(dir);
        if (directoryType.equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getCrowdClientForDir(dir);
            if (client != null) {
                GroupWithAttributes groupAttr;
                try {
                    logger.debug("Get group with attributes in Crowd for group: " + groupName);
                    try {
                        groupAttr = EmbeddedCrowdGroup.convertGroupToEmbedded(client.getGroupWithAttributes(groupName));
                    }
                    catch (OperationFailedException e) {
                        if (!e.getMessage().contains("timed out")) throw e;
                        groupAttr = EmbeddedCrowdGroup.convertGroupToEmbedded(client.getGroupWithAttributes(groupName));
                    }
                }
                catch (GroupNotFoundException e) {
                    logger.error("GroupNotFoundException on getGroupMappings for CrowdDirectory and group " + groupName);
                    logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
                if (groupAttr == null) return result;
                String pwdAllowed = groupAttr.getValue("fidoallowed");
                if (SecSignIDMappingExtractor.isAttributeEmpty(pwdAllowed) || pwdAllowed.equals("deactivate")) {
                    result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "deactivate");
                    return result;
                }
                if (pwdAllowed.equals("activate")) {
                    result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "activate");
                    return result;
                }
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "peruser");
                return result;
            }
            logger.debug("No CrowdClient created, so cannot get mapping for group: " + groupName);
            return null;
        }
        if (directoryType.equals((Object)DirectoryType.INTERNAL)) {
            GroupWithAttributes groupAttr;
            try {
                groupAttr = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().findGroupWithAttributesByName(dir.getId(), groupName);
            }
            catch (GroupNotFoundException e) {
                logger.error("GroupNotFoundException on getMappings for Internal Directory and group " + groupName);
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on getMappings for Internal Directory and group " + groupName);
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            if (groupAttr == null) return result;
            String pwdAllowed = groupAttr.getValue("fidoallowed");
            if (SecSignIDMappingExtractor.isAttributeEmpty(pwdAllowed) || pwdAllowed.equals("deactivate")) {
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "deactivate");
                return result;
            }
            if (pwdAllowed.equals("activate")) {
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "activate");
                return result;
            }
            result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "peruser");
            return result;
        }
        logger.debug("Directory is neither Internal nor Crowd for group " + groupName);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static HashMap<String, String> getMailOTPMappingsForGroup(String groupName, long dirID) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        Directory dir;
        HashMap<String, String> result = new HashMap<String, String>();
        logger.debug("getGroupMappings");
        try {
            dir = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getDirectory(dirID);
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getMappings for group" + groupName);
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        DirectoryType directoryType = SecSignIDMappingExtractor.getDirectoryType(dir);
        if (directoryType.equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getCrowdClientForDir(dir);
            if (client != null) {
                GroupWithAttributes groupAttr;
                try {
                    logger.debug("Get group with attributes in Crowd for group: " + groupName);
                    try {
                        groupAttr = EmbeddedCrowdGroup.convertGroupToEmbedded(client.getGroupWithAttributes(groupName));
                    }
                    catch (OperationFailedException e) {
                        if (!e.getMessage().contains("timed out")) throw e;
                        groupAttr = EmbeddedCrowdGroup.convertGroupToEmbedded(client.getGroupWithAttributes(groupName));
                    }
                }
                catch (GroupNotFoundException e) {
                    logger.error("GroupNotFoundException on getGroupMappings for CrowdDirectory and group " + groupName);
                    logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
                if (groupAttr == null) return result;
                String pwdAllowed = groupAttr.getValue("mailotpallowed");
                if (SecSignIDMappingExtractor.isAttributeEmpty(pwdAllowed) || pwdAllowed.equals("deactivate")) {
                    result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "deactivate");
                    return result;
                }
                if (pwdAllowed.equals("activate")) {
                    result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "activate");
                    return result;
                }
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "peruser");
                return result;
            }
            logger.debug("No CrowdClient created, so cannot get mapping for group: " + groupName);
            return null;
        }
        if (directoryType.equals((Object)DirectoryType.INTERNAL)) {
            GroupWithAttributes groupAttr;
            try {
                groupAttr = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().findGroupWithAttributesByName(dir.getId(), groupName);
            }
            catch (GroupNotFoundException e) {
                logger.error("GroupNotFoundException on getMappings for Internal Directory and group " + groupName);
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on getMappings for Internal Directory and group " + groupName);
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            if (groupAttr == null) return result;
            String pwdAllowed = groupAttr.getValue("mailotpallowed");
            if (SecSignIDMappingExtractor.isAttributeEmpty(pwdAllowed) || pwdAllowed.equals("deactivate")) {
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "deactivate");
                return result;
            }
            if (pwdAllowed.equals("activate")) {
                result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "activate");
                return result;
            }
            result.put(groupAttr.getName().toLowerCase().replace(" ", "___") + ";" + dirID, "peruser");
            return result;
        }
        logger.debug("Directory is neither Internal nor Crowd for group " + groupName);
        return null;
    }

    @Deprecated
    public static boolean getTOTPActiveForUserKey(String userKey, long dirId) throws UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        return SecSignIDMappingExtractor.getAttributeBoolean(userKey, dirId, "usedtotpbefore");
    }

    @Deprecated
    public static boolean getFIDOActiveForUserKey(String userKey, long dirId) throws UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        return SecSignIDMappingExtractor.getAttributeBoolean(userKey, dirId, "fidoactive");
    }

    @Deprecated
    public static boolean getMailOTPActiveForUserKey(String userKey, long dirId) throws UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        return SecSignIDMappingExtractor.getAttributeBoolean(userKey, dirId, "mailotpactive");
    }

    @Deprecated
    public static boolean getSecSignIDActiveForUserKey(String userKey, long dirId) throws UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        return SecSignIDMappingExtractor.getAttributeBoolean(userKey, dirId, "secsign.secsignidactive");
    }

    @Deprecated
    public static void deleteAllOldGroup2FASettings() throws DirectoryPermissionException, OperationFailedException {
        try {
            List<Directory> dirs = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getAllDirectories();
            for (Directory dir : dirs) {
                if (dir.getType().equals((Object)DirectoryType.CROWD)) {
                    CrowdClient client = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getCrowdClientForDir(dir);
                    if (client == null) {
                        return;
                    }
                    try {
                        PropertyRestriction restriction = Restriction.on((Property)PropertyUtils.ofTypeString((String)"pwdallowed")).startingWith((Object)"");
                        List userlist = client.searchGroupNames((SearchRestriction)restriction, 0, -1);
                        for (String groupname : userlist) {
                            client.removeGroupAttributes(groupname, "pwdallowed");
                        }
                        restriction = Restriction.on((Property)PropertyUtils.ofTypeString((String)"passwordlessallowed")).startingWith((Object)"");
                        userlist = client.searchGroupNames((SearchRestriction)restriction, 0, -1);
                        for (String groupname : userlist) {
                            client.removeGroupAttributes(groupname, "passwordlessallowed");
                        }
                        restriction = Restriction.on((Property)PropertyUtils.ofTypeString((String)"twostepallowed")).startingWith((Object)"");
                        userlist = client.searchGroupNames((SearchRestriction)restriction, 0, -1);
                        for (String groupname : userlist) {
                            client.removeGroupAttributes(groupname, "twostepallowed");
                        }
                        restriction = Restriction.on((Property)PropertyUtils.ofTypeString((String)"mailotpallowed")).startingWith((Object)"");
                        userlist = client.searchGroupNames((SearchRestriction)restriction, 0, -1);
                        for (String groupname : userlist) {
                            client.removeGroupAttributes(groupname, "mailotpallowed");
                        }
                        restriction = Restriction.on((Property)PropertyUtils.ofTypeString((String)"totpallowed")).startingWith((Object)"");
                        userlist = client.searchGroupNames((SearchRestriction)restriction, 0, -1);
                        for (String groupname : userlist) {
                            client.removeGroupAttributes(groupname, "totpallowed");
                        }
                        restriction = Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign_pattern")).startingWith((Object)"");
                        userlist = client.searchGroupNames((SearchRestriction)restriction, 0, -1);
                        for (String groupname : userlist) {
                            client.removeGroupAttributes(groupname, "secsign_pattern");
                        }
                        continue;
                    }
                    catch (OperationFailedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (ApplicationPermissionException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (InvalidAuthenticationException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                }
                if (!dir.getType().equals((Object)DirectoryType.INTERNAL)) continue;
                EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"pwdallowed")).startingWith((Object)"")).startingAt(0).returningAtMost(-1);
                List<String> groups = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().searchGroups(dir.getId(), (EntityQuery<String>)query);
                for (String groupname : groups) {
                    SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().removeGroupAttributes(dir.getId(), groupname, "pwdallowed");
                }
                query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"passwordlessallowed")).startingWith((Object)"")).startingAt(0).returningAtMost(-1);
                groups = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().searchGroups(dir.getId(), (EntityQuery<String>)query);
                for (String groupname : groups) {
                    SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().removeGroupAttributes(dir.getId(), groupname, "passwordlessallowed");
                }
                query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"twostepallowed")).startingWith((Object)"")).startingAt(0).returningAtMost(-1);
                groups = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().searchGroups(dir.getId(), (EntityQuery<String>)query);
                for (String groupname : groups) {
                    SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().removeGroupAttributes(dir.getId(), groupname, "twostepallowed");
                }
                query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"mailotpallowed")).startingWith((Object)"")).startingAt(0).returningAtMost(-1);
                groups = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().searchGroups(dir.getId(), (EntityQuery<String>)query);
                for (String groupname : groups) {
                    SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().removeGroupAttributes(dir.getId(), groupname, "mailotpallowed");
                }
                query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"totpallowed")).startingWith((Object)"")).startingAt(0).returningAtMost(-1);
                groups = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().searchGroups(dir.getId(), (EntityQuery<String>)query);
                for (String groupname : groups) {
                    SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().removeGroupAttributes(dir.getId(), groupname, "totpallowed");
                }
                query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsign_pattern")).startingWith((Object)"")).startingAt(0).returningAtMost(-1);
                groups = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().searchGroups(dir.getId(), (EntityQuery<String>)query);
                for (String groupname : groups) {
                    SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().removeGroupAttributes(dir.getId(), groupname, "secsign_pattern");
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on deleteAllGroup2FASettings");
        }
        catch (GroupNotFoundException e) {
            logger.error("GroupNotFoundException on deleteAllGroup2FASettings");
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Deprecated
    private static boolean getAttributeBoolean(String userKey, long dirId, String key) throws UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        DirectoryWrapper wrapper = SecSignIDMappingExtractor.getDirectoryWrapperForDirectoryId(dirId);
        String state = wrapper.getUserAttribute(userKey, key);
        return !SecSignIDMappingExtractor.isAttributeEmpty(state) && Boolean.parseBoolean(state);
    }

    @Deprecated
    protected static boolean isAttributeEmpty(String attributeValue) {
        return attributeValue == null || attributeValue.length() == 0 || attributeValue.equalsIgnoreCase("SECSIGN_NULL");
    }
}

