/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDGroupPicker
extends HttpServlet {
    private static final long serialVersionUID = 6842235411471448500L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDGroupPicker.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String searchString = req.getParameter("groupname");
        LinkedHashSet<String> _searchUsersSet = new LinkedHashSet<String>();
        List<Directory> dirs = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getAllDirectories();
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)searchString)).startingAt(0).returningAtMost(-1);
        JSONArray json = new JSONArray();
        for (Directory dir : dirs) {
            if (!dir.isActive()) continue;
            try {
                _searchUsersSet.addAll(SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().searchGroups(dir.getId(), (EntityQuery<String>)query));
            }
            catch (DirectoryNotFoundException e) {
                logger.debug("DirectoryNotFoundException on UserPicker");
            }
            catch (OperationFailedException e) {
                logger.debug("OperationFailedException on UserPicker");
            }
            catch (InvalidAuthenticationException e) {
                logger.debug("InvalidAuthenticationException on UserPicker");
            }
            catch (ApplicationPermissionException e) {
                logger.debug("ApplicationPermissionException on UserPicker");
            }
            try {
                for (String groupName : _searchUsersSet) {
                    JSONObject user = new JSONObject();
                    user.put("id", (Object)groupName);
                    user.put("text", (Object)groupName);
                    user.put("dirid", (Object)dir.getId());
                    json.put((Object)user);
                }
            }
            catch (JSONException e) {
                logger.debug("JSONException on UserPicker");
            }
        }
        resp.setContentType("application/json");
        resp.getWriter().write(json.toString());
        resp.setStatus(200);
    }
}

