/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.secsign.atlassian.common.data.SecSignIDServerVersion;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDRESTTOTPResponse {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDRESTTOTPResponse.class);
    private final String totpKeyUri;
    private final String totpQRCodeBase64;

    public static SecSignIDRESTTOTPResponse fromJson(String json, String secSignId, SecSignIDServerVersion serverVersion) throws JSONException, SecSignIDRESTException {
        JSONObject rootObject = new JSONObject(json);
        if (serverVersion.isGreaterOrEquals(SecSignIDServerVersion.VERSION_10_7_5)) {
            return SecSignIDRESTTOTPResponse.getResponseFromJsonObject(rootObject);
        }
        if (!rootObject.has(secSignId)) {
            logger.debug("Key '" + secSignId + "' not found");
            throw new SecSignIDRESTException("No secsignid information available");
        }
        JSONObject secSignObject = rootObject.getJSONObject(secSignId);
        if (!secSignObject.has("totp")) {
            logger.debug("Key 'totp' not found");
            throw new SecSignIDRESTException("No totp information available");
        }
        return SecSignIDRESTTOTPResponse.getResponseFromJsonObject(secSignObject);
    }

    private static SecSignIDRESTTOTPResponse getResponseFromJsonObject(JSONObject object) throws JSONException, SecSignIDRESTException {
        JSONObject totpObject = object.getJSONObject("totp");
        String totpKeyUri = totpObject.optString("totpkeyuri", null);
        if (totpKeyUri == null) {
            logger.debug("Key 'totpkeyuri' not found");
            throw new SecSignIDRESTException("No totpkeyuri information available");
        }
        String totpQRCodeBase64 = totpObject.optString("totpqrcodebase64", null);
        if (totpQRCodeBase64 == null) {
            logger.debug("Key 'totpqrcodebase64' not found");
            throw new SecSignIDRESTException("No totpqrcodebase64 information available");
        }
        return new SecSignIDRESTTOTPResponse(totpKeyUri, totpQRCodeBase64);
    }

    private SecSignIDRESTTOTPResponse(String totpKeyUri, String totpQRCodeBase64) {
        this.totpKeyUri = totpKeyUri;
        this.totpQRCodeBase64 = totpQRCodeBase64;
    }

    public String getTotpKeyUri() {
        return this.totpKeyUri;
    }

    public String getTotpQRCodeBase64() {
        return this.totpQRCodeBase64;
    }
}

