/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDRESTCreateSecSignIDResponse {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDRESTCreateSecSignIDResponse.class);
    private final String restoreUrl;
    private final String qrCodeBase64;

    public static SecSignIDRESTCreateSecSignIDResponse fromJson(String json) throws JSONException, SecSignIDRESTException {
        JSONObject rootObject = new JSONObject(json);
        String createUrl = rootObject.optString("restoreurl", null);
        if (createUrl == null) {
            logger.debug("Key 'restoreurl' not found");
            throw new SecSignIDRESTException("Key 'restoreurl' not found");
        }
        String qrCodeBase64 = rootObject.optString("qrcodebase64", null);
        if (qrCodeBase64 == null) {
            logger.debug("Key 'qrcodebase64' not found");
            throw new SecSignIDRESTException("Key 'qrcodebase64' not found");
        }
        return new SecSignIDRESTCreateSecSignIDResponse(createUrl, qrCodeBase64);
    }

    private SecSignIDRESTCreateSecSignIDResponse(String restoreUrl, String qrCodeBase64) {
        this.restoreUrl = restoreUrl;
        this.qrCodeBase64 = qrCodeBase64;
    }

    public String getRestoreUrl() {
        return this.restoreUrl;
    }

    public String getQrCodeBase64() {
        return this.qrCodeBase64;
    }
}

