/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDRESTAccessTokenAuthorizationResponse {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDRESTAccessTokenAuthorizationResponse.class);
    private final String tokenId;
    private final long authSessionId;
    private final String fido;

    public static SecSignIDRESTAccessTokenAuthorizationResponse fromJson(String json) throws JSONException, SecSignIDRESTException {
        JSONObject rootObject = new JSONObject(json);
        String tokenId = rootObject.optString("tokenid", null);
        if (tokenId == null) {
            logger.debug("Key 'tokenid' not found");
            throw new SecSignIDRESTException("Key 'tokenid' not found");
        }
        long authSessionId = rootObject.optLong("authsessionid", -1L);
        String fido = rootObject.optString("fido", null);
        return new SecSignIDRESTAccessTokenAuthorizationResponse(tokenId, authSessionId, fido);
    }

    private SecSignIDRESTAccessTokenAuthorizationResponse(String tokenId, long authSessionId, String fido) {
        this.tokenId = tokenId;
        this.authSessionId = authSessionId;
        this.fido = fido;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public long getAuthSessionId() {
        return this.authSessionId;
    }

    public String getFido() {
        return this.fido;
    }
}

